function [out,out1,out2]=p_spring(varargin)

%P_SPRING Spring element property function
%
%       Syntax : il = p_spring('default') 
%                il = p_spring('database ProId value') 
%                il = p_spring('dbval ProId value');
%                il = p_spring('dbval -unit MM ProId value');
%
% 	Subtype 1 : point to point connection
%            [ProId type k m c eta S]
%            type  fe_mat('m_elastic','SI',2)
%            stiffness, mass, damping, loss factor, stress coefficient
%       Subtype 2 : BUSH
%            [ProId Type k11:k66 c11:c66 eta Mass Volume]
%            type  fe_mat('m_elastic','SI',2)
%            ki : stiffness for each direction
%            ci : viscous damping for each direction
%
%       Examples
%                p_spring('database 100 1e12')
%                p_spring('dbval 100 1e12')
%
%       See also : help fe_mat
%                  doc  fem (handling materials section), pl, fe_mat, p_shell


%	Jean-Michel Leclere
%       Copyright (c) 2001-2006 by INRIA and SDTools, All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if nargin==1 & comstr(varargin{1},'cvs')
 out='$Revision: 1.22 $  $Date: 2006/04/27 16:28:53 $'; return;
end
if nargin<1; help p_spring;return; end
if ischar(varargin{1}); [CAM,Cam]=comstr(varargin{1},1); il=[]; carg=2;
else il=varargin{1};[CAM,Cam]=comstr(varargin{2},1); carg=3;
end

% -------------------------------------------------------------------------
if comstr(Cam,'propertyunittype')

 i1=varargin{carg};
 out1={};
 switch i1 % PropertySubType
 case 1 % [matid type K M C eta S %the unit of S is unclear ]
  st={...
      'MatId',                  0;
      'Type',                   0;
      'Stiffness'              13;
      'Mass'                    9;
      'Viscous damping',    2.006;
      'Hysteretic damping'  2.005;
      'Loss factor'             0;
      'Stress coef'             0 };
 % case 2 % PBUSH (Based on Nastran)
 % ProId Type k1 k2 k3 k4 k5 k6 b1 b2 b3 b4 b5 b6 eta SA ST EA ET
 otherwise; st={'ProId' 0; 'Type', 0};
 end
 if ~isempty(strfind(Cam,'cell')); out=st; else; out=[st{:,2}]; end

% -------------------------------------------------------------------------
elseif comstr(Cam,'default')

  out=p_spring('database');
  out=out(1);

% -------------------------------------------------------------------------
elseif comstr(Cam,'dbval')

 i1=strfind(comstr(Cam,-27),'-unit'); out1={};
 if ~isempty(i1)
   [Unit,i2,i3,i4]=sscanf(CAM(i1+5:end),'%s',1);
   i4=i1+[0:4+i4];CAM(i4)=''; [CAM,Cam]=comstr(CAM,1);
 else Unit=''; 
 end

 while 1==1
  [CAM,Cam]=comstr(CAM,6); [i1,i2,i3,i4]=sscanf(CAM,'%i',1);
  if isempty(CAM)&carg<=nargin; st=varargin{carg};carg=carg+1; 
  else; st=CAM;end
  [mat,st1,i2]=p_spring('database',st,varargin{carg:end});carg=carg+i2-3;
  if ~isempty(Unit)
   mat.il=fe_mat(sprintf('convert %s %s',mat.unit,Unit),mat.il);
  end
  r1=mat.il; if length(i1)==1; r1(1)=i1;end
  if ~isempty(il) i2=find(il(:,1)==r1(1)); else i2=[];end
  if isempty(i2) i2=size(il,1)+1;end
  il(i2,1:length(r1))=r1;
  if carg>nargin break;end
  [CAM,Cam]=comstr(varargin{carg},1);carg=carg+1;
 end
 out=il;

% -------------------------------------------------------------------------
elseif comstr(Cam,'database') 

  st=comstr(CAM,9);
  if isempty(st)&carg<=nargin st=varargin{carg}; carg=carg+1;end
  [MatId,i2,i3,i4]=sscanf(st,'%i',1); if i2~=1; MatId=1;end
  st=comstr(st,i4);

  out.il=[MatId fe_mat('p_spring',1,1) 1e15]; 
  out.name='stiff spring 1e15';
  out.type='p_spring';
  out.unit='SI';

  out(2).il=[MatId fe_mat('p_spring',1,1) 1e6]; 
  out(2).name='stiff spring 1e6';
  out(2).type='p_spring';
  out(2).unit='SI';

  i1=strmatch(st,{out.name},'exact');

  if ~isempty(i1) out=out(i1);
  elseif ~isempty(st)
   r1=str2num(st); 
   if length(r1)<1 error('Not a consistent database call');end
   il=[MatId fe_mat('p_spring',1,1) r1(:)']; 
   name=['Spring' st];
   type='p_spring';
   unit='SI';
   out=struct('name',name,'il',il,'type',type,'unit',unit);
  end

  out1='Spring/rigid connection';out2=carg;

% -------------------------------------------------------------------------
elseif comstr(Cam,'propertyunittype')

 if carg<2 error('bar number of input arguments'); end
 out=PropertyUnitType_spring(varargin{2});


% -------------------------------------------------------------------------
elseif comstr(Cam,'subtypestring')

 i1=varargin{carg}; carg=carg+1;
 switch i1
 case 1;  out='p_spring';
 otherwise out='p_spring';
 end

end


% --------------------------------------------------------------------
