function [out,out1,out2]=penta6(CAM,varargin);

%PENTA6B 6 node, 5 sided volume element supporting 
%
%     Should be replaced by PENTA6 elements with appropriate 
%       P_SOLID, P_HEAT or P_PIEZO element property entries
%
%       See also doc penta6

%	Etienne Balmes, Jean-Michel Leclere
%       Copyright (c) 2001-2005 by INRIA and SDTools,All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if comstr(CAM,'cvs')
 out='$Revision: 1.11 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(CAM)
 [CAM,Cam]=comstr(CAM,1);
 if comstr(Cam,'integinfo')
  %constit integ,elmap                 ID,pl,il
  [out,out1,out2]= ...
   p_solid('buildconstit',[varargin{1};18;6;1],varargin{2},varargin{3});

 % - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 % Matrix assembly in fe_mknl
 elseif comstr(Cam,'call'); out=elem0('callmat_og');
 elseif comstr(Cam,'rhscall'); out=elem0('rhsmat_og'); % call for load
 % Basic tests of the element - - - - - - - - - - - - - - - - - - - - - -
 elseif  comstr(Cam,'test'); [CAM,Cam] = comstr(CAM,5);
   [out,out1]=femesh(strcat(['teststruct penta6b ' Cam]));
 else; % redirection to parent
  if nargout==0; penta6(CAM,varargin{:});
  elseif nargout==1; out=penta6(CAM,varargin{:});
  elseif nargout==2; [out,out1]=penta6(CAM,varargin{:});
  elseif nargout==3; [out,out1,out2]=penta6(CAM,varargin{:});
  end
 end
return
end % of standard calls with one input argument


