function [idof,k,m]=pyra5(node,elt,pl,il,opt,NNode)

%PYRA5	5-node 15-DOF solid element
%
%	See also help hexa20, hexa8, penta6
% 	         doc  eltfun, elem0


%       Etienne Balmes   10/10/93, 22/09/01
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.

if comstr(node,'cvs')
 idof='$Revision: 1.8 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(node)
 [CAM,Cam]=comstr(node,1);
 if comstr(Cam,'integinfo')

   idof=[];k=[];m=[];

 elseif comstr(Cam,'call')
   idof=['[i1,k1,m1]=pyra5(node,elt(cEGI(jElt),:),pl,il,[opt(1) jGroup jElt],NNode);'];
 elseif comstr(Cam,'node');   idof = [1:5];
 elseif comstr(Cam,'dof')
   idof=[1+[1:3]'/100; 2+[1:3]'/100; 3+[1:3]'/100; 4+[1:3]'/100;5+[1:3]'/100];
 elseif comstr(Cam,'line');    idof = [1 2 3 4 1 5 4 0 3 5 2];
 elseif comstr(Cam,'patch');   idof = [1 2 3 4;1 2 5 5;2 3 5 5;4 1 5 5];
 elseif  comstr(Cam,'edge');   idof = [1 2; 2 3; 3 4; 4 1; 1 5; 2 5;3 5;4 5];
 elseif  comstr(Cam,'face');   idof = [1 4 3 2;4 1 5 5; 1 2 5 5; ...
                                      2 3 5 5; 3 4 5 5];
 elseif  comstr(Cam,'patch');   idof = [1 4 3 2;4 1 5 5; 1 2 5 5; ...
                                      2 3 5 5; 3 4 5 5];
 elseif comstr(Cam,'sci_face');  idof = [1 4 3 2;4 1 5 5; 1 2 5 5; ...
                                      2 3 5 5; 3 4 5 5];                             
 elseif  comstr(Cam,'parent'); idof = 'pyra5';
 elseif  comstr(Cam,'prop');  idof = [6 7 8];
 elseif  comstr(Cam,'test'); disp('pyra5 test : just for display')
 end
return
end % of standard calls with one input argument

