function [out,out1,out2]=quad9(CAM,varargin);
%QUAD9 element function of a 9-node quadrilateral
%


%	Etienne Balmes   10/10/90, 22/03/01
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.

if comstr(CAM,'cvs')
 out='$Revision: 1.13 $  $Date: 2006/03/28 13:51:11 $'; return;
end
% standard calls with one input argument
if ischar(CAM)

 [CAM,Cam]=comstr(CAM,1);
 % Build Constit, Integ, and Elmap for later integration
 if comstr(Cam,'integinfo')

  [constit,iopt] = ...
     fe_mat('plil of_mk 3d',varargin{1},varargin{2},varargin{3}); %solid
  iopt(3:4)=[30 10];

  if isempty(constit); error('Material properties are not defined');end
  if iopt(8)==4 % Use m file for full anisotropy
    error(1)
    [r1,r2] = fe_mat('plil 3d',elt,pl,il);
    i1=find(triu(ones(6,6))); dd=zeros(6,6);dd(i1)=pl(1:21);
    dd=dd+tril(dd',-1);
    out=[dd(:) pl(22) pl(length(pl))]
  else 
   out1=iopt(:); out=constit(:); 
  end
  % element map
  i1=find(triu(ones(30,30))); r1=zeros(30,30);r1(i1)=1:length(i1);
  out2=r1+tril(r1',-1);

 elseif comstr(Cam,'matcall')

  out=@of_mk;  k=1; % SymFlag

 elseif comstr(Cam,'call')
   error(1);
   out = ['[i1,k1,m1] = aq2c(node,elt(cEGI(jElt),:),pl,il,[opt(1) jGroup jElt],NNode);'];

 elseif comstr(Cam,'rhscall') % call for load assembly
   error(1)
   out='be=quad9(nodeE,elt(cEGI(jElt),:),pointers(:,jElt),integ,constit,elmap,gstate);';

 elseif comstr(Cam,'groupinit');   out = '';
 elseif comstr(Cam,'node'); out = [1:9];
 elseif comstr(Cam,'prop'); out = [10 11 12];
 elseif comstr(Cam,'dofcall');out=elem0('dofcall'); % variable field elements
 elseif  comstr(Cam,'dof')
   out = [1:9];k=[1;2;3]/100;out=out(ones(3,1),:)+k(:,ones(9,1));
   out=out(:);
 elseif comstr(Cam,'line');   out = [1 5 2 6 3 7 4 8 1];
 elseif comstr(Cam,'patch');  out = [1 5 2 6 3 7 4 8];
 elseif comstr(Cam,'sci_face'); out = [1 5 9 8;5 2 6 9;6 3 7 9;7 4 8 9];
 elseif comstr(Cam,'parent'); out = 'quad9';
 elseif  comstr(Cam,'flip');   out=[1 4 3 2 8 7 6 5 9]; out1=1:9; 
 elseif  comstr(Cam,'test'); 
   warning('Quad9 : Matrix computations not supported yet');
   out='error';
 end
 return

end % of standard calls with one input argument

warning('quad9 not implemented')

