function out=sdtdef(in1,in2,in3);

% Defaults handling routine (internal)
%
%      Syntax : sdtdef info
%               sdtdef('ConstantName',Value)
%               ...
%
%      cf            : current GUI figure storage
%      DefBackCol    : default background color
%      epsl          : tolerance on node coincidence (1e-6)
%      info          : info on currently stored defaults
%      kcelas        : default penalization stiffness (1e14)
%      view          : list of standard views and associated tags
%                      set with sdtdef('view tag',value)

%	Etienne Balmes 10/06/94, 08/10/00
%       Copyright (c) 1990-2006 by SDTools,
%       All Rights Reserved.

persistent II
%mlock
if nargin>=2&isequal(in1,'diag')&ischar(in2) % early return of diag warning
 try; i1=sp_util('diag');if i1==0;return;end;end
end

if nargin==0   % return stamp
 if ~isfield(II,'stamp') II.stamp=0; end
 out=II.stamp;
elseif ~isstr(in1)
 if in1>0  % return 
  if ~isfield(II,'stamp') II.stamp=0; end
  II.stamp=II.stamp+1;
  out=II.stamp;
 else error('Not a supported case');
 end
else

 Cam=lower(in1);
if strcmp(Cam,'diag') % - - - - - - - - - - - - - - - - - - - - - - - - - - -
  if ~isfield(II,'diag') II.diag=0; end
  if nargin==2
   if ~ischar(in2); II.diag=in2(1);   % Set value 
   elseif ~isempty(strfind(in2,'diagoff')); II.diag=0;
   elseif ~isempty(strfind(in2,'diagon'));  II.diag=1;
   elseif ~strcmp(in2,'tog');  
    if II.diag>1; evalin('caller','dbstack');end
    if II.diag;  disp(in2); end % Display
   else; % Tog
    II.diag=rem(II.diag(1)+1,2);   ssetpref('SDT','diag',II.diag);
   end
  elseif ~isempty(strfind(Cam,'diagoff')); II.diag=0;
  elseif ~isempty(strfind(Cam,'diagon')); II.diag=1;
  elseif nargin>2
   fprintf('%s ',in2);fprintf('\n');
  else  
    out=II.diag; 
  end
  try;sp_util('diag',II.diag);end

elseif strcmp(Cam,'isdeployed') % deployement test- - - - - - - - - - - - -
  if ~isfield(II,'IsDeployed');
   try; II.IsDeployed=isdeployed; catch; II.IsDeployed=0;end 
  end
 out=II.IsDeployed;
elseif strcmp(Cam,'info') % display current values - - - - - - - - - - - - -
  if isempty(II)
   disp('No default defined');
  else disp(II); end

elseif strcmp(Cam,'deflen') % default length for various figures
  if ~isfield(II,'DefLen') II.DefLen=1; end
  if nargin==2&nargout==0&length(in2)==1
    II.DefLen(in2(1))=in2(2);
  else
    if nargin<2|in2(1)>length(II.DefLen) in2(1)=1;end
    out=II.DefLen(in2(1));
  end
 
elseif strcmp(Cam,'defbackcol') % default background color - - - - - - - - - -
  if ~isfield(II,'DefBackCol')
    II.DefBackCol(1,:)=[1 1 1]-round(mean(get(0,'defaultaxescolor')));
  end
  if nargin==2 II.DefBackCol(in2(1),:)=[1 1 1]-in2(2); 
  else out=II.DefBackCol(1,:); end

elseif strcmp(Cam,'epsl') % length tolerance - - - - - - - - - - - - -
  if ~isfield(II,'epsl') II.epsl=1e-6; end
  if nargin==2 II.epsl=in2(1); end
  try; sp_util('epsl',II.epsl);end
  out=II.epsl;

elseif strcmp(Cam,'kcelas') % default penalization - - - - - - - - - - - - -
  if ~isfield(II,'kcelas') II.kcelas=1e14; end
  if nargin==2 II.kcelas=in2(1); end
  out=II.kcelas;
elseif strcmp(Cam,'cvs') % - - - - - - - - - - - - - - - - - - - - - - - - - -

 out='$Revision: 1.8 $  $Date: 2006/04/28 15:46:14 $';
else error('Not a supported case');
end
end

