function out=sdtw(varargin)

% SDT extended warning handling
%    sdtw('_nb',message)      for no backtrace
%    sdtw('_IsGui',message)   selects warndlg if gcbf is defined
%    sdtw('_clip length ReturnString','format',values)
%
%    additional arguments handled using sprintf

%	Etienne Balmes  20/09/00, 23/04/03
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved
%       $Revision: 1.13 $  $Date: 2006/04/27 13:42:18 $

if nargin==1 & comstr(varargin{1},'cvs')
 out='$Revision: 1.13 $  $Date: 2006/04/27 13:42:18 $'; return;
end
if nargin==0 help sdtw; return; end
CAM=varargin{1}; carg=2; 

s=''; grw='';
st1=version;i1=str2num(st1(1:3));

if comstr(CAM,'_nb')
  if i1<=6.2; [s,f]=warning;
  else s=warning('query','backtrace'); warning('off','backtrace');end
  warning('on'); CAM=varargin{carg};carg=carg+1;

% return a potentially clipped list
elseif comstr(comstr(CAM,-27),'_clip')

  opt=comstr(CAM(6:end),[-1 72 0]);
  st=varargin{carg};carg=carg+1;
  val=varargin{carg};carg=carg+1;
  out={}; i1=0;j1=1;
  if isa(val,'cell')
   while j1<=length(val)
    st1=sprintf(st,val{j1}); i1=i1+length(st1);
    if i1<opt(1)/2 | i1>1e3 | (j1>length(val)-j1+1) out{end+1}=st1;
    else out{end+1}='... '; j1=length(val)-j1+1;i1=i1+1e3;
    end
    j1=j1+1;
   end
  else
   while j1<=length(val)
    st1=sprintf(st,val(j1)); i1=i1+length(st1);
    if i1<opt(1)/2 | i1>1e3 | (j1>length(val)-j1+1) out{end+1}=st1;
    else out{end+1}='... '; j1=length(val)-j1+1;i1=i1+1e3;
    end
    j1=j1+1;
   end
  end
  if opt(2)==1 out=[out{:}];end % return a string
  return;
elseif comstr(comstr(CAM,-27),'_isgui')
  if ~isempty(get(0,'CallbackObject')); grw='Warning'; else; grw=''; end
  CAM=varargin{carg};carg=carg+1;
elseif comstr(CAM,'_gr')
  grw=comstr(CAM,4); if isempty(grw) grw='warning'; end
  CAM=varargin{carg};carg=carg+1;
elseif comstr(comstr(CAM,-27),'_err'); grw='error'; CAM=varargin{carg};carg=carg+1;
end 

if carg<=nargin 
    CAM=sprintf(CAM,varargin{carg:end});
end

if strcmp(grw,'error'); error(CAM);
elseif ~isempty(grw); warndlg(CAM,grw);drawnow
else warning(CAM); end
if ~isempty(s) warning(s); end
