      subroutine bremit(nno,npt1,npt2,npt3,npt,xnorm,v1,v2,t,
     *                  npi,xint,yint,vdtq2,vp2,f,fz,inmitc,b,bz,bzz,
     *                  irint,fi,fiz,vdpq2,vp2i,l)
c ...................................................................
c
c   calcul de B aux points d'integration comme polynome de degre 2
c       B(i) = b(i)*z*bz(i)+z**2*bzz(i)
c   
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  PARAMETRES D'ENTREE :
C  -------------------
C  NNO         : NOMBRE DE POINTS DE L ELEMENT
c  npt         : nb de points d'interpolation (tying)
c                npt = npt1 (rr,rz) +npt2 (ss,sz) + npt3 (rs)
c  xnorm       : normale aux noeuds
c  v1,v2       : forment un repere local avec norm (calc reploc)
c  npi         : nombre de points d'integration (en r,s)
c  xint,yint   : coord des pt d'integration en r,s
c  inmitc      : nom generique de la fonction d'interpolation
c                inmitc(j,i,x,y)
c  vdtq2(1,*)  : derivee par rapport a r aux pt interpolation
c  vdtq2(2,*)  : derivee par rapport a s aux pt interpolation
c  f           : matrice f=f+fz*z
c   
c ............................................................
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     PROGRAMMEUR  :  Marina Vidrascu INRIA 2000
C  .................................................................. 
      dimension irint(5)
      double precision xnorm(3,25),v1(3,16),v2(3,16),t(nno),
     *                 F(3,3,npt),fz(3,3,npt),b(5,5*nno),
     *                 bz(5,5*nno),bzz(5,5*nno),zero,
     *                 vdtq2(2,nno,npt),vp2(nno,npt),
     *                 valdx,valx,valdy,valy,inmitc,
     *                 fi(3,3),fiz(3,3),vdpq2(2,nno,npi),
     *                 vp2i(nno,npi),xint(npi),yint(npi)
      external inmitc
      parameter ( zero = 0. )
 

      CALL Dcopy(25*nno,zero,0,b,1)
      CALL Dcopy(25*nno,zero,0,bz,1)
      CALL Dcopy(25*nno,zero,0,bzz,1)

c      ------------------------------------------------------
c
c            COMPOSANTE 1 rr
c
c      ------------------------------------------------------


       if (irint(1) .eq. 1) then
c      ---- > reinterpolation

        do 1 lt = 1,npt1
        do 1 n  = 1,nno

           valdx    =  vdtq2(1,n,lt)* inmitc(1,lt,xint(l),yint(l))
           valx     =  vp2(n,lt)* inmitc(1,lt,xint(l),yint(l))
c
c          calcul de B_rr (B(1,...)
c

c          (B_rr),1
         
            B (1,n) =  B(1,n) +  f(1,1,lt) * valdx
            Bz(1,n) = Bz(1,n) + fz(1,1,lt) * valdx

c          (B_rr),2

            B(1,n+nno) =  B(1,n+nno) +  f(1,2,lt) * valdx
            Bz(1,n+nno) = Bz(1,n+nno) + fz(1,2,lt) * valdx

c          (B_rr),3
         
             B(1,n+2*nno) =  B(1,n+2*nno) +  f(1,3,lt) * valdx
            Bz(1,n+2*nno) = Bz(1,n+2*nno) + fz(1,3,lt) * valdx

c          (B_rr),4
         
             Bz(1,n+3*nno) =  Bz(1,n+3*nno) + (f(1,1,lt)*v1(1,n)
     *         + f(1,2,lt)*v1(2,n) + f(1,3,lt)*v1(3,n))*valdx*.5*t(n)
            Bzz(1,n+3*nno) = Bzz(1,n+3*nno) + (fz(1,1,lt)*v1(1,n)
     *         + fz(1,2,lt)*v1(2,n) + fz(1,3,lt)*v1(3,n))*valdx*.5*t(n)

c          (B_rr),5
         
             Bz(1,n+4*nno) =  Bz(1,n+4*nno) + (f(1,1,lt)*v2(1,n)
     *         + f(1,2,lt)*v2(2,n) + f(1,3,lt)*v2(3,n))*valdx*.5*t(n)
            Bzz(1,n+4*nno) = Bzz(1,n+4*nno) + (fz(1,1,lt)*v2(1,n)
     *         + fz(1,2,lt)*v2(2,n) + fz(1,3,lt)*v2(3,n))*valdx*.5*t(n)
 1        continue

        else
c      ---- > pas de reinterpolation

        do 10 n  = 1,nno
c
c          calcul de B_rr (B(1,...)
c

c          (B_rr),1
         
            B (1,n) = fi(1,1) * vdpq2(1,n,l)
            Bz(1,n) = fiz(1,1) * vdpq2(1,n,l)

c          (B_rr),2

            B(1,n+nno) =  fi(1,2) * vdpq2(1,n,l)
            Bz(1,n+nno) = fiz(1,2) * vdpq2(1,n,l)

c          (B_rr),3
         
             B(1,n+2*nno) = fi(1,3) * vdpq2(1,n,l)
            Bz(1,n+2*nno) = fiz(1,3) * vdpq2(1,n,l)

c          (B_rr),4
         
             Bz(1,n+3*nno) =  (fi(1,1)*v1(1,n) + fi(1,2)*v1(2,n)
     *         +fi(1,3)*v1(3,n))*vdpq2(1,n,l)*.5*t(n)
            Bzz(1,n+3*nno) = (fiz(1,1)*v1(1,n)+ fiz(1,2)*v1(2,n)
     *         +fiz(1,3)*v1(3,n))*vdpq2(1,n,l)*.5*t(n)

c          (B_rr),5
         
             Bz(1,n+4*nno) =  (fi(1,1)*v2(1,n) + fi(1,2)*v2(2,n)
     *         + fi(1,3)*v2(3,n))*vdpq2(1,n,l)*.5*t(n)
            Bzz(1,n+4*nno) = (fiz(1,1)*v2(1,n) +fiz(1,2)*v2(2,n)
     *         +fiz(1,3)*v2(3,n))*vdpq2(1,n,l)*.5*t(n)
 10         continue

        endif
c      ------------------------------------------------------
c
c            COMPOSANTE 4 rz
c
c      ------------------------------------------------------
      
       if (irint(4) .eq. 1) then
c      ---- > reinterpolation

        do 4 lt = 1,npt1
        do 4 n  = 1,nno

           valdx    =  vdtq2(1,n,lt)* inmitc(1,lt,xint(l),yint(l))
           valx     =  vp2(n,lt)* inmitc(1,lt,xint(l),yint(l))
c
c          calcul de B_rz (B(4,...)
c
c                  attention comme Eps_rz(r,s,z) =  Eps_rz(r,s,0)
c                                  Bz =Bzz = 0

c          (B_rz),1
         
             B(4,n) =  B(4,n) +  f(3,1,lt) * valdx

c          (B_rz),2
         
             B(4,n+nno) =  B(4,n+nno) +  f(3,2,lt) * valdx

c          (B_rz),3
         
             B(4,n+2*nno) =  B(4,n+2*nno) +  f(3,3,lt) * valdx

c          (B_rz),4
         
             B(4,n+3*nno) =  B(4,n+3*nno) +  (f(1,1,lt)*v1(1,n)+
     *         f(1,2,lt)*v1(2,n) + f(1,3,lt)*v1(3,n)) * valx*.5*t(n)

c          (B_rz),5
         
             B(4,n+4*nno) =  B(4,n+4*nno) +  (f(1,1,lt)*v2(1,n)+ 
     *         f(1,2,lt)*v2(2,n) + f(1,3,lt)*v2(3,n)) * valx*.5*t(n)

 4        continue

        else
c      ---- > pas de reinterpolation

        do 40 n  = 1,nno
c
c          calcul de B_rz (B(4,...)
c
c                  attention comme Eps_rz(r,s,z) =  Eps_rz(r,s,0)
c                                  Bz =Bzz = 0

c          (B_rz),1
         
             B(4,n) =  fi(3,1) * vdpq2(1,n,l)

c          (B_rz),2
         
             B(4,n+nno) = fi(3,2) * vdpq2(1,n,l)

c          (B_rz),3
         
             B(4,n+2*nno) =  fi(3,3) * vdpq2(1,n,l)

c          (B_rz),4
         
             B(4,n+3*nno) =  (fi(1,1)*v1(1,n)+ fi(1,2)*v1(2,n)
     *         + fi(1,3)*v1(3,n)) * vp2i(n,l)*.5*t(n)

c          (B_rz),5
         
             B(4,n+4*nno) =  (fi(1,1)*v2(1,n)+  fi(1,2)*v2(2,n)
     *         + fi(1,3)*v2(3,n)) * vp2i(n,l)*.5*t(n)

 40          continue
        endif
c      ------------------------------------------------------
c
c            COMPOSANTE 2 ss
c
c      ------------------------------------------------------

       if (irint(2) .eq. 1) then
c      ---- > reinterpolation

          do 2 lt = npt1+1,npt1+npt2
          do 2 n  = 1,nno

           valdy   =  vdtq2(2,n,lt)* inmitc(2,lt-npt1,xint(l),yint(l))
           valy    =  vp2(n,lt)* inmitc(2,lt-npt1,xint(l),yint(l))

c          calcul de B_ss (B(2,...)
c

c          (B_ss),1
         
            B (2,n) =  B(2,n) +  f(2,1,lt) * valdy
            Bz(2,n) = Bz(2,n) + fz(2,1,lt) * valdy

c          (B_ss),2
         
             B(2,n+nno) =  B(2,n+nno) +  f(2,2,lt) * valdy
            Bz(2,n+nno) = Bz(2,n+nno) + fz(2,2,lt) * valdy

c          (B_ss),3
         
             B(2,n+2*nno) =  B(2,n+2*nno) +  f(2,3,lt) * valdy
            Bz(2,n+2*nno) = Bz(2,n+2*nno) + fz(2,3,lt) * valdy

c          (B_ss),4
         
             Bz(2,n+3*nno) =  Bz(2,n+3*nno) + (f(2,1,lt)*v1(1,n)
     *         + f(2,2,lt)*v1(2,n) + f(2,3,lt)*v1(3,n))*valdy*.5*t(n)
            Bzz(2,n+3*nno) = Bzz(2,n+3*nno) + (fz(2,1,lt)*v1(1,n)
     *         + fz(2,2,lt)*v1(2,n) + fz(2,3,lt)*v1(3,n))*valdy*.5*t(n)

c          (B_ss),5
         
             Bz(2,n+4*nno) =  Bz(2,n+4*nno) + (f(2,1,lt)*v2(1,n)
     *         + f(2,2,lt)*v2(2,n) + f(2,3,lt)*v2(3,n))*valdy*.5*t(n)
            Bzz(2,n+4*nno) = Bzz(2,n+4*nno) + (fz(2,1,lt)*v2(1,n)
     *         + fz(2,2,lt)*v2(2,n) + fz(2,3,lt)*v2(3,n))*valdy*.5*t(n)
 2        continue
        else
c      ---- > pas de reinterpolation

          do 20 n  = 1,nno


c          calcul de B_ss (B(2,...)
c

c          (B_ss),1
         
            B (2,n) =  fi(2,1) * vdpq2(2,n,l)
            Bz(2,n) =  fiz(2,1) * vdpq2(2,n,l)

c          (B_ss),2
         
             B(2,n+nno) = fi(2,2) * vdpq2(2,n,l)
            Bz(2,n+nno) = fiz(2,2) * vdpq2(2,n,l)

c          (B_ss),3
         
             B(2,n+2*nno) = fi(2,3) * vdpq2(2,n,l)
            Bz(2,n+2*nno) = fiz(2,3) * vdpq2(2,n,l)

c          (B_ss),4
         
             Bz(2,n+3*nno) = (fi(2,1)*v1(1,n) + fi(2,2)*v1(2,n)
     *         + fi(2,3)*v1(3,n))*vdpq2(2,n,l)*.5*t(n)
            Bzz(2,n+3*nno) = (fiz(2,1)*v1(1,n)+ fiz(2,2)*v1(2,n)
     *         + fiz(2,3)*v1(3,n))*vdpq2(2,n,l)*.5*t(n)

c          (B_ss),5
         
             Bz(2,n+4*nno) = (fi(2,1)*v2(1,n)  + fi(2,2)*v2(2,n)
     *         + fi(2,3)*v2(3,n))*vdpq2(2,n,l)*.5*t(n)
            Bzz(2,n+4*nno) = (fiz(2,1)*v2(1,n) +fiz(2,2)*v2(2,n)
     *         + fiz(2,3)*v2(3,n))*vdpq2(2,n,l)*.5*t(n)
 20         continue
        endif
c      ------------------------------------------------------
c
c            COMPOSANTE 5 sz
c
c      ------------------------------------------------------

      
       if (irint(5) .eq. 1) then
c      ---- > reinterpolation

          do 5 lt = npt1+1,npt1+npt2
          do 5 n  = 1,nno

           valdy   =  vdtq2(2,n,lt)* inmitc(2,lt-npt1,xint(l),yint(l))
           valy    =  vp2(n,lt)* inmitc(2,lt-npt1,xint(l),yint(l))

c
c          calcul de B_sz (B(5,...)
c
c
c                  attention comme Eps_sz(r,s,z) =  Eps_sz(r,s,0)
c                                  Bz =Bzz = 0

c          (B_sz),1
         
             B(5,n) =  B(5,n) +  f(3,1,lt) * valdy

c          (B_sz),2
         
             B(5,n+nno) =  B(5,n+nno) +  f(3,2,lt) * valdy

c          (B_sz),3
         
             B(5,n+2*nno) =  B(5,n+2*nno) +  f(3,3,lt) * valdy

c          (B_sz),4
         
             B(5,n+3*nno) =  B(5,n+3*nno) + (f(2,1,lt)*v1(1,n)+ 
     *         f(2,2,lt)*v1(2,n) + f(2,3,lt)*v1(3,n)) * valy*.5*t(n)

c          (B_sz),5
         
             B(5,n+4*nno) =  B(5,n+4*nno) + (f(2,1,lt)*v2(1,n)+ 
     *         f(2,2,lt)*v2(2,n) +  f(2,3,lt)*v2(3,n)) * valy*.5*t(n)

 5        continue
        else
c      ---- > pas de reinterpolation


          do 50 n  = 1,nno


c
c          calcul de B_sz (B(5,...)
c
c
c                  attention comme Eps_sz(r,s,z) =  Eps_sz(r,s,0)
c                                  Bz =Bzz = 0

c          (B_sz),1
         
             B(5,n) = fi(3,1) * vdpq2(2,n,l)

c          (B_sz),2
         
             B(5,n+nno) =  fi(3,2) * vdpq2(2,n,l)

c          (B_sz),3
         
             B(5,n+2*nno) =  fi(3,3) * vdpq2(2,n,l)

c          (B_sz),4
         
             B(5,n+3*nno) =  (fi(2,1)*v1(1,n)+  fi(2,2)*v1(2,n)
     *         + fi(2,3)*v1(3,n)) * vp2i(n,l)*.5*t(n)

c          (B_sz),5
         
             B(5,n+4*nno) =  (fi(2,1)*v2(1,n)+ fi(2,2)*v2(2,n)
     *         +  fi(2,3)*v2(3,n)) * vp2i(n,l)*.5*t(n)

 50          continue
        endif
c      ------------------------------------------------------
c
c            COMPOSANTE 3 rs
c
c      ------------------------------------------------------

 
       if (irint(3) .eq. 1) then
c      ---- > reinterpolation

          do 3 lt = npt1+npt2+1,npt
          do 3 n  = 1,nno

           valdx    =  vdtq2(1,n,lt)* 
     *                 inmitc(3,lt-npt1-npt2,xint(l),yint(l))
           valdy    =  vdtq2(2,n,lt)* 
     *                 inmitc(3,lt-npt1-npt2,xint(l),yint(l))
c
c          calcul de B_rs (B(3,...)
c

c          (B_rs),1
         
            B (3,n) =  B(3,n) +  f(2,1,lt) * valdx  +
     *                               f(1,1,lt) * valdy
            Bz(3,n) = Bz(3,n) + fz(2,1,lt) * valdx  +
     *                              fz(1,1,lt) * valdy

c          (B_rs),2
         
             B(3,n+nno) =  B(3,n+nno) +  f(2,2,lt) * valdx +
     *                                       f(1,2,lt) * valdy
            Bz(3,n+nno) = Bz(3,n+nno) + fz(2,2,lt) * valdx
     *                                        + fz(1,2,lt) * valdy

c          (B_rs),3
         
             B(3,n+2*nno) =  B(3,n+2*nno) +  f(2,3,lt) * valdx
     *                                          +  f(1,3,lt) * valdy
            Bz(3,n+2*nno) = Bz(3,n+2*nno) + fz(2,3,lt) * valdx
     *                                          + fz(1,3,lt) * valdy

c          (B_rs),4
         
             Bz(3,n+3*nno) =  Bz(3,n+3*nno) + (f(2,1,lt)*v1(1,n)
     *         + f(2,2,lt)*v1(2,n) + f(2,3,lt)*v1(3,n))*valdx *.5*t(n)+ 
     *           (f(1,1,lt)*v1(1,n) + f(1,2,lt)*v1(2,n) 
     *         + f(1,3,lt)*v1(3,n))*valdy*.5*t(n)
            Bzz(3,n+3*nno) = Bzz(3,n+3*nno) + (fz(2,1,lt)*v1(1,n)
     *         +fz(2,2,lt)*v1(2,n) + fz(2,3,lt)*v1(3,n))*valdx*.5*t(n)+ 
     *           (fz(1,1,lt)*v1(1,n) + fz(1,2,lt)*v1(2,n) 
     *         + fz(1,3,lt)*v1(3,n))*valdy*.5*t(n)

c          (B_rs),5
         
             Bz(3,n+4*nno) =  Bz(3,n+4*nno) + (f(2,1,lt)*v2(1,n)
     *         + f(2,2,lt)*v2(2,n) + f(2,3,lt)*v2(3,n))*valdx*.5*t(n) + 
     *           (f(1,1,lt)*v2(1,n) + f(1,2,lt)*v2(2,n) 
     *         + f(1,3,lt)*v2(3,n))*valdy*.5*t(n)
            Bzz(3,n+4*nno) = Bzz(3,n+4*nno) + (fz(2,1,lt)*v2(1,n)
     *         +fz(2,2,lt)*v2(2,n) + fz(2,3,lt)*v2(3,n))*valdx*.5*t(n)+ 
     *           (fz(1,1,lt)*v2(1,n) + fz(1,2,lt)*v2(2,n) 
     *         + fz(1,3,lt)*v2(3,n))*valdy*.5*t(n)
 
 3       continue
        else
c      ---- > pas de reinterpolation
   
          do 30 n  = 1,nno

c
c          calcul de B_rs (B(3,...)
c

c          (B_rs),1
         
            B (3,n) =  fi(2,1) * vdpq2(1,n,l)  +
     *                   fi(1,1) * vdpq2(2,n,l)
            Bz(3,n) =  fiz(2,1) * vdpq2(1,n,l)  +
     *                   fiz(1,1) * vdpq2(2,n,l)

c          (B_rs),2
         
             B(3,n+nno) =  fi(2,2) * vdpq2(1,n,l) +
     *                      fi(1,2) * vdpq2(2,n,l)
            Bz(3,n+nno) = fiz(2,2) * vdpq2(1,n,l)
     *                    + fiz(1,2) * vdpq2(2,n,l)

c          (B_rs),3
         
             B(3,n+2*nno) =  fi(2,3) * vdpq2(1,n,l)
     *                      +  fi(1,3) * vdpq2(2,n,l)
            Bz(3,n+2*nno) = fiz(2,3) * vdpq2(1,n,l)
     *                      + fiz(1,3) * vdpq2(2,n,l)

c          (B_rs),4
         
             Bz(3,n+3*nno) =  (fi(2,1)*v1(1,n) + fi(2,2)*v1(2,n)
     *         + fi(2,3)*v1(3,n))*vdpq2(1,n,l) *.5*t(n)+ 
     *           (fi(1,1)*v1(1,n) + fi(1,2)*v1(2,n) 
     *         + fi(1,3)*v1(3,n))*vdpq2(2,n,l)*.5*t(n)
            Bzz(3,n+3*nno) = (fiz(2,1)*v1(1,n) +fiz(2,2)*v1(2,n)
     *         + fiz(2,3)*v1(3,n))*vdpq2(1,n,l)*.5*t(n)+ 
     *           (fiz(1,1)*v1(1,n) + fiz(1,2)*v1(2,n) 
     *         + fiz(1,3)*v1(3,n))*vdpq2(2,n,l)*.5*t(n)

c          (B_rs),5
         
             Bz(3,n+4*nno) =  (fi(2,1)*v2(1,n) + fi(2,2)*v2(2,n)
     *         + fi(2,3)*v2(3,n))*vdpq2(1,n,l)*.5*t(n) + 
     *           (fi(1,1)*v2(1,n) + fi(1,2)*v2(2,n) 
     *         + fi(1,3)*v2(3,n))*vdpq2(2,n,l)*.5*t(n)
            Bzz(3,n+4*nno) =  (fiz(2,1)*v2(1,n)+fiz(2,2)*v2(2,n)
     *         + fiz(2,3)*v2(3,n))*vdpq2(1,n,l)*.5*t(n)+ 
     *           (fiz(1,1)*v2(1,n) + fiz(1,2)*v2(2,n) 
     *         + fiz(1,3)*v2(3,n))*vdpq2(2,n,l)*.5*t(n)
 
 30         continue
        endif

         end

         


