      subroutine chan56(nno,ae5,lae5,ae6,lae6, t,v1,v2,xnorm,e)
c     ............................................................
c
c     transformer la matrice de rigidite de 5 a 6 dl/noeud
c     transformer bloc par bloc, pour chacun
c
c     K6 = P_t K5 P
c
c     avec
c
c           K11 K12 0                       I   0   0  
c     k5 =  K21 K22 0                       0   P22 P23  
c           0    0  k                       0   P32 P33
c 
c     .............................................................
      double precision  ae6(lae6),ae5(lae5),e,k,xnorm(3,nno),
     *                  v1(3,nno),v2(3,nno),t(nno),penal,ae2221

      parameter (penal = 100000) 


c    --------------- boucle sur les noeuds   -----------------
c        ----- lignes

      do 1 n=1,nno

       jlige  = 5*(n-1) 
       jligs  = 6*(n-1) 

       do 1 m= n,nno

         jcole  = 5*(m-1) 
         jcols  = 6*(m-1) 
c
c        multiplication bloc / bloc
c  

c        sous-blocs diagonaux

         if ( m .eq. n) then
            
c           -- > K6_11  bloc 3*3  sym
c                K6_11  = K5_11

            do 2 j = 1,3 
            js = (jcols+j)*(jcols+j-1)/2
            je = (jcole+j)*(jcole+j-1)/2   

            do 2 i = 1,j
               ae6(js+jligs+i) =ae5(je+jlige+i)
 2          continue


         else
c           -- > K6_11  bloc 3*3  nsym

            do 20 j = 1,3      
            js = (jcols+j)*(jcols+j-1)/2
            je = (jcole+j)*(jcole+j-1)/2   

            do 20 i = 1,3
               ae6(js+jligs+i) =ae5(je+jlige+i)
 20         continue

         end if

c        -- > K6_22  bloc 2,2  
c  
         je1 = (jcole+4)*(jcole+3)/2   
         je2 = (jcole+5)*(jcole+4)/2   

         js1 = (jcols+4)*(jcols+3)/2
         js2 = (jcols+5)*(jcols+4)/2


         if (m .ne. n) then       
             ae2221 = ae5(je1+jlige+5)
             k = 0
         else
             ae2221 = ae5(je2+jlige+4)
             k = e*penal
         endif

         ae6(js1+jligs+4) = v1(1,n)*ae5(je1+jlige+4)*v1(1,m)+
     *                     v1(1,n)*ae5(je2+jlige+4)*v2(1,m)+
     *                     v2(1,n)*ae2221*v1(1,m)+
     *                     v2(1,n)*ae5(je2+jlige+5)*v2(1,m)+
     *                     xnorm(1,n)*K*xnorm(1,m)
         if ( m .ne. n)
     *   ae6(js1+jligs+5) = v1(2,n)*ae5(je1+jlige+4)*v1(1,m)+
     *                     v1(2,n)*ae5(je2+jlige+4)*v2(1,m)+
     *                     v2(2,n)*ae2221*v1(1,m)+
     *                     v2(2,n)*ae5(je2+jlige+5)*v2(1,m)+
     *                     xnorm(2,n)*K*xnorm(1,m)

         ae6(js2+jligs+4) = v1(1,n)*ae5(je1+jlige+4)*v1(2,m)+
     *                     v1(1,n)*ae5(je2+jlige+4)*v2(2,m)+
     *                     v2(1,n)*ae2221*v1(2,m)+
     *                     v2(1,n)*ae5(je2+jlige+5)*v2(2,m)+
     *                     xnorm(1,n)*K*xnorm(2,m)

         ae6(js2+jligs+5) = v1(2,n)*ae5(je1+jlige+4)*v1(2,m)+
     *                     v1(2,n)*ae5(je2+jlige+4)*v2(2,m)+
     *                     v2(2,n)*ae2221*v1(2,m)+
     *                     v2(2,n)*ae5(je2+jlige+5)*v2(2,m)+
     *                     xnorm(2,n)*K*xnorm(2,m)



c        -- > K6_33  bloc 1,1
c  
         je1 = (jcole+4)*(jcole+3)/2   
         je2 = (jcole+5)*(jcole+4)/2   

         js = (jcols+6)*(jcols+5)/2

         ae6(js+jligs+6) =  v1(3,n)*ae5(je1+jlige+4)*v1(3,m)+
     *                     v1(3,n)*ae5(je2+jlige+4)*v2(3,m)+
     *                     v2(3,n)*ae2221*v1(3,m)+
     *                     v2(3,n)*ae5(je2+jlige+5)*v2(3,m)+
     *                     xnorm(3,n)*k* xnorm(3,m)
         
c  
c        sous-blocs non-diagonaux
c
c        -- >K6_12 bloc 3,2 et K6_13 bloc 3,1

         je1 = (jcole+4)*(jcole+3)/2   
         je2 = (jcole+5)*(jcole+4)/2   

         js1 = (jcols+4)*(jcols+3)/2
         js2 = (jcols+5)*(jcols+4)/2
         js3 = (jcols+6)*(jcols+5)/2

         do 3 i = 1,3

            ae6(js1+jligs+i) = ae5(je1+jlige+i)*v1(1,m)+
     *                        ae5(je2+jlige+i)*v2(1,m)
            ae6(js2+jligs+i) = ae5(je1+jlige+i)*v1(2,m)+
     *                        ae5(je2+jlige+i)*v2(2,m)
            ae6(js3+jligs+i) = ae5(je1+jlige+i)*v1(3,m)+
     *                        ae5(je2+jlige+i)*v2(3,m)
 3       continue

c        -- >K6_23 bloc 2,1

         je1 = (jcole+4)*(jcole+3)/2   
         je2 = (jcole+5)*(jcole+4)/2   

         js  = (jcols+6)*(jcols+5)/2

         ae6(js+jligs+4) = v1(1,n)*ae5(je1+jlige+4)*v1(3,m) +
     *                    v2(1,n)*ae2221*v1(3,m) +
     *                    v1(1,n)*ae5(je2+jlige+4)*v2(3,m) +
     *                    v2(1,n)*ae5(je2+jlige+5)*v2(3,m) +
     *                    xnorm(1,n)*k*xnorm(3,m)

         ae6(js+jligs+5) = v1(2,n)*ae5(je1+jlige+4)*v1(3,m) +
     *                       v2(2,n)*ae2221*v1(3,m) +
     *                       v1(2,n)*ae5(je2+jlige+4)*v2(3,m) +
     *                       v2(2,n)*ae5(je2+jlige+5)*v2(3,m) +
     *                       xnorm(2,n)*k*xnorm(3,m)

c        partie triangulaire inferieure si m different de n

         if ( m .ne. n) then

c           -- >K6_21 bloc 2,3
c           -- >K6_31 bloc 1,3


 
            do 4 j = 1,3

               js1 = (jcols+j)*(jcols+j-1)/2   
               je1 = (jcole+j)*(jcole+j-1)/2   

               ae6(js1+jligs+4) = ae5(je1+jlige+4)*v1(1,n)+
     *                           ae5(je1+jlige+5)*v2(1,n)
               ae6(js1+jligs+5) = ae5(je1+jlige+4)*v1(2,n)+
     *                           ae5(je1+jlige+5)*v2(2,n)
               ae6(js1+jligs+6) = ae5(je1+jlige+4)*v1(3,n)+
     *                           ae5(je1+jlige+5)*v2(3,n)
 4          continue

c           -- >K6_32 bloc 1,2

         je1 = (jcole+4)*(jcole+3)/2   
         je2 = (jcole+5)*(jcole+4)/2   

         js1 = (jcols+4)*(jcols+3)/2
         js2 = (jcols+5)*(jcols+4)/2

         ae6(js1+jligs+6) = v1(3,n)*ae5(je1+jlige+4)*v1(1,m) +
     *                     v1(3,n)*ae5(je2+jlige+4)*v2(1,m) +
     *                     v2(3,n)*ae5(je1+jlige+5)*v1(1,m) +
     *                     v2(3,n)*ae5(je2+jlige+5)*v2(1,m) +
     *                     xnorm(3,n)*k*xnorm(1,m)

         ae6(js2+jligs+6) = v1(3,n)*ae5(je1+jlige+4)*v1(2,m) +
     *                     v1(3,n)*ae5(je2+jlige+4)*v2(2,m) +
     *                     v2(3,n)*ae5(je1+jlige+5)*v1(2,m) +
     *                     v2(3,n)*ae5(je2+jlige+5)*v2(2,m) + 
     *                     xnorm(3,n)*k*xnorm(2,m)
         endif

 1    continue

       end
          
      
      
