      subroutine chan57mod(nno,ae5,lae5,ae6,lae6, t,e,COOR)
c     ............................................................
c
c     transformer la matrice de rigidite de 5 a 6 dl/noeud
c     pour cas Coventor plaque mince
c 
c     .............................................................
c     Programmer: Matthieu Sors Coventor/INRIA      2004
c     see Mathematica file for additional informations
c     .............................................................
c
c
c     .............................................................
c     Variables
c
c     ae5: Stiffness matrix without drilling
c     ae6: Stiffness matrix with drilling
c     Mesk: Area of the element
c     penal: coefficient of penalization
c     COOR: Coordinates of the nodes
c     .............................................................

      double precision  ae6(lae6),ae5(lae5),e,k,t(nno),
     *                  COOR(nno,3)
      double precision  penal,MesK,
     * 					Coef11x,Coef12x,Coef14x,Coef22x,Coef23x,Coef33x,Coef34x,Coef44x,
     *					Coef11y,Coef12y,Coef14y,Coef22y,Coef23y,Coef33y,Coef34y,Coef44y,
     *                  t1,t2,t3,t4, temp
     
      integer nno, n, i, j, k61,k62,k51,k52
      
      integer mp, status
      integer matOpen, matPutMatrix, matClose
      integer mxCreateDoubleMatrix, mxGetPr, arN
      integer Ar, are5, are6, ttp
      parameter (penal = 100.)
c
c    --------------- boucle sur les noeuds   -----------------
c        ----- lignes
C
C     ..................................................................
C     Initialize ae6
C     ..................................................................
C
       do 99 n=1,300
            ae6(n)=0.0
 99    continue
C
C     ..................................................................
C     Calculate area of the element
C     ..................................................................
C       
      MesK = (COOR(1,1)*COOR(2,2)-COOR(2,1)*COOR(1,2)
     *  +COOR(2,1)*COOR(3,2)-COOR(2,2)*COOR(3,1)
     *  +COOR(3,1)*COOR(4,2)-COOR(3,2)*COOR(4,1)
     *  +COOR(4,1)*COOR(1,2)-COOR(4,2)*COOR(1,1))/2

C     ...................................................................
C     Evaluate Coefficients of the Energy of penalization
C     ...................................................................
C
       Coef12x=(COOR(1,2)-COOR(2,2))/(2.*((-COOR(1,1)+COOR(2,1))**2+
     *  (-COOR(1,2)+COOR(2,2))**2))
       Coef12y=(-COOR(1,1)+COOR(2,1))/(2.*((-COOR(1,1)+COOR(2,1))**2+
     *   (-COOR(1,2) + COOR(2,2))**2))
       Coef14x=-(-COOR(1,2)+COOR(4,2))/(2.*((COOR(1,1)-COOR(4,1))**2+
     *   (COOR(1,2) - COOR(4,2))**2))
       Coef14y=(-COOR(1,1)+COOR(4,1))/(2.*((COOR(1,1)-COOR(4,1))**2+
     *   (COOR(1,2) - COOR(4,2))**2))
       Coef23x=(COOR(2,2)-COOR(3,2))/(2.*((-COOR(2,1)+COOR(3,1))**2+
     *   (-COOR(2,2) + COOR(3,2))**2))
       Coef23y=(-COOR(2,1)+COOR(3,1))/(2.*((-COOR(2,1)+COOR(3,1))**2+
     *   (-COOR(2,2) + COOR(3,2))**2))
       Coef34x=(COOR(3,2)-COOR(4,2))/(2.*((-COOR(3,1)+COOR(4,1))**2+
     *   (-COOR(3,2) + COOR(4,2))**2))
       Coef34y=(-COOR(3,1)+COOR(4,1))/(2.*((-COOR(3,1)+COOR(4,1))**2+
     *   (-COOR(3,2) + COOR(4,2))**2))
C       
       	Coef11x=-Coef12x - Coef14x
		Coef11y=-Coef12y - Coef14y
  		Coef22x=Coef12x - Coef23x
  		Coef22y=Coef12y - Coef23y
  		Coef33x=Coef23x - Coef34x
  		Coef33y=Coef23y - Coef34y
  		Coef44x=Coef14x + Coef34x
  		Coef44y=Coef14y + Coef34y
C  
C  
       t1=t(1)
       t2=t(2)
       t3=t(3)
       t4=t(4)
C
C      ..........................................................
C      Test
C      ..........................................................
C     
C      if(COOR(3,2) .eq. 1) then
C          if(COOR(3,1) .eq. 2) then
C      temp=MesK
c      mp = matOpen('inputm.mat', 'w')
C 
c      arN = mxCreateDoubleMatrix(1,1,0)
c      call mxCopyReal8ToPtr(MesK,mxGetPr(arN),1)
c      call mxSetName(arN,'MesK')      
c      status = matPutMatrix(mp,arN)      
c      status = matClose(mp) 
C          endif
C      endif
C
C      .................................................................
C      Copy ae5 in ae6
C      .................................................................
C       
       do 1 n=1,nno
            if (n .ne. 1) then
                nloc=n-1
                do 2 ncar=1,nloc
                    do 3 i=1,5
                            k61=6*nloc+i
                            k51=5*nloc+i
                            do 4 j=1,5
                                k62=6*(ncar-1)+j
                                k52=5*(ncar-1)+j
C                        
                                ae6(((k61*(k61-1)/2))+ k62)=
     *                            ae5(((k51*(k51-1)/2))+ k52)
 4                          continue
 3                  continue
 2              continue
           endif
C    
C                
            do 21 i=1,5
                k61=6*(n-1)+i
                k51=5*(n-1)+i
                    do 31 j=1,i
                        k62=6*(n-1)+j
                        k52=5*(n-1)+j
C            
                        ae6(((k61*(k61-1)/2))+ k62)=
     *                    ae5(((k51*(k51-1)/2))+ k52)
 31                continue
 21        continue
  1     continue
C
C     ...................................................................
C     Adding Energy of compensation for drilling degrees of freedom
C     ...................................................................
C
		ae6(1)=ae6(1)+e*MesK*penal*
     *    (Coef11x**2*t1 + Coef12x**2*t2 + Coef14x**2*t4)
		ae6(2)=ae6(2)+e*MesK*penal*
     *    (Coef11x*Coef11y*t1+Coef12x*Coef12y*t2+Coef14x*Coef14y*t4)
		ae6(3)=ae6(3)+e*MesK*penal*
     *    (Coef11y**2*t1 + Coef12y**2*t2 + Coef14y**2*t4)
		ae6(16)=ae6(16)-(Coef11x*e*MesK*penal*t1)
		ae6(17)=ae6(17)-(Coef11y*e*MesK*penal*t1)
		ae6(21)=ae6(21)+e*MesK*penal*t1
		ae6(22)=ae6(22)+e*MesK*penal*
     *    (Coef11x*Coef12x*t1 - Coef12x*Coef22x*t2)
		ae6(23)=ae6(23)+e*MesK*penal*
     *      (Coef11y*Coef12x*t1 - Coef12y*Coef22x*t2)
		ae6(27)=ae6(27)-(Coef12x*e*MesK*penal*t1)
		ae6(28)=ae6(28)+e*MesK*penal*
     *    (Coef12x**2*t1 + Coef22x**2*t2 + Coef23x**2*t3)
		ae6(29)=ae6(29)+e*MesK*penal*
     *    (Coef11x*Coef12y*t1 - Coef12x*Coef22y*t2)
		ae6(30)=ae6(30)+e*MesK*penal*
     *    (Coef11y*Coef12y*t1 - Coef12y*Coef22y*t2)
		ae6(34)=ae6(34)-(Coef12y*e*MesK*penal*t1)
		ae6(35)=ae6(35)+e*MesK*penal*
     *    (Coef12x*Coef12y*t1+Coef22x*Coef22y*t2+Coef23x*Coef23y*t3)
		ae6(36)=ae6(36)+e*MesK*penal*
     *    (Coef12y**2*t1 + Coef22y**2*t2 + Coef23y**2*t3)
		ae6(67)=ae6(67)+Coef12x*e*MesK*penal*t2
		ae6(68)=ae6(68)+Coef12y*e*MesK*penal*t2
		ae6(73)=ae6(73)-(Coef22x*e*MesK*penal*t2)
		ae6(74)=ae6(74)-(Coef22y*e*MesK*penal*t2)
		ae6(78)=ae6(78)+e*MesK*penal*t2
		ae6(79)=ae6(79)+e*MesK*penal*
     *    (-(Coef12x*Coef23x*t2) + Coef14x*Coef34x*t4)
		ae6(80)=ae6(80)+e*MesK*penal*
     *    (-(Coef12y*Coef23x*t2) + Coef14y*Coef34x*t4)
		ae6(85)=ae6(85)+e*MesK*penal*
     *    (Coef22x*Coef23x*t2 - Coef23x*Coef33x*t3)
		ae6(86)=ae6(86)+e*MesK*penal*
     *    (Coef22y*Coef23x*t2 - Coef23y*Coef33x*t3)
		ae6(90)=ae6(90)-(Coef23x*e*MesK*penal*t2)
		ae6(91)=ae6(91)+e*MesK*penal*
     *    (Coef23x**2*t2 + Coef33x**2*t3 + Coef34x**2*t4)
		ae6(92)=ae6(92)+e*MesK*penal*
     *    (-(Coef12x*Coef23y*t2) + Coef14x*Coef34y*t4)
		ae6(93)=ae6(93)+e*MesK*penal*
     *    (-(Coef12y*Coef23y*t2) + Coef14y*Coef34y*t4)
		ae6(98)=ae6(98)+e*MesK*penal*
     *    (Coef22x*Coef23y*t2 - Coef23x*Coef33y*t3)
		ae6(99)=ae6(99)+e*MesK*penal*
     *    (Coef22y*Coef23y*t2 - Coef23y*Coef33y*t3)
		ae6(103)=ae6(103)-(Coef23y*e*MesK*penal*t2)
		ae6(104)=ae6(104)+e*MesK*penal*
     *    (Coef23x*Coef23y*t2+Coef33x*Coef33y*t3+Coef34x*Coef34y*t4)
		ae6(105)=ae6(105)+e*MesK*penal*
     *    (Coef23y**2*t2 + Coef33y**2*t3 + Coef34y**2*t4)
		ae6(160)=ae6(160)+Coef23x*e*MesK*penal*t3
		ae6(161)=ae6(161)+Coef23y*e*MesK*penal*t3
		ae6(166)=ae6(166)-(Coef33x*e*MesK*penal*t3)
		ae6(167)=ae6(167)-(Coef33y*e*MesK*penal*t3)
		ae6(171)=ae6(171)+e*MesK*penal*t3
		ae6(172)=ae6(172)+e*MesK*penal*
     *    (Coef11x*Coef14x*t1 - Coef14x*Coef44x*t4)
		ae6(173)=ae6(173)+e*MesK*penal*
     *    (Coef11y*Coef14x*t1 - Coef14y*Coef44x*t4)
		ae6(177)=ae6(177)-(Coef14x*e*MesK*penal*t1)
		ae6(178)=ae6(178)+e*MesK*penal*
     *    (Coef12x*Coef14x*t1 - Coef23x*Coef34x*t3)
		ae6(179)=ae6(179)+e*MesK*penal*
     *    (Coef12y*Coef14x*t1 - Coef23y*Coef34x*t3)
		ae6(184)=ae6(184)+e*MesK*penal*
     *    (Coef33x*Coef34x*t3 - Coef34x*Coef44x*t4)
		ae6(185)=ae6(185)+e*MesK*penal*
     *    (Coef33y*Coef34x*t3 - Coef34y*Coef44x*t4)
		ae6(189)=ae6(189)-(Coef34x*e*MesK*penal*t3)
		ae6(190)=ae6(190)+e*MesK*penal*
     *    (Coef14x**2*t1 + Coef34x**2*t3 + Coef44x**2*t4)
		ae6(191)=ae6(191)+e*MesK*penal*
     *    (Coef11x*Coef14y*t1 - Coef14x*Coef44y*t4)
		ae6(192)=ae6(192)+e*MesK*penal*
     *    (Coef11y*Coef14y*t1 - Coef14y*Coef44y*t4)
		ae6(196)=ae6(196)-(Coef14y*e*MesK*penal*t1)
		ae6(197)=ae6(197)+e*MesK*penal*
     *    (Coef12x*Coef14y*t1 - Coef23x*Coef34y*t3)
		ae6(198)=ae6(198)+e*MesK*penal*
     *    (Coef12y*Coef14y*t1 - Coef23y*Coef34y*t3)
		ae6(203)=ae6(203)+e*MesK*penal*
     *    (Coef33x*Coef34y*t3 - Coef34x*Coef44y*t4)
		ae6(204)=ae6(204)+e*MesK*penal*
     *    (Coef33y*Coef34y*t3 - Coef34y*Coef44y*t4)
		ae6(208)=ae6(208)-(Coef34y*e*MesK*penal*t3)
		ae6(209)=ae6(209)+e*MesK*penal*
     *    (Coef14x*Coef14y*t1+Coef34x*Coef34y*t3+Coef44x*Coef44y*t4)
		ae6(210)=ae6(210)+e*MesK*penal*
     *    (Coef14y**2*t1 + Coef34y**2*t3 + Coef44y**2*t4)
		ae6(277)=ae6(277)+Coef14x*e*MesK*penal*t4
		ae6(278)=ae6(278)+Coef14y*e*MesK*penal*t4
		ae6(289)=ae6(289)+Coef34x*e*MesK*penal*t4
		ae6(290)=ae6(290)+Coef34y*e*MesK*penal*t4
		ae6(295)=ae6(295)-(Coef44x*e*MesK*penal*t4)
		ae6(296)=ae6(296)-(Coef44y*e*MesK*penal*t4)
		ae6(300)=ae6(300)+e*MesK*penal*t4
C
C      ..........................................................
C      Test
C      ..........................................................
C
C        if(COOR(3,2) .eq. 1) then
C          if(COOR(3,1) .eq. 1) then
C        mp = matOpen('inputm2.mat', 'w')
C 
C        are6 = mxCreateDoubleMatrix(300,1,0)
C        call mxCopyReal8ToPtr(ae6,mxGetPr(are6),300)
C        call mxSetName(are6,'ae6ap')      
C        status = matPutMatrix(mp,are6)      
C        status = matClose(mp) 
C          endif
C        endif
C
        end
        
