      SUBROUTINE DPAQ2C(R,Z,NBPOLY,NPI,POIDSG,P,DP,F1,F2,DFM1DP,POIDEL)
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C IN:  R et Z des 9 points de l'element + (Cf. include polbas.ins)
C      NBPOLY : NBRE DE POLYNOMES DE BASE = 9
C      NPI    : NBRE DE POINTS D INTEGRATION SUR L ELEMENT = 9
C      POIDSG(NPI): VALEUR DES NPI POIDS GAUSS
C      P(NBPOLY,NPI): VALEUR des polynomes de base aux points d'int. num
C      DP(2,NBPOLY,NPI): Valeur DERIVEE DP/DX,  DP/DY
C OUT: F1,F2  COORDONNEES DES PTS D INT. NUMERIQUES DE L ELEMENT COURANT
C      DFM1DP = PRODUIT DF-1 * DP 
C      POIDEL : PRODUIT DU POIDSG*DELTA*R AUX POINTS D'INTEGRATION
C ......................................................................
      implicit none
      INTEGER NBPOLY,NPI, L, I
      DOUBLE PRECISION R(9),Z(9)
      DOUBLE PRECISION POIDSG(NPI),P(NBPOLY,NPI),DP(2,NBPOLY,NPI),
     +             POIDEL(9),RR,ZZ,DF1,DF2,DF3,DF4,F1(9),F2(9),D,
     +             DFM1(4,9),DFM1DP(2,9,9)
C
C      F1,DFM1,DELTA
C
      DO 2 L=1,NPI
         RR = 0.D0
         ZZ = 0.D0
         DF1= 0.D0
         DF2= 0.D0
         DF3= 0.D0
         DF4= 0.D0
         DO 3 I=1,NBPOLY
            RR  = RR + P(I,L) * R(I)
            ZZ  = ZZ + P(I,L) * Z(I)
            DF1 = DF1 + DP(1,I,L) * R(I)
            DF2 = DF2 + DP(2,I,L) * R(I)
            DF3 = DF3 + DP(1,I,L) * Z(I)
            DF4 = DF4 + DP(2,I,L) * Z(I)
    3    CONTINUE
         F1(L) = RR
         F2(L) = ZZ
         D     = DF1 * DF4 - DF2 * DF3
         DFM1(1,L) = DF4 / D
         DFM1(2,L) =-DF2 / D
         DFM1(3,L) =-DF3 / D
         DFM1(4,L) = DF1 / D
         POIDEL(L) = DABS(D) * POIDSG(L) * RR
C
C        DFM1DP = DF-1 * DP SUR T UNITE
C
         DO 4 I=1,NBPOLY
            DFM1DP(1,I,L) = DFM1(1,L) * DP(1,I,L) +
     +                      DFM1(3,L) * DP(2,I,L)
            DFM1DP(2,I,L) = DFM1(2,L) * DP(1,I,L) +
     +                      DFM1(4,L) * DP(2,I,L)
    4    CONTINUE
    2 CONTINUE
C
C     COORDONNEES DU BARYCENTRE DE L'ELEMENT COURANT:  F1(5) ET F2(5)

      END
