      SUBROUTINE E2AQ2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,
     +                  poidel,dfm1,RZ)
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                    S.P. E2AP2C
C                   ------------
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: IP     : PASSAGE DES D.L. PAR COMPOSANTE AUX NOEUDS 
C      F1,F2  : COOR DES POINTS D INT.  NUM. DE L ELEMENT COURANT
C      DFM1   = (DF) -1 AUX POINTS D INTEGRATION
C      DFM1DP = DERIVEES DES POLYNOMES AUX POINTS D INTEGRATION
C      POIDEL : POIDS * DELTA * R  AUX POINTS D'INTEGRATION
C
C PARAMETRES D ENTREE :
C ---------------------
C NBPOLY : NBRE DE POLYNOMES DE BASE
C NPI    : NBRE DE POINTS D INTEGRATION SUR L ELEMENT
C POIDS  : VALEUR DES NPI POIDS
C P13    : P13(I,J)=VALEUR DE PI(POINT J D INTEGRATION)
C DP13   : DP13(I,J,L)=DERIVEE DPJ/DXI(POINT L)
C RZ(NOE,NDIM): RAYON ET COTE DES 3 POINTS DE L ELEMENT
C ......................................................................
c  programmeur : modulef
c ......................................................................
      implicit none
      integer nbpoly, NPI, IP(16), j, i2, i, l
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 POIDEL(npi),RR,ZZ,DF1,DF2,DF3,DF4,F1(npi),
     +                 F2(npi),D,DFM1(4,NPI),DFM1DP(2,nbpoly,NPI),
     +                 D2PI,RZ(nbpoly,2)
      DATA D2PI/ 6.2831853071795862D0 /
C
C     IP(I) = POSITION DU I-EME D.L. PAR COMPOSANTE DANS L ORDRE
C             NOEUD PAR NOEUD
C
      IP( 1) = 1
      IP(16) = 16
      J      = 1
      I2     = 2 * NBPOLY - 2
      DO 1 I = 2,I2,2
         IP(J+NBPOLY) = I
         J = J + 1
         IP(J) = I + 1
    1 CONTINUE
C
C      F1,DFM1,DELTA
C
      DO 2 L=1,NPI
         RR = 0.D0
         ZZ = 0.D0
         DF1= 0.D0
         DF2= 0.D0
         DF3= 0.D0
         DF4= 0.D0
         DO 3 I=1,NBPOLY
            RR  = RR + P25(I,L) * RZ(I,1)
            ZZ  = ZZ + P25(I,L) * RZ(I,2)
            DF1 = DF1 + DP25(1,I,L) * RZ(I,1)
            DF2 = DF2 + DP25(2,I,L) * RZ(I,1)
            DF3 = DF3 + DP25(1,I,L) * RZ(I,2)
            DF4 = DF4 + DP25(2,I,L) * RZ(I,2)
    3    CONTINUE
         F1(L) = RR
         F2(L) = ZZ
         D     = DF1 * DF4 - DF2 * DF3
         DFM1(1,L) = DF4 / D
         DFM1(2,L) =-DF2 / D
         DFM1(3,L) =-DF3 / D
         DFM1(4,L) = DF1 / D
         POIDEL(L) = DABS(D) * POIDS(L) * D2PI * RR
C
C        DP = DF-1 * DP SUR T UNITE
C
         DO 4 I=1,NBPOLY
            DFM1DP(1,I,L) = DFM1(1,L) * DP25(1,I,L) +
     +                      DFM1(3,L) * DP25(2,I,L)
            DFM1DP(2,I,L) = DFM1(2,L) * DP25(1,I,L) +
     +                      DFM1(4,L) * DP25(2,I,L)
    4    CONTINUE
    2 CONTINUE
C
C     COORDONNEES DU BARYCENTRE DE L'ELEMENT COURANT
C     F1(5) ET F2(5)
      END
