       SUBROUTINE EC3C2C(NNO,NPO,X,Y,Z,IJT,VDPQ2,VDPQ1,iopt,e,
     +                   xnu,ELAS,SIGMAE,SIGMA,U, DELTA,A2)
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT : CALCUL DES TABLEAUX SIGMAE ET SIGMA
C  ---        CONTRAINTES ELEMENTAIRES D UN ELEMENT
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C   PARAMETRES D'ENTREE :
C  -------------------
c  NNO          : nombre de points (interpolation des fonctions)
c  NPO          : nombre de points (interpolation de la geometrie)
C  IJT          : PERMUTATION
C  X,Y,Z        : COORDONNEES DES NOEUDS DE L ELEMENT
C  ELAS         : MATRICE D ELASTICITE DE L ELEMENT
C  VDPQ2        : VALEURS DES DERIVES DES POL DE BASE (Fonctions)
C  VDPQ1        : VALEURS DES DERIVES DES POLYNOMES DE BASE (geometrie)
C  VP1          : VALEURS DES POLYNOMES DE BASE DE (geometrie)
C  POUR CES POL. OU DP. CES VALEURS  SONT AUX NOEUDS
c  U            : solution dans l element
c
c   TAB DE TRAVAIL
c  ----------------
C  SIGMAE         : VALEURS DES CONTRAINTES ELEMENTAIRES
c
C  PARAMETRES RESULTATS :
C  --------------------
C  SIGMA          : contraintes
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEURS  : Marina Vidrascu 2001
C  ...................................................................
      parameter (ndim=3)
      DOUBLE PRECISION X(NPO),Y(NPO),Z(NPO)
      DOUBLE PRECISION VDPQ1(3,NPO,NNO),VDPQ2(3,NNO,NNO),DELTA(NNO),
     +           A2(3,NNO,NNO),ELAS(9),DFINV(3,3),DF(3,3),
     +           SIGMAE(6,NDIM*NNO,NNO),sigma(6,nno),U(ndim*nno),
     +           e,xnu,xlam,xmu,
     +           XINT(1),YINT(1),ZINT(1)
      dimension IJT(ndim*nno)
c
c     ---- non utilises ---
c
      double precision fi(1),vp1(1)
C
C   -----  CALCUL DE DELTA , DERIVEES  -----
C

      INDICE = 1
      CALL FOBASE(3,3,NNO,NPO,NNO,VP1,VP1,VDPQ2,VDPQ1,X,Y,Z,
     +            A2,XINT,YINT,ZINT,DELTA,DFINV,DF,INDICE,
     +            fi,fi,fi,iopt)
c
c
C           --------------

       if (iopt .eq. 2) then
               XMU   = E/(2.*(1.+XNU))
               XLAM  = E*XNU/((1.+XNU)* (1.-2.*XNU))
               ELAS(1) = XLAM + 2. * XMU
               ELAS(3) = XLAM + 2. * XMU
               ELAS(6) = XLAM + 2. * XMU
               ELAS(2) = XLAM
               ELAS(4) = XLAM
               ELAS(5) = XLAM
               ELAS(7) = XMU
               ELAS(8) = XMU
               ELAS(9) = XMU
       endif
C
c       pour traiter l'orthotrope donner directement elas!
C
      DO 10 L=1,NNO
C
C        B = DELTA * (DF)-1 * VDPQ2(L)
C
      DO 11 J=1,NNO
C
C   --- BLOC1
C
        J1=IJT(J)
            SIGMAE(1,J1,L) = ELAS(1)*A2(1,J,L) / DELTA(L)
            SIGMAE(2,J1,L) = ELAS(2)*A2(1,J,L) / DELTA(L)
            SIGMAE(3,J1,L) = ELAS(4)*A2(1,J,L) / DELTA(L)
            SIGMAE(4,J1,L) = ELAS(7)*A2(2,J,L) / DELTA(L)
            SIGMAE(5,J1,L) = 0
            SIGMAE(6,J1,L) = ELAS(9)*A2(3,J,L) / DELTA(L)
c
C   --- BLOC2
C
        J1=IJT(J+NNO)
            SIGMAE(1,J1,L) = ELAS(2)*A2(2,J,L) / DELTA(L)
            SIGMAE(2,J1,L) = ELAS(3)*A2(2,J,L) / DELTA(L)
            SIGMAE(3,J1,L) = ELAS(5)*A2(2,J,L) / DELTA(L)
            SIGMAE(4,J1,L) = ELAS(7)*A2(1,J,L) / DELTA(L)
            SIGMAE(5,J1,L) = ELAS(8)*A2(3,J,L) / DELTA(L)
            SIGMAE(6,J1,L) = 0
C
C   --- BLOC3
C
        J1=IJT(J+NNO*2)
            SIGMAE(1,J1,L) = ELAS(4)*A2(3,J,L) / DELTA(L)
            SIGMAE(2,J1,L) = ELAS(5)*A2(3,J,L) / DELTA(L)
            SIGMAE(3,J1,L) = ELAS(6)*A2(3,J,L) / DELTA(L)
            SIGMAE(4,J1,L) = 0
            SIGMAE(5,J1,L) = ELAS(8)*A2(2,J,L) / DELTA(L)
            SIGMAE(6,J1,L) = ELAS(9)*A2(1,J,L) / DELTA(L)
 11    CONTINUE
c
c       multiplier la contraine elementaire par le deplacement
c
        do 2 i = 1,6
           sigma(i,l) = 0.
           do 2 j = 1,3*nno
              sigma(i,l) = sigma(i,l) + sigmae(i,j,l)*u(j)
 2      continue

   10 CONTINUE
      END
