       SUBROUTINE EMAQ2C(N,R,Z,Rho,AE)
C ***************************************************************
C BUT : CALCUL DE LA MATRICE DE MASSE DE L ELEMENT QUAD AQ2C
C --- 
C IN :
C      N           : Nb ondes circonferentielles
C      R(9) , Z(9) : Coordonnees des sommets de l'element courant
C      Rho  : masse volumique
C OUT: matrice de rigidite AE. Cf ERAQ2C pour mode de stockage.
C .......................................................................
C  PROGRAMMEUR :  A.Hassim
C .......................................................................
      IMPLICIT NONE
      integer I, N
      double precision  R(9),Z(9)
      double precision AE(378),RHO,POIDEL(9),F1(9),F2(9),DFM1DP(2,9,9), 
     +                 P1,P2,P3,P4,P5,P6,P7,P8,P9,poids,COEF,PI
      include 'dpaq2c.ins'
      DATA PI /3.14159265358979D0/
C
C     Calcul de [DF]  ; [DF] * [DP] ; ...
C
      CALL DPAQ2C(R,Z,NBPOLY,NPI,POIDSG,P,DP,F1,F2,DFM1DP,POIDEL)
C
C     INITIALISATION DE AE: -> AZEROD(1,1,378,AE)
C     --------------------
       DO 1 I = 1 , 378
          AE(I) = 0.D0
 1     CONTINUE
C
       IF(N .EQ. 0) THEN
         COEF = 2.D0*PI
       ELSE
         COEF = PI
       END IF
       DO 2 I = 1 , 9
         poids = COEF * RHO * poidel(i)
         P1   = P(1,I)
         P2   = P(2,I)
         P3   = P(3,I)
         P4   = P(4,I)
         P5   = P(5,I)
         P6   = P(6,I)
         P7   = P(7,I)
         P8   = P(8,I)
         P9   = P(9,I)

      AE(1) = AE(1)+poids*P1**2
      AE(3) = AE(3)+poids*P1**2
      AE(6) = AE(6)+poids*P1**2
      AE(7) = AE(7)+poids*P1*P2
      AE(10) = AE(10)+poids*P2**2
      AE(12) = AE(12)+poids*P1*P2
      AE(15) = AE(15)+poids*P2**2
      AE(18) = AE(18)+poids*P1*P2
      AE(21) = AE(21)+poids*P2**2
      AE(22) = AE(22)+poids*P1*P3
      AE(25) = AE(25)+poids*P2*P3
      AE(28) = AE(28)+poids*P3**2
      AE(30) = AE(30)+poids*P1*P3
      AE(33) = AE(33)+poids*P2*P3
      AE(36) = AE(36)+poids*P3**2
      AE(39) = AE(39)+poids*P1*P3
      AE(42) = AE(42)+poids*P2*P3
      AE(45) = AE(45)+poids*P3**2
      AE(46) = AE(46)+poids*P1*P4
      AE(49) = AE(49)+poids*P2*P4
      AE(52) = AE(52)+poids*P3*P4
      AE(55) = AE(55)+poids*P4**2
      AE(57) = AE(57)+poids*P1*P4
      AE(60) = AE(60)+poids*P2*P4
      AE(63) = AE(63)+poids*P3*P4
      AE(66) = AE(66)+poids*P4**2
      AE(69) = AE(69)+poids*P1*P4
      AE(72) = AE(72)+poids*P2*P4
      AE(75) = AE(75)+poids*P3*P4
      AE(78) = AE(78)+poids*P4**2
      AE(79) = AE(79)+poids*P1*P5
      AE(82) = AE(82)+poids*P2*P5
      AE(85) = AE(85)+poids*P3*P5
      AE(88) = AE(88)+poids*P4*P5
      AE(91) = AE(91)+poids*P5**2
      AE(93) = AE(93)+poids*P1*P5
      AE(96) = AE(96)+poids*P2*P5
      AE(99) = AE(99)+poids*P3*P5
      AE(102) = AE(102)+poids*P4*P5
      AE(105) = AE(105)+poids*P5**2
      AE(108) = AE(108)+poids*P1*P5
      AE(111) = AE(111)+poids*P2*P5
      AE(114) = AE(114)+poids*P3*P5
      AE(117) = AE(117)+poids*P4*P5
      AE(120) = AE(120)+poids*P5**2
      AE(121) = AE(121)+poids*P1*P6
      AE(124) = AE(124)+poids*P2*P6
      AE(127) = AE(127)+poids*P3*P6
      AE(130) = AE(130)+poids*P4*P6
      AE(133) = AE(133)+poids*P5*P6
      AE(136) = AE(136)+poids*P6**2
      AE(138) = AE(138)+poids*P1*P6
      AE(141) = AE(141)+poids*P2*P6
      AE(144) = AE(144)+poids*P3*P6
      AE(147) = AE(147)+poids*P4*P6
      AE(150) = AE(150)+poids*P5*P6
      AE(153) = AE(153)+poids*P6**2
      AE(156) = AE(156)+poids*P1*P6
      AE(159) = AE(159)+poids*P2*P6
      AE(162) = AE(162)+poids*P3*P6
      AE(165) = AE(165)+poids*P4*P6
      AE(168) = AE(168)+poids*P5*P6
      AE(171) = AE(171)+poids*P6**2
      AE(172) = AE(172)+poids*P1*P7
      AE(175) = AE(175)+poids*P2*P7
      AE(178) = AE(178)+poids*P3*P7
      AE(181) = AE(181)+poids*P4*P7
      AE(184) = AE(184)+poids*P5*P7
      AE(187) = AE(187)+poids*P6*P7
      AE(190) = AE(190)+poids*P7**2
      AE(192) = AE(192)+poids*P1*P7
      AE(195) = AE(195)+poids*P2*P7
      AE(198) = AE(198)+poids*P3*P7
      AE(201) = AE(201)+poids*P4*P7
      AE(204) = AE(204)+poids*P5*P7
      AE(207) = AE(207)+poids*P6*P7
      AE(210) = AE(210)+poids*P7**2
      AE(213) = AE(213)+poids*P1*P7
      AE(216) = AE(216)+poids*P2*P7
      AE(219) = AE(219)+poids*P3*P7
      AE(222) = AE(222)+poids*P4*P7
      AE(225) = AE(225)+poids*P5*P7
      AE(228) = AE(228)+poids*P6*P7
      AE(231) = AE(231)+poids*P7**2
      AE(232) = AE(232)+poids*P1*P8
      AE(235) = AE(235)+poids*P2*P8
      AE(238) = AE(238)+poids*P3*P8
      AE(241) = AE(241)+poids*P4*P8
      AE(244) = AE(244)+poids*P5*P8
      AE(247) = AE(247)+poids*P6*P8
      AE(250) = AE(250)+poids*P7*P8
      AE(253) = AE(253)+poids*P8**2
      AE(255) = AE(255)+poids*P1*P8
      AE(258) = AE(258)+poids*P2*P8
      AE(261) = AE(261)+poids*P3*P8
      AE(264) = AE(264)+poids*P4*P8
      AE(267) = AE(267)+poids*P5*P8
      AE(270) = AE(270)+poids*P6*P8
      AE(273) = AE(273)+poids*P7*P8
      AE(276) = AE(276)+poids*P8**2
      AE(279) = AE(279)+poids*P1*P8
      AE(282) = AE(282)+poids*P2*P8
      AE(285) = AE(285)+poids*P3*P8
      AE(288) = AE(288)+poids*P4*P8
      AE(291) = AE(291)+poids*P5*P8
      AE(294) = AE(294)+poids*P6*P8
      AE(297) = AE(297)+poids*P7*P8
      AE(300) = AE(300)+poids*P8**2
      AE(301) = AE(301)+poids*P1*P9
      AE(304) = AE(304)+poids*P2*P9
      AE(307) = AE(307)+poids*P3*P9
      AE(310) = AE(310)+poids*P4*P9
      AE(313) = AE(313)+poids*P5*P9
      AE(316) = AE(316)+poids*P6*P9
      AE(319) = AE(319)+poids*P7*P9
      AE(322) = AE(322)+poids*P8*P9
      AE(325) = AE(325)+poids*P9**2
      AE(327) = AE(327)+poids*P1*P9
      AE(330) = AE(330)+poids*P2*P9
      AE(333) = AE(333)+poids*P3*P9
      AE(336) = AE(336)+poids*P4*P9
      AE(339) = AE(339)+poids*P5*P9
      AE(342) = AE(342)+poids*P6*P9
      AE(345) = AE(345)+poids*P7*P9
      AE(348) = AE(348)+poids*P8*P9
      AE(351) = AE(351)+poids*P9**2
      AE(354) = AE(354)+poids*P1*P9
      AE(357) = AE(357)+poids*P2*P9
      AE(360) = AE(360)+poids*P3*P9
      AE(363) = AE(363)+poids*P4*P9
      AE(366) = AE(366)+poids*P5*P9
      AE(369) = AE(369)+poids*P6*P9
      AE(372) = AE(372)+poids*P7*P9
      AE(375) = AE(375)+poids*P8*P9
      AE(378) = AE(378)+poids*P9**2
C
 2    CONTINUE
      END
