       SUBROUTINE ERAQ2C(N,R,Z,YOUNG,POISSON,AE)
C ***************************************************************
C BUT: CALCUL DE LA MATRICE DE RIGIDITE POUR L'ELEMENT QUAD AQ2C
C ---  QUADRANGLE Q2 AXISYMETRIQUE
C IN :
C      N           : Nb ondes circonferentielles
C      R(9) , Z(9) : Coordonnees des sommets de l'element courant
C      YOUNG et POISSON
C OUT: AE: MATRICE DE RIGIDITE DE L'ELEMENT.
C
C    [ AE(1) AE(2) AE(4) AE(7)  .......... ]  { Ur    (1) }
C    [       AE(3) AE(5)  :     .......... ]  { Utheta(1) }
C    [             AE(6)  :     .......... ]  { Uz    (1) }
C    [                    :     .......... ]  {   .....   }
C    [                          .......... ]  {   .....   }
C    [                          .......... ]  { Ur    (9) ]
C    [                             AE(377) ]  { Utheta(9) }
C    [                             AE(378) ]  { Uz    (9) }
C                                        27*27
C    SEULE LA PARTIE SUPERIEURE DE HAUT EN BAS ET DE GAUCHE VERS LA
C    DROITE EST STOCKEE. Soit AE(27 * (27+1)/2) = AE(378)
C  
C      4----- 7 -------3
C      |               |
C      |               |  3 degrees de liberte' par noeud :
C      8      9        6  ( Ur(i), Utheta(i), Uz (i) ; i=1,9)
C      |               |
C      |               |
C      1------5--------2
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C PROGRAMMEUR A. Hassim
C  ..............................................................
      IMPLICIT NONE
      INTEGER N, I
      DOUBLE PRECISION    R(9),Z(9)
      DOUBLE PRECISION  young,poisson,E(9),AE(378),lambda,mu,
     +  poidel(9),F1(9),F2(9),DFM1DP(2,9,9),P1,P2,P3,P4,P5,P6,
     +  P7,P8,P9,DPr1,DPr2,DPr3,DPr4,DPr5,DPr6,DPr7,DPr8,DPr9,
     +  DPz1,DPz2,DPz3,DPz4,DPz5,DPz6,DPz7,DPz8,DPz9,poids,f,
     +  COEF,PI
      include 'dpaq2c.ins'
      DATA PI /3.14159265358979D0/

C
      lambda= YOUNG*POISSON/( (1.D0+POISSON) * (1.D0-2.D0*POISSON) )
      mu    = YOUNG /( 2.D0 * (1.D0+POISSON) )
      E(1) = lambda + 2.D0 * mu
      E(2) = lambda
      E(3) = E(1)
      E(4) = lambda
      E(5) = lambda 
      E(6) = E(1)
      E(7) = mu
      E(8) = mu
      E(9) = mu
C
C     -- Calcul de [DF]  ; [DF] * [DP] ; ...
C
      CALL DPAQ2C(R,Z,NBPOLY,NPI,POIDSG,P,DP,F1,F2,DFM1DP,POIDEL)
C
C     -- INITIALISATION DE AE:
C
       DO 1 I = 1 , 378
          AE(I) = 0.D0
 1     CONTINUE
C
       if(N .eq. 0) then
       	coef = 2.D0 * PI
       else
       	coef = PI
       endif
C
       DO 2 I = 1 , 9
         poids = COEF * poidel(i)
         f    = F1(I)
         P1   = P(1,I)
         P2   = P(2,I)
         P3   = P(3,I)
         P4   = P(4,I)
         P5   = P(5,I)
         P6   = P(6,I)
         P7   = P(7,I)
         P8   = P(8,I)
         P9   = P(9,I)
C
         DPr1 = DFM1DP(1,1,I)
         DPr2 = DFM1DP(1,2,I)
         DPr3 = DFM1DP(1,3,I)
         DPr4 = DFM1DP(1,4,I)
         DPr5 = DFM1DP(1,5,I)
         DPr6 = DFM1DP(1,6,I)
         DPr7 = DFM1DP(1,7,I)
         DPr8 = DFM1DP(1,8,I)
         DPr9 = DFM1DP(1,9,I)
C
         DPz1 = DFM1DP(2,1,I)
         DPz2 = DFM1DP(2,2,I)
         DPz3 = DFM1DP(2,3,I)
         DPz4 = DFM1DP(2,4,I)
         DPz5 = DFM1DP(2,5,I)
         DPz6 = DFM1DP(2,6,I)
         DPz7 = DFM1DP(2,7,I)
         DPz8 = DFM1DP(2,8,I)
         DPz9 = DFM1DP(2,9,I)


      AE(1) = AE(1)+poids*(P1**2*E(3)+P1**2*n**2*E(8)+2.D0*P1*E(2)*DPr1*
     #f+DPr1**2*f**2*E(1)+E(7)*DPz1**2*f**2)/f**2
      AE(2) = AE(2)+poids*P1*n*(P1*E(3)+P1*E(8)+E(2)*DPr1*f-E(8)*DPr1*f)
     #/f**2
      AE(3) = AE(3)+poids*(P1**2*n**2*E(3)+P1**2*E(8)-2.D0*P1*E(8)*DPr1*
     #f+E(8)*DPr1**2*f**2+E(9)*DPz1**2*f**2)/f**2
      AE(4) = AE(4)+poids*DPz1*(E(7)*DPr1*f+E(5)*P1+E(4)*DPr1*f)/f
      AE(5) = AE(5)+poids*P1*n*DPz1*(E(5)-E(9))/f
      AE(6) = AE(6)+poids*(n**2*E(9)*P1**2+E(7)*DPr1**2*f**2+E(6)*DPz1**
     #2*f**2)/f**2
      AE(7) = AE(7)+poids*(P1*P2*E(3)+P1*P2*n**2*E(8)+P1*DPr2*E(2)*f+DPr
     #1*f*E(2)*P2+DPr1*f**2*E(1)*DPr2+DPz1*E(7)*DPz2*f**2)/f**2
      AE(8) = AE(8)-poids*n*(-P1*P2*E(3)-P1*P2*E(8)+P2*E(8)*DPr1*f-P1*DP
     #r2*E(2)*f)/f**2
      AE(9) = AE(9)+poids*(DPr1*E(7)*DPz2*f+DPz1*E(5)*P2+DPz1*E(4)*DPr2*
     #f)/f
      AE(10) = AE(10)+poids*(P2**2*E(3)+P2**2*n**2*E(8)+2.D0*P2*DPr2*E(2
     #)*f+DPr2**2*f**2*E(1)+E(7)*DPz2**2*f**2)/f**2
      AE(11) = AE(11)+poids*n*(P1*P2*E(3)+P1*P2*E(8)+DPr1*f*E(2)*P2-DPr2
     #*E(8)*P1*f)/f**2
      AE(12) = AE(12)+poids*(P2*P1*n**2*E(3)+P1*P2*E(8)-P2*E(8)*DPr1*f-D
     #Pr2*E(8)*P1*f+E(8)*DPr2*f**2*DPr1+DPz1*E(9)*DPz2*f**2)/f**2
      AE(13) = AE(13)+poids*n*(-P1*E(9)*DPz2+DPz1*E(5)*P2)/f
      AE(14) = AE(14)+poids*P2*n*(P2*E(3)+P2*E(8)-E(8)*DPr2*f+DPr2*E(2)*
     #f)/f**2
      AE(15) = AE(15)+poids*(P2**2*n**2*E(3)+P2**2*E(8)-2.D0*P2*E(8)*DPr
     #2*f+E(8)*DPr2**2*f**2+E(9)*DPz2**2*f**2)/f**2
      AE(16) = AE(16)+poids*(P1*E(5)*DPz2+DPr1*E(4)*DPz2*f+DPz1*E(7)*DPr
     #2*f)/f
      AE(17) = AE(17)-poids*n*(-P1*E(5)*DPz2+DPz1*E(9)*P2)/f
      AE(18) = AE(18)+poids*(P1*n**2*E(9)*P2+DPr1*E(7)*DPr2*f**2+DPz1*E(
     #6)*DPz2*f**2)/f**2
      AE(19) = AE(19)+poids*DPz2*(E(7)*DPr2*f+E(5)*P2+E(4)*DPr2*f)/f
      AE(20) = AE(20)+poids*P2*n*DPz2*(E(5)-E(9))/f
      AE(21) = AE(21)+poids*(n**2*E(9)*P2**2+E(7)*DPr2**2*f**2+E(6)*DPz2
     #**2*f**2)/f**2
      AE(22) = AE(22)+poids*(P1*P3*E(3)+P3*P1*n**2*E(8)+DPr1*E(2)*P3*f+D
     #Pr3*f*E(2)*P1+DPr3*f**2*E(1)*DPr1+DPz1*E(7)*DPz3*f**2)/f**2
      AE(23) = AE(23)-poids*n*(-P1*P3*E(3)-P1*P3*E(8)+P3*E(8)*DPr1*f-DPr
     #3*f*E(2)*P1)/f**2
      AE(24) = AE(24)+poids*(P3*E(5)*DPz1+DPr3*E(4)*DPz1*f+DPr1*E(7)*DPz
     #3*f)/f
      AE(25) = AE(25)+poids*(P2*P3*E(3)+P2*P3*n**2*E(8)+P2*E(2)*DPr3*f+P
     #3*DPr2*E(2)*f+DPr2*f**2*E(1)*DPr3+DPz2*E(7)*DPz3*f**2)/f**2
      AE(26) = AE(26)+poids*n*(P2*P3*E(3)+P2*P3*E(8)+P2*E(2)*DPr3*f-DPr2
     #*E(8)*P3*f)/f**2
      AE(27) = AE(27)+poids*(DPz2*E(5)*P3+DPr3*E(4)*DPz2*f+DPr2*E(7)*DPz
     #3*f)/f
      AE(28) = AE(28)+poids*(P3**2*E(3)+P3**2*n**2*E(8)+2.D0*P3*E(2)*DPr
     #3*f+DPr3**2*f**2*E(1)+E(7)*DPz3**2*f**2)/f**2
      AE(29) = AE(29)+poids*n*(P1*P3*E(3)+P1*P3*E(8)-P1*E(8)*DPr3*f+DPr1
     #*E(2)*P3*f)/f**2
      AE(30) = AE(30)+poids*(P3*P1*n**2*E(3)+P1*P3*E(8)-P3*E(8)*DPr1*f-P
     #1*E(8)*DPr3*f+E(8)*DPr3*f**2*DPr1+DPz1*E(9)*DPz3*f**2)/f**2
      AE(31) = AE(31)+poids*n*(-P1*E(9)*DPz3+P3*E(5)*DPz1)/f
      AE(32) = AE(32)-poids*n*(-P2*P3*E(3)-P2*P3*E(8)-P3*DPr2*E(2)*f+DPr
     #3*E(8)*P2*f)/f**2
      AE(33) = AE(33)+poids*(P2*P3*n**2*E(3)+P2*P3*E(8)-DPr3*E(8)*P2*f-D
     #Pr2*E(8)*P3*f+E(8)*DPr2*f**2*DPr3+DPz2*E(9)*DPz3*f**2)/f**2
      AE(34) = AE(34)-poids*n*(P2*E(9)*DPz3-DPz2*E(5)*P3)/f
      AE(35) = AE(35)+poids*P3*n*(P3*E(3)+P3*E(8)-E(8)*DPr3*f+E(2)*DPr3*
     #f)/f**2
      AE(36) = AE(36)+poids*(P3**2*n**2*E(3)+P3**2*E(8)-2.D0*P3*E(8)*DPr
     #3*f+E(8)*DPr3**2*f**2+E(9)*DPz3**2*f**2)/f**2
      AE(37) = AE(37)+poids*(P1*E(5)*DPz3+DPr1*E(4)*DPz3*f+DPz1*E(7)*DPr
     #3*f)/f
      AE(38) = AE(38)-poids*n*(-P1*E(5)*DPz3+DPz1*E(9)*P3)/f
      AE(39) = AE(39)+poids*(P1*n**2*E(9)*P3+DPr1*E(7)*DPr3*f**2+DPz1*E(
     #6)*DPz3*f**2)/f**2
      AE(40) = AE(40)+poids*(DPz2*E(7)*DPr3*f+DPz3*E(5)*P2+DPz3*E(4)*DPr
     #2*f)/f
      AE(41) = AE(41)+poids*n*(DPz3*E(5)*P2-DPz2*E(9)*P3)/f
      AE(42) = AE(42)+poids*(P2*n**2*E(9)*P3+DPr2*E(7)*DPr3*f**2+DPz2*E(
     #6)*DPz3*f**2)/f**2
      AE(43) = AE(43)+poids*DPz3*(E(5)*P3+E(4)*DPr3*f+E(7)*DPr3*f)/f
      AE(44) = AE(44)+poids*P3*n*DPz3*(E(5)-E(9))/f
      AE(45) = AE(45)+poids*(n**2*E(9)*P3**2+E(7)*DPr3**2*f**2+E(6)*DPz3
     #**2*f**2)/f**2
      AE(46) = AE(46)+poids*(P4*P1*E(3)+P4*P1*n**2*E(8)+P4*E(2)*DPr1*f+P
     #1*E(2)*DPr4*f+DPr4*f**2*E(1)*DPr1+DPz1*E(7)*DPz4*f**2)/f**2
      AE(47) = AE(47)-poids*n*(-P4*P1*E(3)-P4*P1*E(8)-P1*E(2)*DPr4*f+P4*
     #E(8)*DPr1*f)/f**2
      AE(48) = AE(48)+poids*(P4*E(5)*DPz1+DPr4*E(4)*DPz1*f+DPr1*E(7)*DPz
     #4*f)/f
      AE(49) = AE(49)+poids*(P2*P4*E(3)+P4*P2*n**2*E(8)+DPr2*E(2)*P4*f+D
     #Pr4*E(2)*P2*f+DPr4*f**2*E(1)*DPr2+DPz2*E(7)*DPz4*f**2)/f**2
      AE(50) = AE(50)-poids*n*(-P2*P4*E(3)-P2*P4*E(8)+P4*E(8)*DPr2*f-DPr
     #4*E(2)*P2*f)/f**2
      AE(51) = AE(51)+poids*(DPr2*E(7)*DPz4*f+DPz2*E(5)*P4+DPz2*E(4)*DPr
     #4*f)/f
      AE(52) = AE(52)+poids*(P4*P3*E(3)+P4*P3*n**2*E(8)+P4*E(2)*DPr3*f+D
     #Pr4*f*E(2)*P3+DPr4*f**2*E(1)*DPr3+DPz3*E(7)*DPz4*f**2)/f**2
      AE(53) = AE(53)-poids*n*(-P4*P3*E(3)-P4*P3*E(8)-DPr4*f*E(2)*P3+DPr
     #3*E(8)*P4*f)/f**2
      AE(54) = AE(54)+poids*(DPr3*E(7)*DPz4*f+DPz3*E(5)*P4+DPz3*E(4)*DPr
     #4*f)/f
      AE(55) = AE(55)+poids*(P4**2*E(3)+P4**2*n**2*E(8)+2.D0*P4*E(2)*DPr
     #4*f+DPr4**2*f**2*E(1)+E(7)*DPz4**2*f**2)/f**2
      AE(56) = AE(56)+poids*n*(P4*P1*E(3)+P4*P1*E(8)+P4*E(2)*DPr1*f-E(8)
     #*DPr4*f*P1)/f**2
      AE(57) = AE(57)+poids*(P4*P1*n**2*E(3)+P4*P1*E(8)-P4*E(8)*DPr1*f-E
     #(8)*DPr4*f*P1+E(8)*DPr4*f**2*DPr1+DPz1*E(9)*DPz4*f**2)/f**2
      AE(58) = AE(58)+poids*n*(-P1*E(9)*DPz4+P4*E(5)*DPz1)/f
      AE(59) = AE(59)+poids*n*(P2*P4*E(3)+P2*P4*E(8)-P2*E(8)*DPr4*f+DPr2
     #*E(2)*P4*f)/f**2
      AE(60) = AE(60)+poids*(P4*P2*n**2*E(3)+P2*P4*E(8)-P4*E(8)*DPr2*f-P
     #2*E(8)*DPr4*f+E(8)*DPr4*f**2*DPr2+DPz2*E(9)*DPz4*f**2)/f**2
      AE(61) = AE(61)+poids*n*(-P2*E(9)*DPz4+DPz2*E(5)*P4)/f
      AE(62) = AE(62)+poids*n*(P4*P3*E(3)+P4*P3*E(8)+P4*E(2)*DPr3*f-P3*E
     #(8)*DPr4*f)/f**2
      AE(63) = AE(63)+poids*(P3*P4*n**2*E(3)+P4*P3*E(8)-P3*E(8)*DPr4*f-D
     #Pr3*E(8)*P4*f+E(8)*DPr3*f**2*DPr4+DPz3*E(9)*DPz4*f**2)/f**2
      AE(64) = AE(64)+poids*n*(-P3*E(9)*DPz4+DPz3*E(5)*P4)/f
      AE(65) = AE(65)+poids*P4*n*(P4*E(3)+P4*E(8)-E(8)*DPr4*f+E(2)*DPr4*
     #f)/f**2
      AE(66) = AE(66)+poids*(P4**2*n**2*E(3)+P4**2*E(8)-2.D0*P4*E(8)*DPr
     #4*f+E(8)*DPr4**2*f**2+E(9)*DPz4**2*f**2)/f**2
      AE(67) = AE(67)+poids*(DPz1*E(7)*DPr4*f+DPz4*E(5)*P1+DPz4*E(4)*DPr
     #1*f)/f
      AE(68) = AE(68)-poids*n*(-DPz4*E(5)*P1+DPz1*E(9)*P4)/f
      AE(69) = AE(69)+poids*(P1*n**2*E(9)*P4+DPr1*E(7)*DPr4*f**2+DPz1*E(
     #6)*DPz4*f**2)/f**2
      AE(70) = AE(70)+poids*(P2*E(5)*DPz4+DPr2*E(4)*DPz4*f+DPz2*E(7)*DPr
     #4*f)/f
      AE(71) = AE(71)-poids*n*(-P2*E(5)*DPz4+DPz2*E(9)*P4)/f
      AE(72) = AE(72)+poids*(P2*n**2*E(9)*P4+DPr2*E(7)*DPr4*f**2+DPz2*E(
     #6)*DPz4*f**2)/f**2
      AE(73) = AE(73)+poids*(P3*E(5)*DPz4+DPr3*E(4)*DPz4*f+DPz3*E(7)*DPr
     #4*f)/f
      AE(74) = AE(74)-poids*n*(-P3*E(5)*DPz4+DPz3*E(9)*P4)/f
      AE(75) = AE(75)+poids*(P3*n**2*E(9)*P4+DPr3*E(7)*DPr4*f**2+DPz3*E(
     #6)*DPz4*f**2)/f**2
      AE(76) = AE(76)+poids*DPz4*(E(5)*P4+E(4)*DPr4*f+E(7)*DPr4*f)/f
      AE(77) = AE(77)+poids*P4*n*DPz4*(E(5)-E(9))/f
      AE(78) = AE(78)+poids*(n**2*E(9)*P4**2+E(7)*DPr4**2*f**2+E(6)*DPz4
     #**2*f**2)/f**2
      AE(79) = AE(79)+poids*(P5*P1*E(3)+P1*P5*n**2*E(8)+P1*DPr5*E(2)*f+D
     #Pr1*f*E(2)*P5+DPr1*f**2*E(1)*DPr5+DPz1*E(7)*DPz5*f**2)/f**2
      AE(80) = AE(80)+poids*n*(P5*P1*E(3)+P5*P1*E(8)-P5*E(8)*DPr1*f+P1*D
     #Pr5*E(2)*f)/f**2
      AE(81) = AE(81)+poids*(DPr1*E(7)*DPz5*f+DPz1*E(5)*P5+DPz1*DPr5*E(4
     #)*f)/f
      AE(82) = AE(82)+poids*(P5*P2*E(3)+P5*P2*n**2*E(8)+P5*DPr2*E(2)*f+D
     #Pr5*f*E(2)*P2+DPr5*f**2*E(1)*DPr2+DPz2*E(7)*DPz5*f**2)/f**2
      AE(83) = AE(83)+poids*n*(P5*P2*E(3)+P5*P2*E(8)-P5*E(8)*DPr2*f+DPr5
     #*f*E(2)*P2)/f**2
      AE(84) = AE(84)+poids*(P5*E(5)*DPz2+DPr5*E(4)*DPz2*f+DPr2*E(7)*DPz
     #5*f)/f
      AE(85) = AE(85)+poids*(P3*P5*E(3)+P3*P5*n**2*E(8)+P3*DPr5*E(2)*f+D
     #Pr3*f*E(2)*P5+DPr3*f**2*E(1)*DPr5+DPz3*E(7)*DPz5*f**2)/f**2
      AE(86) = AE(86)+poids*n*(P3*P5*E(3)+P3*P5*E(8)-P5*E(8)*DPr3*f+P3*D
     #Pr5*E(2)*f)/f**2
      AE(87) = AE(87)+poids*(DPr3*E(7)*DPz5*f+DPz3*E(5)*P5+DPz3*DPr5*E(4
     #)*f)/f
      AE(88) = AE(88)+poids*(P4*P5*E(3)+P4*P5*n**2*E(8)+P4*DPr5*E(2)*f+P
     #5*E(2)*DPr4*f+DPr4*f**2*E(1)*DPr5+DPz4*E(7)*DPz5*f**2)/f**2
      AE(89) = AE(89)+poids*n*(P4*P5*E(3)+P4*P5*E(8)+P4*DPr5*E(2)*f-DPr4
     #*E(8)*P5*f)/f**2
      AE(90) = AE(90)+poids*(DPz4*E(5)*P5+DPr5*E(4)*DPz4*f+DPr4*E(7)*DPz
     #5*f)/f
      AE(91) = AE(91)+poids*(P5**2*E(3)+P5**2*n**2*E(8)+2.D0*P5*DPr5*E(2
     #)*f+DPr5**2*f**2*E(1)+E(7)*DPz5**2*f**2)/f**2
      AE(92) = AE(92)+poids*n*(P5*P1*E(3)+P5*P1*E(8)-DPr5*E(8)*f*P1+DPr1
     #*f*E(2)*P5)/f**2
      AE(93) = AE(93)+poids*(P5*P1*n**2*E(3)+P5*P1*E(8)-P5*E(8)*DPr1*f-D
     #Pr5*E(8)*f*P1+DPr5*E(8)*f**2*DPr1+DPz1*E(9)*DPz5*f**2)/f**2
      AE(94) = AE(94)+poids*n*(-P1*E(9)*DPz5+DPz1*E(5)*P5)/f
      AE(95) = AE(95)-poids*n*(-P5*P2*E(3)-P5*P2*E(8)+P2*DPr5*E(8)*f-P5*
     #DPr2*E(2)*f)/f**2
      AE(96) = AE(96)+poids*(P5*P2*n**2*E(3)+P5*P2*E(8)-P5*E(8)*DPr2*f-P
     #2*DPr5*E(8)*f+DPr5*E(8)*f**2*DPr2+DPz2*E(9)*DPz5*f**2)/f**2
      AE(97) = AE(97)-poids*n*(P2*E(9)*DPz5-P5*E(5)*DPz2)/f
      AE(98) = AE(98)-poids*n*(-P3*P5*E(3)-P3*P5*E(8)+P3*DPr5*E(8)*f-DPr
     #3*f*E(2)*P5)/f**2
      AE(99) = AE(99)+poids*(P3*P5*n**2*E(3)+P3*P5*E(8)-P3*DPr5*E(8)*f-P
     #5*E(8)*DPr3*f+E(8)*DPr3*f**2*DPr5+DPz3*E(9)*DPz5*f**2)/f**2
      AE(100) = AE(100)-poids*n*(P3*E(9)*DPz5-DPz3*E(5)*P5)/f
      AE(101) = AE(101)-poids*n*(-P4*P5*E(3)-P4*P5*E(8)-P5*E(2)*DPr4*f+D
     #Pr5*E(8)*P4*f)/f**2
      AE(102) = AE(102)+poids*(P4*P5*n**2*E(3)+P4*P5*E(8)-DPr5*E(8)*P4*f
     #-DPr4*E(8)*P5*f+E(8)*DPr4*f**2*DPr5+DPz4*E(9)*DPz5*f**2)/f**2
      AE(103) = AE(103)-poids*n*(P4*E(9)*DPz5-DPz4*E(5)*P5)/f
      AE(104) = AE(104)+poids*P5*n*(P5*E(3)+P5*E(8)-DPr5*E(8)*f+DPr5*E(2
     #)*f)/f**2
      AE(105) = AE(105)+poids*(P5**2*n**2*E(3)+P5**2*E(8)-2.D0*P5*DPr5*E
     #(8)*f+DPr5**2*E(8)*f**2+E(9)*DPz5**2*f**2)/f**2
      AE(106) = AE(106)+poids*(DPz1*E(7)*DPr5*f+P1*E(5)*DPz5+DPz5*E(4)*D
     #Pr1*f)/f
      AE(107) = AE(107)+poids*n*(P1*E(5)*DPz5-DPz1*E(9)*P5)/f
      AE(108) = AE(108)+poids*(P1*n**2*E(9)*P5+DPr1*E(7)*DPr5*f**2+DPz1*
     #E(6)*DPz5*f**2)/f**2
      AE(109) = AE(109)+poids*(DPz2*E(7)*DPr5*f+DPz5*E(5)*P2+DPz5*E(4)*D
     #Pr2*f)/f
      AE(110) = AE(110)+poids*n*(DPz5*E(5)*P2-DPz2*E(9)*P5)/f
      AE(111) = AE(111)+poids*(P2*n**2*E(9)*P5+DPr2*E(7)*DPr5*f**2+DPz2*
     #E(6)*DPz5*f**2)/f**2
      AE(112) = AE(112)+poids*(P3*E(5)*DPz5+DPr3*E(4)*DPz5*f+DPz3*E(7)*D
     #Pr5*f)/f
      AE(113) = AE(113)+poids*n*(P3*E(5)*DPz5-DPz3*E(9)*P5)/f
      AE(114) = AE(114)+poids*(P3*n**2*E(9)*P5+DPr3*E(7)*DPr5*f**2+DPz3*
     #E(6)*DPz5*f**2)/f**2
      AE(115) = AE(115)+poids*(DPz4*E(7)*DPr5*f+DPz5*E(5)*P4+DPz5*E(4)*D
     #Pr4*f)/f
      AE(116) = AE(116)+poids*n*(DPz5*E(5)*P4-DPz4*E(9)*P5)/f
      AE(117) = AE(117)+poids*(P4*n**2*E(9)*P5+DPr4*E(7)*DPr5*f**2+DPz4*
     #E(6)*DPz5*f**2)/f**2
      AE(118) = AE(118)+poids*DPz5*(P5*E(5)+DPr5*E(4)*f+E(7)*DPr5*f)/f
      AE(119) = AE(119)+poids*P5*n*DPz5*(E(5)-E(9))/f
      AE(120) = AE(120)+poids*(n**2*E(9)*P5**2+E(7)*DPr5**2*f**2+E(6)*DP
     #z5**2*f**2)/f**2
      AE(121) = AE(121)+poids*(P6*P1*E(3)+P1*P6*n**2*E(8)+DPr6*E(2)*P1*f
     #+P6*E(2)*DPr1*f+DPr1*f**2*E(1)*DPr6+DPz1*E(7)*DPz6*f**2)/f**2
      AE(122) = AE(122)+poids*n*(P6*P1*E(3)+P6*P1*E(8)-P6*E(8)*DPr1*f+DP
     #r6*E(2)*P1*f)/f**2
      AE(123) = AE(123)+poids*(P6*E(5)*DPz1+DPr6*E(4)*DPz1*f+DPr1*E(7)*D
     #Pz6*f)/f
      AE(124) = AE(124)+poids*(P2*P6*E(3)+P6*P2*n**2*E(8)+P6*DPr2*E(2)*f
     #+P2*E(2)*DPr6*f+DPr6*f**2*E(1)*DPr2+DPz2*E(7)*DPz6*f**2)/f**2
      AE(125) = AE(125)+poids*n*(P2*P6*E(3)+P2*P6*E(8)+P2*E(2)*DPr6*f-DP
     #r2*E(8)*P6*f)/f**2
      AE(126) = AE(126)+poids*(DPz2*E(5)*P6+DPr6*E(4)*DPz2*f+DPr2*E(7)*D
     #Pz6*f)/f
      AE(127) = AE(127)+poids*(P3*P6*E(3)+P3*P6*n**2*E(8)+P3*E(2)*DPr6*f
     #+P6*E(2)*DPr3*f+DPr3*f**2*E(1)*DPr6+DPz3*E(7)*DPz6*f**2)/f**2
      AE(128) = AE(128)+poids*n*(P3*P6*E(3)+P3*P6*E(8)+P3*E(2)*DPr6*f-DP
     #r3*E(8)*P6*f)/f**2
      AE(129) = AE(129)+poids*(P6*E(5)*DPz3+DPr6*E(4)*DPz3*f+DPr3*E(7)*D
     #Pz6*f)/f
      AE(130) = AE(130)+poids*(P6*P4*E(3)+P6*P4*n**2*E(8)+P6*E(2)*DPr4*f
     #+DPr6*f*E(2)*P4+DPr6*f**2*E(1)*DPr4+DPz4*E(7)*DPz6*f**2)/f**2
      AE(131) = AE(131)+poids*n*(P6*P4*E(3)+P6*P4*E(8)-P6*E(8)*DPr4*f+DP
     #r6*f*E(2)*P4)/f**2
      AE(132) = AE(132)+poids*(P6*E(5)*DPz4+DPr6*E(4)*DPz4*f+DPr4*E(7)*D
     #Pz6*f)/f
      AE(133) = AE(133)+poids*(P5*P6*E(3)+P5*P6*n**2*E(8)+P5*E(2)*DPr6*f
     #+DPr5*f*E(2)*P6+DPr5*f**2*E(1)*DPr6+DPz5*E(7)*DPz6*f**2)/f**2
      AE(134) = AE(134)+poids*n*(P5*P6*E(3)+P5*P6*E(8)-DPr5*E(8)*f*P6+P5
     #*E(2)*DPr6*f)/f**2
      AE(135) = AE(135)+poids*(DPz5*E(5)*P6+DPr6*E(4)*DPz5*f+DPr5*E(7)*D
     #Pz6*f)/f
      AE(136) = AE(136)+poids*(P6**2*E(3)+P6**2*n**2*E(8)+2.D0*P6*E(2)*D
     #Pr6*f+DPr6**2*f**2*E(1)+E(7)*DPz6**2*f**2)/f**2
      AE(137) = AE(137)+poids*n*(P6*P1*E(3)+P6*P1*E(8)+P6*E(2)*DPr1*f-P1
     #*E(8)*DPr6*f)/f**2
      AE(138) = AE(138)+poids*(P1*P6*n**2*E(3)+P6*P1*E(8)-P1*E(8)*DPr6*f
     #-P6*E(8)*DPr1*f+E(8)*DPr1*f**2*DPr6+DPz1*E(9)*DPz6*f**2)/f**2
      AE(139) = AE(139)+poids*n*(-P1*E(9)*DPz6+P6*E(5)*DPz1)/f
      AE(140) = AE(140)-poids*n*(-P2*P6*E(3)-P2*P6*E(8)+P2*E(8)*DPr6*f-P
     #6*DPr2*E(2)*f)/f**2
      AE(141) = AE(141)+poids*(P2*P6*n**2*E(3)+P2*P6*E(8)-P2*E(8)*DPr6*f
     #-DPr2*E(8)*P6*f+E(8)*DPr2*f**2*DPr6+DPz2*E(9)*DPz6*f**2)/f**2
      AE(142) = AE(142)-poids*n*(P2*E(9)*DPz6-DPz2*E(5)*P6)/f
      AE(143) = AE(143)-poids*n*(-P3*P6*E(3)-P3*P6*E(8)-P6*E(2)*DPr3*f+D
     #Pr6*E(8)*P3*f)/f**2
      AE(144) = AE(144)+poids*(P3*P6*n**2*E(3)+P3*P6*E(8)-DPr6*E(8)*P3*f
     #-DPr3*E(8)*P6*f+E(8)*DPr3*f**2*DPr6+DPz3*E(9)*DPz6*f**2)/f**2
      AE(145) = AE(145)-poids*n*(P3*E(9)*DPz6-P6*E(5)*DPz3)/f
      AE(146) = AE(146)-poids*n*(-P6*P4*E(3)-P6*P4*E(8)-P6*E(2)*DPr4*f+P
     #4*E(8)*DPr6*f)/f**2
      AE(147) = AE(147)+poids*(P4*P6*n**2*E(3)+P6*P4*E(8)-P4*E(8)*DPr6*f
     #-P6*E(8)*DPr4*f+E(8)*DPr4*f**2*DPr6+DPz4*E(9)*DPz6*f**2)/f**2
      AE(148) = AE(148)-poids*n*(P4*E(9)*DPz6-P6*E(5)*DPz4)/f
      AE(149) = AE(149)+poids*n*(P5*P6*E(3)+P5*P6*E(8)-P5*E(8)*DPr6*f+DP
     #r5*f*E(2)*P6)/f**2
      AE(150) = AE(150)+poids*(P5*P6*n**2*E(3)+P5*P6*E(8)-P5*E(8)*DPr6*f
     #-DPr5*E(8)*f*P6+DPr5*E(8)*f**2*DPr6+DPz5*E(9)*DPz6*f**2)/f**2
      AE(151) = AE(151)+poids*n*(-P5*E(9)*DPz6+DPz5*E(5)*P6)/f
      AE(152) = AE(152)+poids*P6*n*(P6*E(3)+P6*E(8)+E(2)*DPr6*f-E(8)*DPr
     #6*f)/f**2
      AE(153) = AE(153)+poids*(P6**2*n**2*E(3)+P6**2*E(8)-2.D0*P6*E(8)*D
     #Pr6*f+E(8)*DPr6**2*f**2+E(9)*DPz6**2*f**2)/f**2
      AE(154) = AE(154)+poids*(P1*E(5)*DPz6+DPr1*E(4)*DPz6*f+DPz1*E(7)*D
     #Pr6*f)/f
      AE(155) = AE(155)+poids*n*(P1*E(5)*DPz6-DPz1*E(9)*P6)/f
      AE(156) = AE(156)+poids*(P1*n**2*E(9)*P6+DPr1*E(7)*DPr6*f**2+DPz1*
     #E(6)*DPz6*f**2)/f**2
      AE(157) = AE(157)+poids*(DPz2*E(7)*DPr6*f+DPz6*E(5)*P2+DPz6*E(4)*D
     #Pr2*f)/f
      AE(158) = AE(158)+poids*n*(DPz6*E(5)*P2-DPz2*E(9)*P6)/f
      AE(159) = AE(159)+poids*(P2*n**2*E(9)*P6+DPr2*E(7)*DPr6*f**2+DPz2*
     #E(6)*DPz6*f**2)/f**2
      AE(160) = AE(160)+poids*(DPz3*E(7)*DPr6*f+P3*E(5)*DPz6+DPz6*E(4)*D
     #Pr3*f)/f
      AE(161) = AE(161)+poids*n*(P3*E(5)*DPz6-DPz3*E(9)*P6)/f
      AE(162) = AE(162)+poids*(P3*n**2*E(9)*P6+DPr3*E(7)*DPr6*f**2+DPz3*
     #E(6)*DPz6*f**2)/f**2
      AE(163) = AE(163)+poids*(P4*E(5)*DPz6+DPr4*E(4)*DPz6*f+DPz4*E(7)*D
     #Pr6*f)/f
      AE(164) = AE(164)+poids*n*(P4*E(5)*DPz6-DPz4*E(9)*P6)/f
      AE(165) = AE(165)+poids*(P4*n**2*E(9)*P6+DPr4*E(7)*DPr6*f**2+DPz4*
     #E(6)*DPz6*f**2)/f**2
      AE(166) = AE(166)+poids*(P5*E(5)*DPz6+DPr5*E(4)*DPz6*f+DPz5*E(7)*D
     #Pr6*f)/f
      AE(167) = AE(167)+poids*n*(P5*E(5)*DPz6-DPz5*E(9)*P6)/f
      AE(168) = AE(168)+poids*(P5*n**2*E(9)*P6+DPr5*E(7)*DPr6*f**2+DPz5*
     #E(6)*DPz6*f**2)/f**2
      AE(169) = AE(169)+poids*DPz6*(E(5)*P6+E(4)*DPr6*f+E(7)*DPr6*f)/f
      AE(170) = AE(170)+poids*P6*n*DPz6*(E(5)-E(9))/f
      AE(171) = AE(171)+poids*(n**2*E(9)*P6**2+E(7)*DPr6**2*f**2+E(6)*DP
     #z6**2*f**2)/f**2
      AE(172) = AE(172)+poids*(P7*P1*E(3)+P1*P7*n**2*E(8)+DPr7*E(2)*P1*f
     #+P7*E(2)*DPr1*f+DPr1*f**2*E(1)*DPr7+DPz1*E(7)*DPz7*f**2)/f**2
      AE(173) = AE(173)+poids*n*(P7*P1*E(3)+P7*P1*E(8)-P7*E(8)*DPr1*f+DP
     #r7*E(2)*P1*f)/f**2
      AE(174) = AE(174)+poids*(DPr1*E(7)*DPz7*f+DPz1*E(5)*P7+DPz1*E(4)*D
     #Pr7*f)/f
      AE(175) = AE(175)+poids*(P2*P7*E(3)+P7*P2*n**2*E(8)+P7*DPr2*E(2)*f
     #+P2*E(2)*DPr7*f+DPr7*f**2*E(1)*DPr2+DPz2*E(7)*DPz7*f**2)/f**2
      AE(176) = AE(176)+poids*n*(P2*P7*E(3)+P2*P7*E(8)+P2*E(2)*DPr7*f-DP
     #r2*E(8)*P7*f)/f**2
      AE(177) = AE(177)+poids*(DPr2*E(7)*DPz7*f+DPz2*E(5)*P7+DPz2*E(4)*D
     #Pr7*f)/f
      AE(178) = AE(178)+poids*(P7*P3*E(3)+P3*P7*n**2*E(8)+DPr7*E(2)*P3*f
     #+DPr3*f*E(2)*P7+DPr3*f**2*E(1)*DPr7+DPz3*E(7)*DPz7*f**2)/f**2
      AE(179) = AE(179)+poids*n*(P7*P3*E(3)+P7*P3*E(8)-P7*E(8)*DPr3*f+DP
     #r7*E(2)*P3*f)/f**2
      AE(180) = AE(180)+poids*(P7*E(5)*DPz3+DPr7*E(4)*DPz3*f+DPr3*E(7)*D
     #Pz7*f)/f
      AE(181) = AE(181)+poids*(P7*P4*E(3)+P7*P4*n**2*E(8)+P7*E(2)*DPr4*f
     #+DPr7*f*E(2)*P4+DPr7*f**2*E(1)*DPr4+DPz4*E(7)*DPz7*f**2)/f**2
      AE(182) = AE(182)+poids*n*(P7*P4*E(3)+P7*P4*E(8)-P7*E(8)*DPr4*f+DP
     #r7*f*E(2)*P4)/f**2
      AE(183) = AE(183)+poids*(DPz4*E(5)*P7+DPr7*E(4)*DPz4*f+DPr4*E(7)*D
     #Pz7*f)/f
      AE(184) = AE(184)+poids*(P7*P5*E(3)+P7*P5*n**2*E(8)+P7*DPr5*E(2)*f
     #+P5*E(2)*DPr7*f+DPr7*f**2*E(1)*DPr5+DPz5*E(7)*DPz7*f**2)/f**2
      AE(185) = AE(185)+poids*n*(P7*P5*E(3)+P7*P5*E(8)+P5*E(2)*DPr7*f-DP
     #r5*E(8)*P7*f)/f**2
      AE(186) = AE(186)+poids*(DPr5*E(7)*DPz7*f+DPz5*E(5)*P7+DPz5*E(4)*D
     #Pr7*f)/f
      AE(187) = AE(187)+poids*(P6*P7*E(3)+P7*P6*n**2*E(8)+DPr6*E(2)*P7*f
     #+P6*E(2)*DPr7*f+DPr7*f**2*E(1)*DPr6+DPz6*E(7)*DPz7*f**2)/f**2
      AE(188) = AE(188)+poids*n*(P6*P7*E(3)+P6*P7*E(8)+P6*E(2)*DPr7*f-DP
     #r6*E(8)*P7*f)/f**2
      AE(189) = AE(189)+poids*(DPr6*E(7)*DPz7*f+DPz6*E(5)*P7+DPz6*E(4)*D
     #Pr7*f)/f
      AE(190) = AE(190)+poids*(P7**2*E(3)+P7**2*n**2*E(8)+2.D0*P7*E(2)*D
     #Pr7*f+DPr7**2*f**2*E(1)+E(7)*DPz7**2*f**2)/f**2
      AE(191) = AE(191)+poids*n*(P7*P1*E(3)+P7*P1*E(8)+P7*E(2)*DPr1*f-E(
     #8)*DPr7*f*P1)/f**2
      AE(192) = AE(192)+poids*(P7*P1*n**2*E(3)+P7*P1*E(8)-P7*E(8)*DPr1*f
     #-E(8)*DPr7*f*P1+E(8)*DPr7*f**2*DPr1+DPz1*E(9)*DPz7*f**2)/f**2
      AE(193) = AE(193)+poids*n*(-P1*E(9)*DPz7+DPz1*E(5)*P7)/f
      AE(194) = AE(194)-poids*n*(-P2*P7*E(3)-P2*P7*E(8)-P7*DPr2*E(2)*f+P
     #2*E(8)*DPr7*f)/f**2
      AE(195) = AE(195)+poids*(P2*P7*n**2*E(3)+P2*P7*E(8)-P2*E(8)*DPr7*f
     #-DPr2*E(8)*P7*f+E(8)*DPr2*f**2*DPr7+DPz2*E(9)*DPz7*f**2)/f**2
      AE(196) = AE(196)-poids*n*(P2*E(9)*DPz7-DPz2*E(5)*P7)/f
      AE(197) = AE(197)-poids*n*(-P7*P3*E(3)-P7*P3*E(8)+E(8)*DPr7*f*P3-D
     #Pr3*f*E(2)*P7)/f**2
      AE(198) = AE(198)+poids*(P7*P3*n**2*E(3)+P7*P3*E(8)-P7*E(8)*DPr3*f
     #-E(8)*DPr7*f*P3+E(8)*DPr7*f**2*DPr3+DPz3*E(9)*DPz7*f**2)/f**2
      AE(199) = AE(199)-poids*n*(P3*E(9)*DPz7-P7*E(5)*DPz3)/f
      AE(200) = AE(200)-poids*n*(-P7*P4*E(3)-P7*P4*E(8)+E(8)*DPr7*f*P4-P
     #7*E(2)*DPr4*f)/f**2
      AE(201) = AE(201)+poids*(P7*P4*n**2*E(3)+P7*P4*E(8)-P7*E(8)*DPr4*f
     #-E(8)*DPr7*f*P4+E(8)*DPr7*f**2*DPr4+DPz4*E(9)*DPz7*f**2)/f**2
      AE(202) = AE(202)-poids*n*(P4*E(9)*DPz7-DPz4*E(5)*P7)/f
      AE(203) = AE(203)+poids*n*(P7*P5*E(3)+P7*P5*E(8)+P7*DPr5*E(2)*f-DP
     #r7*E(8)*P5*f)/f**2
      AE(204) = AE(204)+poids*(P7*P5*n**2*E(3)+P7*P5*E(8)-DPr5*E(8)*P7*f
     #-DPr7*E(8)*P5*f+E(8)*DPr7*f**2*DPr5+DPz5*E(9)*DPz7*f**2)/f**2
      AE(205) = AE(205)+poids*n*(-P5*E(9)*DPz7+DPz5*E(5)*P7)/f
      AE(206) = AE(206)+poids*n*(P6*P7*E(3)+P6*P7*E(8)-P6*E(8)*DPr7*f+DP
     #r6*E(2)*P7*f)/f**2
      AE(207) = AE(207)+poids*(P7*P6*n**2*E(3)+P6*P7*E(8)-DPr6*E(8)*P7*f
     #-P6*E(8)*DPr7*f+E(8)*DPr7*f**2*DPr6+DPz6*E(9)*DPz7*f**2)/f**2
      AE(208) = AE(208)+poids*n*(-P6*E(9)*DPz7+DPz6*E(5)*P7)/f
      AE(209) = AE(209)+poids*P7*n*(P7*E(3)+P7*E(8)-E(8)*DPr7*f+E(2)*DPr
     #7*f)/f**2
      AE(210) = AE(210)+poids*(P7**2*n**2*E(3)+P7**2*E(8)-2.D0*P7*E(8)*D
     #Pr7*f+E(8)*DPr7**2*f**2+E(9)*DPz7**2*f**2)/f**2
      AE(211) = AE(211)+poids*(DPz1*E(7)*DPr7*f+DPz7*E(5)*P1+DPz7*E(4)*D
     #Pr1*f)/f
      AE(212) = AE(212)+poids*n*(DPz7*E(5)*P1-DPz1*E(9)*P7)/f
      AE(213) = AE(213)+poids*(P1*n**2*E(9)*P7+DPr1*E(7)*DPr7*f**2+DPz1*
     #E(6)*DPz7*f**2)/f**2
      AE(214) = AE(214)+poids*(P2*E(5)*DPz7+DPr2*E(4)*DPz7*f+DPz2*E(7)*D
     #Pr7*f)/f
      AE(215) = AE(215)+poids*n*(P2*E(5)*DPz7-DPz2*E(9)*P7)/f
      AE(216) = AE(216)+poids*(P2*n**2*E(9)*P7+DPr2*E(7)*DPr7*f**2+DPz2*
     #E(6)*DPz7*f**2)/f**2
      AE(217) = AE(217)+poids*(DPz3*E(7)*DPr7*f+DPz7*E(5)*P3+DPz7*E(4)*D
     #Pr3*f)/f
      AE(218) = AE(218)+poids*n*(DPz7*E(5)*P3-DPz3*E(9)*P7)/f
      AE(219) = AE(219)+poids*(P3*n**2*E(9)*P7+DPr3*E(7)*DPr7*f**2+DPz3*
     #E(6)*DPz7*f**2)/f**2
      AE(220) = AE(220)+poids*(P4*E(5)*DPz7+DPr4*E(4)*DPz7*f+DPz4*E(7)*D
     #Pr7*f)/f
      AE(221) = AE(221)+poids*n*(P4*E(5)*DPz7-DPz4*E(9)*P7)/f
      AE(222) = AE(222)+poids*(P4*n**2*E(9)*P7+DPr4*E(7)*DPr7*f**2+DPz4*
     #E(6)*DPz7*f**2)/f**2
      AE(223) = AE(223)+poids*(P5*E(5)*DPz7+DPr5*E(4)*DPz7*f+DPz5*E(7)*D
     #Pr7*f)/f
      AE(224) = AE(224)+poids*n*(P5*E(5)*DPz7-DPz5*E(9)*P7)/f
      AE(225) = AE(225)+poids*(P5*n**2*E(9)*P7+DPr5*E(7)*DPr7*f**2+DPz5*
     #E(6)*DPz7*f**2)/f**2
      AE(226) = AE(226)+poids*(P6*E(5)*DPz7+DPr6*E(4)*DPz7*f+DPz6*E(7)*D
     #Pr7*f)/f
      AE(227) = AE(227)+poids*n*(P6*E(5)*DPz7-DPz6*E(9)*P7)/f
      AE(228) = AE(228)+poids*(P6*n**2*E(9)*P7+DPr6*E(7)*DPr7*f**2+DPz6*
     #E(6)*DPz7*f**2)/f**2
      AE(229) = AE(229)+poids*DPz7*(E(5)*P7+E(4)*DPr7*f+E(7)*DPr7*f)/f
      AE(230) = AE(230)+poids*P7*n*DPz7*(E(5)-E(9))/f
      AE(231) = AE(231)+poids*(n**2*E(9)*P7**2+E(7)*DPr7**2*f**2+E(6)*DP
     #z7**2*f**2)/f**2
      AE(232) = AE(232)+poids*(P1*P8*E(3)+P8*P1*n**2*E(8)+DPr1*E(2)*P8*f
     #+P1*E(2)*DPr8*f+DPr8*f**2*E(1)*DPr1+DPz1*E(7)*DPz8*f**2)/f**2
      AE(233) = AE(233)-poids*n*(-P1*P8*E(3)-P1*P8*E(8)-P1*E(2)*DPr8*f+P
     #8*E(8)*DPr1*f)/f**2
      AE(234) = AE(234)+poids*(P8*E(5)*DPz1+DPr8*E(4)*DPz1*f+DPr1*E(7)*D
     #Pz8*f)/f
      AE(235) = AE(235)+poids*(P2*P8*E(3)+P8*P2*n**2*E(8)+DPr2*E(2)*P8*f
     #+DPr8*f*E(2)*P2+DPr8*f**2*E(1)*DPr2+DPz2*E(7)*DPz8*f**2)/f**2
      AE(236) = AE(236)+poids*n*(P2*P8*E(3)+P2*P8*E(8)-P8*E(8)*DPr2*f+DP
     #r8*f*E(2)*P2)/f**2
      AE(237) = AE(237)+poids*(DPr2*E(7)*DPz8*f+DPz2*E(5)*P8+DPz2*E(4)*D
     #Pr8*f)/f
      AE(238) = AE(238)+poids*(P8*P3*E(3)+P3*P8*n**2*E(8)+P3*E(2)*DPr8*f
     #+P8*E(2)*DPr3*f+DPr3*f**2*E(1)*DPr8+DPz3*E(7)*DPz8*f**2)/f**2
      AE(239) = AE(239)+poids*n*(P8*P3*E(3)+P8*P3*E(8)+P3*E(2)*DPr8*f-P8
     #*E(8)*DPr3*f)/f**2
      AE(240) = AE(240)+poids*(DPr3*E(7)*DPz8*f+DPz3*E(5)*P8+DPz3*E(4)*D
     #Pr8*f)/f
      AE(241) = AE(241)+poids*(P8*P4*E(3)+P8*P4*n**2*E(8)+P8*E(2)*DPr4*f
     #+DPr8*f*E(2)*P4+DPr8*f**2*E(1)*DPr4+DPz4*E(7)*DPz8*f**2)/f**2
      AE(242) = AE(242)+poids*n*(P8*P4*E(3)+P8*P4*E(8)+DPr8*f*E(2)*P4-DP
     #r4*E(8)*P8*f)/f**2
      AE(243) = AE(243)+poids*(DPr4*E(7)*DPz8*f+DPz4*E(5)*P8+DPz4*E(4)*D
     #Pr8*f)/f
      AE(244) = AE(244)+poids*(P8*P5*E(3)+P8*P5*n**2*E(8)+P8*DPr5*E(2)*f
     #+DPr8*f*E(2)*P5+DPr8*f**2*E(1)*DPr5+DPz5*E(7)*DPz8*f**2)/f**2
      AE(245) = AE(245)-poids*n*(-P8*P5*E(3)-P8*P5*E(8)-DPr8*f*E(2)*P5+P
     #8*DPr5*E(8)*f)/f**2
      AE(246) = AE(246)+poids*(DPr5*E(7)*DPz8*f+DPz5*E(5)*P8+DPz5*E(4)*D
     #Pr8*f)/f
      AE(247) = AE(247)+poids*(P6*P8*E(3)+P6*P8*n**2*E(8)+P6*E(2)*DPr8*f
     #+DPr6*f*E(2)*P8+DPr6*f**2*E(1)*DPr8+DPz6*E(7)*DPz8*f**2)/f**2
      AE(248) = AE(248)-poids*n*(-P6*P8*E(3)-P6*P8*E(8)+P8*E(8)*DPr6*f-P
     #6*E(2)*DPr8*f)/f**2
      AE(249) = AE(249)+poids*(DPr6*E(7)*DPz8*f+DPz6*E(5)*P8+DPz6*E(4)*D
     #Pr8*f)/f
      AE(250) = AE(250)+poids*(P8*P7*E(3)+P8*P7*n**2*E(8)+P8*E(2)*DPr7*f
     #+DPr8*f*E(2)*P7+DPr8*f**2*E(1)*DPr7+DPz7*E(7)*DPz8*f**2)/f**2
      AE(251) = AE(251)-poids*n*(-P8*P7*E(3)-P8*P7*E(8)-DPr8*f*E(2)*P7+D
     #Pr7*E(8)*P8*f)/f**2
      AE(252) = AE(252)+poids*(P8*E(5)*DPz7+DPr8*E(4)*DPz7*f+DPr7*E(7)*D
     #Pz8*f)/f
      AE(253) = AE(253)+poids*(P8**2*E(3)+P8**2*n**2*E(8)+2.D0*P8*E(2)*D
     #Pr8*f+DPr8**2*f**2*E(1)+E(7)*DPz8**2*f**2)/f**2
      AE(254) = AE(254)+poids*n*(P1*P8*E(3)+P1*P8*E(8)-P1*DPr8*E(8)*f+DP
     #r1*E(2)*P8*f)/f**2
      AE(255) = AE(255)+poids*(P8*P1*n**2*E(3)+P1*P8*E(8)-P8*E(8)*DPr1*f
     #-P1*DPr8*E(8)*f+DPr8*E(8)*f**2*DPr1+DPz1*E(9)*DPz8*f**2)/f**2
      AE(256) = AE(256)+poids*n*(-P1*E(9)*DPz8+P8*E(5)*DPz1)/f
      AE(257) = AE(257)-poids*n*(-P2*P8*E(3)-P2*P8*E(8)+P2*DPr8*E(8)*f-D
     #Pr2*E(2)*P8*f)/f**2
      AE(258) = AE(258)+poids*(P2*P8*n**2*E(3)+P2*P8*E(8)-P2*DPr8*E(8)*f
     #-P8*E(8)*DPr2*f+E(8)*DPr2*f**2*DPr8+DPz2*E(9)*DPz8*f**2)/f**2
      AE(259) = AE(259)-poids*n*(P2*E(9)*DPz8-DPz2*E(5)*P8)/f
      AE(260) = AE(260)-poids*n*(-P8*P3*E(3)-P8*P3*E(8)-P8*E(2)*DPr3*f+D
     #Pr8*E(8)*P3*f)/f**2
      AE(261) = AE(261)+poids*(P8*P3*n**2*E(3)+P8*P3*E(8)-P8*E(8)*DPr3*f
     #-DPr8*E(8)*P3*f+DPr8*E(8)*f**2*DPr3+DPz3*E(9)*DPz8*f**2)/f**2
      AE(262) = AE(262)-poids*n*(P3*E(9)*DPz8-DPz3*E(5)*P8)/f
      AE(263) = AE(263)-poids*n*(-P8*P4*E(3)-P8*P4*E(8)+P4*DPr8*E(8)*f-P
     #8*E(2)*DPr4*f)/f**2
      AE(264) = AE(264)+poids*(P4*P8*n**2*E(3)+P8*P4*E(8)-P4*DPr8*E(8)*f
     #-DPr4*E(8)*P8*f+E(8)*DPr4*f**2*DPr8+DPz4*E(9)*DPz8*f**2)/f**2
      AE(265) = AE(265)-poids*n*(P4*E(9)*DPz8-DPz4*E(5)*P8)/f
      AE(266) = AE(266)+poids*n*(P8*P5*E(3)+P8*P5*E(8)+P8*DPr5*E(2)*f-DP
     #r8*E(8)*P5*f)/f**2
      AE(267) = AE(267)+poids*(P8*P5*n**2*E(3)+P8*P5*E(8)-P8*DPr5*E(8)*f
     #-DPr8*E(8)*P5*f+DPr8*E(8)*f**2*DPr5+DPz5*E(9)*DPz8*f**2)/f**2
      AE(268) = AE(268)+poids*n*(-P5*E(9)*DPz8+DPz5*E(5)*P8)/f
      AE(269) = AE(269)+poids*n*(P6*P8*E(3)+P6*P8*E(8)-P6*DPr8*E(8)*f+DP
     #r6*f*E(2)*P8)/f**2
      AE(270) = AE(270)+poids*(P8*P6*n**2*E(3)+P6*P8*E(8)-P8*E(8)*DPr6*f
     #-P6*DPr8*E(8)*f+DPr8*E(8)*f**2*DPr6+DPz6*E(9)*DPz8*f**2)/f**2
      AE(271) = AE(271)+poids*n*(-P6*E(9)*DPz8+DPz6*E(5)*P8)/f
      AE(272) = AE(272)+poids*n*(P8*P7*E(3)+P8*P7*E(8)-P7*DPr8*E(8)*f+P8
     #*E(2)*DPr7*f)/f**2
      AE(273) = AE(273)+poids*(P7*P8*n**2*E(3)+P8*P7*E(8)-P7*DPr8*E(8)*f
     #-DPr7*E(8)*P8*f+E(8)*DPr7*f**2*DPr8+DPz7*E(9)*DPz8*f**2)/f**2
      AE(274) = AE(274)+poids*n*(-P7*E(9)*DPz8+P8*E(5)*DPz7)/f
      AE(275) = AE(275)+poids*P8*n*(P8*E(3)+P8*E(8)+E(2)*DPr8*f-DPr8*E(8
     #)*f)/f**2
      AE(276) = AE(276)+poids*(P8**2*n**2*E(3)+P8**2*E(8)-2.D0*P8*DPr8*E
     #(8)*f+DPr8**2*E(8)*f**2+E(9)*DPz8**2*f**2)/f**2
      AE(277) = AE(277)+poids*(P1*E(5)*DPz8+DPr1*E(4)*DPz8*f+DPz1*E(7)*D
     #Pr8*f)/f
      AE(278) = AE(278)-poids*n*(-P1*E(5)*DPz8+DPz1*E(9)*P8)/f
      AE(279) = AE(279)+poids*(P1*n**2*E(9)*P8+DPr1*E(7)*DPr8*f**2+DPz1*
     #E(6)*DPz8*f**2)/f**2
      AE(280) = AE(280)+poids*(P2*E(5)*DPz8+DPr2*E(4)*DPz8*f+DPz2*E(7)*D
     #Pr8*f)/f
      AE(281) = AE(281)+poids*n*(P2*E(5)*DPz8-DPz2*E(9)*P8)/f
      AE(282) = AE(282)+poids*(P2*n**2*E(9)*P8+DPr2*E(7)*DPr8*f**2+DPz2*
     #E(6)*DPz8*f**2)/f**2
      AE(283) = AE(283)+poids*(P3*E(5)*DPz8+DPr3*E(4)*DPz8*f+DPz3*E(7)*D
     #Pr8*f)/f
      AE(284) = AE(284)+poids*n*(P3*E(5)*DPz8-DPz3*E(9)*P8)/f
      AE(285) = AE(285)+poids*(P3*n**2*E(9)*P8+DPr3*E(7)*DPr8*f**2+DPz3*
     #E(6)*DPz8*f**2)/f**2
      AE(286) = AE(286)+poids*(DPz4*E(7)*DPr8*f+P4*E(5)*DPz8+DPz8*E(4)*D
     #Pr4*f)/f
      AE(287) = AE(287)+poids*n*(P4*E(5)*DPz8-DPz4*E(9)*P8)/f
      AE(288) = AE(288)+poids*(P4*n**2*E(9)*P8+DPr4*E(7)*DPr8*f**2+DPz4*
     #E(6)*DPz8*f**2)/f**2
      AE(289) = AE(289)+poids*(P5*E(5)*DPz8+DPr5*E(4)*DPz8*f+DPz5*E(7)*D
     #Pr8*f)/f
      AE(290) = AE(290)-poids*n*(-P5*E(5)*DPz8+DPz5*E(9)*P8)/f
      AE(291) = AE(291)+poids*(P5*n**2*E(9)*P8+DPr5*E(7)*DPr8*f**2+DPz5*
     #E(6)*DPz8*f**2)/f**2
      AE(292) = AE(292)+poids*(DPz6*E(7)*DPr8*f+P6*E(5)*DPz8+DPz8*E(4)*D
     #Pr6*f)/f
      AE(293) = AE(293)-poids*n*(-P6*E(5)*DPz8+DPz6*E(9)*P8)/f
      AE(294) = AE(294)+poids*(P6*n**2*E(9)*P8+DPr6*E(7)*DPr8*f**2+DPz6*
     #E(6)*DPz8*f**2)/f**2
      AE(295) = AE(295)+poids*(P7*E(5)*DPz8+DPr7*E(4)*DPz8*f+DPz7*E(7)*D
     #Pr8*f)/f
      AE(296) = AE(296)-poids*n*(-P7*E(5)*DPz8+DPz7*E(9)*P8)/f
      AE(297) = AE(297)+poids*(P7*n**2*E(9)*P8+DPr7*E(7)*DPr8*f**2+DPz7*
     #E(6)*DPz8*f**2)/f**2
      AE(298) = AE(298)+poids*DPz8*(E(7)*DPr8*f+E(5)*P8+E(4)*DPr8*f)/f
      AE(299) = AE(299)+poids*P8*n*DPz8*(E(5)-E(9))/f
      AE(300) = AE(300)+poids*(n**2*E(9)*P8**2+E(7)*DPr8**2*f**2+E(6)*DP
     #z8**2*f**2)/f**2
      AE(301) = AE(301)+poids*(P9*P1*E(3)+P1*P9*n**2*E(8)+DPr9*E(2)*P1*f
     #+P9*E(2)*DPr1*f+DPr1*f**2*E(1)*DPr9+DPz1*E(7)*DPz9*f**2)/f**2
      AE(302) = AE(302)+poids*n*(P9*P1*E(3)+P9*P1*E(8)-P9*E(8)*DPr1*f+DP
     #r9*E(2)*P1*f)/f**2
      AE(303) = AE(303)+poids*(P9*E(5)*DPz1+DPr9*E(4)*DPz1*f+DPr1*E(7)*D
     #Pz9*f)/f
      AE(304) = AE(304)+poids*(P2*P9*E(3)+P2*P9*n**2*E(8)+P2*E(2)*DPr9*f
     #+DPr2*f*E(2)*P9+DPr2*f**2*E(1)*DPr9+DPz2*E(7)*DPz9*f**2)/f**2
      AE(305) = AE(305)+poids*n*(P2*P9*E(3)+P2*P9*E(8)-E(8)*DPr2*f*P9+P2
     #*E(2)*DPr9*f)/f**2
      AE(306) = AE(306)+poids*(DPr2*E(7)*DPz9*f+DPz2*E(5)*P9+DPz2*E(4)*D
     #Pr9*f)/f
      AE(307) = AE(307)+poids*(P3*P9*E(3)+P3*P9*n**2*E(8)+P3*E(2)*DPr9*f
     #+P9*E(2)*DPr3*f+DPr3*f**2*E(1)*DPr9+DPz3*E(7)*DPz9*f**2)/f**2
      AE(308) = AE(308)+poids*n*(P3*P9*E(3)+P3*P9*E(8)+P3*E(2)*DPr9*f-DP
     #r3*E(8)*P9*f)/f**2
      AE(309) = AE(309)+poids*(P9*E(5)*DPz3+DPr9*E(4)*DPz3*f+DPr3*E(7)*D
     #Pz9*f)/f
      AE(310) = AE(310)+poids*(P9*P4*E(3)+P9*P4*n**2*E(8)+P9*E(2)*DPr4*f
     #+P4*E(2)*DPr9*f+DPr9*f**2*E(1)*DPr4+DPz4*E(7)*DPz9*f**2)/f**2
      AE(311) = AE(311)+poids*n*(P9*P4*E(3)+P9*P4*E(8)+P4*E(2)*DPr9*f-P9
     #*E(8)*DPr4*f)/f**2
      AE(312) = AE(312)+poids*(DPr4*E(7)*DPz9*f+DPz4*E(5)*P9+DPz4*E(4)*D
     #Pr9*f)/f
      AE(313) = AE(313)+poids*(P9*P5*E(3)+P5*P9*n**2*E(8)+DPr9*E(2)*P5*f
     #+DPr5*f*E(2)*P9+DPr5*f**2*E(1)*DPr9+DPz5*E(7)*DPz9*f**2)/f**2
      AE(314) = AE(314)+poids*n*(P9*P5*E(3)+P9*P5*E(8)-P9*DPr5*E(8)*f+DP
     #r9*E(2)*P5*f)/f**2
      AE(315) = AE(315)+poids*(P9*E(5)*DPz5+DPr9*E(4)*DPz5*f+DPr5*E(7)*D
     #Pz9*f)/f
      AE(316) = AE(316)+poids*(P9*P6*E(3)+P9*P6*n**2*E(8)+P9*E(2)*DPr6*f
     #+P6*E(2)*DPr9*f+DPr9*f**2*E(1)*DPr6+DPz6*E(7)*DPz9*f**2)/f**2
      AE(317) = AE(317)+poids*n*(P9*P6*E(3)+P9*P6*E(8)+P6*E(2)*DPr9*f-P9
     #*E(8)*DPr6*f)/f**2
      AE(318) = AE(318)+poids*(DPz6*E(5)*P9+DPr9*E(4)*DPz6*f+DPr6*E(7)*D
     #Pz9*f)/f
      AE(319) = AE(319)+poids*(P9*P7*E(3)+P9*P7*n**2*E(8)+P9*E(2)*DPr7*f
     #+P7*E(2)*DPr9*f+DPr9*f**2*E(1)*DPr7+DPz7*E(7)*DPz9*f**2)/f**2
      AE(320) = AE(320)+poids*n*(P9*P7*E(3)+P9*P7*E(8)+P7*E(2)*DPr9*f-P9
     #*E(8)*DPr7*f)/f**2
      AE(321) = AE(321)+poids*(DPr7*E(7)*DPz9*f+DPz7*E(5)*P9+DPz7*E(4)*D
     #Pr9*f)/f
      AE(322) = AE(322)+poids*(P8*P9*E(3)+P8*P9*n**2*E(8)+P8*E(2)*DPr9*f
     #+P9*E(2)*DPr8*f+DPr8*f**2*E(1)*DPr9+DPz8*E(7)*DPz9*f**2)/f**2
      AE(323) = AE(323)+poids*n*(P8*P9*E(3)+P8*P9*E(8)+P8*E(2)*DPr9*f-DP
     #r8*E(8)*P9*f)/f**2
      AE(324) = AE(324)+poids*(P9*E(5)*DPz8+DPr9*E(4)*DPz8*f+DPr8*E(7)*D
     #Pz9*f)/f
      AE(325) = AE(325)+poids*(P9**2*E(3)+P9**2*n**2*E(8)+2.D0*P9*E(2)*D
     #Pr9*f+DPr9**2*f**2*E(1)+E(7)*DPz9**2*f**2)/f**2
      AE(326) = AE(326)+poids*n*(P9*P1*E(3)+P9*P1*E(8)+P9*E(2)*DPr1*f-P1
     #*E(8)*DPr9*f)/f**2
      AE(327) = AE(327)+poids*(P1*P9*n**2*E(3)+P9*P1*E(8)-P1*E(8)*DPr9*f
     #-P9*E(8)*DPr1*f+E(8)*DPr1*f**2*DPr9+DPz1*E(9)*DPz9*f**2)/f**2
      AE(328) = AE(328)+poids*n*(-P1*E(9)*DPz9+P9*E(5)*DPz1)/f
      AE(329) = AE(329)-poids*n*(-P2*P9*E(3)-P2*P9*E(8)+P2*E(8)*DPr9*f-D
     #Pr2*f*E(2)*P9)/f**2
      AE(330) = AE(330)+poids*(P2*P9*n**2*E(3)+P2*P9*E(8)-P2*E(8)*DPr9*f
     #-E(8)*DPr2*f*P9+E(8)*DPr2*f**2*DPr9+DPz2*E(9)*DPz9*f**2)/f**2
      AE(331) = AE(331)-poids*n*(P2*E(9)*DPz9-DPz2*E(5)*P9)/f
      AE(332) = AE(332)-poids*n*(-P3*P9*E(3)-P3*P9*E(8)-P9*E(2)*DPr3*f+P
     #3*E(8)*DPr9*f)/f**2
      AE(333) = AE(333)+poids*(P3*P9*n**2*E(3)+P3*P9*E(8)-P3*E(8)*DPr9*f
     #-DPr3*E(8)*P9*f+E(8)*DPr3*f**2*DPr9+DPz3*E(9)*DPz9*f**2)/f**2
      AE(334) = AE(334)-poids*n*(P3*E(9)*DPz9-P9*E(5)*DPz3)/f
      AE(335) = AE(335)-poids*n*(-P9*P4*E(3)-P9*P4*E(8)-P9*E(2)*DPr4*f+D
     #Pr9*E(8)*P4*f)/f**2
      AE(336) = AE(336)+poids*(P9*P4*n**2*E(3)+P9*P4*E(8)-P9*E(8)*DPr4*f
     #-DPr9*E(8)*P4*f+E(8)*DPr9*f**2*DPr4+DPz4*E(9)*DPz9*f**2)/f**2
      AE(337) = AE(337)-poids*n*(P4*E(9)*DPz9-DPz4*E(5)*P9)/f
      AE(338) = AE(338)+poids*n*(P9*P5*E(3)+P9*P5*E(8)-P5*E(8)*DPr9*f+DP
     #r5*f*E(2)*P9)/f**2
      AE(339) = AE(339)+poids*(P9*P5*n**2*E(3)+P9*P5*E(8)-P9*DPr5*E(8)*f
     #-P5*E(8)*DPr9*f+E(8)*DPr9*f**2*DPr5+DPz5*E(9)*DPz9*f**2)/f**2
      AE(340) = AE(340)+poids*n*(-P5*E(9)*DPz9+P9*E(5)*DPz5)/f
      AE(341) = AE(341)+poids*n*(P9*P6*E(3)+P9*P6*E(8)-E(8)*DPr9*f*P6+P9
     #*E(2)*DPr6*f)/f**2
      AE(342) = AE(342)+poids*(P9*P6*n**2*E(3)+P9*P6*E(8)-P9*E(8)*DPr6*f
     #-E(8)*DPr9*f*P6+E(8)*DPr9*f**2*DPr6+DPz6*E(9)*DPz9*f**2)/f**2
      AE(343) = AE(343)+poids*n*(-P6*E(9)*DPz9+DPz6*E(5)*P9)/f
      AE(344) = AE(344)+poids*n*(P9*P7*E(3)+P9*P7*E(8)+P9*E(2)*DPr7*f-DP
     #r9*E(8)*P7*f)/f**2
      AE(345) = AE(345)+poids*(P9*P7*n**2*E(3)+P9*P7*E(8)-P9*E(8)*DPr7*f
     #-DPr9*E(8)*P7*f+E(8)*DPr9*f**2*DPr7+DPz7*E(9)*DPz9*f**2)/f**2
      AE(346) = AE(346)+poids*n*(-P7*E(9)*DPz9+DPz7*E(5)*P9)/f
      AE(347) = AE(347)-poids*n*(-P8*P9*E(3)-P8*P9*E(8)-P9*E(2)*DPr8*f+P
     #8*E(8)*DPr9*f)/f**2
      AE(348) = AE(348)+poids*(P8*P9*n**2*E(3)+P8*P9*E(8)-P8*E(8)*DPr9*f
     #-DPr8*E(8)*P9*f+DPr8*E(8)*f**2*DPr9+DPz8*E(9)*DPz9*f**2)/f**2
      AE(349) = AE(349)-poids*n*(P8*E(9)*DPz9-P9*E(5)*DPz8)/f
      AE(350) = AE(350)+poids*P9*n*(P9*E(3)+P9*E(8)-E(8)*DPr9*f+E(2)*DPr
     #9*f)/f**2
      AE(351) = AE(351)+poids*(P9**2*n**2*E(3)+P9**2*E(8)-2.D0*P9*E(8)*D
     #Pr9*f+E(8)*DPr9**2*f**2+E(9)*DPz9**2*f**2)/f**2
      AE(352) = AE(352)+poids*(P1*E(5)*DPz9+DPr1*E(4)*DPz9*f+DPz1*E(7)*D
     #Pr9*f)/f
      AE(353) = AE(353)+poids*n*(P1*E(5)*DPz9-DPz1*E(9)*P9)/f
      AE(354) = AE(354)+poids*(P1*n**2*E(9)*P9+DPr1*E(7)*DPr9*f**2+DPz1*
     #E(6)*DPz9*f**2)/f**2
      AE(355) = AE(355)+poids*(DPz2*E(7)*DPr9*f+DPz9*E(5)*P2+DPz9*E(4)*D
     #Pr2*f)/f
      AE(356) = AE(356)+poids*n*(DPz9*E(5)*P2-DPz2*E(9)*P9)/f
      AE(357) = AE(357)+poids*(P2*n**2*E(9)*P9+DPr2*E(7)*DPr9*f**2+DPz2*
     #E(6)*DPz9*f**2)/f**2
      AE(358) = AE(358)+poids*(DPz3*E(7)*DPr9*f+P3*E(5)*DPz9+DPz9*E(4)*D
     #Pr3*f)/f
      AE(359) = AE(359)+poids*n*(P3*E(5)*DPz9-DPz3*E(9)*P9)/f
      AE(360) = AE(360)+poids*(P3*n**2*E(9)*P9+DPr3*E(7)*DPr9*f**2+DPz3*
     #E(6)*DPz9*f**2)/f**2
      AE(361) = AE(361)+poids*(DPz4*E(7)*DPr9*f+P4*E(5)*DPz9+DPz9*E(4)*D
     #Pr4*f)/f
      AE(362) = AE(362)+poids*n*(P4*E(5)*DPz9-DPz4*E(9)*P9)/f
      AE(363) = AE(363)+poids*(P4*n**2*E(9)*P9+DPr4*E(7)*DPr9*f**2+DPz4*
     #E(6)*DPz9*f**2)/f**2
      AE(364) = AE(364)+poids*(DPz5*E(7)*DPr9*f+P5*E(5)*DPz9+DPz9*DPr5*E
     #(4)*f)/f
      AE(365) = AE(365)+poids*n*(P5*E(5)*DPz9-DPz5*E(9)*P9)/f
      AE(366) = AE(366)+poids*(P5*n**2*E(9)*P9+DPr5*E(7)*DPr9*f**2+DPz5*
     #E(6)*DPz9*f**2)/f**2
      AE(367) = AE(367)+poids*(DPz6*E(7)*DPr9*f+P6*E(5)*DPz9+DPz9*E(4)*D
     #Pr6*f)/f
      AE(368) = AE(368)+poids*n*(P6*E(5)*DPz9-DPz6*E(9)*P9)/f
      AE(369) = AE(369)+poids*(P6*n**2*E(9)*P9+DPr6*E(7)*DPr9*f**2+DPz6*
     #E(6)*DPz9*f**2)/f**2
      AE(370) = AE(370)+poids*(DPz7*E(7)*DPr9*f+P7*E(5)*DPz9+DPz9*E(4)*D
     #Pr7*f)/f
      AE(371) = AE(371)+poids*n*(P7*E(5)*DPz9-DPz7*E(9)*P9)/f
      AE(372) = AE(372)+poids*(P7*n**2*E(9)*P9+DPr7*E(7)*DPr9*f**2+DPz7*
     #E(6)*DPz9*f**2)/f**2
      AE(373) = AE(373)+poids*(DPz8*E(7)*DPr9*f+DPz9*E(5)*P8+DPz9*E(4)*D
     #Pr8*f)/f
      AE(374) = AE(374)+poids*n*(DPz9*E(5)*P8-DPz8*E(9)*P9)/f
      AE(375) = AE(375)+poids*(P8*n**2*E(9)*P9+DPr8*E(7)*DPr9*f**2+DPz8*
     #E(6)*DPz9*f**2)/f**2
      AE(376) = AE(376)+poids*DPz9*(E(5)*P9+E(4)*DPr9*f+E(7)*DPr9*f)/f
      AE(377) = AE(377)+poids*P9*n*DPz9*(E(5)-E(9))/f
      AE(378) = AE(378)+poids*(n**2*E(9)*P9**2+E(7)*DPr9**2*f**2+E(6)*DP
     #z9**2*f**2)/f**2
 2    CONTINUE
      END
