      SUBROUTINE etc2p1d(coor,car,iopt,U,ALPHA,THETA,SIGMA)
C ***************************************************************
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT TRIA 2p1d
C ---  
c in : coor(noe,ndim) : coor. 3 sommets
c      car, iopt      : caracteristiques des materiaux
c      U(ndim,noe): deplacements U_x et U_y aux 3 sommets
C      alpha(3)   : tenseur de dilatation thermique
C      theta(3)   : temperature aux 3 somets
C out: SIGMA(3)   :  S_xx, S_yy, S_xy elastiques au barycentre
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer  I, J, iopt
      double precision coor(3,2),car(6),E(6),U(2,3),ALPHA(3),
     +                 theta(3),sigma(3),DSIGMA(18),ED1(3),
     +                 EAP(3,3),X21,Y21,X31,Y31,X32,Y32,DELTA,
     +                 YOUNG,POISSON,C,UNMNU
C
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      DELTA = X21*Y31 - X31*Y21
C
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
          E(i) = car(i)
 1     continue
      end if
      DO 2 J=1,6
         E(J) = E(J) / DELTA
 2    continue

C     [      11]   [E1 E2 E4]    [    ]    [          ]
C     [SIGMA 22] = [   E3 E5]  * [ DP ]  * [u_solution]
C     [      12]   [      E6]    [    ]    [          ]
C             3*1          3*3       3*6             6*1
C     ---
C     [      11]   [1 4 7 10 13 16]        [          ]
C     [SIGMA 22] = [2 5 8 11 14 17]      * [u_solution]
C     [      12]   [3 6 9 12 15 18]        [          ]
C             3*1                3*6                 6*1
C
C     ---    SIGMA11
      DSIGMA(1)  = - E(1)*Y32 + E(4)*X32
      DSIGMA(4)  =   E(2)*X32 - E(4)*Y32
      DSIGMA(7)  =   E(1)*Y31 - E(4)*X31
      DSIGMA(10) = - E(2)*X31 + E(4)*Y31
      DSIGMA(13) = - E(1)*Y21 + E(4)*X21
      DSIGMA(16) =   E(2)*X21 - E(4)*Y21
      sigma(1)   = DSIGMA( 1)*U(1,1) + DSIGMA( 4)*U(2,1)
     +           + DSIGMA( 7)*U(1,2) + DSIGMA(10)*U(2,2)
     +           + DSIGMA(13)*U(1,3) + DSIGMA(16)*U(2,3)
C     ---    SIGMA22
      DSIGMA(2 ) = - E(2)*Y32 + E(5)*X32
      DSIGMA(5 ) =   E(3)*X32 - E(5)*Y32
      DSIGMA(8 ) =   E(2)*Y31 - E(5)*X31
      DSIGMA(11) = - E(3)*X31 + E(5)*Y31
      DSIGMA(14) = - E(2)*Y21 + E(5)*X21
      DSIGMA(17) =   E(3)*X21 - E(5)*Y21
      sigma(2)   = DSIGMA( 2)*U(1,1) + DSIGMA( 5)*U(2,1)
     +           + DSIGMA( 8)*U(1,2) + DSIGMA(11)*U(2,2)
     +           + DSIGMA(14)*U(1,3) + DSIGMA(17)*U(2,3)
C     ---    SIGMA12
      DSIGMA(3 ) = - E(4)*Y32 + E(6)*X32
      DSIGMA(6 ) =   E(5)*X32 - E(6)*Y32
      DSIGMA(9 ) =   E(4)*Y31 - E(6)*X31
      DSIGMA(12) = - E(5)*X31 + E(6)*Y31
      DSIGMA(15) = - E(4)*Y21 + E(6)*X21
      DSIGMA(18) =   E(5)*X21 - E(6)*Y21
      sigma(3)   = DSIGMA( 3)*U(1,1) + DSIGMA( 6)*U(2,1)
     +           + DSIGMA( 9)*U(1,2) + DSIGMA(12)*U(2,2)
     +           + DSIGMA(15)*U(1,3) + DSIGMA(18)*U(2,3)

C      print *,'---------------- Verif avec impressions Modulef'
C      print *, (dsigma(i), i= 1, 6)
C      print *, (dsigma(i), i= 7, 12)
C      print *, (dsigma(i), i= 13, 18)

C
C     CONTRAINTES THERMIQUES = HOOKE * ALPHA * TETA
C
C
C [s_11]   [E1 E2 E4]    [alpha_x ]                   [teta1]
C [s_22] = [   E3 E5]  * [alpha_y ]  *[ p1, p2, p3] * [teta2]
C [s 12]   [      E6]    [alpha_xy]              1*3  [teta3]
C     3*1          3*3           3*1                       3*1
C
C     SIGMA(TETA) = - (E) * (ALPHA) * (P) (X,Y)
c
C     [ED1] = [E] * [ALPHA]
c              3*3       3*1

      ED1(1) = - ( E(1)*ALPHA(1) + E(2)*ALPHA(3) + E(4)*ALPHA(2) )
      ED1(2) = - ( E(2)*ALPHA(1) + E(3)*ALPHA(3) + E(5)*ALPHA(2) )
      ED1(3) = - ( E(4)*ALPHA(1) + E(5)*ALPHA(3) + E(6)*ALPHA(2) )
C
C     [ED1] * [P] => [EAP]
C        3*1   1*3      3*3
c
      DO 3 I=1,3
        DO 3 J=1,3
          EAP(I,J) = ED1(I) / 3.
 3    CONTINUE
c
      do 4 j = 1 , 3
        sigma(1) = sigma(1) + EAP(1,J) * theta(J) 
        sigma(2) = sigma(2) + EAP(2,J) * theta(J) 
        sigma(3) = sigma(3) + EAP(3,J) * theta(J) 
 4    continue
c
      return
      end
