      SUBROUTINE etc2p2c(coor,car,iopt,U,ALPHA,THETA,SIGMA)
C ***************************************************************
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT TRIA 2p2c
C ---  
c in : coor(noe,ndim) : coor. 3 sommets + 3 milieux aretes
c      car, iopt      : caracteristiques des materiaux
c      U(ndim,noe): deplacements U_x et U_y aux 6 noeuds
C      alpha(3)   : tenseur de dilatation thermique
C      theta(6)   : temperature aux 6 noeuds.
C out: SIGMA(3)   :  S_xx, S_yy, S_xy elastiques
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer IJT(12),iopt,i,j,ibloc,i1,i2,i3,i4,i5,i6,kk,j1,l
      DOUBLE PRECISION coor(6,2),car(6),E(6),U(2,6),ALPHA(3),
     +                 theta(6),sigma(3),DSIGMA(36),
     +                 X21,Y21,X31,Y31,X32,Y32,X41,Y41,X42,Y42,X54,
     +                 Y54,X61,Y61,X63,Y63,X65,Y65,C,ED1(3),EAP(3,6),
     +                 DELTA,S,ED(6),DFINV(2,2,4),EDFP(3,6),const(3),
     +                 DFIDP(2,6),DP(2,6,4),young,poisson,unmnu
      DATA IJT/ 1, 3, 5, 7, 9, 11, 2, 4, 6, 8, 10, 12/
      DATA DP/ 2*-1.D+00 , 1.D+00, 2*0.D00 , 1.D+00, 0.D00 ,
     +         -4.D+00 , 2*4.D+00 , -4.D+00 , 0.D00,
     +         2*-3.D+00 , -1.D+00 , 2*0.D+00 , -1.D+00 , 4.D+00 ,
     +         4*0.D+00  , 4.D+00 ,
     +         2*1.D+00 , 3.D+00 , 2*0.D+00 , -1.D+00 , 2*-4.D+00 ,
     +         0.D+00   , 4.D+00 , 2*0.D+00 ,
     +         2*1.D+00 , -1.D+00 , 2*0.D+00 , 3.D+00 , 2*0.D+00 ,
     +         4.D+00   ,  0.D+00 , 2*-4.D+00/
C
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      X41  = coor(4,1) - coor(1,1)
      Y41  = coor(4,2) - coor(1,2)
      X42  = coor(4,1) - coor(2,1)
      Y42  = coor(4,2) - coor(2,2)
      X54  = coor(5,1) - coor(4,1)
      Y54  = coor(5,2) - coor(4,2)
      X61  = coor(6,1) - coor(1,1)
      Y61  = coor(6,2) - coor(1,2)
      X63  = coor(6,1) - coor(3,1)
      Y63  = coor(6,2) - coor(3,2)
      X65  = coor(6,1) - coor(5,1)
      Y65  = coor(6,2) - coor(5,2)
C
      IF(iopt .eq. 1) THEN
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      ELSE IF(iopt .eq. 2) THEN
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = Car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
C -- CALCUL DES CONTRAINTES ELEMENTAIRES AU BARYCENTRE
C
C     --  CALCUL DE DFINV  L INVERSE DE DF
C
      DFINV(1,1,1) =  Y31 + 4.D0 * Y54
      DFINV(2,1,1) = -X31 - 4.D0 * X54
      DFINV(1,2,1) = -Y21 + 4.D0 * Y65
      DFINV(2,2,1) =  X21 - 4.D0 * X65
      DELTA = DFINV(1,1,1)*DFINV(2,2,1)
     +      - DFINV(1,2,1)*DFINV(2,1,1)
      DO 2 J=1,6
        E(J) = E(J) /  DELTA
 2    CONTINUE
C
C     -- CALCUL DE DFINV*DP
c
c                | dp1dx dp2dx dp3dx dp3dx dp4dx dp5dx dp6dx |
c   DFIDP(2,6) = |                                           |
c                | dp1dy dp2dy dp3dy dp3dy dp4dy dp5dy dp6dy |  

      DO 4 I=1,2
        DO 4  J=1,6
          S = 0.D+00
          DO 3 L=1,2
            S = S + DFINV(I,L,1)*DP(L,J,1)
 3        CONTINUE
          DFIDP(I,J) = S
 4    CONTINUE
c
C     --CALCUL DE E*D
      do 8 ibloc = 1 , 2
        if(ibloc .eq. 1) then
          I1 = 1
          I2 = 2
          I3 = 4
          I4 = 4
          I5 = 5
          I6 = 6
        elseif(ibloc .eq. 2) then
          I1 = 4
          I2 = 5
          I3 = 6
          I4 = 2
          I5 = 3
          I6 = 5
        end if
        ED(1) = E(I1)
        ED(2) = E(I2)
        ED(3) = E(I3)
        ED(4) = E(I4)
        ED(5) = E(I5)
        ED(6) = E(I6)
C
C       -- CALCUL DE ED * DFIDP PAR BLOC
C
        DO 6 J=1,6
          DO 6 I=1,3
            S = 0.D+00
            DO 5 L=1,2
              KK = 3 * (L-1) + I
              S = S + ED(KK)*DFIDP(L,J)
 5          CONTINUE
            EDFP(I,J) = S
 6      CONTINUE
c
C       -- CALCUL DE DSIGMA(36)
C
        DO 7 J=1,6
          DO 7 I=1,3
            J1 = J
            IF ( IBLOC .EQ. 2) J1 = J + 6
            KK = 3 * ( IJT(J1) -1 ) + I
            DSIGMA(KK) = EDFP(I,J)
 7      CONTINUE
 8    continue
c
C  [      11]   [1 4 7 10 13 16 19 22 25 28 31 34]   [          ]
C  [SIGMA 22] = [2 5 8 11 14 17 20 23 26 29 32 35] * [u_solution]
C  [      12]   [3 6 9 12 15 18 21 24 27 30 33 36]   [          ]
C          3*1                                 3*12           12*1

      sigma(1) = DSIGMA( 1)*U(1,1) + DSIGMA( 4)*U(2,1)
     +         + DSIGMA( 7)*U(1,2) + DSIGMA(10)*U(2,2)
     +         + DSIGMA(13)*U(1,3) + DSIGMA(16)*U(2,3)
     +         + DSIGMA(19)*U(1,4) + DSIGMA(22)*U(2,4)
     +         + DSIGMA(25)*U(1,5) + DSIGMA(28)*U(2,5)
     +         + DSIGMA(31)*U(1,6) + DSIGMA(34)*U(2,6)
      sigma(2) = DSIGMA( 2)*U(1,1) + DSIGMA( 5)*U(2,1)
     +         + DSIGMA( 8)*U(1,2) + DSIGMA(11)*U(2,2)
     +         + DSIGMA(14)*U(1,3) + DSIGMA(17)*U(2,3)
     +         + DSIGMA(20)*U(1,4) + DSIGMA(23)*U(2,4)
     +         + DSIGMA(26)*U(1,5) + DSIGMA(29)*U(2,5)
     +         + DSIGMA(32)*U(1,6) + DSIGMA(35)*U(2,6)
      sigma(3) = DSIGMA( 3)*U(1,1) + DSIGMA( 6)*U(2,1)
     +         + DSIGMA( 9)*U(1,2) + DSIGMA(12)*U(2,2)
     +         + DSIGMA(15)*U(1,3) + DSIGMA(18)*U(2,3)
     +         + DSIGMA(21)*U(1,4) + DSIGMA(24)*U(2,4)
     +         + DSIGMA(27)*U(1,5) + DSIGMA(30)*U(2,5)
     +         + DSIGMA(33)*U(1,6) + DSIGMA(36)*U(2,6)

C      print *,'---------------- Verif avec impressions Modulef'
C      print *, (dsigma(i), i= 1, 6)
C      print *, (dsigma(i), i= 7, 12)
C      print *, (dsigma(i), i= 13, 18)
C      print *, (dsigma(i), i= 19, 24)
C      print *, (dsigma(i), i= 24, 30)
C      print *, (dsigma(i), i= 31, 36)
C
C     LES CONTRAINTES THERMIQUES
C     --------------------------
C
C     SIGMA(TETA) = - (E) * (ALPHA) * (P) (X,Y)
C     ED1 = (E) * (ALPHA)
C            3*3       3*1
      ED1(1) = - ( E(1)*ALPHA(1) + E(2)*ALPHA(3) + E(4)*ALPHA(2) )
      ED1(2) = - ( E(2)*ALPHA(1) + E(3)*ALPHA(3) + E(5)*ALPHA(2) )
      ED1(3) = - ( E(4)*ALPHA(1) + E(5)*ALPHA(3) + E(6)*ALPHA(2) )
C
C     ED1  * P   => EAP
C      3*1  1*6      3*6
C
C     CONTRAINTES AU BARYCENTRE
      DO 9 I=1,3
         CONST(I) = ED1(I)/9.
 9    CONTINUE
         
      DO 10 I=1,3
        DO 10 J=1,3
          EAP(I,J)   = -CONST(I)
          EAP(I,J+3) =  CONST(I)*4.
 10   CONTINUE
c
      do 11 j = 1 , 6
        sigma(1) = sigma(1) + EAP(1,J) * theta(J) 
        sigma(2) = sigma(2) + EAP(2,J) * theta(J) 
        sigma(3) = sigma(3) + EAP(3,J) * theta(J) 
 11   continue

      END
