      SUBROUTINE etc2q1d(coor,car,iopt,U,ALPHA,THETA,SIGMA)
C ***************************************************************
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT QUAD 2q1d
C ---  
c in : coor(noe,ndim) : coor. 3 sommets
c      car, iopt      : caracteristiques des materiaux
c      U(ndim,noe): deplacements U_x et U_y aux 3 sommets
C      alpha(3)   : tenseur de dilatation thermique
C      theta(4)   : temperature aux 3 somets
C out: SIGMA(3)   :  S_xx, S_yy, S_xy elastiques au barycentre
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer  I, J, iopt
      double precision coor(4,2),car(6),E(6),U(2,4),ALPHA(3),theta(4),
     +                 sigma(3),ED1(3),EAP(3,4),X21,Y21,X41,Y41,X32,
     +                 Y32,X42,Y42,X43,Y43,X31,Y31,DELTA,YOUNG,POISSON,
     +                 C,UNMNU,dsigma(24)
C
      x21  = coor(2,1) - coor(1,1)
      y21  = coor(2,2) - coor(1,2)
      x31  = coor(3,1) - coor(1,1)
      y31  = coor(3,2) - coor(1,2)
      x32  = coor(3,1) - coor(2,1)
      y32  = coor(3,2) - coor(2,2)
      x41  = coor(4,1) - coor(1,1)
      y41  = coor(4,2) - coor(1,2)
      x42  = coor(4,1) - coor(2,1)
      y42  = coor(4,2) - coor(2,2)
      x43  = coor(4,1) - coor(3,1)
      y43  = coor(4,2) - coor(3,2)
C
      DELTA = ((X21-X43)*(Y41+Y32)-(Y21-Y43)*(X41+X32))/2.D00
C
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
c
      DO 2 J=1,6
         E(J) = E(J) / DELTA
 2    continue
C
C     [      11]   [E1 E2 E4]    [    ]    [          ]
C     [SIGMA 22] = [   E3 E5]  * [ DP ]  * [u_solution]
C     [      12]   [      E6]    [    ]    [          ]
C             3*1          3*3       3*8             8*1
C     ---
C     [      11]   [1 4 7 10 13 16 19 22]     [          ]
C     [SIGMA 22] = [2 5 8 11 14 17 20 23]   * [u_solution]
C     [      12]   [3 6 9 12 15 18 21 24]     [          ]
C             3*1                      3*8              8*1
C
C     ---    SIGMA11
      DSIGMA(1 ) = - E(1)*Y42 + E(4)*X42
      DSIGMA(7)  =   E(1)*Y31 - E(4)*X31
      DSIGMA(13) =   E(1)*Y42 - E(4)*X42
      DSIGMA(19) = - E(1)*Y31 + E(4)*X31
      DSIGMA(4)  =   E(2)*X42 - E(4)*Y42
      DSIGMA(10) = - E(2)*X31 + E(4)*Y31
      DSIGMA(16) = - E(2)*X42 + E(4)*Y42
      DSIGMA(22) =   E(2)*X31 - E(4)*Y31
      sigma(1)   = DSIGMA( 1)*U(1,1) + DSIGMA( 4)*U(2,1)
     +           + DSIGMA( 7)*U(1,2) + DSIGMA(10)*U(2,2)
     +           + DSIGMA(13)*U(1,3) + DSIGMA(16)*U(2,3)
     +           + DSIGMA(19)*U(1,4) + DSIGMA(22)*U(2,4)
C     ---    SIGMA22
      DSIGMA(2 ) = - E(2)*Y42 + E(5)*X42
      DSIGMA(8 ) =   E(2)*Y31 - E(5)*X31
      DSIGMA(14) =   E(2)*Y42 - E(5)*X42
      DSIGMA(20) = - E(2)*Y31 + E(5)*X31
      DSIGMA(5 ) =   E(3)*X42 - E(5)*Y42
      DSIGMA(11) = - E(3)*X31 + E(5)*Y31
      DSIGMA(17) = - E(3)*X42 + E(5)*Y42
      DSIGMA(23) =   E(3)*X31 - E(5)*Y31
      sigma(2)   = DSIGMA( 2)*U(1,1) + DSIGMA( 5)*U(2,1)
     +           + DSIGMA( 8)*U(1,2) + DSIGMA(11)*U(2,2)
     +           + DSIGMA(14)*U(1,3) + DSIGMA(17)*U(2,3)
     +           + DSIGMA(20)*U(1,4) + DSIGMA(23)*U(2,4)
C     ---    SIGMA12
      DSIGMA(3 ) = - E(4)*Y42 + E(6)*X42
      DSIGMA(9 ) =   E(4)*Y31 - E(6)*X31
      DSIGMA(15) =   E(4)*Y42 - E(6)*X42
      DSIGMA(21) = - E(4)*Y31 + E(6)*X31
      DSIGMA(6 ) =   E(5)*X42 - E(6)*Y42
      DSIGMA(12) = - E(5)*X31 + E(6)*Y31
      DSIGMA(18) = - E(5)*X42 + E(6)*Y42
      DSIGMA(24) =   E(5)*X31 - E(6)*Y31
      sigma(3)   = DSIGMA( 3)*U(1,1) + DSIGMA( 6)*U(2,1)
     +           + DSIGMA( 9)*U(1,2) + DSIGMA(12)*U(2,2)
     +           + DSIGMA(15)*U(1,3) + DSIGMA(18)*U(2,3)
     +           + DSIGMA(21)*U(1,4) + DSIGMA(24)*U(2,4)

C      print *,'---------------- Verif avec impressions Modulef'
C      print *, (dsigma(i), i= 1, 6)
C      print *, (dsigma(i), i= 7, 12)
C      print *, (dsigma(i), i= 13, 18)
C      print *, (dsigma(i), i= 19, 24)
C
C     CONTRAINTES THERMIQUES = HOOKE * ALPHA * TETA
C
C
C [s_11]   [E1 E2 E4]    [alpha_x ]                   [teta1]
C [s_22] = [   E3 E5]  * [alpha_y ]  *[ p1, p2, p3] * [teta2]
C [s 12]   [      E6]    [alpha_xy]              1*4  [teta3]
C     3*1          3*3           3*1                  [teta4]
C
C     SIGMA(TETA) = - (E) * (ALPHA) * (P) (X,Y)
c
C     [ED1] = [E] * [ALPHA]
c              3*3       3*1
C
      ED1(1) = - ( E(1)*ALPHA(1) + E(2)*ALPHA(3) + E(4)*ALPHA(2) )
      ED1(2) = - ( E(2)*ALPHA(1) + E(3)*ALPHA(3) + E(5)*ALPHA(2) )
      ED1(3) = - ( E(4)*ALPHA(1) + E(5)*ALPHA(3) + E(6)*ALPHA(2) )
C
C     [ED1] * [P] => [EAP]
C        3*1   1*4      3*4
c
C
C     ED1 * P => EAP
C
      DO 3 I=1,3
         DO 3 J=1,4
            EAP(I,J) = ED1(I) / 4.
 3       CONTINUE
c
      do 4 j = 1 , 4
        sigma(1) = sigma(1) + EAP(1,J) * theta(J) 
        sigma(2) = sigma(2) + EAP(2,J) * theta(J) 
        sigma(3) = sigma(3) + EAP(3,J) * theta(J) 
 4    continue
c
      return
      end
