      SUBROUTINE etc2q2c(coor,car,iopt,U,SIGMA)
C ***************************************************************
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT QUAD 2Q2C
C ---  
c in : coor(noe,ndim) : coordonnees des 8 noeuds.
c      car, iopt      : caracteristiques des materiaux
c      U(ndim,noe): deplacements U_x et U_y aux 8 noeuds
C out: SIGMA(3)   :  S_xx, S_yy, S_xy elastiques
c programmeur : modulef
c ...............................................................
      implicit none
      integer IJT(16),iopt,i,j,ibloc,i1,i2,i3,i4,i5,i6,kk,j1,l,
     +        ndim,nbpoly,npi
      PARAMETER (ndim=2 , NBPOLY=8 , NPI=9)
      DOUBLE PRECISION COOR(8,2),car(6),U(8,2),sigma(3),DSIGMA(48),
     +                 P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),POIDS(NPI),
     +                 XYNPI(ndim,npi),F11(9),F12(9),F21(9),F22(9),
     +                 E(6),C,DELT5,S,ED(6),DFINV(2,2),EDFP(3,8),
     +                 DFIDP(2,8),young,poisson,unmnu
      DATA IJT/ 1, 3, 5, 7, 9, 11, 13, 15, 2, 4, 6, 8, 10, 12, 14, 16/
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
c 
c
      IF(iopt .eq. 1) THEN
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      ELSE IF(iopt .eq. 2) THEN
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
C -- CALCUL DES CONTRAINTES ELEMENTAIRES AU BARYCENTRE
C            CALCUL DE DELT5 = DELTA(5)
C
      F11(5) = 0.D0
      F12(5) = 0.D0
      F21(5) = 0.D0
      F22(5) = 0.D0
      DO 2 I=1,NBPOLY
        F11(5) = F11(5) + DP25(1,I,5) * coor(I,1)
        F12(5) = F12(5) + DP25(2,I,5) * coor(I,1)
        F21(5) = F21(5) + DP25(1,I,5) * coor(I,2)
        F22(5) = F22(5) + DP25(2,I,5) * coor(I,2)
 2    CONTINUE
      DELT5 = F11(5) * F22(5) - F12(5) * F21(5)
C
C     ----  CALCUL DE DFINV  L INVERSE DE DF  -----
C
      DFINV(1,1) =   F22(5)
      DFINV(2,1) = - F12(5)
      DFINV(1,2) = - F21(5)
      DFINV(2,2) =   F11(5)
C
C     ----  CALCUL DE DFINV*DP
C
      DO 4 I=1,2
        DO 4  J=1,NBPOLY
          S = 0.D+00
          DO 3 L=1,2
            S = S + DFINV(I,L)*DP25(L,J,5)
 3        CONTINUE
          DFIDP(I,J) = S / DELT5
 4    CONTINUE
c
C     --CALCUL DE E*D
      do 8 ibloc = 1 , 2
        if(ibloc .eq. 1) then
          I1 = 1
          I2 = 2
          I3 = 4
          I4 = 4
          I5 = 5
          I6 = 6
        elseif(ibloc .eq. 2) then
          I1 = 4
          I2 = 5
          I3 = 6
          I4 = 2
          I5 = 3
          I6 = 5
        end if
        ED(1) = E(I1)
        ED(2) = E(I2)
        ED(3) = E(I3)
        ED(4) = E(I4)
        ED(5) = E(I5)
        ED(6) = E(I6)
C
C       -- CALCUL DE ED * DFIDP PAR BLOC
C
        DO 6 J=1,NBPOLY
          DO 6 I=1,3
            S = 0.D+00
            DO 5 L=1,2
               KK = 3 * (L-1) + I
               S = S + ED(KK)*DFIDP(L,J)
 5          CONTINUE
            EDFP(I,J) = S
 6      CONTINUE
c
C       -- CALCUL DE DSIGMA(48)
C

        DO 7 J=1,NBPOLY
          DO 7 I=1,3
            J1 = J
            IF ( IBLOC .EQ. 2) J1 = J + 8
            KK = 3 * ( IJT(J1) -1 ) + I 
            DSIGMA(KK) = EDFP(I,J)
 7      CONTINUE
 8    continue
c
c
C  [  11] [1 4 7 10 13 16 19 22 25 28 31 34 37 40 43 46] [     ]
C  [S 22]=[2 5 8 11 14 17 20 23 26 29 32 35 38 41 44 47]*[u_sol]
C  [  12] [3 6 9 12 15 18 21 24 27 30 33 36 39 42 45 48] [     ]
C      3*1                                          3*48    16*1

      sigma(1) = DSIGMA( 1)*U(1,1) + DSIGMA( 4)*U(1,2)
     +         + DSIGMA( 7)*U(2,1) + DSIGMA(10)*U(2,2)
     +         + DSIGMA(13)*U(3,1) + DSIGMA(16)*U(3,2)
     +         + DSIGMA(19)*U(4,1) + DSIGMA(22)*U(4,2)
     +         + DSIGMA(25)*U(5,1) + DSIGMA(28)*U(5,2)
     +         + DSIGMA(31)*U(6,1) + DSIGMA(34)*U(6,2)
     +         + DSIGMA(37)*U(7,1) + DSIGMA(40)*U(7,2)
     +         + DSIGMA(43)*U(8,1) + DSIGMA(46)*U(8,2)

      sigma(2) = DSIGMA( 2)*U(1,1) + DSIGMA( 5)*U(1,2)
     +         + DSIGMA( 8)*U(2,1) + DSIGMA(11)*U(2,2)
     +         + DSIGMA(14)*U(3,1) + DSIGMA(17)*U(3,2)
     +         + DSIGMA(20)*U(4,1) + DSIGMA(23)*U(4,2)
     +         + DSIGMA(26)*U(5,1) + DSIGMA(29)*U(5,2)
     +         + DSIGMA(32)*U(6,1) + DSIGMA(35)*U(6,2)
     +         + DSIGMA(38)*U(7,1) + DSIGMA(41)*U(7,2)
     +         + DSIGMA(44)*U(8,1) + DSIGMA(47)*U(8,2)

      sigma(3) = DSIGMA( 3)*U(1,1) + DSIGMA( 6)*U(1,2)
     +         + DSIGMA( 9)*U(2,1) + DSIGMA(12)*U(2,2)
     +         + DSIGMA(15)*U(3,1) + DSIGMA(18)*U(3,2)
     +         + DSIGMA(21)*U(4,1) + DSIGMA(24)*U(4,2)
     +         + DSIGMA(27)*U(5,1) + DSIGMA(30)*U(5,2)
     +         + DSIGMA(33)*U(6,1) + DSIGMA(36)*U(6,2)
     +         + DSIGMA(39)*U(7,1) + DSIGMA(42)*U(7,2)
     +         + DSIGMA(45)*U(8,1) + DSIGMA(48)*U(8,2)
c
C      print *,'---------------- Verif avec impressions Modulef'
C      print *, (dsigma(i), i= 1, 6)
C      print *, (dsigma(i), i= 7, 12)
C      print *, (dsigma(i), i= 13, 18)
C      print *, (dsigma(i), i= 19, 24)

C      print *, (dsigma(i), i= 25, 30)
C      print *, (dsigma(i), i= 31, 36)
C      print *, (dsigma(i), i= 37, 42)
C      print *, (dsigma(i), i= 43, 48)
c
      END
