      SUBROUTINE ETC3P1D(COOR,CAR,IOPT,SIGMA,U)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DES CONTRAINTES TETRAEDRE P1 DROIT
C  ---     
c          aux points d'integration, les 4 sommets
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   coor  : TABLEAUX DES COORDONNEES DES POINTS DE L ELEMENT
c   ijt     : permutation pour oasser de la numerotation par inconnues
c             a celle par noeuds
c   nno     : nombre de noeuds de l'element
c   npo     : nombre de points
c   npi     : nombre de points d'integration
c   dp      : valeur des derivees des polynomes de base aux points
c             d'integration sur l'element de reference
c   vp1     : valeur des polynomes de base aux points
c             d'integration sur l'element de reference
c   poids   : poids de la formule d'integration
c
c  tableaux de travail :
c  -------------------
c   delta   : jacobien aux points d'integration
c   (x y z)int : coordonnees des points d'integration sur 
c              l'element courant
C
C  PARAMETRE DE SORTIE  :
C  --------------------
C   AE     : MATRICE DE RIGIDITE . SYMETRIQUE
C            STockee dans ae(nmax,nmax)
C

C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEURS  : Marina Vidrascu 2003
C ...................................................................
C
      parameter (ndim=3, nno=4, npo=4)
      DOUBLE PRECISION SIGMAE(6,NDIM*NNO,NPO),sigma(6,npo),U(ndim*npo)
      DOUBLE PRECISION COOR(npo,3)
      
      DIMENSION IJT(ndim*nno)
      double precision elas(9),delta(nno), a2(ndim,nno,nno),
     &                 DP(ndim,nno,npo),car(iopt)
c
      DATA IJT / 1, 4, 7, 10,  2, 5, 8, 11,  3, 6, 9, 12/

      DATA DP/ -1., -1.0, -1.0,  1.0 ,  0.0 ,  0.0 , 0.0 ,  1.0 ,  0.0 ,
     *     0.0 ,  0.0 ,  1.0 , -1.0 , -1.0 , -1.0 , 1.0 ,  0.0 ,  0.0 ,
     *     0.0 ,  1.0 ,  0.0 ,  0.0 ,  0.0 ,  1.0 ,-1.0 , -1.0 , -1.0 ,
     *     1.0 ,  0.0 ,  0.0 ,  0.0 ,  1.0 ,  0.0 , 0.0 ,  0.0 ,  1.0 ,
     *    -1.0 , -1.0 , -1.0 ,  1.0 ,  0.0 ,  0.0 , 0.0 ,  1.0 ,  0.0 ,
     *     0.0 ,  0.0 ,  1.0  /
C
C
c     si isotrope e=car(1), nu=car(2)
c     si orthotrope elas=car
      if (iopt .eq. 2) then
C
C         CAS ISOTROPE
C         ------------
          CALL EC3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),IJT,
     +            dp,dp,iopt,car(1),car(2),elas,sigmae,sigma,u,delta,a2)
      else
C
C         CAS ORTHOTROPE
C         --------------
          CALL EC3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),IJT,
     +            dp,dp,iopt,car(1),car(2),car,sigmae,sigma,u,delta,a2)


      endif
 
      END
