      SUBROUTINE etcap2c(coor,car,iopt,u,alpha,theta,sigma)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT TRIA AP2C
C ---  
c in : coor(noe,ndim) : coordonnees R(6), Z(6) des 6 noeuds.

c      car        : caracteristiques des materiaux
c           if(iopt .eq. 1) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c      U(ndim,noe): deplacements U_r et U_z aux 6 noeuds
C      alpha(3) : coef. dilatation thermique: radial, axial, tangentiel
C      theta(6)   : theta aux 6 noeuds
C out: 
C      SIGMA(4)   :  S_rr, S_rz, S_zz, S_tt elastiques
C .....................................................................
      implicit none
      integer ndim,NBPOLY,NPI,nbarete,nnof,IP(12),iopt,i
      PARAMETER (ndim=2, NBPOLY=6, NPI=7, nbarete=3, nnof=3)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,npi),DFM1DP(2,nbpoly,npi),alpha(3),
     +                 theta(6),
     +                 COOR(6,2),car(10),elas(10),U(ndim,6),r,SIGMA(4),
     +                 estrain_zz,estrain_rr, estrain_tt, estrain_rz,
     +                 tstrain_zz,tstrain_rr, tstrain_tt,alpha_z,
     +                 alpha_r,alpha_t,p1,p2,p3,p4,p5,p6,dp1dr,dp2dr,
     +                 dp3dr,dp4dr,dp5dr,dp6dr,dp1dz,dp2dz,dp3dz,dp4dz,
     +                 dp5dz,dp6dz
C 2P25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +             .10128650732345632D+00,   .10128650732345632D+00,
     +             .79742698535308720D+00,   .10128650732345632D+00,
     +             .10128650732345632D+00,   .79742698535308720D+00,
     +             .47014206410511505D+00,   .59715871789769801D-01,
     +             .47014206410511505D+00,   .47014206410511505D+00,
     +             .59715871789769801D-01,   .47014206410511505D+00,
     +             .33333334326744079D+00,   .33333334326744079D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS /
     +             .62969590272413583D-01,   .62969590272413583D-01,
     +             .62969590272413583D-01,   .66197076394253095D-01,
     +             .66197076394253095D-01,   .66197076394253095D-01,
     +             .11249999701976776D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / 
     +             .47435260858553857D+00,  -.80768594191887185D-01,
     +            -.80768594191887185D-01,   .32307437676754874D+00,
     +             .41035826263138293D-01,   .32307437676754874D+00,
     +            -.80768594191886977D-01,   .47435260858553840D+00,
     +            -.80768594191887185D-01,   .32307437676754879D+00,
     +             .32307437676754868D+00,   .41035826263138341D-01,
     +            -.80768594191887033D-01,  -.80768594191887185D-01,
     +             .47435260858553840D+00,   .41035826263138334D-01,
     +             .32307437676754868D+00,   .32307437676754890D+00,
     +            -.28074943223078796D-01,  -.28074943223078852D-01,
     +            -.52583901102545349D-01,   .88413424176407262D+00,
     +             .11229977289231514D+00,   .11229977289231517D+00,
     +            -.52583901102545571D-01,  -.28074943223078852D-01,
     +            -.28074943223078852D-01,   .11229977289231540D+00,
     +             .88413424176407240D+00,   .11229977289231540D+00,
     +            -.28074943223078765D-01,  -.52583901102545349D-01,
     +            -.28074943223078852D-01,   .11229977289231514D+00,
     +             .11229977289231514D+00,   .88413424176407262D+00,
     +            -.11111111773384862D+00,  -.11111110779974175D+00,
     +            -.11111110779974175D+00,   .44444443119896703D+00,
     +             .44444447093539807D+00,   .44444443119896703D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +            -.21897079414123492D+01,  -.21897079414123492D+01,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +             .27845619121185238D+01,  -.40514602929382531D+00,
     +             .40514602929382531D+00,   .40514602929382531D+00,
     +            -.40514602929382531D+00,   .27845619121185238D+01,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +             .21897079414123488D+01,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +            -.27845619121185229D+01,  -.31897079414123488D+01,
     +             .40514602929382531D+00,   .31897079414123488D+01,
     +            -.40514602929382531D+00,   .00000000000000000D+00,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .21897079414123488D+01,
     +             .00000000000000000D+00,  -.40514602929382531D+00,
     +             .31897079414123488D+01,   .40514602929382531D+00,
     +            -.31897079414123488D+01,  -.27845619121185229D+01,
     +            -.88056825642046065D+00,  -.88056825642046065D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.76113651284092076D+00,
     +             .00000000000000000D+00,  -.18805682564204602D+01,
     +             .23886348715907920D+00,   .18805682564204602D+01,
     +            -.23886348715907920D+00,   .16417047692613815D+01,
     +             .76113651284092043D+00,   .76113651284092043D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +            -.16417047692613806D+01,  -.18805682564204602D+01,
     +             .18805682564204602D+01,   .18805682564204602D+01,
     +            -.18805682564204602D+01,  -.16417047692613806D+01,
     +            -.88056825642046054D+00,  -.88056825642046054D+00,
     +            -.76113651284092076D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +             .16417047692613813D+01,  -.23886348715907920D+00,
     +             .18805682564204602D+01,   .23886348715907920D+00,
     +            -.18805682564204602D+01,   .00000000000000000D+00,
     +            -.33333325386047363D+00,  -.33333325386047363D+00,
     +             .33333337306976318D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .33333337306976318D+00,
     +            -.11920928955078125D-06,  -.13333333730697631D+01,
     +             .13333333730697631D+01,   .13333333730697631D+01,
     +            -.13333333730697631D+01,  -.11920928955078125D-06 /
C
c     -- CALCUL DE F1,F2,FFM1,DFM1DP
c
      CALL E2AP2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
C
      call hookax(iopt,car,ELAS)
C
C     Contriantes [SIG] = [Elas] * [STRAIN_elas - STRAIN_ther] + SIG_0
C
c
C     1) --- STRAIN Elastiques
c                                                             [U_r(1)]
c [Strain_zz]   [  0     0   ...   0   dp1dz dp2dz ... dp6dz] [  .   ]
c [         ]   [                                           ] [  .   ]
c [Strain_rr]   [dp1dr dp2dr ... dp6dr   0      0  ...   0  ] [  .   ]
c [         ]   [                                           ] [U_r(6)]
c [Strain_tt] = [ p1    p2        p6                        ] [      ]
c [         ]   [---   ---  ...  ---     0      0  ...   0  ] [U_z(1)]
c [2*Stra_rz]   [ r     r         r                         ] [  .   ]
c               [                                           ] [  .   ]
c               [ dp1dz .......  dp86z dp1dr ........  dp6dr] [  .   ]
c                                                             [U_z(6)]
c
c  barycentre F1(1) etr F2(1)
      i = 5
      r = F1(i)
      p1 = P25(1,i)
      p2 = P25(2,i)
      p3 = P25(3,i)
      p4 = P25(4,i)
      p5 = P25(5,i)
      p6 = P25(6,i)
      dp1dr = DFM1DP(1,1,i)
      dp2dr = DFM1DP(1,2,i)
      dp3dr = DFM1DP(1,3,i)
      dp4dr = DFM1DP(1,4,i)
      dp5dr = DFM1DP(1,5,i)
      dp6dr = DFM1DP(1,6,i)
      dp1dz = DFM1DP(2,1,i)
      dp2dz = DFM1DP(2,2,i)
      dp3dz = DFM1DP(2,3,i)
      dp4dz = DFM1DP(2,4,i)
      dp5dz = DFM1DP(2,5,i)
      dp6dz = DFM1DP(2,6,i)
      estrain_zz = dp1dz*U(2,1) + dp2dz*U(2,2) + dp3dz*U(2,3)
     +           + dp4dz*U(2,4) + dp5dz*U(2,5) + dp6dz*U(2,6)
      estrain_rr = dp1dr*U(1,1) + dp2dr*U(1,2) + dp3dr*U(1,3)
     +           + dp4dr*U(1,4) + dp5dr*U(1,5) + dp6dr*U(1,6)
      estrain_tt = ( p1*U(1,1) + p2*U(1,2) + p3*U(1,3)
     +             + p4*U(1,4) + p5*U(1,5) + p6*U(1,6) ) / r
      estrain_rz = .5*( dp1dz*U(1,1) + dp1dr*U(2,1) + dp2dz*U(1,2)
     +                + dp2dr*U(2,2) + dp3dz*U(1,3) + dp3dr*U(2,3)
     +                + dp4dz*U(1,4) + dp4dr*U(2,4) + dp5dz*U(1,5)
     +                + dp5dr*U(2,5) + dp6dz*U(1,6) + dp6dr*U(2,6) )
C
C     2) --- STRAIN THermiques =  (ALPHA) * (P) * THETA
c         
c [ Strain_zz ] [alpha_z]
c [           ] [       ]                         [ theta(1)]
c [ Strain_rr ] [alpha_r]                         [ theta(2)]
c [           ]=[       ]*[ p1 p2 p3  p4 p5 p6] * [ theta(3)]
c [ Strain_tt ] [alpha_t]                         [ theta(4)]
c [           ] [       ]                         [ theta(5)] 
c [2*Strain_rz] [  0    ]                         [ theta(6)] 
c
      alpha_r = alpha(1)
      alpha_z = alpha(2)
      alpha_t = alpha(3)
      tstrain_zz = alpha_z * (p1*theta(1) + p2*theta(2) + p3*theta(3)
     +                      + p4*theta(4) + p5*theta(5) + p6*theta(6) )
      tstrain_rr = alpha_r * (p1*theta(1) + p2*theta(2) + p3*theta(3)
     +                      + p4*theta(4) + p5*theta(5) + p6*theta(6) )
      tstrain_tt = alpha_t * (p1*theta(1) + p2*theta(2) + p3*theta(3)
     +                      + p4*theta(4) + p5*theta(5) + p6*theta(6) )
c
C     3) --- Contraintes
c
c  [  Sig_zz  ]    [ elas(1)  elas(2)  elas(4)   elas(7) ] [  Strain_zz  ]
c  [          ]    [                                     ] [             ]
c  [  Sig_rr  ]    [ elas(2)  elas(3)  elas(5)   elas(8) ] [  Strain_rr  ]
c  [          ] := [                                     ] [             ]
c  [  Sig_tt  ]    [ elas(4)  elas(5)  elas(6)   elas(9) ] [  Strain_tt  ]
c  [          ]    [                                     ] [             ]
c  [  Sig_rz  ]    [ elas(7)  elas(8)  elas(9)  elas(10) ] [ 2*Strain_rz ]
c
c    Rangement SIGMA(4): S_rr, S_rz, S_zz, S_tt
c
      sigma(3) = elas(1)*(estrain_zz - tstrain_zz)
     +         + elas(2)*(estrain_rr - tstrain_rr)
     +         + elas(4)*(estrain_tt - tstrain_tt)
     +         + 2*elas(7)*estrain_rz
      sigma(1) = elas(2)*(estrain_zz - tstrain_zz)
     +         + elas(3)*(estrain_rr - tstrain_rr)
     +         + elas(5)*(estrain_tt - tstrain_tt)
     +         + 2*elas(8)*estrain_rz
      sigma(4) = elas(4)*(estrain_zz - tstrain_zz)
     +         + elas(5)*(estrain_rr - tstrain_rr)
     +         + elas(6)*(estrain_tt - tstrain_tt)
     +         + 2*elas(9)*estrain_rz
      sigma(2) = elas(7)*(estrain_zz - tstrain_zz)
     +         + elas(8)*(estrain_rr - tstrain_rr)
     +         + elas(9)*(estrain_tt - tstrain_tt)
     +         + 2*elas(10)*estrain_rz
c
      return
      END
