      SUBROUTINE etcaq1d(coor,car,iopt,u,alpha,theta,sigma)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT TRIA AP1D
C ---  
c in : coor(noe,ndim) : coordonnees R(3), Z(3) des 3 sommets.
c
c      car        : caracteristiques des materiaux
c           if(iopt .eq. 1) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c      U(ndim,noe): deplacements U_r et U_z aux 3 noeuds (sommets)
C      alpha(3) : coef. dilatation thermique: radial, axial, tangentiel
C      theta(4)    : theta aux 4 sommets
C out: 
C      SIGMA(4) :  S_rr, S_rz, S_zz, S_tt elastiques
C .....................................................................
      implicit none
      integer NBPOLY,NPI,NPS, IP(8), iopt, ndim, i
      PARAMETER (ndim=2 , nbpoly=4 , npi=4, nps=4)
      DOUBLE PRECISION POIDS(NPI),Q13(NBPOLY,NPI),DQ13(2,NBPOLY,NPI),
     +                 POIDEL(npi),F1(5),F2(5),DFM1(4,4),
     +                 DFM1DP(2,4,4),XYNPI(2,NPI),alpha(3),theta(4),
     +                 COOR(4,2),car(10),elas(10),U(ndim,4),r,SIGMA(4),
     +                 estrain_zz,estrain_rr, estrain_tt, estrain_rz,
     +                 tstrain_zz,tstrain_rr, tstrain_tt,alpha_z,
     +                 alpha_r,alpha_t,q1,q2,q3,q4,dq1dr,dq2dr,dq3dr,
     +                 dq4dr,dq1dz,dq2dz,dq3dz,dq4dz
C 2Q13 -- POIDS: poids du schema d'integration numerique.
      DATA POIDS/ 
     +            .25000000000000000D+00,   .25000000000000000D+00,
     +            .25000000000000000D+00,   .25000000000000000D+00 /
C     -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI/
     +            .21132486540518707D+00,   .21132486540518707D+00,
     +            .78867513459481286D+00,   .21132486540518707D+00,
     +            .78867513459481286D+00,   .78867513459481286D+00,
     +            .21132486540518707D+00,   .78867513459481286D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA Q13 /
     +           .62200846792814612D+00,   .16666666666666662D+00,
     +           .44658198738520435D-01,   .16666666666666662D+00,
     +           .16666666666666662D+00,   .62200846792814623D+00,
     +           .16666666666666662D+00,   .44658198738520449D-01,
     +           .44658198738520504D-01,   .16666666666666662D+00,
     +           .62200846792814623D+00,   .16666666666666662D+00,
     +           .16666666666666668D+00,   .44658198738520449D-01,
     +           .16666666666666662D+00,   .62200846792814623D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DQ13/
     +           -.78867513459481286D+00,  -.78867513459481286D+00,
     +            .78867513459481286D+00,  -.21132486540518707D+00,
     +            .21132486540518707D+00,   .21132486540518707D+00,
     +           -.21132486540518707D+00,   .78867513459481286D+00,
     +           -.78867513459481286D+00,  -.21132486540518713D+00,
     +            .78867513459481286D+00,  -.78867513459481286D+00,
     +            .21132486540518707D+00,   .78867513459481286D+00,
     +           -.21132486540518707D+00,   .21132486540518713D+00,
     +           -.21132486540518713D+00,  -.21132486540518713D+00,
     +            .21132486540518713D+00,  -.78867513459481286D+00,
     +            .78867513459481286D+00,   .78867513459481286D+00,
     +           -.78867513459481286D+00,   .21132486540518713D+00,
     +           -.21132486540518713D+00,  -.78867513459481286D+00,
     +            .21132486540518713D+00,  -.21132486540518707D+00,
     +            .78867513459481286D+00,   .21132486540518707D+00,
     +           -.78867513459481286D+00,   .78867513459481286D+00 /
C
C     CALCUL DE F1,F2,DFM1,DFM1DP
C     -----------------------
      CALL E1AQ1C(NBPOLY,NPI,POIDS,Q13,DQ13,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,COOR)
C
      call hookax(iopt,car,ELAS)
c
C     1) --- STRAIN Elastiques                                         [ U_r(1) ]
c                                                                      [ U_r(2) ]
c  [ Estrain_zz ]    [  0     0     0     0   dq1dz dq2dz dq3dz dq4dz] [        ]
c  [            ]    [                                               ] [ U_r(3) ]
c  [ Estrain_rr ]    [dq1dr dq2dr dq3dr dq4dr   0      0      0   0  ] [        ]
c  [            ]    [                                               ] [ U_r(4) ]
c  [ Estrain_tt ] := [  p1    p2    p3    p4                         ] [        ]
c  [            ]    [ ----  ----  ----  ----   0      0      0   0  ] [ U_z(1) ]
c  [2*Estrain_rz]    [   r     r     r     r                         ] [        ]
c                    [                                               ] [ U_z(2) ]
c                    [dq1dz dq2dz dq3dz dq4dz dq1dr dq2dr dq3dr dq4dr] [        ]
c                                                                      [ U_z(3) ]
c                                                                      [ U_z(4) ]
      sigma(1) = 0.d0
      sigma(2) = 0.d0
      sigma(3) = 0.d0
      sigma(4) = 0.d0
      do 1 i = 1 , npi
        q1 = Q13(1,i)
        q2 = Q13(2,i)
        q3 = Q13(3,i)
        q4 = Q13(4,i)
        dq1dr = DFM1DP(1,1,i)
        dq2dr = DFM1DP(1,2,i)
        dq3dr = DFM1DP(1,3,i)
        dq4dr = DFM1DP(1,4,i)
        dq1dz = DFM1DP(2,1,i)
        dq2dz = DFM1DP(2,2,i)
        dq3dz = DFM1DP(2,3,i)
        dq4dz = DFM1DP(2,4,i)
        r = F1(i)
        estrain_zz = dq1dz*U(2,1) + dq2dz*U(2,2) + dq3dz*U(2,3)
     +            + dq4dz*U(2,4)
        estrain_rr = dq1dr*U(1,1) + dq2dr*U(1,2) + dq3dr*U(1,3)
     +            + dq4dr*U(1,4)
        estrain_tt = (q1*U(1,1) + q2*U(1,2) + q3*U(1,3) + q4*U(1,4))/r
        estrain_rz = .5*( dq1dz*U(1,1) + dq2dz*U(1,2) + dq3dz*U(1,3)
     +                  + dq4dz*U(1,4) + dq1dr*U(2,1) + dq2dr*U(2,2)
     +                  + dq3dr*U(2,3) + dq4dr*U(2,4) )

C     2) --- Thermal STRAIN
C
c  [ Tstrain_zz ]    [ alpha[z] ]                    [ theta[1] ]
c  [            ]    [          ]                    [          ]
c  [ Tstrain_rr ]    [ alpha[r] ]                    [ theta[2] ]
c  [            ] := [          ] [ q1  q2  q3  q4 ] [          ]
c  [ Tstrain_tt ]    [ alpha[t] ]                    [ theta[3] ]
c  [            ]    [          ]                    [          ]
C  [2*Tstrain_rz]    [   0      ]                    [ theta[4] ]
C
C
        alpha_r = alpha(1)
        alpha_z = alpha(2)
        alpha_t = alpha(3)
        tstrain_zz = alpha_z *
     +     ( q1*theta(1) + q2*theta(2) + q3*theta(3) + q4*theta(4) )
        tstrain_rr = alpha_r *
     +     ( q1*theta(1) + q2*theta(2) + q3*theta(3) + q4*theta(4) )
        tstrain_tt = alpha_t *
     +     ( q1*theta(1) + q2*theta(2) + q3*theta(3) + q4*theta(4) )
C
C     3) --- STRESS
C                                            [                        ]
c                                            [ Estrain_zz - Tstrain_zz]
c [ sigma_zz ]  [ elas1 elas2 elas4  elas7 ] [                        ]
c [          ]  [                          ] [                        ]
c [ sigma_rr ]  [ elas2 elas3 elas5  elas8 ] [ Estrain_rr - Tstrain_rr]
c [          ]= [                          ] [                        ]
c [ sigma_tt ]  [ elas4 elas5 elas6  elas9 ] [                        ]
c [          ]  [                          ] [ Estrain_tt - Tstrain_tt]
c [ sigma_rz ]  [ elas7 elas8 elas9 elas10 ] [                        ]
c                                            [                        ]
c                                            [2Estrain_rz             ]
c    Rangement SIGMA(4): S_rr, S_rz, S_zz, S_tt

        sigma(3) = sigma(3) + elas(1)*(estrain_zz - tstrain_zz)
     +           +            elas(2)*(estrain_rr - tstrain_rr)
     +           +            elas(4)*(estrain_tt - tstrain_tt)
     +           + 2*elas(7)*estrain_rz
        sigma(1) = sigma(1) + elas(2)*(estrain_zz - tstrain_zz)
     +           +            elas(3)*(estrain_rr - tstrain_rr)
     +           +            elas(5)*(estrain_tt - tstrain_tt)
     +           + 2*elas(8)*estrain_rz
        sigma(4) = sigma(4) + elas(4)*(estrain_zz - tstrain_zz)
     +           +            elas(5)*(estrain_rr - tstrain_rr)
     +           +            elas(6)*(estrain_tt - tstrain_tt)
     +           + 2*elas(9)*estrain_rz
        sigma(2) = sigma(2) + elas(7)*(estrain_zz - tstrain_zz)
     +           +            elas(8)*(estrain_rr - tstrain_rr)
     +           +            elas(9)*(estrain_tt - tstrain_tt)
     +           + 2*elas(10)*estrain_rz
c
 1    continue

      sigma(1) = sigma(1) / 4
      sigma(2) = sigma(2) / 4
      sigma(3) = sigma(3) / 4
      sigma(4) = sigma(4) / 4
c
      END
