      subroutine etcaq2c(coor,car,iopt,u,alpha,theta,sigma)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DES CONTRAINTES DE L ELEMENT TRIA AP1D
C ---  
c in : coor(noe,ndim) : coordonnees R(8), Z(8) des 8 noeuds

c      car        : caracteristiques des materiaux
c           if(iopt .eq. 1) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c      U(ndim,noe): deplacements U_r et U_z aux 8 noeuds
C      alpha(3) : coef. dilatation thermique: radial, axial, tangentiel
C      theta(8) : theta aux 8 noeuds
C out: 
C      SIGMA(4) :  S_rr, S_rz, S_zz, S_tt elastiques
C .....................................................................
      implicit none
      integer ndim,NBPOLY,NPI,nbarete,nnof,IP(12),iopt,i
      PARAMETER (ndim=2, NBPOLY=8, NPI=9, nbarete=3, nnof=3)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +              DFM1(4,npi),DFM1DP(2,nbpoly,npi),alpha(3),theta(8),
     +                 COOR(8,2),car(10),elas(10),U(ndim,8),r,SIGMA(4),
     +                 estrain_zz,estrain_rr, estrain_tt, estrain_rz,
     +                 tstrain_zz,tstrain_rr, tstrain_tt,alpha_z,
     +                 alpha_r,alpha_t,q1,q2,q3,q4,q5,q6,q7,q8,dq1dr,
     +                 dq2dr,dq3dr,dq4dr,dq5dr,dq6dr,dq7dr,dq8dr,
     +                 dq1dz,dq2dz,dq3dz,dq4dz,dq5dz,dq6dz,dq7dz,dq8dz
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
C
c     -- CALCUL DE F1,F2,FFM1,DFM1DP
c
      CALL E2AQ2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
C
      call hookax(iopt,car,elas)
c
C
C     Contriantes [SIG] = [Elas] * [STRAIN_elas - STRAIN_ther] + SIG_0
C
c
C     1) --- STRAIN Elastiques
c                                                             [U_r(1)]
c [Strain_zz]   [  0     0   ...   0   dq1dz dq2dz ... dq8dz] [  .   ]
c [         ]   [                                           ] [  .   ]
c [Strain_rr]   [dq1dr dq2dr ... dq8dr   0      0  ...   0  ] [  .   ]
c [         ]   [                                           ] [U_r(8)]
c [Strain_tt] = [ p1    p2        p8                        ] [      ]
c [         ]   [---   ---  ...  ---     0      0  ...   0  ] [U_z(1)]
c [2*Stra_rz]   [ r     r         r                         ] [  .   ]
c               [                                           ] [  .   ]
c               [ dq1dz .......  dq8dz dq1dr ........  dq8dr] [  .   ]
c                                                             [U_z(8)]
c
c  barycentre F1(5) etr F2(5)
      i  = 5
      r  = f1(i)
      q1 = P25(1,i)
      q2 = P25(2,i)
      q3 = P25(3,i)
      q4 = P25(4,i)
      q5 = P25(5,i)
      q6 = P25(6,i)
      q7 = P25(7,i)
      q8 = P25(8,i)
      dq1dr = DFM1DP(1,1,i)
      dq2dr = DFM1DP(1,2,i)
      dq3dr = DFM1DP(1,3,i)
      dq4dr = DFM1DP(1,4,i)
      dq5dr = DFM1DP(1,5,i)
      dq6dr = DFM1DP(1,6,i)
      dq7dr = DFM1DP(1,7,i)
      dq8dr = DFM1DP(1,8,i)
      dq1dz = DFM1DP(2,1,i)
      dq2dz = DFM1DP(2,2,i)
      dq3dz = DFM1DP(2,3,i)
      dq4dz = DFM1DP(2,4,i)
      dq5dz = DFM1DP(2,5,i)
      dq6dz = DFM1DP(2,6,i)
      dq7dz = DFM1DP(2,7,i)
      dq8dz = DFM1DP(2,8,i)
      estrain_zz = dq1dz*U(2,1) + dq2dz*U(2,2) + dq3dz*U(2,3)
     +           + dq4dz*U(2,4) + dq5dz*U(2,5) + dq6dz*U(2,6)
     +           + dq7dz*U(2,7) + dq8dz*U(2,8)
      estrain_rr = dq1dr*U(1,1) + dq2dr*U(1,2) + dq3dr*U(1,3)
     +           + dq4dr*U(1,4) + dq5dr*U(1,5) + dq6dr*U(1,6)
     +           + dq7dr*U(1,7) + dq8dr*U(1,8)
      estrain_tt = (q1*U(1,1) + q2*U(1,2) + q3*U(1,3) + q4*U(1,4)
     +           +  q5*U(1,5) + q6*U(1,6) + q7*U(1,7) + q8*U(1,8)) / r
      estrain_rz = .5*( dq1dz*U(1,1) + dq1dr*U(2,1) + dq2dz*U(1,2)
     +                + dq2dr*U(2,2) + dq3dz*U(1,3) + dq3dr*U(2,3)
     +                + dq4dz*U(1,4) + dq4dr*U(2,4) + dq5dz*U(1,5)
     +                + dq5dr*U(2,5) + dq6dz*U(1,6) + dq6dr*U(2,6)
     +                + dq7dz*U(1,7) + dq7dr*U(2,7) + dq8dz*U(1,8)
     +                + dq8dr*U(2,8) )
C
C     2) --- STRAIN THermiques =  (ALPHA) * (P) * THETA
c         
c [ Strain_zz ] [alpha_z]                            [theta(1)]
c [           ] [       ]                            [theta(2)]
c [ Strain_rr ] [alpha_r]                            [theta(3)]
c [           ]=[       ]*[q1 q2 q3  q4 q5 q6 q7 q8]*[theta(4)]
c [ Strain_tt ] [alpha_t]                            [theta(5)]
c [           ] [       ]                            [theta(6)] 
c [2*Strain_rz] [  0    ]                            [theta(7)] 
c                                                    [theta(8)] 
      alpha_r = alpha(1)
      alpha_z = alpha(2)
      alpha_t = alpha(3)
      q1 = P25(1,i)
      q2 = P25(2,i)
      q3 = P25(3,i)
      q4 = P25(4,i)
      q5 = P25(5,i)
      q6 = P25(6,i)
      q7 = P25(7,i)
      q8 = P25(8,i)
      tstrain_zz = alpha_z*( q1*theta(1) + q2*theta(2) + q3*theta(3)
     +                     + q4*theta(4) + q5*theta(5) + q6*theta(6)
     +                     + q7*theta(7) + q8*theta(8) )
      tstrain_rr = alpha_r*( q1*theta(1) + q2*theta(2) + q3*theta(3)
     +                     + q4*theta(4) + q5*theta(5) + q6*theta(6)
     +                     + q7*theta(7) + q8*theta(8) )
      tstrain_tt = alpha_t*( q1*theta(1) + q2*theta(2) + q3*theta(3)
     +                     + q4*theta(4) + q5*theta(5) + q6*theta(6)
     +                     + q7*theta(7) + q8*theta(8) )
c
C     3) --- Contraintes
c
c  [  Sig_zz  ]    [ elas(1)  elas(2)  elas(4)   elas(7) ] [  Strain_zz  ]
c  [          ]    [                                     ] [             ]
c  [  Sig_rr  ]    [ elas(2)  elas(3)  elas(5)   elas(8) ] [  Strain_rr  ]
c  [          ] := [                                     ] [             ]
c  [  Sig_tt  ]    [ elas(4)  elas(5)  elas(6)   elas(9) ] [  Strain_tt  ]
c  [          ]    [                                     ] [             ]
c  [  Sig_rz  ]    [ elas(7)  elas(8)  elas(9)  elas(10) ] [ 2*Strain_rz ]
c
c    Rangement SIGMA(4): S_rr, S_rz, S_zz, S_tt
c
      sigma(3) = elas(1)*(estrain_zz - tstrain_zz)
     +         + elas(2)*(estrain_rr - tstrain_rr)
     +         + elas(4)*(estrain_tt - tstrain_tt)
     +         + 2*elas(7)*estrain_rz
      sigma(1) = elas(2)*(estrain_zz - tstrain_zz)
     +         + elas(3)*(estrain_rr - tstrain_rr)
     +         + elas(5)*(estrain_tt - tstrain_tt)
     +         + 2*elas(8)*estrain_rz
      sigma(4) = elas(4)*(estrain_zz - tstrain_zz)
     +         + elas(5)*(estrain_rr - tstrain_rr)
     +         + elas(6)*(estrain_tt - tstrain_tt)
     +         + 2*elas(9)*estrain_rz
      sigma(2) = elas(7)*(estrain_zz - tstrain_zz)
     +         + elas(8)*(estrain_rr - tstrain_rr)
     +         + elas(9)*(estrain_tt - tstrain_tt)
     +         + 2*elas(10)*estrain_rz
      return
      END
