      subroutine etcdktp(coor,car,iopt,u,sigma)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DE LA MATRICE ELEMENTAIRE ELASTIQUE DES CONTRAINTES
C      AU BARYCENTRE DE L ELEMENT DE PLAQUE TRIA_DKTP .
c in : coor(noe,ndim) : coordonees des 3 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = masse volumique
c                       car(2) = epaisseur de la plaque
c      iopt           : ouvert 
c      U(3,noe)       : U_z, Rotx, Roty
C out: SIGMA(3)      : contraintes elastiques
c
c  programmeur : modulef
c ...............................................................
      implicit none
      integer j, k, iopt
      DOUBLE PRECISION X23,X31,X12,Y23,Y31,Y12,DELTA,D(6),U(3,3),
     +                 coor(3,2),car(3),YOUNG,POISON,EPAIS,COEFF,
     +                 DXHX(9),DYHX(9),DXHY(9),DYHY(9),B(3,9),AL4,
     +                 AL5,AL6,P4,P5,P6,T4,T5,T6,Q4,Q5,Q6,R4,R5,R6,
     +                 DSIGMA(27),XKSI,YNETA,Y31SDE,X31SDE,Y12SDE,
     +                 X12SDE,sigma(3)
C
      young  = car(1)
      poison = car(2)
      epais  = car(3)
c
      X23    = coor(2,1) - coor(3,1)
      Y23    = coor(2,2) - coor(3,2)
      X31    = coor(3,1) - coor(1,1)
      Y31    = coor(3,2) - coor(1,2)
      X12    = coor(1,1) - coor(2,1)
      Y12    = coor(1,2) - coor(2,2)
      DELTA  = X31 * Y12 - X12 * Y31
C
C  MATRICE [ D ] (SYMETRIQUE STOKEE SOUS FORME TRIANGULAIRE => D(6))
C             3*3
      COEFF  = YOUNG*EPAIS**3/(12.D0*(1.D0-POISON**2))
      D(1) = COEFF
      D(2) = COEFF * POISON
      D(3) = COEFF
      D(4) = 0.D0
      D(5) = 0.D0
      D(6) = COEFF * ( 1.D0 - POISON ) / 2.D0
C
C  CALCUL DES LK ,PK ,TK ,QK ,RK
C                 (CF. J.L. BATOZ)
      AL4    = X23**2 + Y23**2
      AL5    = X31**2 + Y31**2
      AL6    = X12**2 + Y12**2
      P4     = - 6.D0 * X23 / AL4
      P5     = - 6.D0 * X31 / AL5
      P6     = - 6.D0 * X12 / AL6
      T4     = - 6.D0 * Y23 / AL4
      T5     = - 6.D0 * Y31 / AL5
      T6     = - 6.D0 * Y12 / AL6
      Q4     = 3.D0 * X23 * Y23 / AL4
      Q5     = 3.D0 * X31 * Y31 / AL5
      Q6     = 3.D0 * X12 * Y12 / AL6
      R4     = 3.D0 * Y23 * Y23 / AL4
      R5     = 3.D0 * Y31 * Y31 / AL5
      R6     = 3.D0 * Y12 * Y12 / AL6
C
C  CALCUL DES MATRICES [DX_HX] , [DY_HX] , [DX_HY] , [DY_HY]
C                           1*9       1*9       1*9       1*9
C
      XKSI  = 1.D0 / 3.D0
      YNETA = XKSI
      DXHX(1) = P6 * ( 1.D0 - 2.D0 * XKSI ) + ( P5 - P6 ) * YNETA
      DXHX(2) = Q6 * ( 1.D0 - 2.D0 * XKSI ) - ( Q5 + Q6 ) * YNETA
      DXHX(3) = -4.D0 + 6.D0 * ( XKSI + YNETA ) +
     +          R6 * ( 1.D0 - 2.D0 * XKSI ) - YNETA * ( R5 + R6 )
      DXHX(4) = - P6 * ( 1.D0 - 2.D0 * XKSI ) + ( P4 + P6 )*YNETA
      DXHX(5) = Q6 * ( 1.D0 - 2.D0 * XKSI ) - ( Q6 - Q4 ) * YNETA
      DXHX(6) = -2.D0 + 6.D0 * XKSI + R6 * ( 1.D0 - 2.D0 * XKSI )
     +        + ( R4 - R6 ) * YNETA
      DXHX(7) = - ( P5 + P4 ) * YNETA
      DXHX(8) =   ( Q4 - Q5 ) * YNETA
      DXHX(9) = - ( R5 - R4 ) * YNETA
C
      DYHX(1) = - P5 * ( 1.D0 - 2.D0 * YNETA ) - ( P6 - P5 )*XKSI
      DYHX(2) = Q5 * ( 1.D0 - 2.D0 * YNETA ) - ( Q5 + Q6 ) * XKSI
      DYHX(3) = - 4.D0 + 6.D0 * ( XKSI + YNETA ) +
     +          R5 * ( 1.D0 - 2.D0 * YNETA ) - XKSI * ( R5 + R6 )
      DYHX(4) =   ( P4 + P6 ) * XKSI
      DYHX(5) =   ( Q4 - Q6 ) * XKSI
      DYHX(6) = - ( R6 - R4 ) * XKSI
      DYHX(7) = P5 * ( 1.D0 - 2.D0 * YNETA ) - ( P4 + P5 ) * XKSI
      DYHX(8) = Q5 * ( 1.D0 - 2.D0 * YNETA ) + ( Q4 - Q5 ) * XKSI
      DYHX(9) = -2.D0 + 6.D0 * YNETA + ( R4 - R5 ) * XKSI
     +        + R5 * ( 1.D0 - 2.D0 * YNETA )
C
      DXHY(1) = T6 * ( 1.D0 - 2.D0 * XKSI ) + ( T5 - T6 ) * YNETA
      DXHY(2) = 1.D0 + R6 * ( 1.D0 - 2.D0 * XKSI )
     +        - ( R5 + R6 ) * YNETA
      DXHY(3) = - Q6 * ( 1.D0 - 2.D0 * XKSI ) + YNETA*( Q5 + Q6 )
      DXHY(4) = - T6 * ( 1.D0 - 2.D0 * XKSI ) + ( T4 + T6 )*YNETA
      DXHY(5) = - 1.D0 + R6 * ( 1.D0 - 2.D0 * XKSI )
     +        + ( R4 - R6 ) * YNETA
      DXHY(6) = - Q6 * ( 1.D0 - 2.D0 * XKSI ) - ( Q4 - Q6 )*YNETA
      DXHY(7) = - ( T4 + T5 ) * YNETA
      DXHY(8) =   ( R4 - R5 ) * YNETA
      DXHY(9) = - ( Q4 - Q5 ) * YNETA
C
      DYHY(1) = - T5 * ( 1.D0 - 2.D0 * YNETA ) - ( T6 - T5 )*XKSI
      DYHY(2) = 1.D0 + R5 * ( 1.D0 - 2.D0 * YNETA )
     +        - ( R5 + R6 ) * XKSI
      DYHY(3) = - Q5 * ( 1.D0 - 2.D0 * YNETA ) + XKSI*( Q5 + Q6 )
      DYHY(4) =   ( T4 + T6 ) * XKSI
      DYHY(5) =   ( R4 - R6 ) * XKSI
      DYHY(6) = - ( Q4 - Q6 ) * XKSI
      DYHY(7) = T5 * ( 1.D0 - 2.D0 * YNETA ) - ( T4 + T5 )*XKSI
      DYHY(8) = - 1.D0 + R5 * ( 1.D0 - 2.D0 * YNETA )
     +        + ( R4 - R5 ) * XKSI
      DYHY(9) = - Q5 * ( 1.D0 - 2.D0 * YNETA ) - ( Q4 - Q5 )*XKSI
C
C  CALCUL DE LA MATRICE [ B ] (CF. J.L. BATOZ)
C                          3*9
      Y31SDE  =  Y31 / DELTA
      X31SDE  =  X31 / DELTA
      Y12SDE  =  Y12 / DELTA
      X12SDE  =  X12 / DELTA
      DO 1  J = 1 , 9
        B(1,J)  =   Y31SDE * DXHX(J) + Y12SDE * DYHX(J)
        B(2,J)  = - X31SDE * DXHY(J) - X12SDE * DYHY(J)
        B(3,J)  = - X31SDE * DXHX(J) - X12SDE * DYHX(J)
     +          + Y31SDE * DXHY(J) + Y12SDE * DYHY(J)
 1    CONTINUE
C
C  CALCUL DE DSIGMA ( PASSAGE AU RANGEMENT PAR D.L. )
C
      K      = 1
      DO 2 J = 1 , 9
        DSIGMA( K     ) = D(1) * B(1,J) + D(2) * B(2,J)
        DSIGMA( K + 1 ) = D(2) * B(1,J) + D(3) * B(2,J)
        DSIGMA( K + 2 ) = - D(6) * B(3,J)
        K               = K + 3
 2    continue
C
C     [      11]   [1 4 7 10 13 16 19 22 25]   [          ]
C     [SIGMA 22] = [2 5 8 11 14 17 20 23 26] * [u_solution]
C     [      12]   [3 6 9 12 15 18 21 24 27]   [          ]
C             3*1                3*9                     9*1
C
      sigma(1) = DSIGMA( 1)*U(1,1)+DSIGMA( 4)*U(2,1)+DSIGMA( 7)*U(3,1)
     +         + DSIGMA(10)*U(1,2)+DSIGMA(13)*U(2,2)+DSIGMA(16)*U(3,2)
     +         + DSIGMA(19)*U(1,3)+DSIGMA(22)*U(2,3)+DSIGMA(25)*U(3,3)

      sigma(2) = DSIGMA( 2)*U(1,1)+DSIGMA( 5)*U(2,1)+DSIGMA( 8)*U(3,1)
     +         + DSIGMA(11)*U(1,2)+DSIGMA(14)*U(2,2)+DSIGMA(17)*U(3,2)
     +         + DSIGMA(20)*U(1,3)+DSIGMA(23)*U(2,3)+DSIGMA(26)*U(3,3)

      sigma(3) = DSIGMA( 3)*U(1,1)+DSIGMA( 6)*U(2,1)+DSIGMA( 9)*U(3,1)
     +         + DSIGMA(12)*U(1,2)+DSIGMA(15)*U(2,2)+DSIGMA(18)*U(3,2)
     +         + DSIGMA(21)*U(1,3)+DSIGMA(24)*U(2,3)+DSIGMA(27)*U(3,3)
c
      END
