      subroutine etm2p1d(coor,car,iopt,ae)
c ***************************************************************
c but : calcul de la matrice de masse de l element tria 2p1d
c --- 
c in : coor(noe,ndim) : coordones des 3 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae            : matrice triangulaire sup
c
c  programmeur : modulef
c .................................................................
      implicit none
      integer i, iopt
      double precision coor(3,2),ae(21),car(1),rho,x21,y21,x31,y31,
     +                 x32,y32,delta,beta,beta2
c
      rho  = car(1)
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      DELTA = X21*Y31 - X31*Y21
      beta   = rho * delta / 24.d+00
      beta2  = beta * 2.d+00
c
c    -----   calcul de ae(ck)  -----
c
      do 1 i = 1,21
         ae(i) = 0.d+00
 1    continue
      ae(1)  = beta2
      ae(4)  = beta
      ae(6)  = beta2
      ae(11) = beta
      ae(13) = beta
      ae(15) = beta2
      ae(3)  = beta2
      ae(8)  = beta
      ae(10) = beta2
      ae(17) = beta
      ae(19) = beta
      ae(21) = beta2
c
      end
