         SUBROUTINE etm2p2c(coor,car,iopt,AE)
C ***************************************************************
C BUT : MATRICE DE MASSE DE L ELEMENT Membrane: TRIA AP2C
C --- 
c in : coor(noe,ndim) : coor. 3 sommets + 3 milieux aretes
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae(78)         : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer IJT(12),j,idec,jdec,ibloc,ifin,i,i1,j1,kk,ii,iint,iopt
      DOUBLE PRECISION coor(6,2),car(10),rho,AE(78),X21,Y21,X31,Y31,X32,
     +                 Y32,X41,Y41,X42,Y42,X54,Y54,X61,Y61,X63,Y63,X65,
     +                 Y65,DELTA(6),C1(42),C2(42),C3(42),C(6,21)
      EQUIVALENCE (C1(1),C(1,1)),(C2(1),C(1,8)),(C3(1),C(1,15))
      DATA IJT/ 1, 3, 5, 7, 9, 11, 2, 4, 6, 8, 10, 12/
      DATA C1/
     +     0.71428571428571428D-02 ,  -0.79365079365079365D-03 ,
     +    -0.79365079365079365D-03 ,   0.47619047619047619D-02 ,
     +     0.15873015873015873D-02 ,   0.47619047619047619D-02 ,
     +    -0.79365079365079365D-03 ,  -0.79365079365079365D-03 ,
     +     0.39682539682539682D-03 ,  -0.15873015873015873D-02 ,2*0.D0,
     +    -0.79365079365079365D-03 ,   0.71428571428571428D-02 ,
     +    -0.79365079365079365D-03 ,   0.47619047619047619D-02 ,
     +     0.47619047619047619D-02 ,   0.15873015873015873D-02 ,
     +    -0.79365079365079365D-03 ,   0.39682539682539682D-03 ,
     +    -0.79365079365079365D-03 ,2*0.D0,   -0.15873015873015873D-02 ,
     +     0.39682539682539682D-03 ,  -0.79365079365079365D-03 ,
     +    -0.79365079365079365D-03 , 0.D0,-0.15873015873015873D-02,0.D0,
     +    -0.79365079365079365D-03 ,  -0.79365079365079365D-03 ,
     +     0.71428571428571428D-02 ,   0.15873015873015873D-02 ,
     +     3*0.47619047619047619D-02 ,  -0.15873015873015873D-02 ,
     +      2*0.D0,-0.31746031746031746D-02, 0.D0 /
      DATA C2/
     +    -0.15873015873015873D-02 ,   0.47619047619047619D-02 ,
     +     3*0.D0      ,  -0.31746031746031772D-02 , 2*0.D0 ,
     +     0.15873015873015873D-02 ,  -0.63492063492063492D-02 ,
     +    -0.31746031746031746D-02 ,  -0.31746031746031746D-02 ,
     +     2*0.D0,-0.63492063492063492D-02 ,   0.57142857142857142D-01 ,
     +     0.19047619047619047D-01 ,   0.19047619047619047D-01 ,
     +     0.15873015873015873D-02 , 2*0.D0 ,-0.31746031746031746D-02 ,
     +    -0.63492063492063492D-02 ,  -0.31746031746031746D-02 ,
     +     0.D0,  0.47619047619047619D-02 , -0.15873015873015873D-02 ,
     +  2*0.D0 ,-0.31746031746031746D-02,0.D0,-0.15873015873015873D-02,
     +     0.47619047619047619D-02 ,  -0.31746031746031746D-02 ,
     +     2*0.D0  , -0.31746031746031772D-02 ,   0.D0  ,
     +    -0.31746031746031746D-02 ,   0.19047619047619047D-01 ,
     +     0.19047619047619047D-01 ,   0.12698412698412698D-01 /
      DATA C3/
     +    -0.63492063492063492D-02 ,  2*0.D0, 0.19047619047619047D-01 ,
     +     0.57142857142857142D-01 ,   0.19047619047619047D-01 ,
     +     0.476190476190476190D-02 ,   0.D0 ,-0.15873015873015873D-02 ,
     +     0.D0, -0.31746031746031798D-02 , 2*0.D0, 0.15873015873D-02,
     +     0.D0, 2*-0.31746031746031746D-02 , -0.63492063492063492D-02,
     +    -0.15873015873015873D-02 ,   0.D0 ,
     +     0.47619047619047619D-02 ,  -0.31746031746031746D-02 ,
     +   3*0.D0, 2*-0.31746031746031746D-02 ,  0.19047619047619047D-01,
     +     0.12698412698412698D-01 ,   0.19047619047619047D-01 ,
     +    -0.31746031746031746D-02 ,  -0.31746031746031746D-02 ,
     +     0.D0                    ,   0.12698412698412698D-01 ,
     +     0.19047619047619047D-01 ,   0.19047619047619047D-01 ,
     +     0.D0 ,-0.63492063492063492D-02, 0.D0,0.19047619047619047D-01,
     +     0.19047619047619047D-01 ,   0.57142857142857142D-01  /
C
      X21 = COOR(2,1) - COOR(1,1)
      Y21 = COOR(2,2) - COOR(1,2)
      X31 = COOR(3,1) - COOR(1,1)
      Y31 = COOR(3,2) - COOR(1,2)
      X32 = COOR(3,1) - COOR(2,1)
      Y32 = COOR(3,2) - COOR(2,2)
      X41 = COOR(4,1) - COOR(1,1)
      Y41 = COOR(4,2) - COOR(1,2)
      X42 = COOR(4,1) - COOR(2,1)
      Y42 = COOR(4,2) - COOR(2,2)
      X54 = COOR(5,1) - COOR(4,1)
      Y54 = COOR(5,2) - COOR(4,2)
      X61 = COOR(6,1) - COOR(1,1)
      Y61 = COOR(6,2) - COOR(1,2)
      X63 = COOR(6,1) - COOR(3,1)
      Y63 = COOR(6,2) - COOR(3,2)
      X65 = COOR(6,1) - COOR(5,1)
      Y65 = COOR(6,2) - COOR(5,2)
C
C    -----   CALCUL DE DELTA AUX 6 NOEUDS  -----
C
      DELTA(1) = ( 3.D0 * X41 + X42 ) * ( 3.D0 * Y61 + Y63 )
     +         - ( 3.D0 * X61 + X63 ) * ( 3.D0 * Y41 + Y42 )
      DELTA(2) = ( 3.D0 * X42 + X41 ) * (-4.D0 * Y54 + Y31 )
     +         + ( 4.D0 * X54 - X31 ) * ( 3.D0 * Y42 + Y41 )
      DELTA(3) = ( 4.D0 * X65 + X21 ) * ( 3.D0 * Y63 + Y61 )
     +         - ( 3.D0 * X63 + X61 ) * ( 4.D0 * Y65 + Y21 )
      DELTA(4) =  X21 * ( 2.D0 * Y54 + Y61 + Y63 )
     +         -  Y21 * ( 2.D0 * X54 + X61 + X63 )
      DELTA(5) = - (2.D0 * X65 + X41 + X42) * (2.D0 * Y54 - Y61 - Y63)
     +         +   (2.D0 * Y65 + Y41 + Y42) * (2.D0 * X54 - X61 - X63)
      DELTA(6) =  Y31 * (-2.D0 * X65 + X41 + X42 )
     +         +  X31 * ( 2.D0 * Y65 - Y41 - Y42 )
C
      rho = car(1)
      DO 5 J=1,6
         DELTA(J) = DELTA(J) * Rho
    5 CONTINUE
C
C    -----   CALCUL DE AE(.)  -----
C
      DO 6 J=1,78
         AE(J) = 0.D+00
    6 CONTINUE
C
      IDEC = 0
      JDEC = 0
      DO 11 IBLOC=1,2
         DO 10 J=1,6
            IFIN = J
            DO 10  I=1,IFIN
               I1 = IDEC + I
               J1 = JDEC + J
               IF( IJT(I1) .GT. IJT(J1) ) GO TO 7
               KK = IJT(J1) * ( IJT(J1) -1 ) / 2 + IJT(I1)
               GO TO 8
    7          KK = IJT(I1) * ( IJT(I1) -1 ) / 2 + IJT(J1)
    8          CONTINUE
               II = J * ( J-1 ) / 2 + I
               DO 9 IINT=1,6
                  AE(KK) = AE(KK) + C(IINT,II) * DELTA(IINT)
    9          CONTINUE
   10    CONTINUE
         IDEC = 6
         JDEC = 6
   11 CONTINUE
      END
