      subroutine etm2q1d(coor,car,iopt,ae)
c ***************************************************************
c but : calcul de la matrice de masse de l element quad 2q1d
c --- 
c in : coor(noe,ndim) : coordones des 4 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae(8)          : matrice DIAGONALE !!
c
c  programmeur : modulef
c .................................................................
      implicit none
      integer i, iopt
      double precision coor(4,2),ae(8),car(1),rho,BETA4,X21,Y21,X31,
     +                 Y31,X32,Y32,X41,Y41,X43,Y43,X42,Y42,DELT1,
     +                 DELT2,DELT3,DELT4
C
      rho  = car(1)
      x21  = coor(2,1) - coor(1,1)
      y21  = coor(2,2) - coor(1,2)
      x31  = coor(3,1) - coor(1,1)
      y31  = coor(3,2) - coor(1,2)
      x32  = coor(3,1) - coor(2,1)
      y32  = coor(3,2) - coor(2,2)
      x41  = coor(4,1) - coor(1,1)
      y41  = coor(4,2) - coor(1,2)
      x42  = coor(4,1) - coor(2,1)
      y42  = coor(4,2) - coor(2,2)
      x43  = coor(4,1) - coor(3,1)
      y43  = coor(4,2) - coor(3,2)
      delt1  = x21*y41 - x41*y21
      delt2  = x21*y32 - x32*y21
      delt3  = x32*y43 - x43*y32
      delt4  = x41*y43 - x43*y41
C
      do 1 i = 1,8
         ae(i) = 0.d+00
 1    continue
      beta4 = rho / 4.d+00
C
      ae(1) = delt1 * beta4
      ae(3) = delt2 * beta4
      ae(5) = delt3 * beta4
      ae(7) = delt4 * beta4
      ae(2) = delt1 * beta4
      ae(4) = delt2 * beta4
      ae(6) = delt3 * beta4
      ae(8) = delt4 * beta4
      end
