      subroutine etm2q2c(coor,car,iopt,AE)
C  ....................................................................
c but : matrice de masse de l element membrane:  QUAD 2Q2C
c --- 
c in : coor(noe,ndim) : coordonnees 8 noeuds
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae(136)        : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer ndim,NBPOL,NPI,j,i,iopt,k,idec,jdec,ibloc,ifin,i1,j1,
     +        IJT(16),kk
      PARAMETER (ndim=2 , NBPOL=8 , NPI=9)
      DOUBLE PRECISION P25(NBPOL,NPI),DP25(2,NBPOL,NPI),POIDS(NPI),
     +                 XYNPI(ndim,npi),
     +                 car(1),COOR(8,2),ae(136),
     +                 delta(9),F11(9),F12(9),F21(9),F22(9),rho
      integer indi
C
      DATA IJT/ 1, 3, 5, 7, 9, 11, 13, 15, 2, 4, 6, 8, 10, 12, 14, 16/
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
c
      rho = car(1)

C
C    -----   CALCUL DE DELTA AUX NPI NOEUDS  -----
C
      DO 2 K=1,NPI
         F11(K) = 0.D0
         F12(K) = 0.D0
         F21(K) = 0.D0
         F22(K) = 0.D0
    2 CONTINUE
      DO 4 K=1,NPI                             
         DO 3 I=1,NBPOL
            F11(K) = F11(K) + DP25(1,I,K) * coor(I,1)
            F12(K) = F12(K) + DP25(2,I,K) * coor(I,1)
            F21(K) = F21(K) + DP25(1,I,K) * coor(I,2)
            F22(K) = F22(K) + DP25(2,I,K) * coor(I,2)
    3   CONTINUE
        DELTA(K) = F11(K) * F22(K) - F12(K) * F21(K)
    4 CONTINUE
C
C    -----   CALCUL DE AE(.)  -----
C
      do 122 indi = 1,136
         AE(indi) = 0.d0
 122     continue

      IDEC = 0
      JDEC = 0
      DO 11 IBLOC=1,2
         DO 10 J=1,NBPOL
            IFIN = J
            DO 10  I=1,IFIN
               I1 = IDEC + I
               J1 = JDEC + J
               IF( IJT(I1) .GT. IJT(J1) ) GO TO 7
               KK = IJT(J1) * ( IJT(J1) -1 ) / 2 + IJT(I1)
               GO TO 8
    7          KK = IJT(I1) * ( IJT(I1) -1 ) / 2 + IJT(J1)
    8          CONTINUE
               DO 9 K=1,NPI
                  AE(KK) = AE(KK) + P25(I,K) * P25(J,K) * DELTA(K)
     +                            * RHO * POIDS(K)
    9          CONTINUE
   10    CONTINUE
         IDEC = NBPOL
         JDEC = NBPOL
   11 CONTINUE
      END
