      SUBROUTINE ETM3Q2C(COOR,RO,IOPT,AE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DE LA MATRICE ELEMENTAIRE ELASTIQUE DE MASSE
C  ---     Hexaedre Q2 ISOPARAMETRIQUE
c          formule d'integration a 27 points, (Gauss) (3*3*3)
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : TABLEAUX DES COORDONNEES DES POINTS DE L ELEMENT
c   ijt     : permutation pour oasser de la numerotation par inconnues
c             a celle par noeuds
c   nno     : nombre de noeuds de l'element
c   npo     : nombre de points
c   npi     : nombre de points d'integration
c   dp      : valeur des derivees des polynomes de base aux points
c             d'integration sur l'element de reference
c   vp1     : valeur des polynomes de base aux points
c             d'integration sur l'element de reference
c   poids   : poids de la formule d'integration
c
c  tableaux de travail :
c  -------------------
c   delta   : jacobien aux points d'integration
c   (x y z)int : coordonnees des points d'integration sur 
c              l'element courant
C
C  PARAMETRE DE SORTIE  :
C  --------------------
C   AE     : MATRICE DE Masse . SYMETRIQUE
C            
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEURS  : Marina Vidrascu 2001
C ...................................................................
C
      parameter (ndim=3, nno=20, npo=20, npi=27)
      DOUBLE PRECISION ae(NNO*3*(NNO*3+1)/2),COOR(NPO,3)
      DIMENSION IJT(ndim*nno)
      double precision poids(npi),delta(npi), vp1(nno,npi),
     &                  VDPQ2(ndim,nno,npi),ro

      double precision dp1(ndim,nno,4),dp2(ndim,nno,4),dp3(ndim,nno,4),
     *                 dp4(ndim,nno,4),dp5(ndim,nno,4),dp6(ndim,nno,4),
     *                 dp7(ndim,nno,3),
     *                 va1(nno,9),va2(nno,9),va3(nno,9)
      equivalence (dp1,VDPQ2(1,1,1)), (dp2,VDPQ2(1,1,5)),
     *            (dp3,VDPQ2(1,1,9)), (dp4,VDPQ2(1,1,13)),
     *            (dp5,VDPQ2(1,1,17)), (dp6,VDPQ2(1,1,21)),
     *            (dp7,VDPQ2(1,1,25)), (va1,VP1(1,1)),
     *            (va2,VP1(1,10)), (va3,VP1(1,19))
c
      DATA IJT/ 1,4,7,10,13,16,19,22,25,28,31,34,37,40,43,46,49,52,
     &55,58,2,5,8,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,
     &3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60/

      DATA dp1/-1.65205633616563,-1.65205633616563, -1.65205633616563,
     *    -.787298334620742,-.549193338482967E-01,-.549193338482967E-01,
     *    -.254919333848297  , -.254919333848297  ,.127016653792583E-01,
     *    -.549193338482967E-01,-.787298334620742,-.549193338482967E-01,
     *    -.549193338482967E-01,-.549193338482967E-01,-.787298334620742,
     *    -.254919333848297  ,.127016653792583E-01, -.254919333848297  ,
     *-.520563361656317E-01,-.520563361656317E-01,-.520563361656317E-01,
     *   .127016653792583E-01, -.254919333848297  , -.254919333848297  ,
     *     2.43935467078637  , -.354919333848297  , -.354919333848297  ,
     *   .354919333848297  ,.309838667696593  , -.450806661517033E-01,
     *   .309838667696593  ,.354919333848297  , -.450806661517033E-01,
     *    -.354919333848297  ,  2.43935467078637  , -.354919333848297  ,
     *    -.354919333848297  , -.354919333848297  ,  2.43935467078637  ,
     *   .354919333848297  , -.450806661517033E-01,.309838667696593  ,
     *   .450806661517033E-01,.450806661517033E-01,.393546707863734E-01,
     *    -.450806661517033E-01,.354919333848297  ,.309838667696593  ,
     *   .309838667696593  , -.450806661517033E-01,.354919333848297  ,
     *   .450806661517033E-01,.393546707863734E-01,.450806661517033E-01,
     *   .393546707863734E-01,.450806661517033E-01,.450806661517033E-01,
     *    -.450806661517033E-01,.309838667696593  ,.354919333848297  ,
     *    -.432379000772445  , -.587298334620742  , -.587298334620742  ,
     *   .432379000772445  , -.587298334620742  , -.587298334620742  ,
     *    -.100000000000000E+00,-.787298334620742 ,.127016653792583E-01,
     *   .100000000000000  , -.787298334620742  ,.127016653792583E-01,
     *   .100000000000000  ,.127016653792583E-01, -.787298334620742  ,
     *    -.100000000000000E+00,.127016653792583E-01, -.787298334620742,
     *    -.323790007724450E-01, -.187298334620742  , -.187298334620742,
     *   .323790007724450E-01, -.187298334620742  , -.187298334620742  ,
     *   .000000000000000E+00, -.887298334620742  , -.887298334620742  ,
     *   .354919333848297  ,  1.37459666924148  , -.200000000000000  ,
     *   .000000000000000E+00,.887298334620742  , -.112701665379258  ,
     *    -.354919333848297  ,  1.37459666924148  , -.200000000000000  ,
     *    -.354919333848297  , -.200000000000000  ,  1.37459666924148  ,
     *   .354919333848297  , -.200000000000000  ,  1.37459666924148  ,
     *   .450806661517033E-01,.200000000000000  ,.174596669241483  ,
     *    -.450806661517033E-01,.200000000000000  ,.174596669241483  ,
     *   .000000000000000E+00, -.112701665379258  ,.887298334620742  ,
     *   .450806661517033E-01,.174596669241483  ,.200000000000000  ,
     *   .000000000000000E+00,.112701665379258  ,.112701665379258  ,
     *    -.450806661517033E-01,.174596669241483  ,.200000000000000  ,
     *   .787298334620742 , -.549193338482970E-01,-.549193338482970E-01,
     *     1.65205633616563  , -1.65205633616563  , -1.65205633616563  ,
     *   .549193338482967E-01,-.787298334620742, -.549193338482967E-01,
     *   .254919333848297  , -.254919333848296  ,.127016653792583E-01,
     *   .254919333848297  ,.127016653792583E-01, -.254919333848296  ,
     *   .549193338482967E-01, -.549193338482967E-01, -.787298334620742,
     *    -.127016653792583E-01, -.254919333848297  , -.254919333848297,
     * .520563361656317E-01,-.520563361656317E-01,-.520563361656317E-01,
     *    -2.43935467078637  , -.354919333848297  , -.354919333848297  ,
     *   .354919333848297  ,  2.43935467078637  , -.354919333848297  ,
     *    -.309838667696593  ,.354919333848297  , -.450806661517033E-01,
     *    -.354919333848297  ,.309838667696593  , -.450806661517033E-01,
     *    -.354919333848297  , -.450806661517033E-01,.309838667696593  ,
     *   .354919333848297  , -.354919333848297  ,  2.43935467078637  ,
     *   .450806661517033E-01,.354919333848297  ,.309838667696593  ,
     *  -.450806661517033E-01,.450806661517033E-01,.393546707863734E-01,
     *    -.309838667696593  , -.450806661517033E-01,.354919333848297  ,
     *   .450806661517033E-01,.309838667696593  ,.354919333848297  ,
     *  -.393546707863734E-01,.450806661517033E-01,.450806661517033E-01,
     *  -.450806661517033E-01,.393546707863734E-01,.450806661517033E-01,
     *    -.587298334620741  , -.432379000772445  , -.587298334620742  ,
     *    -.787298334620742  ,.100000000000000  ,.127016653792583E-01,
     *    -.787298334620742 ,-.100000000000000E+00,.127016653792583E-01,
     *    -.587298334620742  ,.432379000772445  , -.587298334620742  ,
     *   .127016653792583E-01,.100000000000000  , -.787298334620742  ,
     *    -.187298334620742  ,.323790007724450E-01, -.187298334620742  ,
     *    -.187298334620742  , -.323790007724450E-01, -.187298334620742,
     *   .127016653792583E-01, -.100000000000000E+00, -.787298334620742,
     *     1.37459666924148  , -.354919333848297  , -.200000000000000  ,
     *   .887298334620742  ,.000000000000000E+00, -.112701665379258  ,
     *     1.37459666924148  ,.354919333848297  , -.200000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00, -.887298334620742  ,
     *    -.200000000000000  , -.354919333848297  ,  1.37459666924148  ,
     *   .200000000000000  , -.450806661517033E-01,.174596669241483  ,
     *   .200000000000000  ,.450806661517033E-01,.174596669241483  ,
     *    -.200000000000000  ,.354919333848297  ,  1.37459666924148  ,
     *   .174596669241483  , -.450806661517033E-01,.200000000000000  ,
     *   .112701665379258  ,.000000000000000E+00,.112701665379258  ,
     *   .174596669241483  ,.450806661517033E-01,.200000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00,.887298334620742/
 
      data dp2/.100000000000000  ,.100000000000000  , -.137298334620742,
     *    -.999999999999999E-01,.100000000000000E+00, -.137298334620742,
     *    -.100000000000000  , -.100000000000000  , -.137298334620742  ,
     *   .100000000000000E+00, -.100000000000000E+00, -.137298334620742,
     *   .100000000000000E+00,.100000000000000E+00, -.637298334620742  ,
     *    -.100000000000000E+00,.100000000000000E+00, -.637298334620742,
     *    -.100000000000000E+00,-.100000000000000E+00,-.637298334620742,
     *   .100000000000000E+00, -.100000000000000E+00, -.637298334620742,
     *   .000000000000000E+00, -.887298334620742  , -.500000000000000  ,
     *   .887298334620742  ,.000000000000000E+00, -.500000000000000  ,
     *   .000000000000000E+00,.887298334620742  , -.500000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00, -.500000000000000  ,
     *    -.200000000000000  , -.200000000000000  ,.774596669241483  ,
     *   .200000000000000  , -.200000000000000  ,.774596669241483  ,
     *   .200000000000000  ,.200000000000000  ,.774596669241483  ,
     *    -.200000000000000  ,.200000000000000  ,.774596669241483  ,
     *   .000000000000000E+00, -.112701665379258  ,.500000000000000  ,
     *   .112701665379258  ,.000000000000000E+00,.500000000000000  ,
     *   .000000000000000E+00,.112701665379258  ,.500000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00,.500000000000000  ,
     *   .787298334620742  ,.999999999999998E-01,.127016653792577E-01,
     *   .587298334620742  , -.432379000772445  , -.587298334620742  ,
     *   .587298334620742  ,.432379000772445  , -.587298334620742  ,
     *   .787298334620742  , -.100000000000000  ,.127016653792583E-01,
     *   .187298334620742  ,.323790007724451E-01, -.187298334620742  ,
     *    -.127016653792583E-01,.100000000000000E+00, -.787298334620742,
     *    -.127016653792583E-01,-.999999999999999E-01,-.787298334620741,
     *   .187298334620742  , -.323790007724450E-01, -.187298334620742  ,
     *    -1.37459666924148  , -.354919333848297  , -.200000000000000  ,
     *   .887298334620742  ,.000000000000000E+00, -.887298334620742  ,
     *    -1.37459666924148  ,.354919333848297  , -.200000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00, -.112701665379258  ,
     *    -.200000000000000  , -.450806661517033E-01,.174596669241483  ,
     *   .200000000000000  , -.354919333848297  ,  1.37459666924148  ,
     *   .200000000000000  ,.354919333848297  ,  1.37459666924148  ,
     *    -.200000000000000  ,.450806661517033E-01,.174596669241483  ,
     *    -.174596669241483  , -.450806661517033E-01,.200000000000000  ,
     *   .112701665379258  ,.000000000000000E+00,.887298334620742  ,
     *    -.174596669241483  ,.450806661517033E-01,.200000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00,.112701665379258  ,
     *    -.549193338482971E-01,.787298334620742 ,-.549193338482971E-01,
     *    -.254919333848296  ,.254919333848297  ,.127016653792583E-01,
     *    -.787298334620742 ,.549193338482967E-01,-.549193338482967E-01,
     *    -1.65205633616563  ,  1.65205633616563  , -1.65205633616563  ,
     *   .127016653792583E-01,.254919333848297  , -.254919333848297  ,
     * -.520563361656317E-01,.520563361656317E-01,-.520563361656317E-01,
     *    -.254919333848297  , -.127016653792583E-01, -.254919333848297,
     *    -.549193338482967E-01,.549193338482967E-01, -.787298334620742,
     *   .309838667696593  , -.354919333848297  , -.450806661517033E-01,
     *   .354919333848297  , -.309838667696593  , -.450806661517033E-01,
     *     2.43935467078637  ,.354919333848297  , -.354919333848297  ,
     *    -.354919333848297  , -2.43935467078637  , -.354919333848297  ,
     *    -.450806661517033E-01, -.354919333848297  ,.309838667696593  ,
     *  .450806661517033E-01,-.450806661517033E-01,.393546707863734E-01,
     *   .354919333848297  ,.450806661517033E-01,.309838667696593  ,
     *    -.354919333848297  ,.354919333848297  ,  2.43935467078637  ,
     * .393546707863734E-01, -.450806661517033E-01,.450806661517033E-01,
     * .450806661517033E-01, -.393546707863734E-01,.450806661517033E-01,
     *   .309838667696593  ,.450806661517033E-01,.354919333848297  ,
     *    -.450806661517033E-01, -.309838667696593  ,.354919333848297  ,
     *   .999999999999997E-01,.787298334620742  ,.127016653792574E-01,
     *    -.999999999999998E-01,.787298334620742  ,.127016653792583E-01,
     *   .432379000772445  ,.587298334620742  , -.587298334620742  ,
     *    -.432379000772445  ,.587298334620742  , -.587298334620742  ,
     *   .323790007724450E-01,.187298334620742  , -.187298334620742  ,
     *    -.323790007724450E-01,.187298334620742  , -.187298334620742  ,
     *    -.999999999999999E-01,-.127016653792583E-01,-.787298334620741,
     *   .100000000000000E+00, -.127016653792583E-01, -.787298334620742,
     *   .000000000000000E+00, -.887298334620742  , -.112701665379258  ,
     *   .354919333848297  , -1.37459666924148  , -.200000000000000  ,
     *   .000000000000000E+00,.887298334620742  , -.887298334620742  ,
     *    -.354919333848297  , -1.37459666924148  , -.200000000000000  ,
     *    -.450806661517033E-01, -.200000000000000  ,.174596669241483  ,
     *   .450806661517033E-01, -.200000000000000  ,.174596669241483  ,
     *   .354919333848297  ,.200000000000000  ,  1.37459666924148  ,
     *    -.354919333848297  ,.200000000000000  ,  1.37459666924148  ,
     *   .000000000000000E+00, -.112701665379258  ,.112701665379258  ,
     *   .450806661517033E-01, -.174596669241483  ,.200000000000000  ,
     *   .000000000000000E+00,.112701665379258  ,.887298334620742  ,
     *    -.450806661517033E-01, -.174596669241483  ,.200000000000000/

      data dp3/.254919333848296 ,.254919333848296 ,.127016653792571E-01,
     *   .549193338482968E-01,.787298334620742  , -.549193338482967E-01,
     *     1.65205633616563  ,  1.65205633616563  , -1.65205633616563  ,
     *   .787298334620742  ,.549193338482970E-01, -.549193338482965E-01,
     *  .520563361656317E-01,.520563361656317E-01,-.520563361656314E-01,
     *    -.127016653792583E-01,.254919333848297  , -.254919333848297  ,
     *   .549193338482968E-01,.549193338482968E-01, -.787298334620742  ,
     *   .254919333848297  , -.127016653792583E-01, -.254919333848297  ,
     *    -.309838667696593, -.354919333848297, -.450806661517031E-01,
     *   .354919333848297  , -2.43935467078637  , -.354919333848297  ,
     *    -2.43935467078637  ,.354919333848297  , -.354919333848297  ,
     *    -.354919333848297, -.309838667696593  , -.450806661517031E-01,
     * -.450806661517033E-01,-.450806661517033E-01,.393546707863732E-01,
     *   .450806661517033E-01, -.354919333848297  ,.309838667696593  ,
     *   .354919333848297  ,.354919333848297  ,  2.43935467078637  ,
     *    -.354919333848297  ,.450806661517033E-01,.309838667696593  ,
     * -.393546707863734E-01,-.450806661517033E-01,.450806661517031E-01,
     *   .450806661517033E-01, -.309838667696593  ,.354919333848297  ,
     *    -.309838667696593  ,.450806661517033E-01,.354919333848297  ,
     * -.450806661517033E-01,-.393546707863734E-01,.450806661517031E-01,
     *    -.587298334620742  , -.587298334620742  , -.432379000772445  ,
     *    -.787298334620742  ,.127016653792583E-01,.100000000000000  ,
     *    -.187298334620742  , -.187298334620742  ,.323790007724450E-01,
     *   .127016653792583E-01, -.787298334620742  ,.100000000000000  ,
     *    -.587298334620742  , -.587298334620742  ,.432379000772445  ,
     *    -.787298334620742  ,.127016653792583E-01, -.100000000000000  ,
     *  -.187298334620742  , -.187298334620742  , -.323790007724450E-01,
     * .127016653792583E-01, -.787298334620742  , -.100000000000000E+00,
     *     1.37459666924148  , -.200000000000000  , -.354919333848297  ,
     *   .200000000000000  ,.174596669241483  , -.450806661517033E-01,
     *   .174596669241483  ,.200000000000000  , -.450806661517033E-01,
     *    -.200000000000000  ,  1.37459666924148  , -.354919333848297  ,
     *    -.887298334620742  , -.887298334620742  ,.000000000000000E+00,
     *   .887298334620742  , -.112701665379258  ,.000000000000000E+00,
     *   .112701665379258  ,.112701665379258  ,.000000000000000E+00,
     *    -.112701665379258  ,.887298334620742  ,.000000000000000E+00,
     *     1.37459666924148  , -.200000000000000  ,.354919333848297  ,
     *   .200000000000000  ,.174596669241483  ,.450806661517033E-01,
     *   .174596669241483  ,.200000000000000  ,.450806661517033E-01,
     *    -.200000000000000  ,  1.37459666924148  ,.354919333848297  ,
     *   .100000000000000  , -.137298334620742  ,.100000000000000E+00,
     *    -.100000000000000  , -.137298334620742  ,.100000000000000E+00,
     *    -.100000000000000  , -.637298334620742  ,.100000000000000E+00,
     *   .100000000000000E+00, -.637298334620742  ,.100000000000000E+00,
     *   .100000000000000E+00, -.137298334620742 ,-.100000000000000E+00,
     *    -.100000000000000E+00,-.137298334620742,-.100000000000000E+00,
     *    -.100000000000000E+00,-.637298334620742,-.100000000000000E+00,
     *   .100000000000000E+00, -.637298334620742  , -.100000000000000  ,
     *   .000000000000000E+00, -.500000000000000  , -.887298334620742  ,
     *   .200000000000000  ,.774596669241483  , -.200000000000000  ,
     *   .000000000000000E+00,.500000000000000  , -.112701665379258  ,
     *    -.200000000000000  ,.774596669241483  , -.200000000000000  ,
     *    -.887298334620742  , -.500000000000000  ,.000000000000000E+00,
     *   .887298334620742  , -.500000000000000  ,.000000000000000E+00,
     *   .112701665379258  ,.500000000000000  ,.000000000000000E+00,
     *    -.112701665379258  ,.500000000000000  ,.000000000000000E+00,
     *   .000000000000000E+00, -.500000000000000  ,.887298334620742  ,
     *   .200000000000000  ,.774596669241483  ,.200000000000000  ,
     *   .000000000000000E+00,.500000000000000  ,.112701665379258  ,
     *    -.200000000000000  ,.774596669241483  ,.200000000000000  ,
     *   .787298334620742  ,.127016653792577E-01,.999999999999991E-01,
     *   .587298334620742  , -.587298334620742  , -.432379000772445  ,
     *    -.127016653792583E-01, -.787298334620742,.100000000000000E+00,
     *   .187298334620742  , -.187298334620742  ,.323790007724450E-01,
     *   .787298334620742  ,.127016653792583E-01, -.999999999999998E-01,
     *   .587298334620742  , -.587298334620742  ,.432379000772445  ,
     *    -.127016653792583E-01,-.787298334620742,-.999999999999999E-01,
     *   .187298334620742  , -.187298334620742  , -.323790007724450E-01,
     *    -1.37459666924148  , -.200000000000000  , -.354919333848297  ,
     *   .200000000000000  ,  1.37459666924148  , -.354919333848297  ,
     *    -.174596669241483  ,.200000000000000  , -.450806661517033E-01,
     *    -.200000000000000  ,.174596669241483  , -.450806661517033E-01,
     *    -.887298334620742  , -.112701665379258  ,.000000000000000E+00,
     *   .887298334620742  , -.887298334620742  ,.000000000000000E+00,
     *   .112701665379258  ,.887298334620742  ,.000000000000000E+00,
     *    -.112701665379258  ,.112701665379258  ,.000000000000000E+00,
     *    -1.37459666924148  , -.200000000000000  ,.354919333848297  ,
     *   .200000000000000  ,  1.37459666924148  ,.354919333848297  ,
     *    -.174596669241483  ,.200000000000000  ,.450806661517033E-01,
     *    -.200000000000000  ,.174596669241483  ,.450806661517033E-01/

      data dp4/-.137298334620742,.1000000000000E+00,.100000000000E+00,
     *    -.637298334620742  ,.100000000000000E+00,.100000000000000E+00,
     *    -.637298334620742 ,-.100000000000000E+00,.100000000000000E+00,
     *    -.137298334620742 ,-.100000000000000E+00,.100000000000000E+00,
     *    -.137298334620742 ,.100000000000000E+00,-.100000000000000E+00,
     *    -.637298334620742 ,.100000000000000E+00,-.100000000000000E+00,
     *    -.637298334620742,-.100000000000000E+00,-.100000000000000E+00,
     *    -.137298334620742,-.100000000000000E+00,-.100000000000000E+00,
     *   .774596669241483  , -.200000000000000  , -.200000000000000  ,
     *   .500000000000000  ,.000000000000000E+00, -.112701665379258  ,
     *   .774596669241483  ,.200000000000000  , -.200000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00, -.887298334620742  ,
     *    -.500000000000000  , -.887298334620742  ,.000000000000000E+00,
     *   .500000000000000  , -.112701665379258  ,.000000000000000E+00,
     *   .500000000000000  ,.112701665379258  ,.000000000000000E+00,
     *    -.500000000000000  ,.887298334620742  ,.000000000000000E+00,
     *   .774596669241483  , -.200000000000000  ,.200000000000000  ,
     *   .500000000000000  ,.000000000000000E+00,.112701665379258  ,
     *   .774596669241483  ,.200000000000000  ,.200000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00,.887298334620742  ,
     *   .250000000000000  ,.250000000000000  ,.250000000000000  ,
     *    -.250000000000000  ,.250000000000000  ,.250000000000000  ,
     *    -.250000000000000  , -.250000000000000  ,.250000000000000  ,
     *   .250000000000000  , -.250000000000000  ,.250000000000000  ,
     *   .250000000000000  ,.250000000000000  , -.250000000000000  ,
     *    -.250000000000000  ,.250000000000000  , -.250000000000000  ,
     *    -.250000000000000  , -.250000000000000  , -.250000000000000  ,
     *   .250000000000000  , -.250000000000000  , -.250000000000000  ,
     *   .000000000000000E+00, -.500000000000000  , -.500000000000000  ,
     *   .500000000000000  ,.000000000000000E+00, -.500000000000000  ,
     *   .000000000000000E+00,.500000000000000  , -.500000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00, -.500000000000000  ,
     *    -.500000000000000  , -.500000000000000  ,.000000000000000E+00,
     *   .500000000000000  , -.500000000000000  ,.000000000000000E+00,
     *   .500000000000000  ,.500000000000000  ,.000000000000000E+00,
     *    -.500000000000000  ,.500000000000000  ,.000000000000000E+00,
     *   .000000000000000E+00, -.500000000000000  ,.500000000000000  ,
     *   .500000000000000  ,.000000000000000E+00,.500000000000000  ,
     *   .000000000000000E+00,.500000000000000  ,.500000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00,.500000000000000  ,
     *   .637298334620742  ,.999999999999993E-01,.999999999999993E-01,
     *   .137298334620742  ,.100000000000000E+00,.999999999999998E-01,
     *   .137298334620742  , -.999999999999998E-01,.100000000000000E+00,
     *   .637298334620742  , -.100000000000000E+00,.100000000000000E+00,
     *   .637298334620742  ,.100000000000000E+00, -.100000000000000E+00,
     *   .137298334620742  ,.100000000000000E+00, -.100000000000000E+00,
     *   .137298334620742 , -.999999999999998E-01,-.999999999999998E-01,
     *   .637298334620742, -.100000000000000E+00, -.100000000000000E+00,
     *    -.774596669241483  , -.200000000000000  , -.200000000000000  ,
     *   .500000000000000  ,.000000000000000E+00, -.887298334620742  ,
     *    -.774596669241483  ,.200000000000000  , -.200000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00, -.112701665379258  ,
     *    -.500000000000000  , -.112701665379258  ,.000000000000000E+00,
     *   .500000000000000  , -.887298334620742  ,.000000000000000E+00,
     *   .500000000000000  ,.887298334620742  ,.000000000000000E+00,
     *    -.500000000000000  ,.112701665379258  ,.000000000000000E+00,
     *    -.774596669241483  , -.200000000000000  ,.200000000000000  ,
     *   .500000000000000  ,.000000000000000E+00,.887298334620742  ,
     *    -.774596669241483  ,.200000000000000  ,.200000000000000  ,
     *    -.500000000000000  ,.000000000000000E+00,.112701665379258  ,
     *   .127016653792576E-01,.787298334620742  ,.999999999999995E-01,
     *    -.187298334620742  ,.187298334620742  ,.323790007724450E-01,
     *    -.787298334620741  , -.127016653792583E-01,.100000000000000  ,
     *    -.587298334620742  ,.587298334620742  , -.432379000772445  ,
     *   .127016653792583E-01,.787298334620742  , -.100000000000000E+00,
     *    -.187298334620742  ,.187298334620742  , -.323790007724450E-01,
     *    -.787298334620742,-.127016653792583E-01,-.100000000000000E+00,
     *    -.587298334620742  ,.587298334620742  ,.432379000772445  ,
     *   .174596669241483  , -.200000000000000  , -.450806661517033E-01,
     *   .200000000000000  , -.174596669241483  , -.450806661517033E-01,
     *     1.37459666924148  ,.200000000000000  , -.354919333848297  ,
     *    -.200000000000000  , -1.37459666924148  , -.354919333848297  ,
     *    -.112701665379258  , -.887298334620742  ,.000000000000000E+00,
     *   .112701665379258  , -.112701665379258  ,.000000000000000E+00,
     *   .887298334620742  ,.112701665379258  ,.000000000000000E+00,
     *    -.887298334620742  ,.887298334620742  ,.000000000000000E+00,
     *   .174596669241483  , -.200000000000000  ,.450806661517033E-01,
     *   .200000000000000  , -.174596669241483  ,.450806661517033E-01,
     *     1.37459666924148  ,.200000000000000  ,.354919333848297  ,
     *    -.200000000000000  , -1.37459666924148  ,.354919333848297/

      data dp5/.999999999999992E-01,.637298334620742 
     *     ,.999999999999995E-01,
     *    -.100000000000000  ,.637298334620742  ,.100000000000000E+00,
     *    -.999999999999998E-01,.137298334620742  ,.100000000000000E+00,
     *   .100000000000000E+00,.137298334620742  ,.100000000000000E+00,
     *   .100000000000000E+00,.637298334620742  , -.100000000000000E+00,
     *    -.100000000000000E+00,.637298334620742, -.100000000000000E+00,
     *    -.999999999999998E-01,.137298334620742, -.999999999999998E-01,
     *   .100000000000000E+00,.137298334620742  , -.100000000000000E+00,
     *   .000000000000000E+00, -.500000000000000  , -.112701665379258  ,
     *   .200000000000000  , -.774596669241483  , -.200000000000000  ,
     *   .000000000000000E+00,.500000000000000  , -.887298334620742  ,
     *    -.200000000000000  , -.774596669241483  , -.200000000000000  ,
     *    -.112701665379258  , -.500000000000000  ,.000000000000000E+00,
     *   .112701665379258  , -.500000000000000  ,.000000000000000E+00,
     *   .887298334620742  ,.500000000000000  ,.000000000000000E+00,
     *    -.887298334620742  ,.500000000000000  ,.000000000000000E+00,
     *   .000000000000000E+00, -.500000000000000  ,.112701665379258  ,
     *   .200000000000000  , -.774596669241483  ,.200000000000000  ,
     *   .000000000000000E+00,.500000000000000  ,.887298334620742  ,
     *    -.200000000000000  , -.774596669241483  ,.200000000000000  ,
     *   .187298334620741  ,.187298334620741  ,.323790007724440E-01,
     *    -.127016653792584E-01,.787298334620742  ,.100000000000000  ,
     *   .587298334620742  ,.587298334620742  , -.432379000772445  ,
     *   .787298334620742  , -.127016653792583E-01,.100000000000000  ,
     *   .187298334620742  ,.187298334620742  , -.323790007724449E-01,
     *    -.127016653792584E-01,.787298334620742, -.999999999999999E-01,
     *   .587298334620742  ,.587298334620742  ,.432379000772445  ,
     *   .787298334620742 , -.127016653792583E-01,-.999999999999999E-01,
     *    -.174596669241483  , -.200000000000000, -.450806661517031E-01,
     *   .200000000000000  , -1.37459666924148  , -.354919333848297  ,
     *    -1.37459666924148  ,.200000000000000  , -.354919333848297  ,
     *    -.200000000000000  , -.174596669241483, -.450806661517031E-01,
     *    -.112701665379258  , -.112701665379258  ,.000000000000000E+00,
     *   .112701665379258  , -.887298334620742  ,.000000000000000E+00,
     *   .887298334620742  ,.887298334620742  ,.000000000000000E+00,
     *    -.887298334620742  ,.112701665379258  ,.000000000000000E+00,
     *    -.174596669241483  , -.200000000000000  ,.450806661517031E-01,
     *   .200000000000000  , -1.37459666924148  ,.354919333848297  ,
     *    -1.37459666924148  ,.200000000000000  ,.354919333848297  ,
     *    -.200000000000000  , -.174596669241483  ,.450806661517031E-01,
     *    -.549193338482972E-01, -.549193338482972E-01,.787298334620742,
     *    -.254919333848297  ,.127016653792583E-01,.254919333848297  ,
     * -.520563361656317E-01,-.520563361656317E-01,.520563361656317E-01,
     *   .127016653792583E-01, -.254919333848297  ,.254919333848297  ,
     *    -1.65205633616563  , -1.65205633616563  ,  1.65205633616563  ,
     *    -.787298334620742,-.549193338482967E-01,.549193338482967E-01,
     *    -.254919333848297,-.254919333848297  , -.127016653792583E-01,
     *    -.549193338482967E-01,-.787298334620742,.549193338482967E-01,
     *   .309838667696593  , -.450806661517033E-01, -.354919333848297  ,
     *  .450806661517033E-01,.393546707863734E-01,-.450806661517033E-01,
     *  .393546707863734E-01,.450806661517033E-01,-.450806661517033E-01,
     *    -.450806661517033E-01,.309838667696593  , -.354919333848297  ,
     *    -.354919333848297  , -.354919333848297  , -2.43935467078637  ,
     *   .354919333848297  , -.450806661517033E-01, -.309838667696593  ,
     *  .450806661517033E-01,.450806661517033E-01,-.393546707863734E-01,
     *    -.450806661517033E-01,.354919333848297  , -.309838667696593  ,
     *     2.43935467078637  , -.354919333848297  ,.354919333848297  ,
     *   .354919333848297  ,.309838667696593  ,.450806661517033E-01,
     *   .309838667696593  ,.354919333848297  ,.450806661517033E-01,
     *    -.354919333848297  ,  2.43935467078637  ,.354919333848297  ,
     *   .999999999999995E-01,.127016653792574E-01,.787298334620742  ,
     *    -.999999999999998E-01,.127016653792583E-01,.787298334620742  ,
     *    -.323790007724450E-01, -.187298334620742  ,.187298334620742  ,
     *   .323790007724450E-01, -.187298334620742  ,.187298334620742  ,
     *    -.432379000772446  , -.587298334620742  ,.587298334620742  ,
     *   .432379000772445  , -.587298334620742  ,.587298334620742  ,
     *    -.100000000000000E+00,-.787298334620742,-.127016653792583E-01,
     *   .100000000000000E+00, -.787298334620742 ,-.127016653792583E-01,
     *   .000000000000000E+00, -.112701665379258  , -.887298334620742  ,
     *   .450806661517033E-01,.174596669241483  , -.200000000000000  ,
     *   .000000000000000E+00,.112701665379258  , -.112701665379258  ,
     *    -.450806661517033E-01,.174596669241483  , -.200000000000000  ,
     *    -.354919333848297  , -.200000000000000  , -1.37459666924148  ,
     *   .354919333848297  , -.200000000000000  , -1.37459666924148  ,
     *   .450806661517033E-01,.200000000000000  , -.174596669241483  ,
     *    -.450806661517033E-01,.200000000000000  , -.174596669241483  ,
     *   .000000000000000E+00, -.887298334620742  ,.887298334620742  ,
     *   .354919333848297  ,  1.37459666924148  ,.200000000000000  ,
     *   .000000000000000E+00,.887298334620742  ,.112701665379258  ,
     *    -.354919333848297  ,  1.37459666924148  ,.200000000000000/

      data dp6/.254919333848296  ,.127016653792569E-01,.254919333848296,
     *   .549193338482968E-01, -.549193338482965E-01,.787298334620742  ,
     *    -.127016653792583E-01, -.254919333848297  ,.254919333848297  ,
     *  .520563361656317E-01,-.520563361656312E-01,.520563361656317E-01,
     *   .787298334620741  , -.549193338482969E-01,.549193338482966E-01,
     *     1.65205633616563  , -1.65205633616563  ,  1.65205633616563  ,
     *   .549193338482967E-01, -.787298334620741  ,.549193338482967E-01,
     *   .254919333848297  , -.254919333848297  , -.127016653792583E-01,
     *    -.309838667696593  , -.450806661517031E-01, -.354919333848297,
     *   .450806661517033E-01,.309838667696593  , -.354919333848297  ,
     * -.393546707863734E-01,.450806661517031E-01,-.450806661517033E-01,
     * -.450806661517033E-01,.393546707863733E-01,-.450806661517033E-01,
     *    -.354919333848297  , -.450806661517031E-01,-.309838667696593,
     *   .354919333848297  , -.354919333848297  , -2.43935467078637  ,
     *   .450806661517033E-01,.354919333848297  , -.309838667696593  ,
     * -.450806661517033E-01,.450806661517031E-01,-.393546707863734E-01,
     *    -2.43935467078637  , -.354919333848297  ,.354919333848297  ,
     *   .354919333848297  ,  2.43935467078637  ,.354919333848297  ,
     *    -.309838667696593  ,.354919333848297  ,.450806661517033E-01,
     *    -.354919333848297  ,.309838667696593  ,.450806661517033E-01,
     *   .127016653792578E-01,.999999999999995E-01,.787298334620742  ,
     *    -.187298334620742  ,.323790007724450E-01,.187298334620742  ,
     *    -.187298334620742  , -.323790007724450E-01,.187298334620742  ,
     *   .127016653792583E-01, -.100000000000000E+00,.787298334620742  ,
     *    -.587298334620742  , -.432379000772445  ,.587298334620742  ,
     *    -.787298334620742,.100000000000000E+00,-.127016653792583E-01,
     *    -.787298334620742,-.100000000000000E+00,-.127016653792583E-01,
     *    -.587298334620742  ,.432379000772445  ,.587298334620742  ,
     *   .174596669241483  , -.450806661517033E-01, -.200000000000000  ,
     *   .112701665379258  ,.000000000000000E+00, -.112701665379258  ,
     *   .174596669241483  ,.450806661517033E-01, -.200000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00, -.887298334620742  ,
     *    -.200000000000000  , -.354919333848297  , -1.37459666924148  ,
     *   .200000000000000  , -.450806661517033E-01, -.174596669241483  ,
     *   .200000000000000  ,.450806661517033E-01, -.174596669241483  ,
     *    -.200000000000000  ,.354919333848297  , -1.37459666924148  ,
     *     1.37459666924148  , -.354919333848297  ,.200000000000000  ,
     *   .887298334620742  ,.000000000000000E+00,.112701665379258  ,
     *     1.37459666924148  ,.354919333848297  ,.200000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00,.887298334620742  ,
     *   .999999999999996E-01,.999999999999995E-01,.637298334620742  ,
     *    -.100000000000000  ,.999999999999999E-01,.637298334620742  ,
     *    -.100000000000000E+00, -.100000000000000E+00,.637298334620742,
     *   .100000000000000E+00, -.999999999999999E-01,.637298334620742  ,
     *   .999999999999998E-01,.999999999999999E-01,.137298334620742  ,
     *    -.999999999999999E-01,.100000000000000E+00,.137298334620742  ,
     *    -.999999999999999E-01, -.999999999999999E-01,.137298334620742,
     *   .100000000000000E+00, -.100000000000000E+00,.137298334620742  ,
     *   .000000000000000E+00, -.112701665379258  , -.500000000000000  ,
     *   .112701665379258  ,.000000000000000E+00, -.500000000000000  ,
     *   .000000000000000E+00,.112701665379258  , -.500000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00, -.500000000000000  ,
     *    -.200000000000000  , -.200000000000000  , -.774596669241483  ,
     *   .200000000000000  , -.200000000000000  , -.774596669241483  ,
     *   .200000000000000  ,.200000000000000  , -.774596669241483  ,
     *    -.200000000000000  ,.200000000000000  , -.774596669241483  ,
     *   .000000000000000E+00, -.887298334620742  ,.500000000000000  ,
     *   .887298334620742  ,.000000000000000E+00,.500000000000000  ,
     *   .000000000000000E+00,.887298334620742  ,.500000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00,.500000000000000  ,
     *   .187298334620741  ,.323790007724440E-01,.187298334620741  ,
     *    -.127016653792584E-01,.100000000000000  ,.787298334620742  ,
     *    -.127016653792584E-01, -.100000000000000  ,.787298334620742  ,
     *   .187298334620742  , -.323790007724447E-01,.187298334620742  ,
     *   .787298334620741  ,.999999999999999E-01, -.127016653792583E-01,
     *   .587298334620742  , -.432379000772445  ,.587298334620742  ,
     *   .587298334620742  ,.432379000772446  ,.587298334620742  ,
     *   .787298334620742, -.999999999999999E-01,-.127016653792583E-01,
     *    -.174596669241483, -.450806661517031E-01, -.200000000000000  ,
     *   .112701665379258  ,.000000000000000E+00, -.887298334620742  ,
     *    -.174596669241483  ,.450806661517031E-01, -.200000000000000  ,
     *    -.112701665379258  ,.000000000000000E+00, -.112701665379258  ,
     *    -.200000000000000, -.450806661517031E-01, -.174596669241483  ,
     *   .200000000000000  , -.354919333848297  , -1.37459666924148  ,
     *   .200000000000000  ,.354919333848297  , -1.37459666924148  ,
     *    -.200000000000000  ,.450806661517031E-01, -.174596669241483  ,
     *    -1.37459666924148  , -.354919333848297  ,.200000000000000  ,
     *   .887298334620742  ,.000000000000000E+00,.887298334620742  ,
     *    -1.37459666924148  ,.354919333848297  ,.200000000000000  ,
     *    -.887298334620742  ,.000000000000000E+00,.112701665379258/

      data dp7/ .127016653792573E-01,.254919333848296 ,.254919333848296,
     *  -.520563361656314E-01,.520563361656317E-01,.520563361656317E-01,
     *    -.254919333848297  , -.127016653792583E-01,.254919333848297  ,
     *    -.549193338482966E-01,.549193338482969E-01,.787298334620742  ,
     *    -.549193338482968E-01,.787298334620742  ,.549193338482967E-01,
     *    -.254919333848297  ,.254919333848297  , -.127016653792583E-01,
     *    -.787298334620741  ,.549193338482967E-01,.549193338482967E-01,
     *    -1.65205633616563  ,  1.65205633616563  ,  1.65205633616563  ,
     * .393546707863734E-01,-.450806661517033E-01,-.450806661517033E-01,
     * .450806661517031E-01,-.393546707863734E-01,-.450806661517033E-01,
     *   .309838667696593  ,.450806661517033E-01, -.354919333848297  ,
     *    -.450806661517031E-01, -.309838667696593  , -.354919333848297,
     *    -.450806661517031E-01, -.354919333848297  , -.309838667696593,
     * .450806661517031E-01,-.450806661517033E-01,-.393546707863734E-01,
     *   .354919333848297  ,.450806661517033E-01, -.309838667696593  ,
     *    -.354919333848297  ,.354919333848297  , -2.43935467078637  ,
     *   .309838667696593  , -.354919333848297  ,.450806661517033E-01,
     *   .354919333848297  , -.309838667696593  ,.450806661517033E-01,
     *     2.43935467078637  ,.354919333848297  ,.354919333848297  ,
     *    -.354919333848297  , -2.43935467078637  ,.354919333848297  ,
     *   .323790007724443E-01,.187298334620741  ,.187298334620741  ,
     *    -.323790007724447E-01,.187298334620742  ,.187298334620742  ,
     *    -.100000000000000  , -.127016653792582E-01,.787298334620742  ,
     *   .100000000000000  , -.127016653792582E-01,.787298334620742  ,
     *   .999999999999999E-01,.787298334620741  , -.127016653792585E-01,
     *    -.999999999999999E-01,.787298334620742, -.127016653792583E-01,
     *   .432379000772446  ,.587298334620742  ,.587298334620742  ,
     *    -.432379000772445  ,.587298334620741  ,.587298334620741  ,
     *   .000000000000000E+00, -.112701665379258  , -.112701665379258  ,
     *   .450806661517031E-01, -.174596669241483  , -.200000000000000  ,
     *   .000000000000000E+00,.112701665379258  , -.887298334620742  ,
     *    -.450806661517031E-01, -.174596669241483  , -.200000000000000,
     *    -.450806661517031E-01, -.200000000000000  , -.174596669241483,
     *   .450806661517031E-01, -.200000000000000  , -.174596669241483  ,
     *   .354919333848297  ,.200000000000000  , -1.37459666924148  ,
     *    -.354919333848297  ,.200000000000000  , -1.37459666924148  ,
     *   .000000000000000E+00, -.887298334620742  ,.112701665379258  ,
     *   .354919333848297  , -1.37459666924148  ,.200000000000000  ,
     *   .000000000000000E+00,.887298334620742  ,.887298334620742  ,
     *    -.354919333848297  , -1.37459666924148  ,.200000000000000  ,
     *   .520563361656308E-01,.520563361656310E-01,.520563361656301E-01,
     *    -.127016653792582E-01,.254919333848297  ,.254919333848296  ,
     *   .549193338482965E-01,.549193338482967E-01,.787298334620742  ,
     *   .254919333848297  , -.127016653792580E-01,.254919333848297  ,
     *   .254919333848297  ,.254919333848296  , -.127016653792584E-01,
     *   .549193338482969E-01,.787298334620742  ,.549193338482967E-01,
     *     1.65205633616563  ,  1.65205633616563  ,  1.65205633616563  ,
     *   .787298334620742  ,.549193338482965E-01,.549193338482965E-01,
     *-.393546707863734E-01,-.450806661517031E-01,-.450806661517031E-01,
     *   .450806661517031E-01, -.309838667696594  , -.354919333848297  ,
     *    -.309838667696594  ,.450806661517031E-01, -.354919333848297  ,
     *-.450806661517031E-01,-.393546707863734E-01,-.450806661517031E-01,
     *-.450806661517031E-01,-.450806661517031E-01,-.393546707863734E-01,
     *   .450806661517031E-01, -.354919333848297  , -.309838667696594  ,
     *   .354919333848297  ,.354919333848297  , -2.43935467078637  ,
     *    -.354919333848297  ,.450806661517031E-01, -.309838667696594  ,
     *    -.309838667696594  , -.354919333848297  ,.450806661517031E-01,
     *   .354919333848297  , -2.43935467078637  ,.354919333848297  ,
     *    -2.43935467078637  ,.354919333848297  ,.354919333848297  ,
     *    -.354919333848297  , -.309838667696594  ,.450806661517031E-01/


      DATA Va1/.226189500386223,-.108729833462074,-.312701665379258E-01,
     *   -.108729833462074  ,-.108729833462074,-.312701665379258E-01,
     *   -.618950038622251E-02,-.312701665379258E-01,.314919333848297,
     *   .400000000000000E-01,.400000000000000E-01,.314919333848297  ,
     *   .314919333848297 ,.400000000000000E-01,.508066615170332E-02,
     *   .400000000000000E-01,.400000000000000E-01,.508066615170332E-02,
     *   .508066615170332E-02,.400000000000000E-01,-.177459666924148 ,
     *   -.177459666924148 ,-.100000000000000E+00,-.100000000000000 ,
     *   -.100000000000000 ,-.100000000000000E+00,-.225403330758517E-01,
     *   -.225403330758517E-01,.787298334620742 ,.177459666924148 ,
     *   .100000000000000E+00,.177459666924148 ,.177459666924148 ,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   .100000000000000E+00,.225403330758517E-01,.127016653792583E-01,
     *   .225403330758517E-01,-.108729833462074 ,.226189500386223 ,
     *   -.108729833462074 ,-.312701665379258E-01,-.312701665379258E-01,
     *   -.108729833462074 ,-.312701665379258E-01,-.618950038622251E-02,
     *   .314919333848297 ,.314919333848297 ,.400000000000000E-01,
     *   .400000000000000E-01,.400000000000000E-01,.314919333848297 ,
     *   .400000000000000E-01,.508066615170332E-02,.400000000000000E-01,
     *   .400000000000000E-01,.508066615170332E-02,.508066615170332E-02,
     *   -.177459666924148 ,-.100000000000000 ,-.100000000000000E+00,
     *   -.177459666924148 ,-.100000000000000 ,-.225403330758517E-01,
     *   -.225403330758517E-01,-.100000000000000E+00,.177459666924148 ,
     *   .100000000000000E+00,.177459666924148 ,.787298334620742 ,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   .177459666924148 ,.225403330758517E-01,.127016653792583E-01,
     *   .225403330758517E-01,.100000000000000E+00,-.271824583655185 ,
     *   -.271824583655185 ,-.271824583655185 ,-.271824583655185 ,
     *-.781754163448146E-01,-.781754163448146E-01,-.781754163448146E-01,
     *   -.781754163448146E-01,.443649167310371 ,.443649167310371 ,
     *   .443649167310371 ,.443649167310371 ,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.100000000000000E+00,
     *   .563508326896291E-01,.563508326896291E-01,.563508326896291E-01,
     *   .563508326896291E-01,-.100000000000000 ,-.177459666924148 ,
     *   -.177459666924148 ,-.999999999999998E-01,-.225403330758517E-01,
     *   -.100000000000000 ,-.100000000000000E+00,-.225403330758516E-01,
     *   .177459666924148 ,.787298334620742 ,.177459666924148 ,
     *   .100000000000000E+00,.225403330758517E-01,.177459666924148 ,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   .100000000000000E+00,.225403330758517E-01,.127016653792583E-01,
     *   -.108729833462074 ,-.312701665379258E-01,-.108729833462074 ,
     *   .226189500386223 ,-.312701665379258E-01,-.618950038622251E-02,
     *   -.312701665379258E-01,-.108729833462074 ,.400000000000000E-01,
     *   .400000000000000E-01,.314919333848297 ,.314919333848297 ,
     *   .400000000000000E-01,.508066615170332E-02,.400000000000000E-01,
     *   .314919333848297 ,.508066615170332E-02,.508066615170332E-02,
     *   .400000000000000E-01,.400000000000000E-01,-.100000000000000 ,
     *   -.999999999999999E-01,-.177459666924148 ,-.177459666924148 ,
     *   -.225403330758517E-01,-.225403330758516E-01,-.1000000000E+00,
     *   -.100000000000000E+00,.100000000000000E+00,.177459666924148 ,
     *   .787298334620742 ,.177459666924148 ,.225403330758517E-01,
     *   .225403330758517E-01,.177459666924148 ,.177459666924148 ,
     *   .127016653792583E-01,.225403330758517E-01,.100000000000000E+00,
     *   .225403330758517E-01,-.312701665379259E-01,-.108729833462074 ,
     *   .226189500386222 ,-.108729833462074 ,-.618950038622246E-02,
     *   -.312701665379258E-01,-.108729833462074 ,-.312701665379258E-01,
     *   .400000000000001E-01,.314919333848297 ,.314919333848297 ,
     *   .400000000000001E-01,.508066615170331E-02,.400000000000000E-01,
     *   .314919333848297 ,.400000000000000E-01,.508066615170327E-02,
     *   .400000000000000E-01,.400000000000000E-01,.508066615170327E-02/

      data va2/-.177459666924148,-.1000000000000 ,-.225403330758517E-01,
     *   -.100000000000000E+00,-.177459666924148 ,-.100000000000000E+00,
     *   -.225403330758517E-01,-.100000000000000E+00,.177459666924148 ,
     *   .225403330758517E-01,.225403330758517E-01,.177459666924148 ,
     *   .787298334620742 ,.100000000000000E+00,.127016653792583E-01,
     *   .100000000000000E+00,.177459666924148 ,.225403330758517E-01,
     *   .225403330758517E-01,.177459666924148 ,-.271824583655186 ,
     *   -.271824583655185 ,-.781754163448146E-01,-.781754163448145E-01,
     *   -.271824583655185 ,-.271824583655185 ,-.781754163448146E-01,
     *   -.781754163448146E-01,.443649167310371 ,.100000000000000E+00,
     *   .563508326896291E-01,.100000000000000E+00,.443649167310371 ,
     *   .443649167310371 ,.563508326896291E-01,.563508326896291E-01,
     *   .443649167310371 ,.100000000000000E+00,.563508326896291E-01,
     *   .100000000000000E+00,-.100000000000000 ,-.177459666924148 ,
     *   -.100000000000000 ,-.225403330758516E-01,-.999999999999998E-01,
     *   -.177459666924148 ,-.100000000000000E+00,-.225403330758517E-01,
     *   .177459666924148 ,.177459666924148 ,.225403330758517E-01,
     *   .225403330758517E-01,.100000000000000E+00,.787298334620742 ,
     *   .100000000000000E+00,.127016653792583E-01,.177459666924148 ,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   -.271824583655185 ,-.781754163448146E-01,-.781754163448146E-01,
     *   -.271824583655185 ,-.271824583655185 ,-.781754163448146E-01,
     *   -.781754163448146E-01,-.271824583655185 ,.100000000000000E+00,
     *   .563508326896291E-01,.100000000000000E+00,.443649167310371 ,
     *   .443649167310371 ,.563508326896291E-01,.563508326896291E-01,
     *   .443649167310371 ,.100000000000000E+00,.563508326896291E-01,
     *   .100000000000000E+00,.443649167310371 ,-.250000000000000 ,
     *   -.250000000000000 ,-.250000000000000 ,-.250000000000000 ,
     *   -.250000000000000 ,-.250000000000000 ,-.250000000000000 ,
     *   -.250000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,-.781754163448151E-01,-.271824583655185 ,
     *   -.271824583655185 ,-.781754163448146E-01,-.781754163448146E-01,
     *   -.271824583655185 ,-.271824583655185 ,-.781754163448146E-01,
     *   .100000000000000E+00,.443649167310371 ,.100000000000000E+00,
     *   .563508326896291E-01,.563508326896291E-01,.443649167310371 ,
     *   .443649167310371 ,.563508326896291E-01,.100000000000000E+00,
     *   .443649167310371 ,.100000000000000E+00,.563508326896291E-01,
     *   -.100000000000000 ,-.225403330758516E-01,-.100000000000000 ,
     *   -.177459666924148 ,-.100000000000000E+00,-.225403330758517E-01,
     *   -.100000000000000E+00,-.177459666924148 ,.225403330758517E-01,
     *   .225403330758517E-01,.177459666924148 ,.177459666924148 ,
     *   .100000000000000E+00,.127016653792583E-01,.100000000000000E+00,
     *   .787298334620742 ,.225403330758517E-01,.225403330758517E-01,
     *   .177459666924148 ,.177459666924148 ,-.781754163448150E-01,
     *   -.781754163448146E-01,-.271824583655185 ,-.271824583655185 ,
     *   -.781754163448146E-01,-.781754163448146E-01,-.271824583655185 ,
     *   -.271824583655185 ,.563508326896291E-01,.100000000000000E+00,
     *   .443649167310371 ,.100000000000000E+00,.563508326896291E-01,
     *   .563508326896291E-01,.443649167310371 ,.443649167310371 ,
     *   .563508326896291E-01,.100000000000000E+00,.443649167310371 ,
     * .100000000000000E+00,-.225403330758523E-01,-.999999999999998E-01,
     *   -.177459666924149 ,-.999999999999999E-01,-.225403330758515E-01,
     *   -.100000000000000E+00,-.177459666924148 ,-.100000000000000E+00,
     *   .225403330758513E-01,.177459666924148 ,.177459666924148 ,
     *   .225403330758513E-01,.127016653792583E-01,.100000000000000E+00,
     *   .787298334620742 ,.100000000000000E+00,.225403330758516E-01,
     *   .177459666924148 ,.177459666924148 ,.225403330758516E-01/

      data va3/-.108729833462074 ,-.312701665379258E-01,
     *    -.618950038622250E-02,
     *   -.312701665379258E-01,.226189500386223 ,-.108729833462074 ,
     *   -.312701665379258E-01,-.108729833462074 ,.400000000000000E-01,
     *   .508066615170332E-02,.508066615170332E-02,.400000000000000E-01,
     *   .314919333848297 ,.400000000000000E-01,.508066615170332E-02,
     *   .400000000000000E-01,.314919333848297 ,.400000000000000E-01,
     *   .400000000000000E-01,.314919333848297 ,-.100000000000000 ,
     *-.100000000000000E+00,-.225403330758517E-01,-.225403330758516E-01,
     *   -.177459666924148 ,-.177459666924148 ,-.100000000000000E+00,
     *   -.100000000000000 ,.100000000000000E+00,.225403330758517E-01,
     *   .127016653792583E-01,.225403330758517E-01,.177459666924148 ,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   .787298334620742 ,.177459666924148 ,.100000000000000E+00,
     *   .177459666924148 ,-.312701665379262E-01,-.108729833462074 ,
     *   -.312701665379258E-01,-.618950038622246E-02,-.108729833462074 ,
     *   .226189500386222 ,-.108729833462074 ,-.312701665379258E-01,
     *   .400000000000000E-01,.400000000000000E-01,.508066615170333E-02,
     *   .508066615170332E-02,.400000000000000E-01,.314919333848297 ,
     *   .400000000000000E-01,.508066615170333E-02,.314919333848297 ,
     *   .314919333848297 ,.400000000000000E-01,.400000000000000E-01,
     *   -.100000000000000 ,-.225403330758516E-01,-.225403330758517E-01,
     *   -.100000000000000E+00,-.177459666924148 ,-.100000000000000 ,
     *   -.100000000000000E+00,-.177459666924148 ,.225403330758517E-01,
     *   .127016653792583E-01,.225403330758517E-01,.100000000000000E+00,
     *   .177459666924148 ,.225403330758517E-01,.225403330758517E-01,
     *   .177459666924148 ,.177459666924148 ,.100000000000000E+00,
     *   .177459666924148 ,.787298334620742 ,-.781754163448149E-01,
     *-.781754163448146E-01,-.781754163448146E-01,-.781754163448146E-01,
     *   -.271824583655185 ,-.271824583655185 ,-.271824583655185 ,
     *   -.271824583655185 ,.563508326896291E-01,.563508326896291E-01,
     *   .563508326896291E-01,.563508326896291E-01,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.100000000000000E+00,
     *   .443649167310371 ,.443649167310371 ,.443649167310371 ,
     *   .443649167310371 ,-.225403330758526E-01,-.999999999999998E-01,
     *   -.100000000000000 ,-.225403330758516E-01,-.999999999999999E-01,
     *   -.177459666924149 ,-.177459666924148 ,-.100000000000000E+00,
     *   .225403330758513E-01,.100000000000000E+00,.225403330758516E-01,
     *   .127016653792583E-01,.225403330758513E-01,.177459666924148 ,
     *   .177459666924148 ,.225403330758516E-01,.177459666924148 ,
     *   .787298334620742 ,.177459666924148 ,.100000000000000E+00,
     *-.312701665379264E-01,-.618950038622245E-02,-.312701665379258E-01,
     *   -.108729833462074 ,-.108729833462074 ,-.312701665379258E-01,
     *   -.108729833462074 ,.226189500386222 ,.508066615170332E-02,
     *   .508066615170333E-02,.400000000000000E-01,.399999999999998E-01,
     *   .399999999999998E-01,.508066615170333E-02,.400000000000000E-01,
     *   .314919333848297 ,.400000000000000E-01,.400000000000000E-01,
     *   .314919333848297 ,.314919333848297 ,-.225403330758530E-01,
     *   -.225403330758515E-01,-.100000000000000 ,-.999999999999998E-01,
     *   -.100000000000000 ,-.999999999999999E-01,-.177459666924148 ,
     *   -.177459666924149 ,.127016653792583E-01,.225403330758516E-01,
     *   .100000000000000E+00,.225403330758516E-01,.225403330758516E-01,
     *   .225403330758516E-01,.177459666924148 ,.177459666924148 ,
     *   .100000000000000E+00,.177459666924148 ,.787298334620742 ,
     *   .177459666924148 ,-.618950038622335E-02,-.312701665379256E-01,
     *   -.108729833462074 ,-.312701665379258E-01,-.312701665379254E-01,
     *   -.108729833462075 ,.226189500386222 ,-.108729833462075 ,
     *   .508066615170311E-02,.400000000000000E-01,.400000000000000E-01,
     *   .508066615170311E-02,.508066615170266E-02,.400000000000005E-01,
     *   .314919333848296 ,.400000000000005E-01,.400000000000000E-01,
     *   .314919333848297 ,.314919333848297 ,.400000000000000E-01/


      DATA POIDS/.214334705075446E-01,.342935528120713E-01,
     *    .214334705075446E-01,
     *   .342935528120713E-01,.548696844993141E-01,.342935528120713E-01,
     *   .214334705075446E-01,.342935528120713E-01,.214334705075446E-01,
     *   .342935528120713E-01,.548696844993141E-01,.342935528120713E-01,
     *   .548696844993141E-01,.877914951989026E-01,.548696844993141E-01,
     *   .342935528120713E-01,.548696844993141E-01,.342935528120713E-01,
     *   .214334705075446E-01,.342935528120713E-01,.214334705075446E-01,
     *   .342935528120713E-01,.548696844993141E-01,.342935528120713E-01,
     *   .214334705075446E-01,.342935528120713E-01,.214334705075446E-01/
 

C
      CALL EM3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),NPI,IJT,poids,
     +             vp1, vdpq2,ro,AE,delta)

      END
