      subroutine etm5noe(coor,car,iopt,ae)
c ***************************************************************
c but : calcul de la matrice de masse de l element QUAD 5NOE
c ---   4 SOUS TRIANGLES EN CROIX
c in : coor(noe,ndim) : coordones des 4 sommets.
c      car            : car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: matrice de rigidite ae(55) DEMI-MATRICE SUPERIEURE
c
c  programmeur : modulef
c .................................................................
      implicit none
      integer i, ij, N(3,4), np, j, k, ni, nj,iopt
      double precision coor(5,2),car(1),S,SS,DIV1,AE(55),X(5),Y(5),
     +                 X31,Y31,X42,Y42,rho
      DATA N/1,2,5,2,3,5,3,4,5,4,1,5/

      rho = car(1)
c
C     CALCUL DES COORDONNEES DES NOEUDS
C
      DO 1 I = 1,4
        X(I) = coor(I,1)
        Y(I) = coor(I,2)
 1    continue
      X31=X(3)-X(1)
      Y31=Y(3)-Y(1)
      X42=X(4)-X(2)
      Y42=Y(4)-Y(2)
      DIV1=1./(Y31*X42-Y42*X31)
      X(5)=(X(1)*Y31*X42-X(2)*Y42*X31+(Y(2)-Y(1))*X31*X42)*DIV1
      Y(5)=(Y(2)*Y31*X42-Y(1)*Y42*X31-(X(2)-X(1))*Y31*Y42)*DIV1
C
C     INITIALISATION
C
      DO 2 IJ=1 , 55
        AE(IJ)=0.
 2    continue
C
C     BOUCLE SUR LES SOUS-ELEMENTS
C
      DO 10 NP=1,4
         I=N(1,NP)
         J=N(2,NP)
         K=N(3,NP)
C        ET DE S=2*AIRE DU SOUS ELEMENT
         S   = (X(I)-X(J))*(Y(I)-Y(K))-(X(I)-X(K))*(Y(I)-Y(J))
         SS  = S * rho / 24.
C        ACTUALISATION DE LA MATRICE
         DO 101 K=1,2
            DO 102 I=1,3
               NI=N(I,NP)*2-2+K
               DO 103 J=1,3
                  NJ=N(J,NP)*2-2+K
                  IF(NJ.LE.NI) THEN
                     IJ=(NI-1)*NI/2+NJ
                     AE(IJ)=AE(IJ)+SS
                     IF(NJ.EQ.NI) AE(IJ)=AE(IJ)+SS
                  END IF
 103           CONTINUE
 102        CONTINUE
 101     CONTINUE
 10   CONTINUE
      END
