      subroutine etmap1d(coor,car,iopt,ae)
C ***************************************************************
C BUT : CALCUL DE LA MATRICE DE MASSE DE L ELEMENT AXI: TRIA AP1D
C --- 
c in : coor(noe,ndim) : coordones R(3), Z(3) des 3 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae            : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer ndim,NBPOLY, NPI, IP(6), n, j, l, i, iopt
      PARAMETER (ndim=2 , NBPOLY=3 , NPI=1)
      DOUBLE PRECISION P13(NBPOLY,NPI),DP13(2,NBPOLY,NPI),POIDS(NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,4),DFM1DP(2,3,3),SS(6),S,rho,car(1),
     +                 COOR(3,2),ae(21)

C     -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /  .33333333333333333D+00,  .33333333333333333D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS/ .50000000000000000D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P13 / .33333333333333333D+00,  .33333333333333333D+00,
     +           .33333333333333333D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP13/ -1.0D+00, -1.0D+00, 1.0D+00, .0D+00, .0D+00, 1.0D+00/

C
      CALL e1ap1d(nbpoly,npi,poids,p13,dp13,ip,f1,f2,dfm1dp,poidel,
     +            dfm1,coor)
C
C     F1 , F2 , DFM1 , POIDEL , IP ,  DFM1DP PRETS A L EMPLOI
C     --------------------------------------------------
      rho = car(1)
      N    = 0
      DO 3 J=1,NBPOLY
         DO 4 I=1,J
            S = 0.D0
            DO 5 L=1,NPI
               S = S + POIDEL(L) * P13(J,L) * P13(I,L)
    5       CONTINUE
            N     = N + 1
            SS(N) = S * rho
    4    CONTINUE
    3 CONTINUE
C
C     PLONGER SS DANS AE
C     ------------------
      CALL PLMASD(NBPOLY,2,SS,IP,AE)
C
      END
