      subroutine etmaq1d(coor,car,iopt,AE)
C ***************************************************************
C BUT : CALCUL DE LA MATRICE DE MASSE DE L ELEMENT AXI: quad aq1d
C --- 
c in : coor(noe,ndim) : coordones R(4), Z(4) des 4 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = rho masse volumique
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae            : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer ndim,nbpoly,npi,ip(8),iopt,n,i,j,l
      PARAMETER (ndim=2 , nbpoly=4 , npi=4)
      DOUBLE PRECISION Q13(NBPOLY,NPI),DQ13(2,NBPOLY,NPI),POIDS(NPI),
     +                 XYNPI(ndim,npi),POIDEL(nbpoly),F1(5),F2(5),
     +                 DFM1(4,4),DFM1DP(2,4,4),S,SS(10),Rho,car(10),
     +                 coor(4,2),AE(36)
C 2Q13 -- POIDS: poids du schema d'integration numerique.
      DATA POIDS/ 
     +            .25000000000000000D+00,   .25000000000000000D+00,
     +            .25000000000000000D+00,   .25000000000000000D+00 /
C     -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI/
     +            .21132486540518707D+00,   .21132486540518707D+00,
     +            .78867513459481286D+00,   .21132486540518707D+00,
     +            .78867513459481286D+00,   .78867513459481286D+00,
     +            .21132486540518707D+00,   .78867513459481286D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA Q13 /
     +           .62200846792814612D+00,   .16666666666666662D+00,
     +           .44658198738520435D-01,   .16666666666666662D+00,
     +           .16666666666666662D+00,   .62200846792814623D+00,
     +           .16666666666666662D+00,   .44658198738520449D-01,
     +           .44658198738520504D-01,   .16666666666666662D+00,
     +           .62200846792814623D+00,   .16666666666666662D+00,
     +           .16666666666666668D+00,   .44658198738520449D-01,
     +           .16666666666666662D+00,   .62200846792814623D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DQ13/
     +           -.78867513459481286D+00,  -.78867513459481286D+00,
     +            .78867513459481286D+00,  -.21132486540518707D+00,
     +            .21132486540518707D+00,   .21132486540518707D+00,
     +           -.21132486540518707D+00,   .78867513459481286D+00,
     +           -.78867513459481286D+00,  -.21132486540518713D+00,
     +            .78867513459481286D+00,  -.78867513459481286D+00,
     +            .21132486540518707D+00,   .78867513459481286D+00,
     +           -.21132486540518707D+00,   .21132486540518713D+00,
     +           -.21132486540518713D+00,  -.21132486540518713D+00,
     +            .21132486540518713D+00,  -.78867513459481286D+00,
     +            .78867513459481286D+00,   .78867513459481286D+00,
     +           -.78867513459481286D+00,   .21132486540518713D+00,
     +           -.21132486540518713D+00,  -.78867513459481286D+00,
     +            .21132486540518713D+00,  -.21132486540518707D+00,
     +            .78867513459481286D+00,   .21132486540518707D+00,
     +           -.78867513459481286D+00,   .78867513459481286D+00 /
C
C     F1 , F2 , DFM1 , POIDEL , IP , DFM1DP PRETS A L EMPLOI
C
      CALL E1AQ1C(NBPOLY,NPI,POIDS,Q13,DQ13,ip,f1,f2,DFM1dp,poidel,
     +            dfm1,COOR)
c
      rho = car(1)
      N    = 0
      DO 3 J=1,NBPOLY
         DO 4 I=1,J
            S = 0.D0
            DO 5 L=1,NPI
               S = S + POIDEL(L) * Q13(J,L) * Q13(I,L)
    5       CONTINUE
            N     = N + 1
            SS(N) = S * rho
    4    CONTINUE
    3 CONTINUE
C
C     PLONGER SS DANS AE
C     ------------------
      CALL PLMASD(NBPOLY,2,SS,IP,AE)
C
      END
