      subroutine etmdktp(coor,car,iopt,ae)
C ***************************************************************
c but: calcul de la matrice de masse de l element de plaque
c      tria DKTP (DISCRETE KIRCHHOFF THEORY)
c in : coor(noe,ndim) : coordonees des 3 sommets.
c      car            : caracteristiques des materiaux
c                       car(1) = masse volumique
c                       car(2) = epaisseur de la plaque
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae            : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer i,j,n,k,l,kk,iopt
      DOUBLE PRECISION coor(3,2),car(2),rho,epais,AE(45),X23,X31,X12,
     +                 Y23,Y31,Y12,DELTA,ROH,R(9,9),Q(45)
      DATA Q/0.960317E-01,0.103175E-01,0.153770E-02,0.103175E-01,
     + 0.942460E-03,0.153770E-02,0.353175E-01,0.674603E-02,0.376984E-02,
     + 0.960317E-01,0.376984E-02,0.644841E-03,0.545635E-03,0.103175E-01,
     + 0.153770E-02,0.674603E-02,0.124008E-02,0.644841E-03,0.103175E-01,
     + 0.942460E-03,0.153770E-02,0.353175E-01,0.376984E-02,0.674603E-02,
     + 0.353175E-01,0.674603E-02,0.376984E-02,0.960317E-01,0.674603E-02,
     + 0.644841E-03,
     + 0.124008E-02,0.376984E-02,0.644841E-03,0.545635E-03,0.103175E-01,
     + 0.153770E-02,0.376984E-02,0.545635E-03,0.644841E-03,0.674603E-02,
     + 0.124008E-02,0.644841E-03,0.103175E-01,0.942460E-03,0.153770E-02/
C
c
      X23    = coor(2,1) - coor(3,1)
      Y23    = coor(2,2) - coor(3,2)
      X31    = coor(3,1) - coor(1,1)
      Y31    = coor(3,2) - coor(1,2)
      X12    = coor(1,1) - coor(2,1)
      Y12    = coor(1,2) - coor(2,2)
      DELTA  = X31 * Y12 - X12 * Y31
      do 1 i = 1 , 9
        do 1 j = 1 , 9
          R(i,j) = 0.
 1    continue
      R(1,1) = 1
      R(4,4) = 1
      R(7,7) = 1
      R(2,2) =-Y12
      R(2,3) = X12
      R(3,2) = Y31
      R(3,3) = -X31
      R(5,5) =-Y23
      R(5,6) = X23
      R(6,5) = Y12
      R(6,6) =-X12
      R(8,8) =-Y31
      R(8,9) = X31
      R(9,8) = Y23
      R(9,9) =-X23
      if(iopt .eq. 3) then
       ROH = car(1) * DABS(DELTA)
      else
       rho   = car(1)
       epais = car(2)
       ROH = rho * epais*DABS(DELTA)
      endif
      N = 0
      DO 4 I = 1 , 9
      DO 4 J = 1 , I
        N = N + 1
        AE(N) = 0.
        DO 3 K = 1 , 9
        DO 3 L = 1 , 9
          IF(K .LT. L) THEN
            KK = (L-1)*L/2 + K
          ELSE
            KK = (K-1)*K/2 + L
          END IF
          AE(N) = AE(N) + R(K,I) * Q(KK) * R(L,J)
    3   CONTINUE
        AE(N) = AE(N) * ROH
    4 CONTINUE
      END
