      SUBROUTINE etr2p1d(coor,car,iopt,ae)
C  ....................................................................
c but : calcul de la matrice de rigidite de l element tria 2p1d
c --- 
c in : coor(noe,ndim) : coordonnees des 3 sommets.
c      car            : caracteristiques des materiaux
c      iopt = 1 isotrope Contraintes  Planes
c           = 2 isotrope Deformations Planes
c           = sinon anisotrope
c      car(6): caracteristiques des materiaux
c              if(iopt .eq. 1 .or. iopt.eq. 2) then
c                car(1) = young
c                car(2) = poisson
c              else
c                car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c              end if
c
c out: ae(21): matrice triangulaire sup
C .....................................................................
      implicit none
      integer i,iopt
      double precision coor(3,2),car(6),ae(21),x21,y21,x31,y31,
     +                 x32,y32,delta,e(6),young,poisson,unmnu,c
C
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      DELTA = X21*Y31 - X31*Y21
C
      do 2 i=1,6
         e(i) = e(i) * 0.5d+00 / delta
 2    continue
c
C  -----      COEFFICIENT DE LA MATRICE ELEMENTAIRE     -----
C
      AE(1)  =   E(1)*Y32*Y32 - 2D0*E(4)*X32*Y32          + E(6)*X32*X32
      AE(4)  = - E(1)*Y31*Y32 + E(4)*(X31*Y32 + X32*Y31)  - E(6)*X31*X32
      AE(6)  =   E(1)*Y31*Y31 - 2D0*E(4)*X31*Y31          + E(6)*X31*X31
      AE(11) =   E(1)*Y21*Y32 - E(4)*(X21*Y32 + X32*Y21)  + E(6)*X21*X32
      AE(13) = - E(1)*Y21*Y31 + E(4)*(X21*Y31 + X31*Y21)  - E(6)*X21*X31
      AE(15) =   E(1)*Y21*Y21 - 2D0*E(4)*X21*Y21          + E(6)*X21*X21
      AE(2)  = - (E(2) + E(6))*X32*Y32 + E(4)*Y32*Y32     + E(5)*X32*X32
      AE(5)  =   E(2)*X32*Y31 - E(4)*Y32*Y31-E(5)*X32*X31 + E(6)*X31*Y32
      AE(12) = - E(2)*X32*Y21 + E(4)*Y32*Y21+E(5)*X32*X21 - E(6)*X21*Y32
      AE(3)  =   E(3)*X32*X32 - 2D0*E(5)*X32*Y32          + E(6)*Y32*Y32
      AE(7)  =   E(2)*X31*Y32 - E(4)*Y31*Y32-E(5)*X31*X32 + E(6)*X32*Y31
      AE(9)  = - (E(2) + E(6))*X31*Y31 + E(4)*Y31*Y31     + E(5)*X31*X31
      AE(14) =   E(2)*X31*Y21 - E(4)*Y31*Y21-E(5)*X31*X21 + E(6)*X21*Y31
      AE(8)  = - E(3)*X31*X32 + E(5)*(X32*Y31 + X31*Y32)  - E(6)*Y31*Y32
      AE(10) =   E(3)*X31*X31 - 2D0*E(5)*X31*Y31          + E(6)*Y31*Y31
      AE(16) = - E(2)*X21*Y32 + E(4)*Y21*Y32+E(5)*X21*X32 - E(6)*X32*Y21
      AE(18) =   E(2)*X21*Y31 - E(4)*Y21*Y31-E(5)*X21*X31 + E(6)*X31*Y21
      AE(20) = - (E(2) + E(6))*X21*Y21 + E(4)*Y21*Y21     + E(5)*X21*X21
      AE(17) =   E(3)*X21*X32 - E(5)*(X32*Y21 + X21*Y32)  + E(6)*Y21*Y32
      AE(19) = - E(3)*X21*X31 + E(5)*(X31*Y21 + X21*Y31)  - E(6)*Y21*Y31
      AE(21) =   E(3)*X21*X21 - 2D0*E(5)*X21*Y21          + E(6)*Y21*Y21
C
      END
