      SUBROUTINE etr2p2c(coor,car,iopt,AE)
C  ....................................................................
c but : matrice de rigidite de l element membrane: TRIA 2P2C
c --- 
c in : coor(noe,ndim) : coor. 3 sommets + 3 milieux aretes

c      iopt = 1 isotrope Contraintes  Planes
c           = 2 isotrope Deformations Planes
c           = sinon anisotrope
c      car(6): caracteristiques des materiaux
c              if(iopt .eq. 1 .or. iopt.eq. 2) then
c                car(1) = young
c                car(2) = poisson
c              else
c                car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c              end if
c out: ae(78)        : matrice triangulaire sup
C .....................................................................
      implicit none
      integer IJT(12),IBLT(3),JBLT(3),i,j,ibloc,i1,i2,i3,i4,ifin,j1,
     +        kk,kin,iopt
      DOUBLE PRECISION coor(6,2),car(6),AE(78),X21,Y21,X31,Y31,X32,Y32,
     +                 X41,Y41,X42,Y42,X54,Y54,X61,Y61,X63,Y63,X65,Y65,
     +                 C1,C,E(6),DELTA(3),DPX(3,6),DPY(3,6),
     +                 FDEDF(4,3),DFINV(4,3),young,poisson,unmnu
C
      DATA IJT/ 1, 3, 5, 7, 9, 11, 2, 4, 6, 8, 10, 12/
      DATA IBLT/ 0, 0, 6/
      DATA JBLT/ 0, 6, 6/
      DATA DPX/ -1.D0 ,  1.D0 , -1.D0 ,2*1.D0 , -1.D0 ,4*0.D0 , -2.D0 ,
     +           2.D0 ,  0.D0 ,2*2.D0 ,  0.D0 ,2*-2.D0/
      DATA DPY/ -1.D0 ,  1.D0 , -1.D0 ,3*0.D0 , -1.D0 ,2*1.D0 ,2*-2.D0,
     +           0.D0 ,2*2.D0 ,  0.D0 ,  2.D0 , -2.D0 ,  0.D0/
C
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      X41  = coor(4,1) - coor(1,1)
      Y41  = coor(4,2) - coor(1,2)
      X42  = coor(4,1) - coor(2,1)
      Y42  = coor(4,2) - coor(2,2)
      X54  = coor(5,1) - coor(4,1)
      Y54  = coor(5,2) - coor(4,2)
      X61  = coor(6,1) - coor(1,1)
      Y61  = coor(6,2) - coor(1,2)
      X63  = coor(6,1) - coor(3,1)
      Y63  = coor(6,2) - coor(3,2)
      X65  = coor(6,1) - coor(5,1)
      Y65  = coor(6,2) - coor(5,2)
C
      IF(iopt .eq. 1) THEN
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      ELSE IF(iopt .eq. 2) THEN
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
C  ----       CALCUL DE DFINV :  INVERSE DE DF    ----
C
      DFINV(1,1) = 2.D0 * Y54 + Y61 + Y63
      DFINV(1,2) = 2.D0 * Y54 - Y61 - Y63
      DFINV(1,3) =    Y31
C
      DFINV(2,1) =  - (2.D0 * X54 + X61 + X63)
      DFINV(2,2) =  - (2.D0 * X54 - X61 - X63)
      DFINV(2,3) =  - X31
C
      DFINV(3,1) =  - Y21
      DFINV(3,2) =  2.D0 * Y65 + Y41 + Y42
      DFINV(3,3) =  2.D0 * Y65 - Y41 - Y42
C
      DFINV(4,1) =    X21
      DFINV(4,2) =  - (2.D0 * X65 + X41 + X42)
      DFINV(4,3) =  - (2.D0 * X65 - X41 - X42)
C
      DO 2 J=1,3
         DELTA(J) = DFINV(4,J)*DFINV(1,J) - DFINV(3,J)*DFINV(2,J)
 2    CONTINUE
C
C  -----      COEFFICIENT DE LA MATRICE ELEMENTAIRE     -----
C
      DO 10 ibloc = 1 , 3
        IF (iopt.eq.1 .or. iopt.eq.2) then
c         -- isotrope Deformations planes ou Contraintes planes
          if(ibloc .eq. 1) then
C           -- BLOC  1,1 DE    TDF * TD * E * D * DF   (ISOTROPE)
            DO 3 J=1,3
              FDEDF(1,J) =   E(1) * DFINV(1,J) * DFINV(1,J)
     +                    +  E(6) * DFINV(2,J) * DFINV(2,J)
              FDEDF(2,J) =   E(1) * DFINV(3,J) * DFINV(1,J)
     +                    +  E(6) * DFINV(4,J) * DFINV(2,J)
              FDEDF(3,J) =   FDEDF(2,J)
              FDEDF(4,J) =   E(1) * DFINV(3,J) * DFINV(3,J)
     +                   +  E(6) * DFINV(4,J) * DFINV(4,J)
 3          CONTINUE
          elseif(ibloc .eq. 2) then
C           --- BLOC  1,2
            DO 4 J=1,3
              FDEDF(1,J) =   (E(2) + E(6))  * DFINV(2,J) * DFINV(1,J)
              FDEDF(2,J) =  E(6) * DFINV(4,J) * DFINV(1,J)
     +                   +  E(2) * DFINV(2,J) * DFINV(3,J)
              FDEDF(3,J) =  E(6) * DFINV(2,J) * DFINV(3,J)
     +                   +  E(2) * DFINV(1,J) * DFINV(4,J)
              FDEDF(4,J) =   (E(2) + E(6))  * DFINV(4,J) * DFINV(3,J)
 4          CONTINUE
          elseif(ibloc .eq. 3) then
C           --- BLOC  2,2
            DO 5 J=1,3
              FDEDF(1,J) =  E(3) * DFINV(2,J) * DFINV(2,J)
     +                   +  E(6) * DFINV(1,J) * DFINV(1,J)
              FDEDF(2,J) =  E(3) * DFINV(4,J) * DFINV(2,J)
     +                   +  E(6) * DFINV(3,J) * DFINV(1,J)
              FDEDF(3,J) =  FDEDF(2,J)
              FDEDF(4,J) =  E(3) * DFINV(4,J) * DFINV(4,J)
     +                   +  E(6) * DFINV(3,J) * DFINV(3,J)
 5          CONTINUE
          endif
        else
c         -- anisotrope
          if(ibloc .eq. 1) then
C           ---  BLOC  1,1        CAS   ANISOTROPE
            I1 = 1
            I2 = 4
            I3 = 4
            I4 = 6
          elseif(ibloc .eq. 2) then
C           --- BLOC  1,2
            I1 = 4
            I2 = 6
            I3 = 2
            I4 = 5
          elseif(ibloc .eq. 3) then
C           --- BLOC  2,2
            I1 = 6
            I2 = 5
            I3 = 5
            I4 = 3
          endif
c
          DO 6 J=1,3
            FDEDF(1,J) =   E(I1) * DFINV(1,J) * DFINV(1,J)
     +                  +  E(I4) * DFINV(2,J) * DFINV(2,J)
     +                  + (E(I2) + E(I3)) * DFINV(2,J) * DFINV(1,J)
            FDEDF(2,J) =   E(I1) * DFINV(3,J) * DFINV(1,J)
     +                  +  E(I4) * DFINV(4,J) * DFINV(2,J)
     +                  +  E(I2) * DFINV(4,J) * DFINV(1,J)
     +                  +  E(I3) * DFINV(2,J) * DFINV(3,J)
            FDEDF(3,J) =   E(I1) * DFINV(3,J) * DFINV(1,J)
     +                  +  E(I4) * DFINV(4,J) * DFINV(2,J)
     +                  +  E(I3) * DFINV(4,J) * DFINV(1,J)
     +                  +  E(I2) * DFINV(2,J) * DFINV(3,J)
            FDEDF(4,J) =   E(I4) * DFINV(4,J) * DFINV(4,J)
     +                  +  E(I1) * DFINV(3,J) * DFINV(3,J)
     +                  + (E(I2) + E(I3)) * DFINV(4,J) * DFINV(3,J)
 6        CONTINUE
        end if
C
C       -- CALCUL DE AE  ( CONTRIBUTION DU BLOC )
C       --   1.  GESTION DES BLOCS ( IBLOC )
C       --   2.  PASSAGE AU RANGEMENT PAR D.L. ( IJT )
C
        DO 9 J=1,6
          IFIN = J
          IF(IBLOC .EQ. 2) IFIN = 6
          DO 8 I=1,IFIN
             I1 = IBLT(IBLOC) + I
             J1 = JBLT(IBLOC) + J
             IF ( IJT(I1) .le. IJT(J1) ) then
               KK = IJT(J1) * ( IJT(J1) -1 ) / 2  + IJT(I1)
             else
               KK = IJT(I1) * ( IJT(I1) -1 ) / 2  + IJT(J1)
             endif
             C = 0.D+00
             DO 7 KIN=1,3
                C1 =    FDEDF(1,KIN) * DPX(KIN,J) * DPX(KIN,I)
     +                + FDEDF(2,KIN) * DPX(KIN,J) * DPY(KIN,I)
     +                + FDEDF(3,KIN) * DPX(KIN,I) * DPY(KIN,J)
     +                + FDEDF(4,KIN) * DPY(KIN,I) * DPY(KIN,J)
                C = C + C1 / DELTA(KIN)
 7           CONTINUE
             AE(KK) = C / 6.D+00
 8        CONTINUE
 9      CONTINUE
C
 10   continue
C
      END
