      SUBROUTINE etr2q1d(coor,car,iopt,ae)
C  ....................................................................
c but : calcul de la matrice de rigidite de l element quad 2q1d
c --- 
c in : coor(noe,ndim) : coordones des 4 sommets.
c      car            : caracteristiques des materiaux
c      iopt = 1 isotrope Deformations Planes
c           = 2 isotrope Contraintes  Planes
c           = sinon anisotrope
c      car(6): caracteristiques des materiaux
c              if(iopt .eq. 1 .or. iopt.eq. 2) then
c                car(1) = young
c                car(2) = poisson
c              else
c                car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c              end if
c
c out: ae(36): matrice triangulaire sup
C .....................................................................
      implicit none
      integer i,iopt
      DOUBLE PRECISION coor(4,2),car(6),ae(36),X21,Y21,X31,Y31,
     +                 X32,Y32,X41,Y41,X43,Y43,X42,Y42,X42C,Y42C,X41C,
     +                 Y41C,X21C,Y21C,X32C,Y32C,X31C,Y31C,X43C,Y43C,
     +                 DELT1,DELT2,DELT3,DELT4,DEL1,DEL2,DEL3,DEL4,
     +                 E(6),young,poisson,unmnu,c
C
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
      x21  = coor(2,1) - coor(1,1)
      y21  = coor(2,2) - coor(1,2)
      x31  = coor(3,1) - coor(1,1)
      y31  = coor(3,2) - coor(1,2)
      x32  = coor(3,1) - coor(2,1)
      y32  = coor(3,2) - coor(2,2)
      x41  = coor(4,1) - coor(1,1)
      y41  = coor(4,2) - coor(1,2)
      x42  = coor(4,1) - coor(2,1)
      y42  = coor(4,2) - coor(2,2)
      x43  = coor(4,1) - coor(3,1)
      y43  = coor(4,2) - coor(3,2)
C
      DELT1  = X21*Y41 - X41*Y21
      DELT2  = X21*Y32 - X32*Y21
      DELT3  = X32*Y43 - X43*Y32
      DELT4  = X41*Y43 - X43*Y41
C
      Y42C  = Y42*Y42
      X42C  = X42*X42
      Y41C  = Y41*Y41
      X41C  = X41*X41
      Y21C  = Y21*Y21
      X21C  = X21*X21
      Y32C  = Y32*Y32
      X32C  = X32*X32
      Y31C  = Y31*Y31
      X31C  = X31*X31
      Y43C  = Y43*Y43
      X43C  = X43*X43
      DEL1  = .25D+00 / DELT1
      DEL2  = .25D+00 / DELT2
      DEL3  = .25D+00 / DELT3
      DEL4  = .25D+00 / DELT4
C
      AE(1) =  (e(1)*Y42C + e(6)*X42C - 2.D00*e(4)*X42*Y42) * DEL1
     +       + (e(1)*Y43C + e(6)*X43C - 2.D00*e(4)*X43*Y43) * DEL4
     +       + (e(1)*Y32C + e(6)*X32C - 2.D00*e(4)*X32*Y32) * DEL2
      AE(4) =- (e(1)*Y42*Y41+e(6)*X41*X42-e(4)*(X41*Y42+X42*Y41)) * DEL1
     +       - (e(1)*Y31*Y32+e(6)*X31*X32-e(4)*(X31*Y32+X32*Y31)) * DEL2
      AE(6) =  (e(1)*Y41C + e(6)*X41C - 2.D00*e(4)*X41*Y41) * DEL1
     +       + (e(1)*Y31C + e(6)*X31C - 2.D00*e(4)*X31*Y31) * DEL2
     +       + (e(1)*Y43C + e(6)*X43C - 2.D00*e(4)*X43*Y43) * DEL3
      AE(11)=  (e(1)*Y21*Y32+e(6)*X21*X32-e(4)*(X21*Y32+X32*Y21)) * DEL2
     +       - (e(1)*Y41*Y43+e(6)*X41*X43-e(4)*(X41*Y43+X43*Y41)) * DEL4
      AE(13)=- (e(1)*Y21*Y31+e(6)*X21*X31-e(4)*(X21*Y31+X31*Y21)) * DEL2
     +       - (e(1)*Y42*Y43+e(6)*X43*X42-e(4)*(X42*Y43+X43*Y42)) * DEL3
      AE(15)=  (e(1)*Y21C + e(6)*X21C - 2.D00*e(4)*X21*Y21) * DEL2
     +       + (e(1)*Y42C + e(6)*X42C - 2.D00*e(4)*X42*Y42) * DEL3
     +       + (e(1)*Y41C + e(6)*X41C - 2.D00*e(4)*X41*Y41) * DEL4
      AE(22)=  (e(1)*Y42*Y21+e(6)*X42*X21-e(4)*(X21*Y42+X42*Y21)) * DEL1
     +       + (e(1)*Y31*Y43+e(6)*X31*X43-e(4)*(X31*Y43+X43*Y31)) * DEL4
      AE(24)=- (e(1)*Y41*Y21+e(6)*X41*X21-e(4)*(X21*Y41+X41*Y21)) * DEL1
     +       + (e(1)*Y32*Y43+e(6)*X32*X43-e(4)*(X32*Y43+X43*Y32)) * DEL3
      AE(26)=- (e(1)*Y32*Y42+e(6)*X32*X42-e(4)*(X32*Y42+X42*Y32)) * DEL3
     +       - (e(1)*Y31*Y41+e(6)*X31*X41-e(4)*(X31*Y41+X41*Y31)) * DEL4
      AE(28)=  (e(1)*Y21C + e(6)*X21C - 2.D00*e(4)*X21*Y21) * DEL1
     +       + (e(1)*Y32C + e(6)*X32C - 2.D00*e(4)*X32*Y32) * DEL3
     +       + (e(1)*Y31C + e(6)*X31C - 2.D00*e(4)*X31*Y31) * DEL4
      AE(2) =- ((e(2)+e(6))*X42*Y42 - e(4)*Y42C - e(5)*X42C) * DEL1
     +       - ((e(2)+e(6))*X32*Y32 - e(4)*Y32C - e(5)*X32C) * DEL2
     +       - ((e(2)+e(6))*Y43*X43 - e(4)*Y43C - e(5)*X43C) * DEL4
      AE(5) = (e(2)*X42*Y41+e(6)*Y42*X41-e(4)*Y42*Y41-e(5)*X42*X41)*DEL1
     +      + (e(2)*X32*Y31+e(6)*Y32*X31-e(4)*Y32*Y31-e(5)*X32*X31)*DEL2
      AE(12)=-(e(2)*X32*Y21+e(6)*X21*Y32-e(4)*Y32*Y21-e(5)*X32*X21)*DEL2
     +      + (e(2)*X43*Y41+e(6)*Y43*X41-e(4)*Y43*Y41-e(5)*X43*X41)*DEL4
      AE(23)=-(e(2)*X42*Y21+e(6)*Y42*X21-e(4)*Y42*Y21-e(5)*X42*X21)*DEL1
     +      - (e(2)*X43*Y31+e(6)*Y43*X31-e(4)*Y43*Y31-e(5)*X43*X31)*DEL4
      AE(3) =  (e(6)*Y42C + e(3)*X42C - 2.D00*e(5)*X42*Y42) * DEL1
     +       + (e(6)*Y43C + e(3)*X43C - 2.D00*e(5)*X43*Y43) * DEL4
     +       + (e(6)*Y32C + e(3)*X32C - 2.D00*e(5)*X32*Y32) * DEL2
      AE(7) = (e(2)*X41*Y42+e(6)*Y41*X42-e(4)*Y41*Y42-e(5)*X41*X42)*DEL1
     +      + (e(2)*X31*Y32+e(6)*X32*Y31-e(4)*Y31*Y32-e(5)*X31*X32)*DEL2
      AE(9) =- ((e(2)+e(6))*X41*Y41 - e(4)*Y41C - e(5)*X41C) * DEL1
     +       - ((e(2)+e(6))*X31*Y31 - e(4)*Y31C - e(5)*X31C) * DEL2
     +       - ((e(2)+e(6))*X43*Y43 - e(4)*Y43C - e(5)*X43C) * DEL3
      AE(14)= (e(2)*X31*Y21+e(6)*X21*Y31-e(4)*Y31*Y21-e(5)*X31*X21)*DEL2
     +      + (e(2)*X43*Y42+e(6)*X42*Y43-e(4)*Y43*Y42-e(5)*X43*X42)*DEL3
      AE(25)= (e(2)*X41*Y21+e(6)*X21*Y41-e(4)*Y41*Y21-e(5)*X41*X21)*DEL1
     +      - (e(2)*X43*Y32+e(6)*Y43*X32-e(4)*Y43*Y32-e(5)*X43*X32)*DEL3
      AE(8) =- (e(6)*Y42*Y41+e(3)*X41*X42-e(5)*(X42*Y41+X41*Y42)) * DEL1
     +       - (e(6)*Y31*Y32+e(3)*X31*X32-e(5)*(X32*Y31+X31*Y32)) * DEL2
      AE(10)=  (e(6)*Y41C + e(3)*X41C - 2.D00*e(5)*X41*Y41) * DEL1
     +       + (e(6)*Y31C + e(3)*X31C - 2.D00*e(5)*X31*Y31) * DEL2
     +       + (e(6)*Y43C + e(3)*X43C - 2.D00*e(5)*X43*Y43) * DEL3
      AE(16)=-(e(2)*X21*Y32+e(6)*Y21*X32-e(4)*Y21*Y32-e(5)*X21*X32)*DEL2
     +      + (e(2)*X41*Y43+e(6)*X43*Y41-e(4)*Y41*Y43-e(5)*X41*X43)*DEL4
      AE(18)= (e(2)*X21*Y31+e(6)*X31*Y21-e(4)*Y21*Y31-e(5)*X21*X31)*DEL2
     +      + (e(2)*X42*Y43+e(6)*Y42*X43-e(4)*Y42*Y43-e(5)*X42*X43)*DEL3
      AE(20)=- ((e(2)+e(6))*Y21*X21 - e(4)*Y21C - e(5)*X21C) * DEL2
     +       - ((e(2)+e(6))*X42*Y42 - e(4)*Y42C - e(5)*X42C) * DEL3
     +       - ((e(2)+e(6))*X41*Y41 - e(4)*Y41C - e(5)*X41C) * DEL4
      AE(27)= (e(2)*X42*Y32+e(6)*Y42*X32-e(4)*Y42*Y32-e(5)*X42*X32)*DEL3
     +      + (e(2)*X41*Y31+e(6)*Y41*X31-e(4)*Y41*Y31-e(5)*X41*X31)*DEL4
      AE(17)= (e(6)*Y21*Y32+e(3)*X21*X32-e(5)*(Y21*X32+Y32*X21)) * DEL2
     +      - (e(6)*Y41*Y43+e(3)*X41*X43-e(5)*(Y41*X43+Y43*X41)) * DEL4
      AE(19)=- (e(6)*Y21*Y31+e(3)*X21*X31-e(5)*(Y21*X31+Y31*X21)) * DEL2
     +       - (e(6)*Y42*Y43+e(3)*X43*X42-e(5)*(Y42*X43+Y43*X42)) * DEL3
      AE(21)=  (e(6)*Y21C + e(3)*X21C - 2.D00*e(5)*X21*Y21) * DEL2
     +       + (e(6)*Y42C + e(3)*X42C - 2.D00*e(5)*X42*Y42) * DEL3
     +       + (e(6)*Y41C + e(3)*X41C - 2.D00*e(5)*X41*Y41) * DEL4
      AE(29)=-(e(2)*X21*Y42+e(6)*X42*Y21-e(4)*Y21*Y42-e(5)*X21*X42)*DEL1
     +      - (e(2)*X31*Y43+e(6)*Y31*X43-e(4)*Y31*Y43-e(5)*X31*X43)*DEL4
      AE(31)= (e(2)*X21*Y41+e(6)*X41*Y21-e(4)*Y21*Y41-e(5)*X21*X41)*DEL1
     +      - (e(2)*X32*Y43+e(6)*X43*Y32-e(4)*Y32*Y43-e(5)*X32*X43)*DEL3
      AE(33)= (e(2)*X32*Y42+e(6)*Y32*X42-e(4)*Y32*Y42-e(5)*X32*X42)*DEL3
     +      + (e(2)*X31*Y41+e(6)*X41*Y31-e(4)*Y31*Y41-e(5)*X31*X41)*DEL4
      AE(35)=- ((e(6)+e(2))*X21*Y21-e(4)*Y21C-e(5)*X21C) * DEL1
     +       - ((e(2)+e(6))*X32*Y32-e(4)*Y32C-e(5)*X32C) * DEL3
     +       - ((e(2)+e(6))*X31*Y31-e(4)*Y31C-e(5)*X31C) * DEL4
      AE(30)=  (e(6)*Y42*Y21+e(3)*X42*X21-e(5)*(X42*Y21+X21*Y42)) * DEL1
     +       + (e(6)*Y31*Y43+e(3)*X31*X43-e(5)*(Y31*X43+Y43*X31)) * DEL4
      AE(32)=- (e(6)*Y41*Y21+e(3)*X41*X21-e(5)*(Y21*X41+Y41*X21)) * DEL1
     +       + (e(6)*Y32*Y43+e(3)*X32*X43-e(5)*(X43*Y32+X32*Y43)) * DEL3
      AE(34)=- (e(6)*Y32*Y42+e(3)*X32*X42-e(5)*(Y32*X42+X32*Y42)) * DEL3
     +       - (e(6)*Y31*Y41+e(3)*X31*X41-e(5)*(Y31*X41+Y41*X31)) * DEL4
      AE(36)=  (e(6)*Y21C+e(3)*X21C - 2.D00*e(5)*X21*Y21) * DEL1
     +       + (e(6)*Y32C+e(3)*X32C - 2.D00*e(5)*X32*Y32) * DEL3
     +       + (e(6)*Y31C+e(3)*X31C - 2.D00*e(5)*X31*Y31) * DEL4
C
       END
