      subroutine etr2q2c(coor,car,iopt,AE)
C  ....................................................................
c but : matrice de rigidite de l element membrane:  QUAD 2Q2C
c --- 
c in : coor(noe,ndim) : coordonees 8 noeuds
c
c      iopt = 1 isotrope Deformations Planes
c           = 2 isotrope Contraintes  Planes
c           = sinon anisotrope
c      car(6): caracteristiques des materiaux
c              if(iopt .eq. 1 .or. iopt.eq. 2) then
c                car(1) = young
c                car(2) = poisson
c              else
c                car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c              end if
c out: ae(136)        : matrice triangulaire sup
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer IJT(16),IBLT(3),JBLT(3),ndim,nbpol,npi,iopt,i,k,ibloc,
     +        j,i1,i2,i3,i4,kin,j1,kk,ij,ifin
      PARAMETER (ndim=2 , NBPOL=8 , NPI=9)
      DOUBLE PRECISION COOR(8,2),car(6),ae(136),P25(NBPOL,NPI),
     +                 DP25(2,NBPOL,NPI),POIDS(NPI),
     +                 XYNPI(ndim,npi),
     +                 delta(9),F11(9),F12(9),F21(9),F22(9),
     +                 E(6),FDEDF(4,9),DFINV(4,npi),
     +                 AUX1(64),c,young,poisson,unmnu

      DATA IJT/ 1, 3, 5, 7, 9, 11, 13, 15, 2, 4, 6, 8, 10, 12, 14, 16/
      DATA IBLT/ 0, 0, 8/
      DATA JBLT/ 0, 8, 8/
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
c
        do 20 J = 1 , 136
          ae(j) = 0.d0
 20     continue
c
      IF(iopt .eq. 1) THEN
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      ELSE IF(iopt .eq. 2) THEN
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 1 i = 1 , 6
           E(i) = car(i)
 1      continue
      end if
C
C    -----   CALCUL DE DELTA AUX NPI NOEUDS  -----
C
      DO 2 K=1,NPI
        F11(K) = 0.D0
        F12(K) = 0.D0
        F21(K) = 0.D0
        F22(K) = 0.D0
 2    CONTINUE
      DO 4 K=1,NPI                             
        DO 3 I=1,NBPOL
          F11(K) = F11(K) + DP25(1,I,K) * coor(I,1)
          F12(K) = F12(K) + DP25(2,I,K) * coor(I,1)
          F21(K) = F21(K) + DP25(1,I,K) * coor(I,2)
          F22(K) = F22(K) + DP25(2,I,K) * coor(I,2)
 3      CONTINUE
        DELTA(K) = F11(K) * F22(K) - F12(K) * F21(K)
 4    CONTINUE
C
C  ----       CALCUL DE DFINV :  INVERSE DE DF    ----
C
      DO 5 K=1,NPI
         DFINV(1,K) =   F22(K)
         DFINV(2,K) = - F12(K)
         DFINV(3,K) = - F21(K)
         DFINV(4,K) =   F11(K)
 5    CONTINUE
C
C  -----      COEFFICIENT DE LA MATRICE ELEMENTAIRE     -----
C
      DO 13 ibloc = 1 , 3
        IF (iopt.eq.1 .or. iopt.eq.2) then
c         -- isotrope Deformations planes ou Contraintes planes
          if(ibloc .eq. 1) then
C           -- BLOC  1,1 DE    TDF * TD * E * D * DF   (ISOTROPE)
            DO 6 J=1,NPI
              FDEDF(1,J) =   E(1) * DFINV(1,J) * DFINV(1,J)
     +                   +  E(6) * DFINV(2,J) * DFINV(2,J)
              FDEDF(2,J) =   E(1) * DFINV(3,J) * DFINV(1,J)
     +                   +  E(6) * DFINV(4,J) * DFINV(2,J)
              FDEDF(3,J) =   FDEDF(2,J)
              FDEDF(4,J) =   E(1) * DFINV(3,J) * DFINV(3,J)
     +                   +  E(6) * DFINV(4,J) * DFINV(4,J)
 6          CONTINUE
          elseif(ibloc .eq. 2) then
C           --- BLOC  1,2
            DO 7 J=1,NPI
              FDEDF(1,J) =   (E(2) + E(6))  * DFINV(2,J) * DFINV(1,J)
              FDEDF(2,J) =  E(6) * DFINV(4,J) * DFINV(1,J)
     +                   +  E(2) * DFINV(2,J) * DFINV(3,J)
              FDEDF(3,J) =  E(6) * DFINV(2,J) * DFINV(3,J)
     +                   +  E(2) * DFINV(1,J) * DFINV(4,J)
              FDEDF(4,J) =   (E(2) + E(6))  * DFINV(4,J) * DFINV(3,J)
 7          CONTINUE
          elseif(ibloc .eq. 3) then
C           --- BLOC  2,2
            DO 8 J=1,NPI
              FDEDF(1,J) =  E(3) * DFINV(2,J) * DFINV(2,J)
     +                   +  E(6) * DFINV(1,J) * DFINV(1,J)
              FDEDF(2,J) =  E(3) * DFINV(4,J) * DFINV(2,J)
     +                   +  E(6) * DFINV(3,J) * DFINV(1,J)
              FDEDF(3,J) =  FDEDF(2,J)
              FDEDF(4,J) =  E(3) * DFINV(4,J) * DFINV(4,J)
     +                   +  E(6) * DFINV(3,J) * DFINV(3,J)
 8          CONTINUE
          endif
        else
c         -- anisotrope
          if(ibloc .eq. 1) then
C           ---  BLOC  1,1        CAS   ANISOTROPE
            I1 = 1
            I2 = 4
            I3 = 4
            I4 = 6
          elseif(ibloc .eq. 2) then
C           --- BLOC  1,2
            I1 = 4
            I2 = 6
            I3 = 2
            I4 = 5
          elseif(ibloc .eq. 3) then
C           --- BLOC  2,2
            I1 = 6
            I2 = 5
            I3 = 5
            I4 = 3
          endif
c
          DO 9 J = 1,NPI
            FDEDF(1,J) =   E(I1) * DFINV(1,J) * DFINV(1,J)
     +                 +  E(I4) * DFINV(2,J) * DFINV(2,J)
     +                 + (E(I2) + E(I3)) * DFINV(2,J) * DFINV(1,J)
            FDEDF(2,J) =   E(I1) * DFINV(3,J) * DFINV(1,J)
     +                 +  E(I4) * DFINV(4,J) * DFINV(2,J)
     +                 +  E(I2) * DFINV(4,J) * DFINV(1,J)
     +                 +  E(I3) * DFINV(2,J) * DFINV(3,J)
            FDEDF(3,J) =   E(I1) * DFINV(3,J) * DFINV(1,J)
     +                 +  E(I4) * DFINV(4,J) * DFINV(2,J)
     +                 +  E(I3) * DFINV(4,J) * DFINV(1,J)
     +                 +  E(I2) * DFINV(2,J) * DFINV(3,J)
            FDEDF(4,J) =   E(I4) * DFINV(4,J) * DFINV(4,J)
     +                 +  E(I1) * DFINV(3,J) * DFINV(3,J)
     +                 + (E(I2) + E(I3)) * DFINV(4,J) * DFINV(3,J)
 9        continue
        end if
C
C       -- CALCUL DE AE:  BLOCS (IBLOC) et  PASSAGE AU PAR D.L. (IJT)
        DO 12 KIN = 1 , NPI
          if(ibloc .ne. 2) then
           CALL TABA2D(NBPOL, 2,DP25(1,1,KIN),FDEDF(1,KIN),AUX1)
          else
           CALL TABA6D(NBPOL, 2,DP25(1,1,KIN),FDEDF(1,KIN),AUX1)
          end if
c
          DO 11 J=1,NBPOL
            IFIN = J
            IF ( IBLOC .EQ. 2 ) IFIN = NBPOL
            DO 10 I=1,IFIN
               I1 = IBLT(IBLOC) + I
               J1 = JBLT(IBLOC) + J
               IF ( IJT(I1) .le. IJT(J1) ) then
                 KK = IJT(J1) * ( IJT(J1) -1 ) / 2  + IJT(I1)
               else
                 KK = IJT(I1) * ( IJT(I1) -1 ) / 2  + IJT(J1)
               endif
               IJ = J * ( J - 1) / 2 + I
               IF ( IBLOC .EQ. 2 ) IJ = 8 * ( J - 1 ) + I
               AE(KK) = AE(KK) + AUX1(IJ) * POIDS(KIN) / DELTA(KIN)
 10         CONTINUE
 11       CONTINUE

 12     CONTINUE
 13   continue
c
      END














