      SUBROUTINE ETR3P2c(COOR,car,iopt,AE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DE LA MATRICE ELEMENTAIRE ELASTIQUE DE RIGIDITE
C  ---     TETRAEDRE P2 ISOPARAMETRIQUE
c          formule d'integration a 15 points, (Gauss)
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : TABLEAUX DES COORDONNEES DES POINTS DE L ELEMENT
c   ijt     : permutation pour oasser de la numerotation par inconnues
c             a celle par noeuds
c   nno     : nombre de noeuds de l'element
c   npo     : nombre de points
c   npi     : nombre de points d'integration
c   dp      : valeur des derivees des polynomes de base aux points
c             d'integration sur l'element de reference
c   vp1     : valeur des polynomes de base aux points
c             d'integration sur l'element de reference
c   poids   : poids de la formule d'integration
c
c  tableaux de travail :
c  -------------------
c   delta   : jacobien aux points d'integration
c   (x y z)int : coordonnees des points d'integration sur 
c              l'element courant
C
C  PARAMETRE DE SORTIE  :
C  --------------------
C   AE     : MATRICE DE RIGIDITE . SYMETRIQUE
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEURS  : Marina Vidrascu 2001
C ...................................................................
C
      parameter (ndim=3, nno=10, npo=10, npi=15)
      DOUBLE PRECISION ae(NNO*3*(NNO*3+1)/2)
      DOUBLE PRECISION COOR(npo,3),xint(npi),yint(npi),zint(npi)
      DIMENSION IJT(ndim*nno)
      double precision poids(npi),elas(9),delta(npi),
     &                 a2(ndim,nno,npi),vp1(nno,npi),
     &                 VDPQ2(ndim,nno,npi),car(iopt)

      double precision dp1(ndim,nno,5),dp2(ndim,nno,5),dp3(ndim,nno,5)
      equivalence (dp1,VDPQ2(1,1,1)), (dp2,VDPQ2(1,1,6)),
     *            (dp3,VDPQ2(1,1,11))

c
      DATA IJT/ 1, 4, 7,10,13,16,19,22,25,28,
     *          2, 5, 8,11,14,17,20,23,26,29,
     *          3, 6, 9,12,15,18,21,24,27,30/
      DATA dp1/.0000000000000E+00,.000000000000E+00,.00000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00, -1.00000000000000 , -1.00000000000000 ,
     *     1.00000000000000 ,  1.00000000000000 , .000000000000000E+00,
     *    -1.00000000000000 , .000000000000000E+00, -1.00000000000000 ,
     *    -1.00000000000000 , -1.00000000000000 , .000000000000000E+00,
     *     1.00000000000000 , .000000000000000E+00,  1.00000000000000 ,
     *    .000000000000000E+00,  1.00000000000000 ,  1.00000000000000 ,
     *    -1.89634706336732 , -1.89634706336732 , -1.89634706336732 ,
     *    -.632115687789108 ,.000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *     2.52846275115643 , -.367884312210892 , -.367884312210892 ,
     *    .367884312210892 , .367884312210892 , .000000000000000E+00,
     *    -.367884312210892 ,  2.52846275115643 , -.367884312210892 ,
     *    -.367884312210892 , -.367884312210892 ,  2.52846275115643 ,
     *    .367884312210892 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00, .367884312210892 , .367884312210892 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *     1.89634706336732 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *    -2.52846275115643 , -2.89634706336732 , -2.89634706336732 ,
     *    .367884312210892 ,  2.89634706336732 , .000000000000000E+00,
     *    -.367884312210892 , .000000000000000E+00, -.367884312210892 ,
     *    -.367884312210892 , -.367884312210892 , .000000000000000E+00,
     *    .367884312210892 , .000000000000000E+00,  2.89634706336732 ,
     *    .000000000000000E+00, .367884312210892 , .367884312210892 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *    -.632115687789108 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00,  1.89634706336732,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *    .000000000000000E+00, -.367884312210892 , -.367884312210892 ,
     *     2.89634706336732 , .367884312210892 , .000000000000000E+00,
     *    -2.89634706336732 , -2.52846275115643 , -2.89634706336732 ,
     *    -.367884312210892 , -.367884312210892 , .000000000000000E+00,
     *    .367884312210892 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00, .367884312210892 ,  2.89634706336732 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *    -.632115687789108 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, 1.89634706336732 ,
     *    .000000000000000E+00, -.367884312210892 , -.367884312210892 ,
     *    .367884312210892 , .367884312210892 , .000000000000000E+00,
     *    -.367884312210892 , .000000000000000E+00, -.367884312210892 ,
     *    -2.89634706336732 , -2.89634706336732 , -2.52846275115643 ,
     *     2.89634706336732 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00,  2.89634706336732 , .367884312210892/

       data dp2 /.837523533955559 , .837523533955559 , .837523533955559,
     *    .279174511318520, .00000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *    -1.11669804527408 , -1.27917451131852 , -1.27917451131852 ,
     *     1.27917451131852 ,  1.27917451131852 , .000000000000000E+00,
     *    -1.27917451131852 , -1.11669804527408 , -1.27917451131852 ,
     *    -1.27917451131852 , -1.27917451131852 , -1.11669804527408 ,
     *     1.27917451131852 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00,  1.27917451131852 ,  1.27917451131852 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    -.837523533955559 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *     1.11669804527408 , -.162476466044441 , -.162476466044441 ,
     *     1.27917451131852 , .162476466044441 , .000000000000000E+00,
     *    -1.27917451131852 , .000000000000000E+00, -1.27917451131852 ,
     *    -1.27917451131852 , -1.27917451131852 , .000000000000000E+00,
     *     1.27917451131852 , .000000000000000E+00, .162476466044441 ,
     *    .000000000000000E+00,  1.27917451131852 ,  1.27917451131852 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    .279174511318520 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.837523533955559 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *    .000000000000000E+00, -1.27917451131852 , -1.27917451131852 ,
     *    .162476466044441 ,  1.27917451131852 , .000000000000000E+00,
     *    -.162476466044441 ,  1.11669804527408 , -.162476466044441 ,
     *    -1.27917451131852 , -1.27917451131852 , .000000000000000E+00,
     *     1.27917451131852 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00,  1.27917451131852 , .162476466044441 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    .279174511318520 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.837523533955559 ,
     *    .000000000000000E+00, -1.27917451131852 , -1.27917451131852 ,
     *     1.27917451131852 ,  1.27917451131852 , .000000000000000E+00,
     *    -1.27917451131852 , .000000000000000E+00, -1.27917451131852 ,
     *    -.162476466044441 , -.162476466044441 ,  1.11669804527408 ,
     *    .162476466044441 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00, .162476466044441 ,  1.27917451131852 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *    .000000000000000E+00, -.225403330758517 , -.225403330758517 ,
     *     1.77459666924148 , .225403330758517 , .000000000000000E+00,
     *    -1.77459666924148 , -1.54919333848297 , -1.77459666924148 ,
     *    -1.77459666924148 , -1.77459666924148 , -1.54919333848297 ,
     *     1.77459666924148 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00,  1.77459666924148 ,  1.77459666924148/

      data dp3/-.774596669241483, -.774596669241483, -.774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *     1.54919333848297 , -.225403330758517 , -.225403330758517 ,
     *    .225403330758517 , .225403330758517 , .000000000000000E+00,
     *    -.225403330758517 ,  1.54919333848297 , -.225403330758517 ,
     *    -1.77459666924148 , -1.77459666924148 , .000000000000000E+00,
     *     1.77459666924148 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00,  1.77459666924148 , .225403330758517 ,
     *    -.774596669241483 , -.774596669241483 , -.774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.774596669241483 ,
     *    .000000000000000E+00, -1.77459666924148 , -1.77459666924148 ,
     *    .225403330758517 ,  1.77459666924148 , .000000000000000E+00,
     *    -.225403330758517 ,  1.54919333848297 , -.225403330758517 ,
     *    -.225403330758517 , -.225403330758517 ,  1.54919333848297 ,
     *    .225403330758517 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00, .225403330758517 , .225403330758517 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, -.774596669241483,
     *    -1.54919333848297 , -1.77459666924148 , -1.77459666924148 ,
     *     1.77459666924148 ,  1.77459666924148 , .000000000000000E+00,
     *    -1.77459666924148 , -1.54919333848297 , -1.77459666924148 ,
     *    -.225403330758517 , -.225403330758517 , .000000000000000E+00,
     *    .225403330758517 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00, .225403330758517 ,  1.77459666924148 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *    -1.54919333848297 , -1.77459666924148 , -1.77459666924148 ,
     *    .225403330758517 ,  1.77459666924148 , .000000000000000E+00,
     *    -.225403330758517 , .000000000000000E+00, -.225403330758517 ,
     *    -1.77459666924148 , -1.77459666924148 , -1.54919333848297 ,
     *     1.77459666924148 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00,  1.77459666924148 , .225403330758517 ,
     *    -.774596669241483 , -.774596669241483 , -.774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.774596669241483 ,
     *     1.54919333848297 , -.225403330758517 , -.225403330758517 ,
     *     1.77459666924148 , .225403330758517 , .000000000000000E+00,
     *    -1.77459666924148 , .000000000000000E+00, -1.77459666924148 ,
     *    -.225403330758517 , -.225403330758517 ,  1.54919333848297 ,
     *    .225403330758517 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00, .225403330758517 ,  1.77459666924148/

      DATA VP1/-.125000000000000 ,-.125000000000000 ,-.125000000000000 ,
     *   -.125000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,.250000000000000 ,.250000000000000 ,
     *   .250000000000000 ,.324516523092734 ,-.750537196563629E-01,
     *   -.750537196563629E-01,-.750537196563629E-01,.266380161832731 ,
     *   .338347167927203E-01,.266380161832731 ,.266380161832731 ,
     *  .338347167927203E-01,.338347167927203E-01,-.750537196563630E-01,
     *   .324516523092734 ,-.750537196563629E-01,-.750537196563629E-01,
     *   .266380161832731 ,.266380161832731 ,.338347167927203E-01,
     *   .338347167927203E-01,.266380161832731 ,.338347167927203E-01,
     *   -.750537196563627E-01,-.750537196563629E-01,.324516523092734 ,
     *   -.750537196563629E-01,.338347167927203E-01,.266380161832731 ,
     *   .266380161832731 ,.338347167927203E-01,.338347167927203E-01,
     *   .266380161832731 ,-.750537196563627E-01,-.750537196563629E-01,
     *   -.750537196563629E-01,.324516523092734 ,.338347167927203E-01,
     *   .338347167927203E-01,.338347167927203E-01,.266380161832731 ,
     *   .266380161832731 ,.266380161832731 ,-.373192912588241E-01,
     *   -.115257699028758 ,-.115257699028758 ,-.115257699028758 ,
     *   .519589385132896E-01,.409071857601743 ,.519589385132896E-01,
     *   .519589385132896E-01,.409071857601743 ,.409071857601743 ,
     *   -.115257699028758 ,-.373192912588239E-01,-.115257699028758 ,
     *   -.115257699028758 ,.519589385132895E-01,.519589385132894E-01,
     *   .409071857601743 ,.409071857601743 ,.519589385132894E-01,
     *   .409071857601743 ,-.115257699028758 ,-.115257699028758 ,
     *   -.373192912588239E-01,-.115257699028758 ,.409071857601743 ,
     *   .519589385132894E-01,.519589385132895E-01,.409071857601743 ,
     *   .409071857601743 ,.519589385132894E-01,-.115257699028758 ,
     *   -.115257699028758 ,-.115257699028758 ,-.373192912588239E-01,
     *   .409071857601743 ,.409071857601743 ,.409071857601743 ,
     *   .519589385132895E-01,.519589385132894E-01,.519589385132894E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *  -.500000000000000E-01,.127016653792583E-01,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.100000000000000E+00,
     *   .787298334620742 ,-.500000000000000E-01,-.500000000000000E-01,
     *   -.500000000000000E-01,-.500000000000000E-01,.100000000000000 ,
     *   .127016653792583E-01,.100000000000000 ,.787298334620742 ,
     *  .100000000000000E+00,.100000000000000E+00,-.500000000000001E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   .787298334620742 ,.100000000000000E+00,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.127016653792583E-01,
     *-.499999999999999E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   -.500000000000000E-01,.999999999999999E-01,.787298334620742 ,
     *   .999999999999999E-01,.127016653792583E-01,.100000000000000E+00,
     * .100000000000000E+00,-.500000000000000E-01,-.500000000000000E-01,
     * -.500000000000000E-01,-.500000000000000E-01,.100000000000000E+00,
     *   .100000000000000E+00,.127016653792583E-01,.100000000000000E+00,
     *   .787298334620742 ,.100000000000000E+00,-.500000000000000E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   .100000000000000E+00,.100000000000000E+00,.787298334620742 ,
     *   .100000000000000E+00,.127016653792583E-01,.100000000000000E+00/
      DATA POIDS/.197530873119831E-01,.119895139631698E-01,
     *   .119895139631698E-01,
     *   .119895139631698E-01,.119895139631698E-01,.115113678710454E-01,
     *   .115113678710454E-01,.115113678710454E-01,.115113678710454E-01,
     *   .881834235042334E-02,.881834235042334E-02,.881834235042334E-02,
     *   .881834235042334E-02,.881834235042334E-02,.881834235042334E-02/

      if (iopt .eq. 2) then    
C
C         CAS ISOTROPE
C         ------------
          CALL ER3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),NPI,IJT,
     +                   poids,vp1,vdpq2,vdpq2,iopt,car(1),car(2),
     +                   elas,AE,delta,xint,yint,zint,a2)
      else
C
C         CAS ORTHOTROPE
C         --------------
          CALL ER3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),NPI,IJT,
     +                   poids,vp1,vdpq2,vdpq2,iopt,car(1),car(2),
     +                   car,AE,delta,xint,yint,zint,a2)
      endif

      END
