      SUBROUTINE ETR3R1D(COOR,car,iopt,AE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DE LA MATRICE ELEMENTAIRE ELASTIQUE DE RIGIDITE
C  ---     pentaedre r1 DROIT
c          formule d'integration a 6 points (gauss) 3*2
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : TABLEAUX DES COORDONNEES DES POINTS DE L ELEMENT
c   ijt     : permutation pour oasser de la numerotation par inconnues
c             a celle par noeuds
c   nno     : nombre de noeuds de l'element
c   npo     : nombre de points
c   npi     : nombre de points d'integration
c   dp      : valeur des derivees des polynomes de base aux points
c             d'integration sur l'element de reference
c   vp1     : valeur des polynomes de base aux points
c             d'integration sur l'element de reference
c   poids   : poids de la formule d'integration
c
c  tableaux de travail :
c  -------------------
c   delta   : jacobien aux points d'integration
c   (x y z)int : coordonnees des points d'integration sur 
c              l'element courant
C
C  PARAMETRE DE SORTIE  :
C  --------------------
C   AE     : MATRICE DE RIGIDITE . SYMETRIQUE
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEURS  : Marina Vidrascu 2001
C ...................................................................
C
      parameter (ndim=3, nno=6, npo=6, npi=6)
      double precision ae(NNO*3*(NNO*3+1)/2)
      DOUBLE PRECISION COOR(npo,3),xint(npi),yint(npi),zint(npi)
      DIMENSION IJT(ndim*nno)
      double precision poids(npi),elas(9),delta(npi),
     &                 a2(ndim,nno,npi),vp1(nno,npi)
     &                  ,DP(ndim,nno,npi),car(iopt)
c
      DATA IJT/1,4,7,10,13,16,
     +         2,5,8,11,14,17,
     +         3,6,9,12,15,18/
c
      DATA DP / -0.78867513459481, -0.78867513459481, -0.66666666666667,
     &    0.78867513459481, 0., -0.16666666666667, 0., 0.78867513459481,
     &   -0.16666666666667, -0.21132486540519, -0.21132486540519,  
     &    0.66666666666667,  0.21132486540519, 0., 0.16666666666667, 0., 
     &    0.21132486540519, 0.16666666666667, -0.78867513459481, 
     &    -0.78867513459481, -0.16666666666667, 0.78867513459481, 0.,
     &    -0.66666666666667, 0., 0.78867513459481,  -0.16666666666667,
     &    -0.21132486540519, -0.21132486540519,  0.16666666666667,
     &   0.21132486540519, 0.,  0.66666666666667, 0.,  0.21132486540519,
     &    0.16666666666667, -0.78867513459481, -0.78867513459481, 
     &    -0.16666666666667, 0.78867513459481, 0., -0.16666666666667,0.,
     &     0.78867513459481, -0.66666666666667, -0.21132486540519,
     &     -0.21132486540519, 0.16666666666667, 0.21132486540519, 0.,
     &     0.16666666666667, 0., 0.21132486540519, 0.66666666666667,
     &    -0.21132486540519, -0.21132486540519, -0.66666666666667,
     &    0.21132486540519, 0., -0.16666666666667, 0., 0.21132486540519,
     &  -0.16666666666667, -0.78867513459481, -0.78867513459481, 
     &   0.66666666666667, 0.78867513459481, 0., 0.16666666666667, 0., 
     &   0.78867513459481,  0.16666666666667, -0.21132486540519, 
     &   -0.21132486540519, -0.16666666666667,  0.21132486540519, 0.,
     &   -0.66666666666667, 0.,  0.21132486540519, -0.16666666666667,
     &   -0.78867513459481, -0.78867513459481,  0.16666666666667,
     &   0.78867513459481, 0., 0.66666666666667, 0., 0.78867513459481,
     &   0.16666666666667, -0.21132486540519, -0.21132486540519, 
     &  -0.16666666666667, 0.21132486540519, 0., -0.16666666666667, 0.,
     &  0.21132486540519, -0.66666666666667, -0.78867513459481, 
     &  -0.78867513459481,  0.16666666666667, 0.78867513459481, 0.,
     &  0.16666666666667, 0.,  0.78867513459481, 0.66666666666667/
  
C
      DATA VP1 / 0.52578342306321, 0.13144585576580 ,0.13144585576580,
     &     0.14088324360346, 3.5220810900865D-02, 3.5220810900865D-02,
     &     0.13144585576580, 0.52578342306321,  0.13144585576580,
     &     3.5220810900865D-02, 0.14088324360346, 3.5220810900865D-02,
     &     0.13144585576580, 0.13144585576580,  0.52578342306321,
     &     3.5220810900865D-02, 3.5220810900865D-02, 0.14088324360346,
     &     0.14088324360346, 3.5220810900865D-02, 3.5220810900865D-02,
     &     0.52578342306321, 0.13144585576580, 0.13144585576580,
     &     3.5220810900865D-02, 0.14088324360346, 3.5220810900865D-02,
     &     0.13144585576580, 0.52578342306321, 0.13144585576580,
     &     3.5220810900865D-02, 3.5220810900865D-02, 0.14088324360346,
     &     0.13144585576580,   0.13144585576580,   0.52578342306321/
  
C
      DATA POIDS /8.3333333333333D-02,  8.3333333333333D-02,
     &            8.3333333333333D-02,  8.3333333333333D-02,
     &            8.3333333333333D-02,  8.3333333333333D-02 /

      if (iopt .eq. 2) then
C
C         CAS ISOTROPE
C         ------------
          CALL ER3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),NPI,IJT,
     +                   poids,vp1,dp,dp,iopt,car(1),car(2),
     +                   elas,AE,delta,xint,yint,zint,a2)
      else
C
C         CAS ORTHOTROPE
C         --------------
          CALL ER3C2C (NNO,NNO,COOR(1,1),COOR(1,2),COOR(1,3),NPI,IJT,
     +                   poids,vp1,dp,dp,iopt,car(1),car(2),
     +                   CAR,AE,delta,xint,yint,zint,a2)
      endif

      END
