       SUBROUTINE etr5noe(coor,car,iopt,ae)
C  ....................................................................
C but : CREATION DES MATRICES ELEMENTAIRES RAIDEUR POUR L ELEMENT
C ---   QUADRILATERAL A 4 SOUS TRIANGLES EN CROIX
C              ---   VERSION PLANE  ---
C ON DISTINGUE DEUX CAS SUIVANT QUE poison EST PROCHE DE .5 EN
C DEFORMATIONS PLANES (CAS INCOMPRESSIBLE) OU NON (CAS COMPRESSIBLE)
C 1) CAS COMPRESSIBLE
C    A(I,J) = 2.*E1 * D(I).D(J)
C           + RR*2.* DIV(D(I))*DIV(D(J))
C 2) CAS INCOMPRESSIBLE
C    A(I,J) = 2.*E1 *( (D(I)-.5*TR(D(I))*ID) * (D(J)-.5*TR(D(J))*ID )
C           + RR*2. * DIV(D(I))*DIV(D(J))
c
c in : coor(noe,ndim) : coordones des 4 sommets.
c      car(2): caracteristiques des materiaux
c              car(1) = young
c              car(2) = poisson
c      iopt = 1 isotrope Contraintes  Planes
c           = 2 isotrope Deformations Planes
C out: ae(55)    : DEMI-MATRICE SUPERIEURE
C ....................................................................
      implicit none
      integer i, ij, N(3,4), np, i1, j, k, ii, i2, iopt
      DOUBLE PRECISION coor(5,2),car(2),SS,DIV1,ae(55),RR,E1,X(5),Y(5),
     +                 BI1(3),BI2(3),D11(10),D22(10),D12(10),DIV(10),S,
     +                 B11,B12,X31,Y31,X42,Y42,young,poison
      LOGICAL ICOMP
      DATA N/1,2,5,2,3,5,3,4,5,4,1,5/
C
      YOUNG  = car(1)
      POISON = car(2)
      E1 = YOUNG*.5D0/(1.D0+POISON)
      ICOMP=.TRUE.
      IF(iopt .eq. 2) then
        SS=1.D0-2.D0*POISON
        IF(ABS(SS) .LT. 0.1) ICOMP = .FALSE.
        RR=E1*.5D0/SS
        IF(ICOMP) RR=RR*2.D0*POISON
      ELSEIF(iopt .eq. 1) then
        RR = E1*POISON/(1.D0-POISON)
      ELSE
        call mexErrMsgTxt('CHOIX CONTRAINTES OU DEFORMATIONS PLANES ?')
        RETURN
      ENDIF
C
C     CALCUL DES COORDONNEES DES NOEUDS
C
      DO 1 I = 1,4
        X(I) = coor(I,1)
        Y(I) = coor(I,2)
 1    continue
      X31=X(3)-X(1)
      Y31=Y(3)-Y(1)
      X42=X(4)-X(2)
      Y42=Y(4)-Y(2)
      DIV1=1./(Y31*X42-Y42*X31)
      X(5)=(X(1)*Y31*X42-X(2)*Y42*X31+(Y(2)-Y(1))*X31*X42)*DIV1
      Y(5)=(Y(2)*Y31*X42-Y(1)*Y42*X31-(X(2)-X(1))*Y31*Y42)*DIV1
C
C     INITIALISATION
C
      DO 2 IJ=1,55
        AE(IJ)=0.
 2    continue
C
C     BOUCLE SUR LES SOUS-ELEMENTS
C
      DO 10 NP=1,4
         DO 100 I1=1,10
            DIV(I1)=0.D0
            D11(I1)=0.D0
            D12(I1)=0.D0
            D22(I1)=0.D0
 100     CONTINUE
         I=N(1,NP)
         J=N(2,NP)
         K=N(3,NP)
C
C        CALCUL DES GRADIENTS BIJ DES COORDONNEES BARYCENTRIQUES
C        ET DE S=2*AIRE DU SOUS ELEMENT
C
         S   = (X(I)-X(J))*(Y(I)-Y(K))-(X(I)-X(K))*(Y(I)-Y(J))
         SS  = 1.D0/S
         BI1(1) = (Y(J)-Y(K))*SS
         BI1(2) = (Y(K)-Y(I))*SS
         BI1(3) = (Y(I)-Y(J))*SS
         BI2(1) = (X(K)-X(J))*SS
         BI2(2) = (X(I)-X(K))*SS
         BI2(3) = (X(J)-X(I))*SS
C
C        ACTUALISATION DE LA MATRICE
         DO 101 II=1,3
            I1=2*N(II,NP)-1
            I2=I1+1
            B11=BI1(II)*.5D0
            B12=BI2(II)*.5D0
C             D11(I1)=B11
            D12(I1)=B12
C             D22(I1)=-B11
            DIV(I1)=B11*2.D0
C             D11(I2)=-B12
            D12(I2)=B11
C             D22(I2)=B12
            DIV(I2)=B12*2.D0
            IF(ICOMP) THEN
               D11(I1)=B11*2.D0
               D22(I2)=B12*2.D0
            ELSE
               D11(I1)=B11
               D22(I1)=-B11
               D11(I2)=-B12
               D22(I2)=B12
            END IF
  101    CONTINUE
         DO 102 I=1,10
         DO 102 J=1,I
            IJ=(I-1)*I/2+J
            AE(IJ)=AE(IJ)+E1*S*(D11(I)*D11(J)+2.D0*D12(I)*D12(J)
     +                   +D22(I)*D22(J))+RR*S*DIV(I)*DIV(J)
  102    CONTINUE
   10 CONTINUE
      END
