      SUBROUTINE etrap2c(coor,car,iopt,ae)
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT  : CALCUL DE LA MATRICE DE RAIDEUR DE L ELEMENT TRIA AP2C
C  ---  
c in : coor(noe,ndim) : coor. 3 sommets + 3 milieux aretes
c      car            : caracteristiques des materiaux
c           if(iopt .lt. 3) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c out: ae            : matrice triangulaire sup
c ...............................................................
c  programmeur : modulef
c ...............................................................
      implicit none
      integer ndim,NBPOLY, NPI, IP(12), l, i, iopt
      PARAMETER (ndim=2 , NBPOLY=6 , NPI=7)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,npi),DFM1DP(2,nbpoly,npi),AE(78),car(10),
     +                 ELAS(10),A11(1),A12(2),A13(2),A22(2,2),
     +                 A23(2,2),A33(3),G1(6,6),G2(6),G3(6,2),
     +                 G5(2,6),G4(6,2),AUX,coor(6,2)
C 2P25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +             .10128650732345632D+00,   .10128650732345632D+00,
     +             .79742698535308720D+00,   .10128650732345632D+00,
     +             .10128650732345632D+00,   .79742698535308720D+00,
     +             .47014206410511505D+00,   .59715871789769801D-01,
     +             .47014206410511505D+00,   .47014206410511505D+00,
     +             .59715871789769801D-01,   .47014206410511505D+00,
     +             .33333334326744079D+00,   .33333334326744079D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS /
     +             .62969590272413583D-01,   .62969590272413583D-01,
     +             .62969590272413583D-01,   .66197076394253095D-01,
     +             .66197076394253095D-01,   .66197076394253095D-01,
     +             .11249999701976776D+00 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / 
     +             .47435260858553857D+00,  -.80768594191887185D-01,
     +            -.80768594191887185D-01,   .32307437676754874D+00,
     +             .41035826263138293D-01,   .32307437676754874D+00,
     +            -.80768594191886977D-01,   .47435260858553840D+00,
     +            -.80768594191887185D-01,   .32307437676754879D+00,
     +             .32307437676754868D+00,   .41035826263138341D-01,
     +            -.80768594191887033D-01,  -.80768594191887185D-01,
     +             .47435260858553840D+00,   .41035826263138334D-01,
     +             .32307437676754868D+00,   .32307437676754890D+00,
     +            -.28074943223078796D-01,  -.28074943223078852D-01,
     +            -.52583901102545349D-01,   .88413424176407262D+00,
     +             .11229977289231514D+00,   .11229977289231517D+00,
     +            -.52583901102545571D-01,  -.28074943223078852D-01,
     +            -.28074943223078852D-01,   .11229977289231540D+00,
     +             .88413424176407240D+00,   .11229977289231540D+00,
     +            -.28074943223078765D-01,  -.52583901102545349D-01,
     +            -.28074943223078852D-01,   .11229977289231514D+00,
     +             .11229977289231514D+00,   .88413424176407262D+00,
     +            -.11111111773384862D+00,  -.11111110779974175D+00,
     +            -.11111110779974175D+00,   .44444443119896703D+00,
     +             .44444447093539807D+00,   .44444443119896703D+00 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +            -.21897079414123492D+01,  -.21897079414123492D+01,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +             .27845619121185238D+01,  -.40514602929382531D+00,
     +             .40514602929382531D+00,   .40514602929382531D+00,
     +            -.40514602929382531D+00,   .27845619121185238D+01,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +             .21897079414123488D+01,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.59485397070617462D+00,
     +            -.27845619121185229D+01,  -.31897079414123488D+01,
     +             .40514602929382531D+00,   .31897079414123488D+01,
     +            -.40514602929382531D+00,   .00000000000000000D+00,
     +             .59485397070617418D+00,   .59485397070617418D+00,
     +            -.59485397070617462D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .21897079414123488D+01,
     +             .00000000000000000D+00,  -.40514602929382531D+00,
     +             .31897079414123488D+01,   .40514602929382531D+00,
     +            -.31897079414123488D+01,  -.27845619121185229D+01,
     +            -.88056825642046065D+00,  -.88056825642046065D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,  -.76113651284092076D+00,
     +             .00000000000000000D+00,  -.18805682564204602D+01,
     +             .23886348715907920D+00,   .18805682564204602D+01,
     +            -.23886348715907920D+00,   .16417047692613815D+01,
     +             .76113651284092043D+00,   .76113651284092043D+00,
     +             .88056825642046021D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +            -.16417047692613806D+01,  -.18805682564204602D+01,
     +             .18805682564204602D+01,   .18805682564204602D+01,
     +            -.18805682564204602D+01,  -.16417047692613806D+01,
     +            -.88056825642046054D+00,  -.88056825642046054D+00,
     +            -.76113651284092076D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .88056825642046021D+00,
     +             .16417047692613813D+01,  -.23886348715907920D+00,
     +             .18805682564204602D+01,   .23886348715907920D+00,
     +            -.18805682564204602D+01,   .00000000000000000D+00,
     +            -.33333325386047363D+00,  -.33333325386047363D+00,
     +             .33333337306976318D+00,   .00000000000000000D+00,
     +             .00000000000000000D+00,   .33333337306976318D+00,
     +            -.11920928955078125D-06,  -.13333333730697631D+01,
     +             .13333333730697631D+01,   .13333333730697631D+01,
     +            -.13333333730697631D+01,  -.11920928955078125D-06 /
C
C     F1 , F2 , DFM1 , POIDEL , IP , DFM1DP PRETS A L EMPLOI
C
      CALL E2AP2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
C
      call hookax(iopt,car,ELAS)
C
C     -- INITIALISATION DE AE
      do 1 i = 1 , 78
        ae(i) = 0.d0
 1    continue
C
C     CONSTRUCTION DES MATRICES   (A11 , A12 , A13)
C     -------------------------   (      A22 , A23)  =  (TD * E * D)
C                                 (            A33)
      DO 5 L=1,NPI
         AUX      = POIDEL(L) / F1(L)
         A11(1)   = AUX * ELAS(6) / F1(L)
         A12(1)   = AUX * ELAS(5)
         A12(2)   = AUX * ELAS(9)
         A13(1)   = AUX * ELAS(9)
         A13(2)   = AUX * ELAS(4)
         AUX      = POIDEL(L)
         A22(1,1) = AUX * ELAS(3)
         A22(2,1) = AUX * ELAS(8)
         A22(1,2) = A22(2,1)
         A22(2,2) = AUX * ELAS(10)
         A23(1,1) = A22(2,1)
         A23(2,1) = A22(2,2)
         A23(1,2) = AUX * ELAS(2)
         A23(2,2) = AUX * ELAS(7)
         A33(1)   = A22(2,2)
         A33(2)   = A23(2,2)
         A33(3)   = AUX * ELAS(1)
C
C        CALCUL DE G1
C        ------------
         CALL AB0D(1,1,NBPOLY,A11,P25(1,L),G2)
         CALL AB1D(1,2,NBPOLY,A12,DFM1DP(1,1,L),G2)
C
         CALL TAB0D(NBPOLY,1,NBPOLY,P25(1,L),G2,G1)
C
         CALL TAB0D(2,1,NBPOLY,A12,P25(1,L),G5)
         CALL AB1D(2,2,NBPOLY,A22,DFM1DP(1,1,L),G5)
C
         CALL TAB1D(NBPOLY,2,NBPOLY,DFM1DP(1,1,L),G5,G1)
C        ON PLONGE G1 DANS AE
         CALL PLONAD(-1,NBPOLY,NBPOLY,1,1,IP,G1,G1,AE)
C
C        CALCUL DE G2
C        ------------
         CALL TAB0D(NBPOLY,1,2,P25(1,L),A13,G3)
         CALL TAB1D(NBPOLY,2,2,DFM1DP(1,1,L),A23,G3)
C
         CALL AB0D(NBPOLY,2,NBPOLY,G3,DFM1DP(1,1,L),G1)
C        ON PLONGE G2 DANS AE
         CALL PLONAD(-1,NBPOLY,NBPOLY,1,2,IP,G1,G1,AE)
C
C        CALCUL DE G3
C        ------------
         CALL TABAXD(NBPOLY,2,DFM1DP(1,1,L),A33,G1,G4,1)
C        ON PLONGE G3 DANS AE
         CALL PLONAD(1,NBPOLY,NBPOLY,2,2,IP,G1,G1,AE)
    5 CONTINUE
      END
