      subroutine etraq2c(coor,car,iopt,ae)
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT  : MATRICE DE RAIDEUR DE L ELEMENT AXI: QUAD AQ2C
C  ---  
c in : coor(noe,ndim) : coordonnees R(3), Z(3) des 3 sommets.
c      car            : caracteristiques des materiaux
c           if(iopt .eq. 1) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car(1) = E_1  (Young radial     -> E_r     )
c             car(2) = nu_1 (poisson          -> Nu_r    )
c             car(3) = E_2  (Young axial      -> E_z     )
c             car(4) = nu_2 (poisson          -> Nu_z    )
c             car(5) = E_3  (Young Tangentiel -> E_theta )
c           end if
c out: ae            : matrice triangulaire sup
c ...............................................................
c  programmeur : modulef
c ...............................................................
      implicit none
      integer ndim,NBPOLY, NPI, IP(16), l, i, iopt
      PARAMETER (ndim=2 , NBPOLY=8 , NPI=9)
      DOUBLE PRECISION POIDS(NPI),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +                 XYNPI(ndim,npi),POIDEL(npi),F1(npi),F2(npi),
     +                 DFM1(4,npi),DFM1DP(2,nbpoly,npi),AE(136),
     +                 car(10),ELAS(10),A11(1),A12(2),A13(2),A22(2,2),
     +                 A23(2,2),A33(3),G1(8,8),G2(8),G3(8,2),
     +                 G5(2,8),G4(8,2),AUX,coor(8,2)
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
C
C     F1 , F2 , DFM1 , POIDEL , IP , DP PRETS A L EMPLOI
C
      CALL E2AQ2C(NBPOLY,NPI,POIDS,P25,DP25,ip,f1,f2,DFM1DP,poidel,
     +            dfm1,coor)
C
      call hookax(iopt,car,elas)
C
       do 1 i = 1 , 136
         ae(i) = 0.d0
 1     continue
C
C     CONSTRUCTION DES MATRICES   (A11 , A12 , A13)
C     -------------------------   (      A22 , A23)  =  (TD * E * D)
C                                 (            A33)
      DO 5 L=1,NPI
         AUX      = POIDEL(L) / F1(L)
         A11(1)   = AUX * ELAS(6) / F1(L)
         A12(1)   = AUX * ELAS(5)
         A12(2)   = AUX * ELAS(9)
         A13(1)   = AUX * ELAS(9)
         A13(2)   = AUX * ELAS(4)
         AUX      = POIDEL(L)
         A22(1,1) = AUX * ELAS(3)
         A22(2,1) = AUX * ELAS(8)
         A22(1,2) = A22(2,1)
         A22(2,2) = AUX * ELAS(10)
         A23(1,1) = A22(2,1)
         A23(2,1) = A22(2,2)
         A23(1,2) = AUX * ELAS(2)
         A23(2,2) = AUX * ELAS(7)
         A33(1)   = A22(2,2)
         A33(2)   = A23(2,2)
         A33(3)   = AUX * ELAS(1)
C
C        CALCUL DE G1
C        ------------
         CALL AB0D(1,1,NBPOLY,A11,P25(1,L),G2)
         CALL AB1D(1,2,NBPOLY,A12,DFM1DP(1,1,L),G2)
C
         CALL TAB0D(NBPOLY,1,NBPOLY,P25(1,L),G2,G1)
C
         CALL TAB0D(2,1,NBPOLY,A12,P25(1,L),G5)
         CALL AB1D(2,2,NBPOLY,A22,DFM1DP(1,1,L),G5)
C
         CALL TAB1D(NBPOLY,2,NBPOLY,DFM1DP(1,1,L),G5,G1)
C        ON PLONGE G1 DANS AE
         CALL PLONAD(-1,NBPOLY,NBPOLY,1,1,IP,G1,G1,AE)
C
C        CALCUL DE G2
C        ------------
         CALL TAB0D(NBPOLY,1,2,P25(1,L),A13,G3)
         CALL TAB1D(NBPOLY,2,2,DFM1DP(1,1,L),A23,G3)
C
         CALL AB0D(NBPOLY,2,NBPOLY,G3,DFM1DP(1,1,L),G1)
C        ON PLONGE G2 DANS AE
         CALL PLONAD(-1,NBPOLY,NBPOLY,1,2,IP,G1,G1,AE)
C
C        CALCUL DE G3
C        ------------
         CALL TABAXD(NBPOLY,2,DFM1DP(1,1,L),A33,G1,G4,1)
C        ON PLONGE G3 DANS AE
         CALL PLONAD(1,NBPOLY,NBPOLY,2,2,IP,G1,G1,AE)
    5 CONTINUE
      END
