      subroutine etrdktp(coor,car,iopt,ae)
C ***************************************************************
c but: calcul de la matrice de rigidite de l element de plaque
c      tria DKTP (DISCRETE KIRCHHOFF THEORY)
c in : coor(noe,ndim) : coordonees des 3 sommets.
c      car(3)         : caracteristiques des materiaux
c                       young, poisson, epaisseur
c      iopt           : ouvert si masse lumping ou autre ds futur
c
c out: ae            : matrice triangulaire sup
c
c  programmeur : modulef
c ...............................................................
      implicit none
      integer i, j, iopt
      DOUBLE PRECISION AE(45),X23,X31,X12,Y23,Y31,Y12,DELTA,D(6),
     +       coor(3,2),car(3),YOUNG,POISON,EPAIS,COEFF,DXHX(9),
     +       DYHX(9),DXHY(9),DYHY(9),B(3,9),AUX(9,3),AL4,AL5,AL6,
     +       P4,P5,P6,Q4,Q5,Q6,T4,T5,T6,R4,R5,R6,XKSI(3),YNETA(3)

      DATA XKSI / .5D0 , .5D0 , 0.D0 / , YNETA / 0.D0 , .5D0 , .5D0 /
C
c
      X23    = coor(2,1) - coor(3,1)
      Y23    = coor(2,2) - coor(3,2)
      X31    = coor(3,1) - coor(1,1)
      Y31    = coor(3,2) - coor(1,2)
      X12    = coor(1,1) - coor(2,1)
      Y12    = coor(1,2) - coor(2,2)
      DELTA  = X31 * Y12 - X12 * Y31
c
C
C  CALCUL DES LK ,PK ,QK ,TK ,RK
C                 (CF. J.L. BATOZ)
      AL4    = X23**2 + Y23**2
      AL5    = X31**2 + Y31**2
      AL6    = X12**2 + Y12**2
      P4     = - 6.D0 * X23 / AL4
      P5     = - 6.D0 * X31 / AL5
      P6     = - 6.D0 * X12 / AL6
      T4     = - 6.D0 * Y23 / AL4
      T5     = - 6.D0 * Y31 / AL5
      T6     = - 6.D0 * Y12 / AL6
      Q4     = 3.D0 * X23 * Y23 / AL4
      Q5     = 3.D0 * X31 * Y31 / AL5
      Q6     = 3.D0 * X12 * Y12 / AL6
      R4     = 3.D0 * Y23 ** 2 / AL4
      R5     = 3.D0 * Y31 ** 2 / AL5
      R6     = 3.D0 * Y12 ** 2 / AL6

C     CAS OU DB EST FOURNI
      if(iopt .eq. 3) then
       D(1)=CAR(1)
       D(2)=CAR(2)
       D(3)=CAR(3)
       D(4)=CAR(4)
       D(5)=CAR(5)
       D(6)=CAR(6)
C
C  MATRICE [ D ] (SYMETRIQUE STOKEE SOUS FORME TRIANGULAIRE => D(6))
C             3*3
      else
       young  = car(1)
       poison = car(2)
       epais  = car(3)
       COEFF  = YOUNG*EPAIS**3/(12.D0*(1.D0-POISON**2))
       D(1) = COEFF / (6.D0 * DELTA)
       D(2) = D(1) * POISON
       D(3) = D(1)
       D(4) = 0.D0
       D(5) = 0.D0
       D(6) = COEFF * ( 1.D0 - POISON ) / (12.D0 * DELTA)
      endif
C
C  BOUCLE SUR LES 3 POINTS D'INTEGRATION NUMERIQUES
C   ( MILIEU DES 3 COTES DU TRIANGLE DE REFERENCE )
C
      DO 2 I = 1 , 3
C
C  CALCUL DES MATRICES [DX_HX] , [DY_HX] , [DX_HY] , [DY_HY]
C                           1*9       1*9       1*9       1*9
      DXHX(1) = P6 * ( 1.D0 - 2.D0 * XKSI(I) ) + ( P5 - P6 ) * YNETA(I)
      DXHX(2) = Q6 * ( 1.D0 - 2.D0 * XKSI(I) ) - ( Q5 + Q6 ) * YNETA(I)
      DXHX(3) = -4.D0 + 6.D0 * ( XKSI(I) + YNETA(I) ) +
     +          R6 * ( 1.D0 - 2.D0 * XKSI(I) ) - YNETA(I) * ( R5 + R6 )
      DXHX(4) = - P6 * ( 1.D0 - 2.D0 * XKSI(I) ) + ( P4 + P6 )*YNETA(I)
      DXHX(5) = Q6 * ( 1.D0 - 2.D0 * XKSI(I) ) - ( Q6 - Q4 ) * YNETA(I)
      DXHX(6) = -2.D0 + 6.D0 * XKSI(I) + R6 * ( 1.D0 - 2.D0 * XKSI(I) )
     +        + ( R4 - R6 ) * YNETA(I)
      DXHX(7) = - ( P5 + P4 ) * YNETA(I)
      DXHX(8) =   ( Q4 - Q5 ) * YNETA(I)
      DXHX(9) = - ( R5 - R4 ) * YNETA(I)
C
      DYHX(1) = - P5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( P6 - P5 )*XKSI(I)
      DYHX(2) = Q5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( Q5 + Q6 ) * XKSI(I)
      DYHX(3) = - 4.D0 + 6.D0 * ( XKSI(I) + YNETA(I) ) +
     +          R5 * ( 1.D0 - 2.D0 * YNETA(I) ) - XKSI(I) * ( R5 + R6 )
      DYHX(4) =   ( P4 + P6 ) * XKSI(I)
      DYHX(5) =   ( Q4 - Q6 ) * XKSI(I)
      DYHX(6) = - ( R6 - R4 ) * XKSI(I)
      DYHX(7) = P5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( P4 + P5 ) * XKSI(I)
      DYHX(8) = Q5 * ( 1.D0 - 2.D0 * YNETA(I) ) + ( Q4 - Q5 ) * XKSI(I)
      DYHX(9) = -2.D0 + 6.D0 * YNETA(I) + ( R4 - R5 ) * XKSI(I)
     +        + R5 * ( 1.D0 - 2.D0 * YNETA(I) )
C
      DXHY(1) = T6 * ( 1.D0 - 2.D0 * XKSI(I) ) + ( T5 - T6 ) * YNETA(I)
      DXHY(2) = 1.D0 + R6 * ( 1.D0 - 2.D0 * XKSI(I) )
     +        - ( R5 + R6 ) * YNETA(I)
      DXHY(3) = - Q6 * ( 1.D0 - 2.D0 * XKSI(I) ) + YNETA(I)*( Q5 + Q6 )
      DXHY(4) = - T6 * ( 1.D0 - 2.D0 * XKSI(I) ) + ( T4 + T6 )*YNETA(I)
      DXHY(5) = - 1.D0 + R6 * ( 1.D0 - 2.D0 * XKSI(I) )
     +        + ( R4 - R6 ) * YNETA(I)
      DXHY(6) = - Q6 * ( 1.D0 - 2.D0 * XKSI(I) ) - ( Q4 - Q6 )*YNETA(I)
      DXHY(7) = - ( T4 + T5 ) * YNETA(I)
      DXHY(8) =   ( R4 - R5 ) * YNETA(I)
      DXHY(9) = - ( Q4 - Q5 ) * YNETA(I)
C
      DYHY(1) = - T5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( T6 - T5 )*XKSI(I)
      DYHY(2) = 1.D0 + R5 * ( 1.D0 - 2.D0 * YNETA(I) )
     +        - ( R5 + R6 ) * XKSI(I)
      DYHY(3) = - Q5 * ( 1.D0 - 2.D0 * YNETA(I) ) + XKSI(I)*( Q5 + Q6 )
      DYHY(4) =   ( T4 + T6 ) * XKSI(I)
      DYHY(5) =   ( R4 - R6 ) * XKSI(I)
      DYHY(6) = - ( Q4 - Q6 ) * XKSI(I)
      DYHY(7) = T5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( T4 + T5 )*XKSI(I)
      DYHY(8) = - 1.D0 + R5 * ( 1.D0 - 2.D0 * YNETA(I) )
     +        + ( R4 - R5 ) * XKSI(I)
      DYHY(9) = - Q5 * ( 1.D0 - 2.D0 * YNETA(I) ) - ( Q4 - Q5 )*XKSI(I)
C
C     --CALCUL DE LA MATRICE [ B ] (CF. J.L. BATOZ)
C                          3*9
        DO 1  J = 1 , 9
          B(1,J)  =   Y31 * DXHX(J) + Y12 * DYHX(J)
          B(2,J)  = - X31 * DXHY(J) - X12 * DYHY(J)
          B(3,J)  = - X31 * DXHX(J) - X12 * DYHX(J)
     +              + Y31 * DXHY(J) + Y12 * DYHY(J)
 1      CONTINUE
C                                 T
C     --CALCUL DU PRODUIT [ AE ] = [ B ] * [ D ] * [ B ]
C                             9*9     9*3     3*3     3*9
C     ( [ AE ] SYMETRIQUE STOKEE SOUS FORME PROFIL => AE(45) )
C
      CALL TABAXD(9,3,B,D,AE,AUX,I)
C
 2    continue
      END
