      SUBROUTINE ets2p1d(coor,fomega,fgamma,pressi,norefs,alpha,
     +                   theta,car,iopt,be)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT: CALCUL DE SECONDS MEMBRES DE L ELEMENT TRIA 2P1D
C ---  
c in : 
c   coor(noe,ndim)        : coordonnees des 3 sommets.
c   fomega(ndim,noe)      : fx, fy aux noeuds
c   fgamma(ndim,2*nbarete): fx, fy aux noeuds de chaque arete.
c   pressi(2*nbarete)     : pression aux noeuds de chaque arete
c   norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                      norefs(i,2) = 0 si pression = 0 sur arete_i
C   theta(3): temperature aux 3 sommets
C   alpha(3): tenseur de dilatation thermique (k11, k12, k22)
C
c   car            : caracteristiques des materiaux
c   iopt = 1 isotrope Contraintes  Planes
c        = 2 isotrope Deformations Planes
c        = sinon anisotrope
c   car(6): caracteristiques des materiaux
c           if(iopt .eq. 1 .or. iopt.eq. 2) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c            end if
c
C out: BE(6): second membre.
C  ....................................................................
      IMPLICIT NONE
      integer  I , J , IJ , iopt, nbarete, norefs(3,2)
      PARAMETER (nbarete=3)
      double precision coor(3,2),car(6),be(6),fomega(2,3),fgamma(2,6),
     +                 pressi(6),theta(3),E(6),ALPHA(3),A(3),X21,Y21,
     +                 X31,Y31,X32,Y32,DELTA,DELT1,YOUNG,UNMNU,POISSON,
     +                 C,somme,xji,yji,xnu,ynu,arelon
c
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      DELTA = X21*Y31 - X31*Y21
      DELT1 = DELTA / 6.D+00
C
C --  FOMEGA: INTEGRATION AUX 3 SOMMETS (F(0,0)+F(1,0)+F(0,1))
C
      DO 1 I=1,2
        DO 1 J=1,3
           IJ = 2 * ( J - 1 ) + I
           BE(IJ) = FOMEGA(I,J) * DELT1
 1    CONTINUE
C
C --  FGAMMA: INTEGRATION AUX 2 EXTREMITES DES COTES (F(0)+F(1))/2.
C
      if(norefs(1,2) .ne. 0) then
        XJI    = coor(2,1) - coor(1,1)
        YJI    = coor(2,2) - coor(1,2)
        ARELON = DSQRT(XJI**2 + YJI**2)
        XNU    =  YJI/ARELON
        YNU    = -XJI/ARELON
      end if
      DELT1 = DSQRT(X21*X21 + Y21*Y21) / 2.D+00
      BE(1) = BE(1) + DELT1*(FGAMMA(1,1) - pressi(1) * XNU)
      BE(3) = BE(3) + DELT1*(FGAMMA(1,2) - pressi(2) * XNU)
      BE(2) = BE(2) + DELT1*(FGAMMA(2,1) - pressi(1) * YNU)
      BE(4) = BE(4) + DELT1*(FGAMMA(2,2) - pressi(2) * YNU)

      if(norefs(2,2) .ne. 0) then
        XJI    = coor(3,1) - coor(2,1)
        YJI    = coor(3,2) - coor(2,2)
        ARELON = DSQRT(XJI**2 + YJI**2)
        XNU    =  YJI/ARELON
        YNU    = -XJI/ARELON
      end if
      DELT1 = DSQRT(X32*X32 + Y32*Y32) / 2.D+00
      BE(3) = BE(3) + DELT1*(FGAMMA(1,3) - pressi(3) * XNU)
      BE(5) = BE(5) + DELT1*(FGAMMA(1,4) - pressi(4) * XNU)
      BE(4) = BE(4) + DELT1*(FGAMMA(2,3) - pressi(3) * YNU)
      BE(6) = BE(6) + DELT1*(FGAMMA(2,4) - pressi(4) * YNU)

      if(norefs(3,2) .ne. 0) then
        XJI    = coor(1,1) - coor(3,1)
        YJI    = coor(1,2) - coor(3,2)
        ARELON = DSQRT(XJI**2 + YJI**2)
        XNU    =  YJI/ARELON
        YNU    = -XJI/ARELON
      end if
      DELT1 = DSQRT(X31*X31 + Y31*Y31) / 2.D+00
      BE(1) = BE(1) + DELT1*(FGAMMA(1,6) - pressi(6) * XNU)
      BE(5) = BE(5) + DELT1*(FGAMMA(1,5) - pressi(5) * XNU)
      BE(2) = BE(2) + DELT1*(FGAMMA(2,6) - pressi(6) * YNU)
      BE(6) = BE(6) + DELT1*(FGAMMA(2,5) - pressi(5) * YNU)
C
C     CONTRAINTES THERMIQUES = HOOKE * ALPHA * THETA
C                         3,1     3,3   3,3       3,1
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 3 i = 1 , 6
          E(i) = car(i)
 3      continue
      end if
C
C     CALCUL DE LA MATRICE TENSEUR D'ELASTICITE * TENSEUR THERMIQUE
C
      A(1) = ALPHA(1)*E(1) + ALPHA(3)*E(2)  + ALPHA(2)*E(4)
      A(2) = ALPHA(1)*E(2) + ALPHA(3)*E(3)  + ALPHA(2)*E(5)
      A(3) = ALPHA(1)*E(4) + ALPHA(3)*E(5)  + ALPHA(2)*E(6)
C
      SOMME = ( THETA(1) + THETA(2) + THETA(3) ) / 6.
      BE(1) = BE(1) + ( X32 * A(3) - Y32 * A(1) ) * SOMME
      BE(2) = BE(2) + ( X32 * A(2) - Y32 * A(3) ) * SOMME
      BE(3) = BE(3) + ( - X31 * A(3) + Y31 * A(1) ) * SOMME
      BE(4) = BE(4) + ( - X31 * A(2) + Y31 * A(3) ) * SOMME
      BE(5) = BE(5) + ( X21 * A(3) - Y21 * A(1) ) * SOMME
      BE(6) = BE(6) + ( X21 * A(2) - Y21 * A(3) ) * SOMME
c
      END
