      subroutine ets2p2c(coor,fomega,fgamma,pressi,norefs,alpha,
     +                   theta,car,iopt,be)
C ...................................................................
C but: SECONDS MEMBRES ELEMENTAIRES TRIA 2P2C
C ---  INTERPOLATION LAGRANGE P2 SUR UN TRIANGLE ISOPARAMETRIQUE
c
c in : coor(6,ndim) : coordonnees des 6 noeuds
C      fomega(ndim,noe)  : fx, fy volumiques aux 6 noeuds
c      fgamma(ndim,3*nbarete): fx, fy aux 3 noeuds de chaque arete.
c      pressi(3*nbarete)     : pression aux 3 noeuds de chaque arete
c      norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                         norefs(i,2) = 0 si pression = 0 sur arete_i
C   theta(6): temperature aux 6 noeuds
C   alpha(3): tenseur de dilatation thermique (k11, k12, k22)
C
c   car            : caracteristiques des materiaux
c   iopt = 1 isotrope Contraintes  Planes
c        = 2 isotrope Deformations Planes
c        = sinon anisotrope
c   car(6): caracteristiques des materiaux
c           if(iopt .eq. 1 .or. iopt.eq. 2) then
c             car(1) = young
c             car(2) = poisson
c           else
c             car: E11, E12, E22, E13, E23, E33 avec
c 
C                     E11   E12   E13       
C                           E22   E23
C                                 E33           
c            end if
c
c out: BE(12)
c
C  ....................................................................
      implicit none
      integer k, j, m, norefs(3,2), i, iopt
      DOUBLE PRECISION coor(6,2),fomega(2,6),fgamma(2,9),BE(12),
     +                 pressi(9),ARET(2,9),DELTA(6),xmi,ymi,xjm,yjm,
     +                 arelon,xnu(3),ynu(3),DESUR(3),X21,Y21,X31,Y31,
     +                 X32,Y32,X41,Y41,X42,Y42,X54,Y54,X61,Y61,X63,Y63,
     +                 X65,Y65,x52,y52,x53,y53,theta(6),E(6),ALPHA(3),
     +                 A(3),YOUNG,UNMNU,POISSON,C,car(6)
C
      X21  = coor(2,1) - coor(1,1)
      Y21  = coor(2,2) - coor(1,2)
      X31  = coor(3,1) - coor(1,1)
      Y31  = coor(3,2) - coor(1,2)
      X32  = coor(3,1) - coor(2,1)
      Y32  = coor(3,2) - coor(2,2)
      X41  = coor(4,1) - coor(1,1)
      Y41  = coor(4,2) - coor(1,2)
      X42  = coor(4,1) - coor(2,1)
      Y42  = coor(4,2) - coor(2,2)
      X54  = coor(5,1) - coor(4,1)
      Y54  = coor(5,2) - coor(4,2)
      X61  = coor(6,1) - coor(1,1)
      Y61  = coor(6,2) - coor(1,2)
      X63  = coor(6,1) - coor(3,1)
      Y63  = coor(6,2) - coor(3,2)
      X65  = coor(6,1) - coor(5,1)
      Y65  = coor(6,2) - coor(5,2)
C
C --  INTEGRATION : TERMES SURFACIQUES  ----
C
C --  CALCUL DE DELTA AUX NOEUDS  --
C
      DELTA(1) = ( 3.D0 * X41 + X42 ) * ( 3.D0 * Y61 + Y63 )
     +         - ( 3.D0 * X61 + X63 ) * ( 3.D0 * Y41 + Y42 )
      DELTA(2) = ( 3.D0 * X42 + X41 ) * (-4.D0 * Y54 + Y31 )
     +         + ( 4.D0 * X54 - X31 ) * ( 3.D0 * Y42 + Y41 )
      DELTA(3) = ( 4.D0 * X65 + X21 ) * ( 3.D0 * Y63 + Y61 )
     +         - ( 3.D0 * X63 + X61 ) * ( 4.D0 * Y65 + Y21 )
      DELTA(4) =  X21 * ( 2.D0 * Y54 + Y61 + Y63 )
     +         -  Y21 * ( 2.D0 * X54 + X61 + X63 )
      DELTA(5) = - (2.D0 * X65 + X41 + X42) * (2.D0 * Y54 - Y61 - Y63)
     +         +   (2.D0 * Y65 + Y41 + Y42) * (2.D0 * X54 - X61 - X63)
      DELTA(6) =  Y31 * (-2.D0 * X65 + X41 + X42 )
     +         +  X31 * ( 2.D0 * Y65 - Y41 - Y42 )
      DO 1 J=1,6
         DELTA(J) = DELTA(J) / 6.D0
 1    CONTINUE
C
      DO 2 J=1,2
        BE(J)    = DELTA(1)*fomega(J,1) / 10.D0
     +      - ( DELTA(2)*fomega(J,2) + DELTA(3)*fomega(J,3) ) / 60.D0
     +           - DELTA(5)*fomega(J,5) / 15.D0
        BE(J+2)  = DELTA(2)*fomega(J,2) / 10.D0
     +      - ( DELTA(1)*fomega(J,1) + DELTA(3)*fomega(J,3) ) / 60.D0
     +      - DELTA(6)*fomega(J,6) / 15.D0
        BE(J+4)  = DELTA(3)*fomega(J,3) / 10.D0
     +      - ( DELTA(1)*fomega(J,1) + DELTA(2)*fomega(J,2) ) / 60.D0
     +      - DELTA(4)*fomega(J,4) / 15.D0
        BE(J+6)  = 8.D0*DELTA(4)*fomega(J,4) / 15.D0
     +   + 4.D0*( DELTA(5)*fomega(J,5) + DELTA(6)*fomega(J,6) )/ 15.D0
     +   - DELTA(3)*fomega(J,3) / 15.D0
        BE(J+8)  = 8.D0*DELTA(5)*fomega(J,5) / 15.D0
     +   + 4.D0*( DELTA(6)*fomega(J,6) + DELTA(4)*fomega(J,4) ) /15.D0
     +   - DELTA(1)*fomega(J,1) / 15.D0
        BE(J+10) = 8.D0*DELTA(6)*fomega(J,6) / 15.D0
     +   + 4.D0*( DELTA(4)*fomega(J,4) + DELTA(5)*fomega(J,5) ) /15.D0
     +   - DELTA(2)*fomega(J,2) / 15.D0
 2    CONTINUE
C
C --  FGAMMA: INTEGRATION aux 3 noeuds de l'arete.
c     fgamma(2,3*nbarete) fx, fy aux 3 noeuds de chaque arete
c     pressi(3*nbarete) pression aux 3 noeuds de chaque arete
c     aret(2,3*nbarete) fx, fy aux 3 noeuds de chaque arete
c
c     -- arete 1
      if(norefs(1,2) .ne. 0) then
        k         = 1
        J         = 2
        M         = k + 3
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) ) 
        aret(1,1) = fgamma(1,1) - pressi(1)*XNU(1)
        aret(2,1) = fgamma(2,1) - pressi(1)*YNU(1)
        aret(1,2) = fgamma(1,2) - pressi(2)*XNU(2)
        aret(2,2) = fgamma(2,2) - pressi(2)*YNU(2)
        aret(1,3) = fgamma(1,3) - pressi(3)*XNU(3)
        aret(2,3) = fgamma(2,3) - pressi(3)*YNU(3)
      else
        aret(1,1) = fgamma(1,1)
        aret(2,1) = fgamma(2,1)
        aret(1,2) = fgamma(1,2)
        aret(2,2) = fgamma(2,2)
        aret(1,3) = fgamma(1,3)
        aret(2,3) = fgamma(2,3)
      end if
      DESUR(1) = DSQRT( (3.D0*X41 + X42)*(3.D0*X41 + X42)
     +           + (3.D0*Y41 + Y42)*(3.D0*Y41 + Y42) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X42 + X41)*(3.D0*X42 + X41)
     +           + (3.D0*Y42 + Y41)*(3.D0*Y42 + Y41) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X21*X21 + Y21*Y21) / 6.D0
c
      BE(1) = BE(1) + DESUR(1)*ARET(1,1)
      BE(2) = BE(2) + DESUR(1)*ARET(2,1)
      BE(3) = BE(3) + DESUR(2)*ARET(1,2)
      BE(4) = BE(4) + DESUR(2)*ARET(2,2)
      BE(7) = BE(7) + DESUR(3)*ARET(1,3)
      BE(8) = BE(8) + DESUR(3)*ARET(2,3)
c     -- arete 2
      if(norefs(2,2) .ne. 0) then
        k         = 2
        J         = 3
        M         = k + 3
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) )
        aret(1,4) = fgamma(1,4) - pressi(4)*XNU(1)
        aret(2,4) = fgamma(2,4) - pressi(4)*YNU(1)
        aret(1,5) = fgamma(1,5) - pressi(5)*XNU(2)
        aret(2,5) = fgamma(2,5) - pressi(5)*YNU(2)
        aret(1,6) = fgamma(1,6) - pressi(6)*XNU(3)
        aret(2,6) = fgamma(2,6) - pressi(6)*YNU(3)
      else
        aret(1,4) = fgamma(1,4)
        aret(2,4) = fgamma(2,4)
        aret(1,5) = fgamma(1,5)
        aret(2,5) = fgamma(2,5)
        aret(1,6) = fgamma(1,6)
        aret(2,6) = fgamma(2,6)
      end if
      X52 = coor(5,1) - coor(2,1)
      Y52 = coor(5,2) - coor(2,2)
      X53 = coor(5,1) - coor(3,1)
      Y53 = coor(5,2) - coor(3,2)
      DESUR(1) = DSQRT( (3.D0*X52 + X53)*(3.D0*X52 + X53)
     +           + (3.D0*Y52 + Y53)*(3.D0*Y52 + Y53) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X53 + X52)*(3.D0*X53 + X52)
     +           + (3.D0*Y53 + Y52)*(3.D0*Y53 + Y52) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X32*X32 + Y32*Y32) / 6.D0
c
      BE(3) = BE(3) + DESUR(1)*ARET(1,4)
      BE(4) = BE(4) + DESUR(1)*ARET(2,4)
      BE(5) = BE(5) + DESUR(2)*ARET(1,5)
      BE(6) = BE(6) + DESUR(2)*ARET(2,5)
      BE(9) = BE(9) + DESUR(3)*ARET(1,6)
      BE(10)= BE(10)+ DESUR(3)*ARET(2,6)
c     -- arete 3
      if(norefs(3,2) .ne. 0) then
        k         = 3
        J         = 1
        M         = k + 3
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) )
        aret(1,7) = fgamma(1,7) - pressi(7)*XNU(1)
        aret(2,7) = fgamma(2,7) - pressi(7)*YNU(1)
        aret(1,8) = fgamma(1,8) - pressi(8)*XNU(2)
        aret(2,8) = fgamma(2,8) - pressi(8)*YNU(2)
        aret(1,9) = fgamma(1,9) - pressi(9)*XNU(3)
        aret(2,9) = fgamma(2,9) - pressi(9)*YNU(3)
      else
        aret(1,7) = fgamma(1,7)
        aret(2,7) = fgamma(2,7)
        aret(1,8) = fgamma(1,8)
        aret(2,8) = fgamma(2,8)
        aret(1,9) = fgamma(1,9)
        aret(2,9) = fgamma(2,9)
      end if
c
      DESUR(1) = DSQRT( (3.D0*X63 + X61)*(3.D0*X63 + X61)
     +          + (3.D0*Y63 + Y61)*(3.D0*Y63 + Y61) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X61 + X63)*(3.D0*X61 + X63)
     +          + (3.D0*Y61 + Y63)*(3.D0*Y61 + Y63) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X31*X31 + Y31*Y31) / 6.D0
c
      BE(5) = BE(5) + DESUR(1)*ARET(1,7)
      BE(6) = BE(6) + DESUR(1)*ARET(2,7)
      BE(1) = BE(1) + DESUR(2)*ARET(1,8)
      BE(2) = BE(2) + DESUR(2)*ARET(2,8)
      BE(11)= BE(11)+ DESUR(3)*ARET(1,9)
      BE(12)= BE(12)+ DESUR(3)*ARET(2,9)
C
C     CONTRAINTES THERMIQUES = HOOKE * ALPHA * THETA
C                         3,1     3,3   3,3       3,1
      if(iopt .eq. 1) then
C  --    CONTRAINTES PLANES     (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         C   = YOUNG / (1.D+00 - POISSON*POISSON)
         E(1)  = C
         E(2)  = C*POISSON
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = C * (1.D+00 - POISSON) / 2.D+00
      else if(iopt .eq. 2) then
C  --    DEFORMATIONS PLANES (ISOTROPE)     -----
         YOUNG   = car(1)
         POISSON = car(2)
         UNMNU   = 1.D+00 - POISSON
         C   = YOUNG*UNMNU
         C   = C /( (1.D+00 + POISSON) * (1.D+00 - 2.D+00*POISSON) )
         E(1)  = C
         E(2)  = POISSON*C / UNMNU
         E(3)  = C
         E(4)  = 0.D0
         E(5)  = 0.D0
         E(6)  = (C * (1.D+00 - 2.D+00*POISSON) ) / (2.D+00*UNMNU)
      else
C  --    CAS ANISOTROPE     -----
        do 3 i = 1 , 6
          E(i) = car(i)
 3      continue
      end if
C
C     CALCUL DE LA MATRICE TENSEUR D'ELASTICITE * TENSEUR THERMIQUE
C
      A(1) = ALPHA(1)*E(1) + ALPHA(3)*E(2)  + ALPHA(2)*E(4)
      A(2) = ALPHA(1)*E(2) + ALPHA(3)*E(3)  + ALPHA(2)*E(5)
      A(3) = ALPHA(1)*E(4) + ALPHA(3)*E(5)  + ALPHA(2)*E(6)
C
            BE(1) = BE(1) +
     +              ( ( -A(1)*Y32+A(3)*X32 ) * THETA(4)  +
     +                (  A(1)*Y32-A(3)*X32 ) * THETA(5)  +
     +                ( -A(1)*Y32+A(3)*X32 ) * THETA(6)  ) / 6.
            BE(2) = BE(2) +
     +              ( ( -A(3)*Y32+A(2)*X32 ) * THETA(4)  +
     +                (  A(3)*Y32-A(2)*X32 ) * THETA(5)  +
     +                ( -A(3)*Y32+A(2)*X32 ) * THETA(6)  ) / 6.
            BE(3) = BE(3) +
     +              ( (  A(1)*Y31-A(3)*X31 ) * THETA(4)  +
     +                (  A(1)*Y31-A(3)*X31 ) * THETA(5)  +
     +                ( -A(1)*Y31+A(3)*X31 ) * THETA(6)  ) / 6.
            BE(4) = BE(4) +
     +              ( (  A(3)*Y31-A(2)*X31 ) * THETA(4)  +
     +                (  A(3)*Y31-A(2)*X31 ) * THETA(5)  +
     +                ( -A(3)*Y31+A(2)*X31 ) * THETA(6)  ) / 6.
            BE(5) = BE(5) +
     +              ( (  A(1)*Y21-A(3)*X21 ) * THETA(4)  +
     +                ( -A(1)*Y21+A(3)*X21 ) * THETA(5)  +
     +                ( -A(1)*Y21+A(3)*X21 ) * THETA(6)  ) / 6.
            BE(6) = BE(6) +
     +              ( (  A(3)*Y21-A(2)*X21 ) * THETA(4)  +
     +                ( -A(3)*Y21+A(2)*X21 ) * THETA(5)  +
     +                ( -A(3)*Y21+A(2)*X21 ) * THETA(6)  ) / 6.
            BE(7) = BE(7) +
     +              ( (  A(1)*Y21-A(3)*X21 ) * 2. * THETA(4)  +
     +                ( -A(1)*Y32+A(3)*X32 ) * 2. * THETA(5)  +
     +                (  A(1)*Y31-A(3)*X31 ) * 2. * THETA(6)  ) / 6.
            BE(8) = BE(8) +
     +              ( (  A(3)*Y21-A(2)*X21 ) * 2. * THETA(4)  +
     +                ( -A(3)*Y32+A(2)*X32 ) * 2. * THETA(5)  +
     +                (  A(3)*Y31-A(2)*X31 ) * 2. * THETA(6)  ) / 6.
            BE(9) = BE(9) +
     +              ( ( -A(1)*Y21+A(3)*X21 ) * 2. * THETA(4)  +
     +                (  A(1)*Y32-A(3)*X32 ) * 2. * THETA(5)  +
     +                (  A(1)*Y31-A(3)*X31 ) * 2. * THETA(6)  ) / 6.
            BE(10) = BE(10) +
     +              ( ( -A(3)*Y21+A(2)*X21 ) * 2. * THETA(4)  +
     +                (  A(3)*Y32-A(2)*X32 ) * 2. * THETA(5)  +
     +                (  A(3)*Y31-A(2)*X31 ) * 2. * THETA(6)  ) / 6.
            BE(11) = BE(11) +
     +              ( ( -A(1)*Y21+A(3)*X21 ) * 2. * THETA(4)  +
     +                ( -A(1)*Y32+A(3)*X32 ) * 2. * THETA(5)  +
     +                ( -A(1)*Y31+A(3)*X31 ) * 2. * THETA(6)  ) / 6.
            BE(12) = BE(12) +
     +              ( ( -A(3)*Y21+A(2)*X21 ) * 2. * THETA(4)  +
     +                ( -A(3)*Y32+A(2)*X32 ) * 2. * THETA(5)  +
     +                ( -A(3)*Y31+A(2)*X31 ) * 2. * THETA(6)  ) / 6.

      END
