       SUBROUTINE ets2q2c(coor,fomega,fgamma,pressi,norefs,BE)
C  ....................................................................
c but : second membre de l element membrane:  QUAD 2Q2C
c --- 
c in : coor(noe,ndim) : coordonees 8 noeuds
C      fomega(2,8)  : fx, fy volumiques aux 8 noeuds
c      fgamma(ndim,3*nbarete): fx, fy aux 3 noeuds de chaque arete.
c      pressi(3*nbarete)     : pression aux 3 noeuds de chaque arete
c      norefs(nbarete,2): norefs(i,1) = 0 si fgamma   = 0 sur arete_i
c                         norefs(i,2) = 0 si pression = 0 sur arete_i
c
c out: BE(16)
c
c programmeur : modulef
c ...............................................................
      implicit none
      integer norefs(4,2),ndim,nbpoly,npi,i,j,k,m
      PARAMETER (ndim=2 , NBPOLY=8 , NPI=9)
      DOUBLE PRECISION coor(8,2),fomega(2,8),fgamma(2,12),be(16),
     +   FFACE(2,npi),ARET(2,12),pressi(12),delta(9),F11(9),F12(9),
     +   F21(9),F22(9),DESUR(3),P25(NBPOLY,NPI),DP25(2,NBPOLY,NPI),
     +   POIDS(NPI),XYNPI(ndim,npi),SX,SY,xmi,ymi,xjm,yjm,arelon,
     +   xnu(3),ynu(3),X51,Y51,X52,Y52,X21,Y21,X62,Y62,X63,Y63,X32,
     +   Y32,X73,Y73,X74,Y74,X43,Y43,X81,Y81,X84,Y84,X41,Y41
C 2Q25 -- XYNPI: coordonnees pt. int. numeriques (element reference)
      DATA XYNPI /
     +            .11270166537925829D+00,   .11270166537925829D+00,
     +            .50000000000000000D+00,   .11270166537925829D+00,
     +            .88729833462074170D+00,   .11270166537925829D+00,
     +            .11270166537925829D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .88729833462074170D+00,   .50000000000000000D+00,
     +            .11270166537925829D+00,   .88729833462074170D+00,
     +            .50000000000000000D+00,   .88729833462074170D+00,
     +            .88729833462074170D+00,   .88729833462074170D+00 /
C     -- POIDS: poids du schema d'integration numerique.
      DATA POIDS / .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .19753086419753085D+00,   .12345679012345678D+00,
     +             .77160493827160503D-01,   .12345679012345678D+00,
     +             .77160493827160503D-01 /
C     -- Valeurs des Polynomes de base aux pt. int. numerique.
      DATA P25  / .43237900077244512D+00,  -.10000000000000000D+00,
     +           -.32379000772445008D-01,  -.99999999999999991D-01,
     +            .35491933384829665D+00,   .45080666151703314D-01,
     +            .45080666151703314D-01,   .35491933384829665D+00,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.10000000000000000D+00,
     +            .88729833462074170D+00,   .19999999999999998D+00,
     +            .11270166537925829D+00,   .19999999999999998D+00,
     +           -.10000000000000003D+00,   .43237900077244512D+00,
     +           -.99999999999999977D-01,  -.32379000772445015D-01,
     +            .35491933384829665D+00,   .35491933384829665D+00,
     +            .45080666151703308D-01,   .45080666151703314D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +           -.99999999999999991D-01,  -.99999999999999991D-01,
     +            .19999999999999998D+00,   .11270166537925829D+00,
     +            .19999999999999998D+00,   .88729833462074170D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +           -.25000000000000000D+00,  -.25000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +            .50000000000000000D+00,   .50000000000000000D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .19999999999999995D+00,   .88729833462074170D+00,
     +            .19999999999999995D+00,   .11270166537925829D+00,
     +           -.99999999999999977D-01,  -.32379000772444987D-01,
     +           -.10000000000000000D+00,   .43237900077244512D+00,
     +            .45080666151703308D-01,   .45080666151703308D-01,
     +            .35491933384829665D+00,   .35491933384829660D+00,
     +           -.10000000000000019D+00,  -.99999999999999977D-01,
     +           -.99999999999999977D-01,  -.99999999999999977D-01,
     +            .11270166537925829D+00,   .19999999999999995D+00,
     +            .88729833462074170D+00,   .19999999999999995D+00,
     +           -.32379000772445598D-01,  -.99999999999999866D-01,
     +            .43237900077244484D+00,  -.10000000000000008D+00,
     +            .45080666151703141D-01,   .35491933384829676D+00,
     +            .35491933384829676D+00,   .45080666151703141D-01 /
C     -- Valeurs Derive'es des Poly. de base aux pt int. numerique.
      DATA DP25  / 
     +           -.20618950038622250D+01,  -.20618950038622250D+01,
     +           -.68729833462074174D+00,  -.87298334620741685D-01,
     +           -.26189500386222502D+00,  -.26189500386222502D+00,
     +           -.87298334620741685D-01,  -.68729833462074174D+00,
     +            .27491933384829669D+01,  -.39999999999999996D+00,
     +            .39999999999999996D+00,   .34919333848296674D+00,
     +            .34919333848296674D+00,   .39999999999999996D+00,
     +           -.39999999999999996D+00,   .27491933384829669D+01,
     +           -.68729833462074152D+00,  -.77459666924148340D+00,
     +            .68729833462074174D+00,  -.77459666924148340D+00,
     +           -.87298334620741657D-01,  -.77459666924148340D+00,
     +            .87298334620741685D-01,  -.77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999996D+00,   .15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999996D+00,   .15491933384829668D+01,
     +            .68729833462074196D+00,  -.87298334620742101D-01,
     +            .20618950038622254D+01,  -.20618950038622250D+01,
     +            .87298334620741713D-01,  -.68729833462074174D+00,
     +            .26189500386222508D+00,  -.26189500386222497D+00,
     +           -.27491933384829669D+01,  -.39999999999999991D+00,
     +            .39999999999999996D+00,   .27491933384829669D+01,
     +           -.34919333848296674D+00,   .39999999999999991D+00,
     +           -.39999999999999996D+00,   .34919333848296674D+00,
     +           -.77459666924148340D+00,  -.68729833462074174D+00,
     +           -.77459666924148340D+00,   .87298334620741685D-01,
     +           -.77459666924148340D+00,  -.87298334620741685D-01,
     +           -.77459666924148340D+00,   .68729833462074174D+00,
     +            .15491933384829668D+01,  -.39999999999999996D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .15491933384829668D+01,   .39999999999999996D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .00000000000000000D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +            .77459666924148340D+00,   .87298334620741213D-01,
     +            .77459666924148340D+00,  -.68729833462074174D+00,
     +            .77459666924148340D+00,   .68729833462074174D+00,
     +            .77459666924148340D+00,  -.87298334620741657D-01,
     +           -.15491933384829668D+01,  -.39999999999999991D+00,
     +            .10000000000000000D+01,   .00000000000000000D+00,
     +           -.15491933384829668D+01,   .39999999999999991D+00,
     +           -.10000000000000000D+01,   .00000000000000000D+00,
     +           -.87298334620742157D-01,   .68729833462074174D+00,
     +           -.26189500386222502D+00,   .26189500386222502D+00,
     +           -.68729833462074174D+00,   .87298334620741685D-01,
     +           -.20618950038622254D+01,   .20618950038622250D+01,
     +            .34919333848296674D+00,  -.39999999999999996D+00,
     +            .39999999999999991D+00,  -.34919333848296674D+00,
     +            .27491933384829669D+01,   .39999999999999996D+00,
     +           -.39999999999999991D+00,  -.27491933384829669D+01,
     +            .87298334620741213D-01,   .77459666924148340D+00,
     +           -.87298334620741657D-01,   .77459666924148340D+00,
     +            .68729833462074174D+00,   .77459666924148340D+00,
     +           -.68729833462074196D+00,   .77459666924148340D+00,
     +            .00000000000000000D+00,  -.10000000000000000D+01,
     +            .39999999999999991D+00,  -.15491933384829668D+01,
     +            .00000000000000000D+00,   .10000000000000000D+01,
     +           -.39999999999999991D+00,  -.15491933384829668D+01,
     +            .26189500386222475D+00,   .26189500386222452D+00,
     +            .87298334620741879D-01,   .68729833462074174D+00,
     +            .20618950038622250D+01,   .20618950038622250D+01,
     +            .68729833462074152D+00,   .87298334620741657D-01,
     +           -.34919333848296663D+00,  -.39999999999999991D+00,
     +            .39999999999999991D+00,  -.27491933384829669D+01,
     +           -.27491933384829669D+01,   .39999999999999991D+00,
     +           -.39999999999999991D+00,  -.34919333848296663D+00 /
C
C --  INTEGRATION : TERMES SURFACIQUES  ----
c     -- Valeurs aux pt d'int. num. a partir valeurs aux noeuds
c        Efforts volumiques  fomega(ndim,noe) -> fface(ndim,npi)
      do 2 i = 1 , npi
        fface(1,i) = 0.d0
        fface(2,i) = 0.d0
        do 1 j = 1 , nbpoly
          fface(1,i) =  fface(1,i) + P25(j,i) * fomega(1,j)
          fface(2,i) =  fface(2,i) + P25(j,i) * fomega(2,j)
 1      continue
 2    continue
C     -----   CALCUL DE DELTA AUX NPI NOEUDS  -----
      DO 3 K=1,NPI
         F11(K) = 0.D0
         F12(K) = 0.D0
         F21(K) = 0.D0
         F22(K) = 0.D0
 3    CONTINUE
      DO 5 K=1,NPI
         DO 4 I=1,NBPOLY
            F11(K) = F11(K) + DP25(1,I,K) * coor(I,1)
            F12(K) = F12(K) + DP25(2,I,K) * coor(I,1)
            F21(K) = F21(K) + DP25(1,I,K) * coor(I,2)
            F22(K) = F22(K) + DP25(2,I,K) * coor(I,2)
 4       CONTINUE
         DELTA(K) = F11(K) * F22(K) - F12(K) * F21(K)
 5    CONTINUE
      DO 6 I=1,16
        BE(I) = 0.D+00
 6    CONTINUE
C
      DO 8 J=1,NBPOLY
        SX = 0.D0
        SY = 0.D0
        DO 7 K=1,NPI
          SX = SX + POIDS(K) * DELTA(K) * P25(J,K) * FFACE(1,K)
          SY = SY + POIDS(K) * DELTA(K) * P25(J,K) * FFACE(2,K)
 7     CONTINUE
        BE(2*J-1) = SX
        BE(2*J  ) = SY
 8      CONTINUE
C
C  -- INTEGRATION : TERMES DE BORD  ----
c
c     -- arete 1
      if(norefs(1,2) .ne. 0) then
        k         = 1
        J         = 2
        M         = k + 4
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) ) 
        aret(1,1) = fgamma(1,1) - pressi(1)*XNU(1)
        aret(2,1) = fgamma(2,1) - pressi(1)*YNU(1)
        aret(1,2) = fgamma(1,2) - pressi(2)*XNU(2)
        aret(2,2) = fgamma(2,2) - pressi(2)*YNU(2)
        aret(1,3) = fgamma(1,3) - pressi(3)*XNU(3)
        aret(2,3) = fgamma(2,3) - pressi(3)*YNU(3)
      else
        aret(1,1) = fgamma(1,1)
        aret(2,1) = fgamma(2,1)
        aret(1,2) = fgamma(1,2)
        aret(2,2) = fgamma(2,2)
        aret(1,3) = fgamma(1,3)
        aret(2,3) = fgamma(2,3)
      end if
      X51 = coor(5,1) - coor(1,1)
      Y51 = coor(5,2) - coor(1,2)
      X52 = coor(5,1) - coor(2,1)
      Y52 = coor(5,2) - coor(2,2)
      X21 = coor(2,1) - coor(1,1)
      Y21 = coor(2,2) - coor(1,2)
      DESUR(1) = DSQRT( (3.D0*X51 + X52)*(3.D0*X51 + X52)
     +         + (3.D0*Y51 + Y52)*(3.D0*Y51 + Y52) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X52 + X51)*(3.D0*X52 + X51)
     +         + (3.D0*Y52 + Y51)*(3.D0*Y52 + Y51) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X21*X21 + Y21*Y21) / 6.D0
      BE(1 ) = BE(1 ) + DESUR(1)*ARET(1,1)
      BE(2 ) = BE(2 ) + DESUR(1)*ARET(2,1)
      BE(3 ) = BE(3 ) + DESUR(2)*ARET(1,2)
      BE(4 ) = BE(4 ) + DESUR(2)*ARET(2,2)
      BE(9 ) = BE(9 ) + DESUR(3)*ARET(1,3)
      BE(10) = BE(10) + DESUR(3)*ARET(2,3)
C
c     -- arete 2
      if(norefs(2,2) .ne. 0) then
        k         = 2
        J         = 3
        M         = k + 4
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) )
        aret(1,4) = fgamma(1,4) - pressi(4)*XNU(1)
        aret(2,4) = fgamma(2,4) - pressi(4)*YNU(1)
        aret(1,5) = fgamma(1,5) - pressi(5)*XNU(2)
        aret(2,5) = fgamma(2,5) - pressi(5)*YNU(2)
        aret(1,6) = fgamma(1,6) - pressi(6)*XNU(3)
        aret(2,6) = fgamma(2,6) - pressi(6)*YNU(3)
      else
        aret(1,4) = fgamma(1,4)
        aret(2,4) = fgamma(2,4)
        aret(1,5) = fgamma(1,5)
        aret(2,5) = fgamma(2,5)
        aret(1,6) = fgamma(1,6)
        aret(2,6) = fgamma(2,6)
      end if
      X62 = coor(6,1) - coor(2,1)
      Y62 = coor(6,2) - coor(2,2)
      X63 = coor(6,1) - coor(3,1)
      Y63 = coor(6,2) - coor(3,2)
      X32 = coor(3,1) - coor(2,1)
      Y32 = coor(3,2) - coor(2,2)
      DESUR(1) = DSQRT( (3.D0*X62 + X63)*(3.D0*X62 + X63)
     +         + (3.D0*Y62 + Y63)*(3.D0*Y62 + Y63) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X63 + X62)*(3.D0*X63 + X62)
     +         + (3.D0*Y63 + Y62)*(3.D0*Y63 + Y62) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X32*X32 + Y32*Y32) / 6.D0
      BE(3 ) = BE(3 ) + DESUR(1)*ARET(1,4)
      BE(4 ) = BE(4 ) + DESUR(1)*ARET(2,4)
      BE(5 ) = BE(5 ) + DESUR(2)*ARET(1,5)
      BE(6 ) = BE(6 ) + DESUR(2)*ARET(2,5)
      BE(11) = BE(11) + DESUR(3)*ARET(1,6)
      BE(12) = BE(12) + DESUR(3)*ARET(2,6)
C
c     -- arete 3
      if(norefs(3,2) .ne. 0) then
        k         = 3
        J         = 4
        M         = k + 4
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) )
        aret(1,7) = fgamma(1,7) - pressi(7)*XNU(1)
        aret(2,7) = fgamma(2,7) - pressi(7)*YNU(1)
        aret(1,8) = fgamma(1,8) - pressi(8)*XNU(2)
        aret(2,8) = fgamma(2,8) - pressi(8)*YNU(2)
        aret(1,9) = fgamma(1,9) - pressi(9)*XNU(3)
        aret(2,9) = fgamma(2,9) - pressi(9)*YNU(3)
      else
        aret(1,7) = fgamma(1,7)
        aret(2,7) = fgamma(2,7)
        aret(1,8) = fgamma(1,8)
        aret(2,8) = fgamma(2,8)
        aret(1,9) = fgamma(1,9)
        aret(2,9) = fgamma(2,9)
      end if
c
      X73 = coor(7,1) - coor(3,1)
      Y73 = coor(7,2) - coor(3,2)
      X74 = coor(7,1) - coor(4,1)
      Y74 = coor(7,2) - coor(4,2)
      X43 = coor(4,1) - coor(3,1)
      Y43 = coor(4,2) - coor(3,2)
      DESUR(1) = DSQRT( (3.D0*X73 + X74)*(3.D0*X73 + X74)
     +         + (3.D0*Y73 + Y74)*(3.D0*Y73 + Y74) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X74 + X73)*(3.D0*X74 + X73)
     +         + (3.D0*Y74 + Y73)*(3.D0*Y74 + Y73) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X43*X43 + Y43*Y43) / 6.D0
      BE(5 ) = BE(5 ) + DESUR(1)*ARET(1,7)
      BE(6 ) = BE(6 ) + DESUR(1)*ARET(2,7)
      BE(7 ) = BE(7 ) + DESUR(2)*ARET(1,8)
      BE(8 ) = BE(8 ) + DESUR(2)*ARET(2,8)
      BE(13) = BE(13) + DESUR(3)*ARET(1,9)
      BE(14) = BE(14) + DESUR(3)*ARET(2,9)
C
c     -- arete 4
      if(norefs(4,2) .ne. 0) then
        k         = 4
        J         = 1
        M         = k + 4
        XMI    = coor(M,1) - coor(k,1)
        YMI    = coor(M,2) - coor(k,2)
        ARELON = DSQRT(XMI**2 + YMI**2)
        XNU(1)    =  YMI/ARELON
        YNU(1)    = -XMI/ARELON
        XJM    = coor(J,1) - coor(M,1)
        YJM    = coor(J,2) - coor(M,2)
        ARELON = DSQRT(XJM**2 + YJM**2)
        XNU(2)    =  YJM/ARELON
        YNU(2)    = -XJM/ARELON
        XNU(3)    = .5d0 * ( xnu(1) + xnu(2) ) 
        YNU(3)    = .5d0 * ( ynu(1) + ynu(2) )
        aret(1,10) = fgamma(1,10) - pressi(10)*XNU(1)
        aret(2,10) = fgamma(2,10) - pressi(10)*YNU(1)
        aret(1,11) = fgamma(1,11) - pressi(11)*XNU(2)
        aret(2,11) = fgamma(2,11) - pressi(11)*YNU(2)
        aret(1,12) = fgamma(1,12) - pressi(12)*XNU(3)
        aret(2,12) = fgamma(2,12) - pressi(12)*YNU(3)
      else
        aret(1,10) = fgamma(1,10)
        aret(2,10) = fgamma(2,10)
        aret(1,11) = fgamma(1,11)
        aret(2,11) = fgamma(2,11)
        aret(1,12) = fgamma(1,12)
        aret(2,12) = fgamma(2,12)
      end if
c

      X81 = coor(8,1) - coor(1,1)
      Y81 = coor(8,2) - coor(1,2)
      X84 = coor(8,1) - coor(4,1)
      Y84 = coor(8,2) - coor(4,2)
      X41 = coor(4,1) - coor(1,1)
      Y41 = coor(4,2) - coor(1,2)
      DESUR(1) = DSQRT( (3.D0*X84 + X81)*(3.D0*X84 + X81)
     +         + (3.D0*Y84 + Y81)*(3.D0*Y84 + Y81) ) / 6.D0
      DESUR(2) = DSQRT( (3.D0*X81 + X84)*(3.D0*X81 + X84)
     +         + (3.D0*Y81 + Y84)*(3.D0*Y81 + Y84) ) / 6.D0
      DESUR(3) = 4.D0* DSQRT( X41*X41 + Y41*Y41) / 6.D0
      BE(7 ) = BE(7 ) + DESUR(1)*ARET(1,10)
      BE(8 ) = BE(8 ) + DESUR(1)*ARET(2,10)
      BE(1 ) = BE(1 ) + DESUR(2)*ARET(1,11)
      BE(2 ) = BE(2 ) + DESUR(2)*ARET(2,11)
      BE(15) = BE(15) + DESUR(3)*ARET(1,12)
      BE(16) = BE(16) + DESUR(3)*ARET(2,12)
c
      END
