      SUBROUTINE ETS3P1D(COOR,volf,sur,pres,noref,BE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                  S.P. ES3P1D
C                  ------------
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DU SECOND MEMBRE ELEMENTAIRE ELASTIQUE
C  ---      TETRAEDRE P1 DROIT  . 
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : COORDONNEES DES POINTS DE L ELEMENT (SIMPLE PRECISION)
C   VOLF    : FORCES VOLUMIQUES
C   NOREF   : noref(nbface,2) avec nbface = nombre de faces
c             noref(i,1) =/ 0 si face i soumise force surfacique
c             noref(2,1) =/ 0 si face i soumise a pression
C   SUR     : efforts surfaciques
c   pres    : pression
C  PARAMETRE DE SORTIE  :
C  --------------------

C   BE      : TABLEAU DES SECONDS MEMBRES
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEUR  : Marina Vidrascu 2001
C ...................................................................
      parameter (ndim=3, nno=4, npo=4, npi=4,
     *           nbface=4, npof=3, nnof=3, npis=3)
      double precision VOLF(3,nno),BE(NNO*ndim),sur(3,nnof,nbface),
     *                  pres(nnof,nbface),COOR(NPO,3)
      DIMENSION nloc(npof,nbface),noref(nbface,2)
      double precision poids(npi),poisms(npis),delta(npi),delts(npis),
     &                 vp1(nno,npi),DP(ndim,nno,npi),
     &                 vps1(nnof,npis),dps1(2,nnof,npis)
c

      data nloc/ 1,3,2,  1,4,3,  1,2,4,  2,3,4/

      DATA DP/-1.D0 ,-1.D0 ,-1.D0 , 1.D0,3*0.D0,1.D0,3*0.D0,1.D0,
     &        -1.D0 ,-1.D0 ,-1.D0 , 1.D0,3*0.D0,1.D0,3*0.D0,1.D0,   
     &        -1.D0 ,-1.D0 ,-1.D0 , 1.D0,3*0.D0,1.D0,3*0.D0,1.D0,   
     &        -1.D0 ,-1.D0 ,-1.D0 , 1.D0,3*0.D0,1.D0,3*0.D0,1.D0/
      data vp1 /1.,0.,0.,0.,  0.,1.,0.,0.,  0.,0.,1.,0.,
     &          0.,0.,0.,1./
      data dps1/2*-1.D0, 1.D0, 2*0.D0, 1.D0,
     &          2*-1.D0, 1.D0, 2*0.D0, 1.D0,
     &          2*-1.D0, 1.D0, 2*0.D0, 1.D0/
      data vps1/1.,0.,0.,  0.,1.,0.,  0.,0.,1./
C
      data poids / 4*  4.166666666666666E-02/
c         poids = .25/6.
      data poisms / 3*  .1666666666666667/
c         poisms = .5/3
C

         CALL ES3C2C(NNO,NPO,NBFACE,NPOF,NNOF,NOREF,
     +               NPI,poids,NPIS,POISMS,NLOC,
     +               COOR(1,1),COOR(1,2),COOR(1,3),VOLF,sur,pres,VP1,
     +               VP1,dp,dp,dps1,vps1,vps1,BE,delts,delta)
       END


