      SUBROUTINE ETS3P2C(COOR,volf,sur,pres,noref,BE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                  S.P. ES3P1D
C                  ------------
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DU SECOND MEMBRE ELEMENTAIRE ELASTIQUE
C  ---      TETRAEDRE P1 DROIT  . 
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : COORDONNEES DES POINTS DE L ELEMENT (SIMPLE PRECISION)
C   VOLF    : FORCES VOLUMIQUES
C   NOREF   : noref(nbface,2) avec nbface = nombre de faces
c             noref(i,1) =/ 0 si face i soumise force surfacique
c             noref(2,1) =/ 0 si face i soumise a pression
C   SUR     : efforts surfaciques
c   pres    : pression

C  PARAMETRE DE SORTIE  :
C  --------------------

C   BE      : TABLEAU DES SECONDS MEMBRES
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEUR  : Marina Vidrascu 2001
C ...................................................................
      parameter (ndim=3, nno=10, npo=10, npi=15,
     *           nbface=4, npof=6, nnof=6, npis=7)
      double precision VOLF(3,nno),BE(NNO*ndim),sur(3,nnof,nbface),
     *                  pres(nnof,nbface),COOR(NPO,3)
      DIMENSION nloc(npof,nbface),noref(nbface,2)
      double precision poids(npi),poisms(npis),delta(npi),delts(npis),
     &                 vp(nno,npi),VDPQ2(ndim,nno,npi),
     &                 vps(nnof,npis),vdpsq1(2,nnof,npis)

      double precision dp1(ndim,nno,5),dp2(ndim,nno,5),dp3(ndim,nno,5)
      equivalence (dp1,VDPQ2(1,1,1)), (dp2,VDPQ2(1,1,6)),
     *            (dp3,VDPQ2(1,1,11))
c
      DATA NLOC/1,3,2,7,6,5,
     +          1,4,3,8,10,7,
     +          1,2,4,5,9,8,
     +          2,3,4,6,10,9/
C
      DATA dp1/.0000000000000E+00,.000000000000E+00,.00000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00,.000000000000000E+00,.000000000000E+00,
     *    .000000000000000E+00, -1.00000000000000 , -1.00000000000000 ,
     *     1.00000000000000 ,  1.00000000000000 , .000000000000000E+00,
     *    -1.00000000000000 , .000000000000000E+00, -1.00000000000000 ,
     *    -1.00000000000000 , -1.00000000000000 , .000000000000000E+00,
     *     1.00000000000000 , .000000000000000E+00,  1.00000000000000 ,
     *    .000000000000000E+00,  1.00000000000000 ,  1.00000000000000 ,
     *    -1.89634706336732 , -1.89634706336732 , -1.89634706336732 ,
     *    -.632115687789108 ,.000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *     2.52846275115643 , -.367884312210892 , -.367884312210892 ,
     *    .367884312210892 , .367884312210892 , .000000000000000E+00,
     *    -.367884312210892 ,  2.52846275115643 , -.367884312210892 ,
     *    -.367884312210892 , -.367884312210892 ,  2.52846275115643 ,
     *    .367884312210892 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00, .367884312210892 , .367884312210892 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *     1.89634706336732 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *    -2.52846275115643 , -2.89634706336732 , -2.89634706336732 ,
     *    .367884312210892 ,  2.89634706336732 , .000000000000000E+00,
     *    -.367884312210892 , .000000000000000E+00, -.367884312210892 ,
     *    -.367884312210892 , -.367884312210892 , .000000000000000E+00,
     *    .367884312210892 , .000000000000000E+00,  2.89634706336732 ,
     *    .000000000000000E+00, .367884312210892 , .367884312210892 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *    -.632115687789108 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00,  1.89634706336732,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.632115687789108 ,
     *    .000000000000000E+00, -.367884312210892 , -.367884312210892 ,
     *     2.89634706336732 , .367884312210892 , .000000000000000E+00,
     *    -2.89634706336732 , -2.52846275115643 , -2.89634706336732 ,
     *    -.367884312210892 , -.367884312210892 , .000000000000000E+00,
     *    .367884312210892 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00, .367884312210892 ,  2.89634706336732 ,
     *    .632115687789108 , .632115687789108 , .632115687789108 ,
     *    -.632115687789108 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.632115687789108 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, 1.89634706336732 ,
     *    .000000000000000E+00, -.367884312210892 , -.367884312210892 ,
     *    .367884312210892 , .367884312210892 , .000000000000000E+00,
     *    -.367884312210892 , .000000000000000E+00, -.367884312210892 ,
     *    -2.89634706336732 , -2.89634706336732 , -2.52846275115643 ,
     *     2.89634706336732 , .000000000000000E+00, .367884312210892 ,
     *    .000000000000000E+00,  2.89634706336732 , .367884312210892/

       data dp2 /.837523533955559 , .837523533955559 , .837523533955559,
     *    .279174511318520 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *    -1.11669804527408 , -1.27917451131852 , -1.27917451131852 ,
     *     1.27917451131852 ,  1.27917451131852 , .000000000000000E+00,
     *    -1.27917451131852 , -1.11669804527408 , -1.27917451131852 ,
     *    -1.27917451131852 , -1.27917451131852 , -1.11669804527408 ,
     *     1.27917451131852 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00,  1.27917451131852 ,  1.27917451131852 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    -.837523533955559 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *     1.11669804527408 , -.162476466044441 , -.162476466044441 ,
     *     1.27917451131852 , .162476466044441 , .000000000000000E+00,
     *    -1.27917451131852 , .000000000000000E+00, -1.27917451131852 ,
     *    -1.27917451131852 , -1.27917451131852 , .000000000000000E+00,
     *     1.27917451131852 , .000000000000000E+00, .162476466044441 ,
     *    .000000000000000E+00,  1.27917451131852 ,  1.27917451131852 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    .279174511318520 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.837523533955559 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .279174511318520 ,
     *    .000000000000000E+00, -1.27917451131852 , -1.27917451131852 ,
     *    .162476466044441 ,  1.27917451131852 , .000000000000000E+00,
     *    -.162476466044441 ,  1.11669804527408 , -.162476466044441 ,
     *    -1.27917451131852 , -1.27917451131852 , .000000000000000E+00,
     *     1.27917451131852 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00,  1.27917451131852 , .162476466044441 ,
     *    -.279174511318520 , -.279174511318520 , -.279174511318520 ,
     *    .279174511318520 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .279174511318520 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.837523533955559 ,
     *    .000000000000000E+00, -1.27917451131852 , -1.27917451131852 ,
     *     1.27917451131852 ,  1.27917451131852 , .000000000000000E+00,
     *    -1.27917451131852 , .000000000000000E+00, -1.27917451131852 ,
     *    -.162476466044441 , -.162476466044441 ,  1.11669804527408 ,
     *    .162476466044441 , .000000000000000E+00,  1.27917451131852 ,
     *    .000000000000000E+00, .162476466044441 ,  1.27917451131852 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *    .000000000000000E+00, -.225403330758517 , -.225403330758517 ,
     *     1.77459666924148 , .225403330758517 , .000000000000000E+00,
     *    -1.77459666924148 , -1.54919333848297 , -1.77459666924148 ,
     *    -1.77459666924148 , -1.77459666924148 , -1.54919333848297 ,
     *     1.77459666924148 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00,  1.77459666924148 ,  1.77459666924148/

      data dp3/-.774596669241483, -.774596669241483, -.774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *     1.54919333848297 , -.225403330758517 , -.225403330758517 ,
     *    .225403330758517 , .225403330758517 , .000000000000000E+00,
     *    -.225403330758517 ,  1.54919333848297 , -.225403330758517 ,
     *    -1.77459666924148 , -1.77459666924148 , .000000000000000E+00,
     *     1.77459666924148 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00,  1.77459666924148 , .225403330758517 ,
     *    -.774596669241483 , -.774596669241483 , -.774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.774596669241483 ,
     *    .000000000000000E+00, -1.77459666924148 , -1.77459666924148 ,
     *    .225403330758517 ,  1.77459666924148 , .000000000000000E+00,
     *    -.225403330758517 ,  1.54919333848297 , -.225403330758517 ,
     *    -.225403330758517 , -.225403330758517 ,  1.54919333848297 ,
     *    .225403330758517 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00, .225403330758517 , .225403330758517 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, -.774596669241483,
     *    -1.54919333848297 , -1.77459666924148 , -1.77459666924148 ,
     *     1.77459666924148 ,  1.77459666924148 , .000000000000000E+00,
     *    -1.77459666924148 , -1.54919333848297 , -1.77459666924148 ,
     *    -.225403330758517 , -.225403330758517 , .000000000000000E+00,
     *    .225403330758517 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00, .225403330758517 ,  1.77459666924148 ,
     *    .774596669241483 , .774596669241483 , .774596669241483 ,
     *    .774596669241483 , .000000000000000E+00, .000000000000000E+00,
     *    .000000000000000E+00, -.774596669241483 ,.000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00, .774596669241483 ,
     *    -1.54919333848297 , -1.77459666924148 , -1.77459666924148 ,
     *    .225403330758517 ,  1.77459666924148 , .000000000000000E+00,
     *    -.225403330758517 , .000000000000000E+00, -.225403330758517 ,
     *    -1.77459666924148 , -1.77459666924148 , -1.54919333848297 ,
     *     1.77459666924148 , .000000000000000E+00,  1.77459666924148 ,
     *    .000000000000000E+00,  1.77459666924148 , .225403330758517 ,
     *    -.774596669241483 , -.774596669241483 , -.774596669241483 ,
     *    -.774596669241483 , .000000000000000E+00,.000000000000000E+00,
     *    .000000000000000E+00, .774596669241483 , .000000000000000E+00,
     *    .000000000000000E+00, .000000000000000E+00,-.774596669241483 ,
     *     1.54919333848297 , -.225403330758517 , -.225403330758517 ,
     *     1.77459666924148 , .225403330758517 , .000000000000000E+00,
     *    -1.77459666924148 , .000000000000000E+00, -1.77459666924148 ,
     *    -.225403330758517 , -.225403330758517 ,  1.54919333848297 ,
     *    .225403330758517 , .000000000000000E+00, .225403330758517 ,
     *    .000000000000000E+00, .225403330758517 ,  1.77459666924148/
      DATA VP/ -.125000000000000 ,-.125000000000000 ,-.125000000000000 ,
     *    -.125000000000000 , .250000000000000 , .250000000000000 ,
     *    .250000000000000 , .250000000000000 , .250000000000000 ,
     *    .250000000000000 , .324516523092734 , -.750537196563629E-01,
     *    -.750537196563629E-01, -.750537196563629E-01,.266380161832731,
     *    .338347167927203E-01, .266380161832731 , .266380161832731 ,
     *  .338347167927203E-01,.338347167927203E-01,-.750537196563630E-01,
     *   .324516523092734, -.750537196563629E-01,-.750537196563629E-01,
     *    .266380161832731 , .266380161832731 , .338347167927203E-01,
     *    .338347167927203E-01, .266380161832731 , .338347167927203E-01,
     *    -.750537196563627E-01,-.750537196563629E-01,.324516523092734 ,
     *    -.750537196563629E-01, .338347167927203E-01,.266380161832731 ,
     *    .266380161832731 , .338347167927203E-01, .338347167927203E-01,
     *    .266380161832731 ,-.750537196563627E-01,-.750537196563629E-01,
     *    -.750537196563629E-01,.324516523092734 , .338347167927203E-01,
     *    .338347167927203E-01, .338347167927203E-01, .266380161832731 ,
     *    .266380161832731 , .266380161832731 , -.373192912588241E-01,
     *    -.115257699028758 , -.115257699028758 , -.115257699028758 ,
     *    .519589385132896E-01, .409071857601743 , .519589385132896E-01,
     *    .519589385132896E-01, .409071857601743 , .409071857601743 ,
     *    -.115257699028758 , -.373192912588239E-01, -.115257699028758 ,
     *    -.115257699028758 ,.519589385132895E-01, .519589385132894E-01,
     *    .409071857601743 , .409071857601743 , .519589385132894E-01,
     *    .409071857601743 , -.115257699028758 , -.115257699028758 ,
     *    -.373192912588239E-01, -.115257699028758 , .409071857601743 ,
     *    .519589385132894E-01, .519589385132895E-01, .409071857601743 ,
     *    .409071857601743 , .519589385132894E-01, -.115257699028758 ,
     *    -.115257699028758 , -.115257699028758 , -.373192912588239E-01,
     *    .409071857601743 , .409071857601743 , .409071857601743 ,
     *   .519589385132895E-01,.519589385132894E-01,.519589385132894E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *  -.500000000000000E-01,.127016653792583E-01,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.100000000000000E+00,
     *   .787298334620742 ,-.500000000000000E-01,-.500000000000000E-01,
     *   -.500000000000000E-01,-.500000000000000E-01,.100000000000000 ,
     *   .127016653792583E-01,.100000000000000 ,.787298334620742 ,
     *  .100000000000000E+00,.100000000000000E+00,-.500000000000001E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   .787298334620742 ,.100000000000000E+00,.100000000000000E+00,
     *   .100000000000000E+00,.100000000000000E+00,.127016653792583E-01,
     *-.499999999999999E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   -.500000000000000E-01,.999999999999999E-01,.787298334620742 ,
     *   .999999999999999E-01,.127016653792583E-01,.100000000000000E+00,
     * .100000000000000E+00,-.500000000000000E-01,-.500000000000000E-01,
     * -.500000000000000E-01,-.500000000000000E-01,.100000000000000E+00,
     *   .100000000000000E+00,.127016653792583E-01,.100000000000000E+00,
     *   .787298334620742 ,.100000000000000E+00,-.500000000000000E-01,
     *-.500000000000000E-01,-.500000000000000E-01,-.500000000000000E-01,
     *   .100000000000000E+00,.100000000000000E+00,.787298334620742 ,
     *   .100000000000000E+00,.127016653792583E-01,.100000000000000E+00/
      DATA POIDS/.197530873119831E-01,.119895139631698E-01,
     *   .119895139631698E-01,
     *   .119895139631698E-01,.119895139631698E-01,.115113678710454E-01,
     *   .115113678710454E-01,.115113678710454E-01,.115113678710454E-01,
     *   .881834235042334E-02,.881834235042334E-02,.881834235042334E-02,
     *   .881834235042334E-02,.881834235042334E-02,.881834235042334E-02/


      DATA VDPSQ1/-2.18970794141235,-2.18970794141235,-.594853970706175,
     *     .000000000000000E+00, .000000000000000E+00,-.594853970706175,
     *     2.78456191211852 , -.405146029293825 ,  .405146029293825 ,
     *     .405146029293825 , -.405146029293825 ,  2.78456191211852 ,
     *     .594853970706174 ,  .594853970706174 ,  2.18970794141235 ,
     *     .000000000000000E+00,.000000000000000E+00,-.594853970706175 ,
     *    -2.78456191211852 , -3.18970794141235 ,  .405146029293825 ,
     *     3.18970794141235 , -.405146029293825 ,  .000000000000000E+00,
     *     .594853970706174 ,  .594853970706174 , -.594853970706175 ,
     *     .000000000000000E+00, .000000000000000E+00, 2.18970794141235,
     *     .000000000000000E+00, -.405146029293825 ,  3.18970794141235 ,
     *     .405146029293825 , -3.18970794141235 , -2.78456191211852 ,
     *    -.880568256420461 , -.880568256420461 ,  .880568256420460 ,
     *     .000000000000000E+00,.000000000000000E+00, -.761136512840921,
     *     .000000000000000E+00, -1.88056825642046 ,  .238863487159079 ,
     *     1.88056825642046 , -.238863487159079 ,  1.64170476926138 ,
     *     .761136512840920 ,  .761136512840920 ,  .880568256420460 ,
     *     .000000000000000E+00, .000000000000000E+00, .880568256420460,
     *    -1.64170476926138 , -1.88056825642046 ,  1.88056825642046 ,
     *     1.88056825642046 , -1.88056825642046 , -1.64170476926138 ,
     *    -.880568256420461 , -.880568256420461 , -.761136512840921 ,
     *     .000000000000000E+00, .000000000000000E+00,.880568256420460,
     *     1.64170476926138 , -.238863487159079 ,  1.88056825642046 ,
     *     .238863487159079 , -1.88056825642046 ,  .000000000000000E+00,
     *    -.333333253860474 , -.333333253860474 ,  .333333373069763 ,
     *     .000000000000000E+00, .000000000000000E+00,.333333373069763 ,
     *    -.119209289550781E-06, -1.33333337306976 ,  1.33333337306976 ,
     *     1.33333337306976 , -1.33333337306976 , -.119209289550781E-06/
      DATA VPS/.474352608585539 , -.807685941918872E-01, 
     *    -.807685941918872E-01,
     *     .323074376767549 ,  .410358262631383E-01,  .323074376767549 ,
     *    -.807685941918870E-01,.474352608585538, -.807685941918872E-01,
     *    .323074376767549 , .323074376767549 , .410358262631383E-01,
     *    -.807685941918870E-01, -.807685941918872E-01,.474352608585538,
     *    .410358262631383E-01, .323074376767549 , .323074376767549 ,
     *-.280749432230788E-01,-.280749432230789E-01,-.525839011025453E-01,
     *    .884134241764073 , .112299772892315 , .112299772892315 ,
     *-.525839011025456E-01,-.280749432230789E-01,-.280749432230789E-01,
     *    .112299772892315 , .884134241764072 , .112299772892315 ,
     *-.280749432230788E-01,-.525839011025453E-01,-.280749432230789E-01,
     *    .112299772892315 , .112299772892315 ,  .884134241764073 ,
     *    -.111111117733849 , -.111111107799742 , -.111111107799742 ,
     *     .444444431198967 ,  .444444470935398 ,  .444444431198967/
      DATA POISMS/.629695902724136E-01,.629695902724136E-01,
     *    .629695902724136E-01, .661970763942531E-01,
     *    .661970763942531E-01, .661970763942531E-01,
     *    .112499997019768/                      

         CALL ES3C2C(NNO,NPO,NBFACE,NPOF,NNOF,NOREF,
     +               NPI,poids,NPIS,POISMS,NLOC,
     +                COOR(1,1),COOR(1,2),COOR(1,3),VOLF,sur,pres,VP,
     +               VP,vdpq2,vdpq2,vdpsq1,vps,vps,BE,delts,delta)
       END


