      SUBROUTINE ETS3Q1D(coor,volf,sur,pres,noref,BE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                  S.P. ES3Q1D
C                  ------------
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DU SECOND MEMBRE ELEMENTAIRE ELASTIQUE
C  ---     HEXAEDRE Q1 DROIT  . 
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : COORDONNEES DES POINTS DE L ELEMENT (SIMPLE PRECISION)
C   VOLF    : FORCES VOLUMIQUES
C   NOREF   : noref(nbface,2) avec nbface = nombre de faces
c             noref(i,1) =/ 0 si face i soumise force surfacique
c             noref(2,1) =/ 0 si face i soumise a pression
C   SUR     : efforts surfaciques
c   pres    : pression

C  PARAMETRE DE SORTIE  :
C  --------------------

C   BE      : TABLEAU DES SECONDS MEMBRES
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEUR  : Marina Vidrascu 2001
C ...................................................................
      parameter (ndim=3, nno=8, npo=8, npi=8,
     *           nbface=6, npof=4, nnof=4, npis=4)
      double precision VOLF(3,nno),BE(NNO*ndim),sur(3,nnof,nbface),
     *                  pres(nnof,nbface), COOR(NPO,3)
      DIMENSION nloc(npof,nbface),noref(nbface,2)
      double precision poids(npi),poisms(npis),delta(npi),delts(npis),
     &                 vp1(nno,npi),DP(ndim,nno,npi),
     &                 vps1(nnof,npis),dps1(2,nnof,npis)
c
      DATA NLOC/ 1, 4, 3, 2,   1, 5, 8, 4,
     +           1, 2, 6, 5,   5, 6, 7, 8,
     +           2, 3, 7, 6,   3, 4, 8, 7/

      DATA DP/ -.622008467928146 ,-.622008467928146 , -.622008467928146,
     *    .622008467928146  , -.166666666666667  , -.166666666666667  ,
     *    .166666666666667  , .166666666666667  , -.446581987385204E-01,
     *    -.166666666666667  , .622008467928146  , -.166666666666667  ,
     *    -.166666666666667  , -.166666666666667  , .622008467928146  ,
     *    .166666666666667  , -.446581987385204E-01, .166666666666667  ,
     *   .446581987385204E-01,.446581987385204E-01,.446581987385204E-01,
     *    -.446581987385204E-01, .166666666666667  , .166666666666667  ,
     *    -.622008467928146  , -.166666666666667  , -.166666666666667  ,
     *    .622008467928146  , -.622008467928146  , -.622008467928146  ,
     *    .166666666666667  , .622008467928146  , -.166666666666667  ,
     *   -.166666666666667  , .166666666666667  , -.446581987385204E-01,
     *    -.166666666666667  , -.446581987385204E-01, .166666666666667,
     *    .166666666666667  , -.166666666666667  , .622008467928146  ,
     *    .446581987385204E-01, .166666666666667  , .166666666666667  ,
     * -.446581987385204E-01, .446581987385204E-01,.446581987385204E-01,
     *    -.166666666666667  , -.622008467928146  , -.166666666666667  ,
     *   .166666666666667  , -.166666666666667  , -.446581987385204E-01,
     *    .622008467928146  , .166666666666667  , -.166666666666667  ,
     *    -.622008467928146  , .622008467928146  , -.622008467928146  ,
     *    -.446581987385204E-01, -.166666666666667  , .166666666666667,
     *  .446581987385204E-01,-.446581987385204E-01,.446581987385204E-01,
     *    .166666666666667  , .446581987385204E-01, .166666666666667  ,
     *    -.166666666666667  , .166666666666667  , .622008467928146  ,
     * -.166666666666667  , -.166666666666667  , -.446581987385205E-01,
     *    .166666666666667  , -.622008467928146  , -.166666666666667  ,
     *    .622008467928146  , .622008467928146  , -.622008467928146  ,
     *    -.622008467928146  , .166666666666667  , -.166666666666667  ,
     * -.446581987385204E-01,-.446581987385204E-01,.446581987385205E-01,
     *    .446581987385204E-01, -.166666666666667  , .166666666666667  ,
     *    .166666666666667  , .166666666666667  , .622008467928146  ,
     *    -.166666666666667  , .446581987385204E-01, .166666666666667  ,
     *    -.166666666666667  , -.166666666666667  , -.622008467928146  ,
     *    .166666666666667  , -.446581987385204E-01, -.166666666666667 ,
     *.446581987385204E-01, .446581987385204E-01, -.446581987385204E-01,
     *    -.446581987385204E-01, .166666666666667  , -.166666666666667,
     *    -.622008467928146  , -.622008467928146  , .622008467928146  ,
     *    .622008467928146  , -.166666666666667  , .166666666666667  ,
     *    .166666666666667  , .166666666666667  , .446581987385204E-01,
     *    -.166666666666667  , .622008467928146  , .166666666666667  ,
     *    -.166666666666667  , -.446581987385205E-01, -.166666666666667,
     *    .166666666666667  , -.166666666666667  , -.622008467928146  ,
     *    .446581987385204E-01, .166666666666667  , -.166666666666667  ,
     * -.446581987385204E-01,.446581987385205E-01,-.446581987385204E-01,
     *    -.622008467928146  , -.166666666666667  , .166666666666667  ,
     *    .622008467928146  , -.622008467928146  , .622008467928146  ,
     *    .166666666666667  , .622008467928146  , .166666666666667  ,
     *    -.166666666666667  , .166666666666667  , .446581987385204E-01,
     *    -.446581987385205E-01, -.166666666666667  , -.166666666666667,
     * .446581987385205E-01,-.446581987385204E-01,-.446581987385204E-01,
     *    .166666666666667  , .446581987385204E-01, -.166666666666667  ,
     *    -.166666666666667  , .166666666666667  , -.622008467928146  ,
     *    -.166666666666667  , -.622008467928146  , .166666666666667  ,
     *    .166666666666667  , -.166666666666667  , .446581987385204E-01,
     *    .622008467928146  , .166666666666667  , .166666666666667  ,
     *    -.622008467928146  , .622008467928146  , .622008467928146  ,
     *    -.446581987385205E-01,-.446581987385205E-01,
     *    -.446581987385205E-01,
     *    .446581987385205E-01, -.166666666666667 , -.166666666666667  ,
     *    .166666666666667 , .166666666666667  , -.622008467928146  ,
     *    -.166666666666667 , .446581987385205E-01, -.166666666666667  ,
     *    -.166666666666667  , -.166666666666667 , .446581987385205E-01,
     *    .166666666666667  , -.622008467928146  , .166666666666667  ,
     *    .622008467928146  , .622008467928146  , .622008467928146  ,
     *    -.622008467928146  , .166666666666667  , .166666666666667/
      DATA VP1/.490562612162344 ,.131445855765802 ,.352208109008645E-01,
     *    .131445855765802  , .131445855765802  , .352208109008645E-01,
     *    .943738783765593E-02,.352208109008645E-01, .131445855765802  ,
     *    .490562612162344  , .131445855765802  , .352208109008645E-01,
     *    .352208109008645E-01, .131445855765802 , .352208109008645E-01,
     *    .943738783765593E-02, .131445855765802 , .352208109008645E-01,
     *    .131445855765802  , .490562612162344  , .352208109008645E-01,
     *    .943738783765593E-02, .352208109008645E-01,.131445855765802  ,
     *    .352208109008645E-01, .131445855765802  , .490562612162344  ,
     *    .131445855765802  , .943738783765594E-02,.352208109008645E-01,
     *    .131445855765802  , .352208109008645E-01, .131445855765802  ,
     *   .352208109008645E-01,.943738783765593E-02,.352208109008645E-01,
     *    .490562612162344  , .131445855765802  , .352208109008645E-01,
     *    .131445855765802  , .352208109008646E-01, .131445855765802  ,
     *    .352208109008645E-01, .943738783765594E-02, .131445855765802 ,
     *    .490562612162344  , .131445855765802  , .352208109008645E-01,
     *   .352208109008646E-01,.943738783765594E-02,.352208109008645E-01,
     *    .131445855765802  , .131445855765802  , .352208109008645E-01,
     *    .131445855765802  , .490562612162344  , .943738783765602E-02,
     *    .352208109008645E-01, .131445855765802 , .352208109008645E-01,
     *    .352208109008645E-01, .131445855765802 , .490562612162344  ,
     *    .131445855765802 /

C
      DATA POIDS/ .125000000000000, .125000000000000, .125000000000000,
     *    .125000000000000  , .125000000000000  , .125000000000000  ,
     *    .125000000000000  , .125000000000000 /

      DATA dps1/ -.788675134594813 ,-.788675134594813 ,.788675134594813,
     *    -.211324865405187  ,  .211324865405187  ,  .211324865405187  ,
     *    -.211324865405187  ,  .788675134594813  , -.788675134594813  ,
     *    -.211324865405187  ,  .788675134594813  , -.788675134594813  ,
     *     .211324865405187  ,  .788675134594813  , -.211324865405187  ,
     *     .211324865405187  , -.211324865405187  , -.788675134594813  ,
     *     .211324865405187  , -.211324865405187  ,  .788675134594813  ,
     *     .211324865405187  , -.788675134594813  ,  .788675134594813  ,
     *    -.211324865405187  , -.211324865405187  ,  .211324865405187  ,
     *    -.788675134594813  ,  .788675134594813  ,  .788675134594813  ,
     *    -.788675134594813  ,  .211324865405187/
      DATA vps1/.622008467928146 ,.166666666666667,.446581987385204E-01,
     *     .166666666666667  , .166666666666667  , .622008467928146  ,
     *     .166666666666667  , .446581987385204E-01, .166666666666667  ,
     *     .446581987385204E-01, .166666666666667  , .622008467928146  ,
     *     .446581987385205E-01, .166666666666667  , .622008467928146  ,
     *     .166666666666667/

      DATA POISms/.250000000000000 , .250000000000000, .250000000000000,
     *     .250000000000000 /
C

         CALL ES3C2C(NNO,NPO,NBFACE,NPOF,NNOF,NOREF,
     +               NPI,poids,NPIS,POISMS,NLOC,
     +               COOR(1,1),COOR(1,2),COOR(1,3),VOLF,sur,pres,VP1,
     +               VP1,dp,dp,dps1,vps1,vps1,BE,delts,delta)
       END


