      SUBROUTINE ETS3R1D(coor,vol,SURF,pres,noref,BE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                  S.P. ETS3R1D
C                  ------------
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DU SECOND MEMBRE ELEMENTAIRE ELASTIQUE
C  ---      PENTAEDRE R1 DROIT  . 
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : COORDONNEES DES POINTS DE L ELEMENT (SIMPLE PRECISION)
C   VOLF    : FORCES VOLUMIQUES
C   NOREF   : noref(nbface,2) avec nbface = nombre de faces
c             noref(i,1) =/ 0 si face i soumise force surfacique
c             noref(2,1) =/ 0 si face i soumise a pression
C   SUR     : efforts surfaciques
c   pres    : pression

C  PARAMETRE DE SORTIE  :
C  --------------------

C   BE      : TABLEAU DES SECONDS MEMBRES
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEUR  : Marina Vidrascu 2001
C ...................................................................
      parameter (ndim=3, nno=6, npo=6, npi=6, npisq = 4, npisp = 1,
     *           nnop = 3, nnoq = 4, npop=3, npoq=4 ,nbface=5 )
      DIMENSION nloc(npoq,nbface), noref(nbface,2)
      DOUBLE PRECISION POIR(NPI),POIQS(NPISQ),POIPS(NPISP),
     +   BE(3,NNO),VOL(3,Nno),SURF(3,nnoq,NBFACE),pres(nnoq,NBFACE),
     +   PR1(NPO,NPI),DPR1(3,NPO,NPI), PQS1(NPOQ,NPISQ),
     +   DPQS1(2,NPOQ,NPISQ),PPS1(NPOP,NPISP),
     +   DPPS1(2,npop,npisp), DELTS(npisq),DELTA(npi),COOR(NPO,3)

      data nloc/ 1,3,2,0,  1,4,6,3,  1,2,5,4,  4,5,6,0,  2,3,5,6/

      DATA DPR1/ -.788675134594813,-.788675134594813, -.666666666666667,
     *     .788675134594813,  .000000000000000E+00, -.166666666666667,
     *     .000000000000000E+00,  .788675134594813, -.166666666666667,
     *    -.211324865405187, -.211324865405187,  .666666666666667,
     *     .211324865405187,  .000000000000000E+00,  .166666666666667,
     *     .000000000000000E+00,  .211324865405187,  .166666666666667,
     *    -.788675134594813, -.788675134594813, -.166666666666667,
     *     .788675134594813,  .000000000000000E+00, -.666666666666667,
     *     .000000000000000E+00,  .788675134594813, -.166666666666667,
     *    -.211324865405187, -.211324865405187,  .166666666666667,
     *     .211324865405187,  .000000000000000E+00,  .666666666666667,
     *     .000000000000000E+00,  .211324865405187,  .166666666666667,
     *    -.788675134594813, -.788675134594813, -.166666666666667,
     *     .788675134594813,  .000000000000000E+00, -.166666666666667,
     *     .000000000000000E+00,  .788675134594813, -.666666666666667,
     *    -.211324865405187, -.211324865405187,  .166666666666667,
     *     .211324865405187,  .000000000000000E+00,  .166666666666667,
     *     .000000000000000E+00,  .211324865405187,  .666666666666667,
     *    -.211324865405187, -.211324865405187, -.666666666666667,
     *     .211324865405187,  .000000000000000E+00, -.166666666666667,
     *     .000000000000000E+00,  .211324865405187, -.166666666666667,
     *    -.788675134594813, -.788675134594813,  .666666666666667,
     *     .788675134594813,  .000000000000000E+00,  .166666666666667,
     *     .000000000000000E+00,  .788675134594813,  .166666666666667,
     *    -.211324865405187, -.211324865405187, -.166666666666667,
     *     .211324865405187,  .000000000000000E+00, -.666666666666667,
     *     .000000000000000E+00,  .211324865405187, -.166666666666667,
     *    -.788675134594813, -.788675134594813,  .166666666666667,
     *     .788675134594813,  .000000000000000E+00,  .666666666666667,
     *     .000000000000000E+00,  .788675134594813,  .166666666666667,
     *    -.211324865405187, -.211324865405187, -.166666666666667,
     *     .211324865405187,  .000000000000000E+00, -.166666666666667,
     *     .000000000000000E+00,  .211324865405187, -.666666666666667,
     *    -.788675134594813, -.788675134594813,  .166666666666667,
     *     .788675134594813,  .000000000000000E+00,  .166666666666667,
     *     .000000000000000E+00,  .788675134594813,  .666666666666667/
      DATA PR1/  .525783423063209,  .131445855765802,  .131445855765802,
     *     .140883243603458, .352208109008645E-01, .352208109008645E-01,
     *     .131445855765802,  .525783423063209,  .131445855765802,
     *     .352208109008645E-01, .140883243603458, .352208109008645E-01,
     *     .131445855765802,  .131445855765802,  .525783423063209,
     *     .352208109008645E-01, .352208109008645E-01, .140883243603458,
     *     .140883243603458, .352208109008645E-01, .352208109008645E-01,
     *     .525783423063209,  .131445855765802,  .131445855765802,
     *     .352208109008646E-01, .140883243603458, .352208109008645E-01,
     *     .131445855765802,  .525783423063209,  .131445855765802,
     *     .352208109008646E-01, .352208109008645E-01, .140883243603458,
     *     .131445855765802,  .131445855765802,  .525783423063209/
      DATA POIR/  6*.833333333333333E-01/
      DATA DPPS1/-1.00000000000000, -1.00000000000000, 1.00000000000000,
     *     .000000000000000E+00, .000000000000000E+00, 1.00000000000000/
      DATA PPS1/ 3* .333333333333333 /
     *   
      DATA POIPS/  .500000000000000  /
      DATA DPQS1/-.788675134594813, -.788675134594813, .788675134594813,
     *    -.211324865405187,  .211324865405187,  .211324865405187,
     *    -.211324865405187,  .788675134594813, -.788675134594813,
     *    -.211324865405187,  .788675134594813, -.788675134594813,
     *     .211324865405187,  .788675134594813, -.211324865405187,
     *     .211324865405187, -.211324865405187, -.211324865405187,
     *     .211324865405187, -.788675134594813,  .788675134594813,
     *     .788675134594813, -.788675134594813,  .211324865405187,
     *    -.211324865405187, -.788675134594813,  .211324865405187,
     *    -.211324865405187,  .788675134594813,  .211324865405187,
     *    -.788675134594813,  .788675134594813/
      DATA PQS1/.622008467928146, .166666666666667,.446581987385204E-01,
     *     .166666666666667,  .166666666666667,  .622008467928146,
     *     .166666666666667, .446581987385204E-01, .446581987385205E-01,
     *     .166666666666667,  .622008467928146,  .166666666666667,
     *     .166666666666667,  .446581987385204E-01,  .166666666666667,
     *     .622008467928146/
      DATA POIQS/  4*.250000000000000 /

      call ES3D2C(NNO,NPO,NBFACE,NPOQ,NNOQ,NPOP,NNOP,NOREF,
     +            NPI,POIR,NPISQ,NPISP,POIQS,POIPS, NLOC,
     +            COOR(1,1),COOR(1,2),COOR(1,3),VOL,SURF,PRES,PR1,
     +            PR1,DPR1,DPR1,DPQS1,DPPS1,PQS1,PQS1,PPS1,PPS1,
     +            DELTS,DELTA,BE)
      END


