      SUBROUTINE ETS3R2C(COOR,vol,SURF,pres,noref,BE)
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                  S.P. ETS3R2C
C                  ------------
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  BUT   : CALCUL DU SECOND MEMBRE ELEMENTAIRE ELASTIQUE
C  ---      PENTAEDRE R1 DROIT  . 
C
C  PARAMETRES D ENTREE  :
C  -------------------
C   X,Y,Z   : COORDONNEES DES POINTS DE L ELEMENT (SIMPLE PRECISION)
C   VOLF    : FORCES VOLUMIQUES
C   NOREF   : noref(nbface,2) avec nbface = nombre de faces
c             noref(i,1) =/ 0 si face i soumise force surfacique
c             noref(2,1) =/ 0 si face i soumise a pression
C   SUR     : efforts surfaciques
c   pres    : pression

C  PARAMETRE DE SORTIE  :
C  --------------------

C   BE      : TABLEAU DES SECONDS MEMBRES
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  PROGRAMMEUR  : Marina Vidrascu 2001
C ...................................................................
      parameter (ndim=3, nno=15, npo=15, npi=21, npisq = 9, npisp = 7,
     *           nnop = 6, nnoq = 8, npop=6, npoq=8 ,nbface=5 )
      DIMENSION nloc(npoq,nbface), noref(nbface,2)
      DOUBLE PRECISION POIR(NPI),POIQS(NPISQ),POIPS(NPISP),
     +   BE(3,NNO),VOL(3,NNO),SURF(3,NNOQ,NBFACE),PRES(NNOQ,NBFACE),
     +   PR1(NPO,NPI),DPR1(3,NPO,NPI), PQS1(NPOQ,NPISQ),
     +   DPQS1(2,NPOQ,NPISQ),PPS1(NPOP,NPISP),
     +   DPPS1(2,npop,npisp), DELTS(npisq),DELTA(npi),COOR(NPO,3)

      double precision dp1(ndim,nno,3),dp2(ndim,nno,3),dp3(ndim,nno,3),
     *                 dp4(ndim,nno,3),dp5(ndim,nno,3),dp6(ndim,nno,3),
     *                 dp7(ndim,nno,3),
     *                 va1(nno,7),va2(nno,7),va3(nno,7)
      equivalence (dp1,DPR1(1,1,1)), (dp2,DPR1(1,1,4)),
     *            (dp3,DPR1(1,1,7)), (dp4,DPR1(1,1,10)),
     *            (dp5,DPR1(1,1,13)), (dp6,DPR1(1,1,16)),
     *            (dp7,DPR1(1,1,19)), (va1,PR1(1,1)),
     *            (va2,PR1(1,8)), (va3,PR1(1,15))
      DATA NLOC/ 1, 3, 2, 9, 8, 7, 0, 0,
     +           1, 4, 6, 3,10,15,12, 9,
     +           1, 2, 5, 4, 7,11,13,10,
     +           4, 5, 6,13,14,15, 0, 0,
     +           2, 3, 6, 5, 8,12,14,11/
C

c
      DATA dp1/ -1.74292420972099 ,-1.74292420972099 ,-1.70972118222110,
     *    -.727812937550124 ,.000000000000000E+00,-.761437882318176E-01,
     *   .000000000000000E+00, -.727812937550124 ,-.761437882318176E-01,
     *    -.467837316913592E-01,-.467837316913592E-01,-.761015965050019,
     *    -.267041033156050 ,.000000000000000E+00, -.237680976615592 ,
     *   .000000000000000E+00, -.267041033156050 , -.237680976615592 ,
     *     2.47073714727111 , -.359485397070617 , -.323074376767549 ,
     *   .359485397070617 ,.359485397070617 , -.410358262631383E-01,
     *    -.359485397070617 ,  2.47073714727111 , -.323074376767549 ,
     *    -.400000000000000 , -.400000000000000 ,  2.47073714727111 ,
     *   .400000000000000 ,.000000000000000E+00,.313824764847410 ,
     *   .000000000000000E+00,.400000000000000 ,.313824764847410 ,
     *   .313824764847410 , -.456606322232079E-01,.323074376767549 ,
     *   .456606322232079E-01,.456606322232079E-01,.410358262631383E-01,
     *    -.456606322232079E-01,.313824764847410 ,.323074376767549 ,
     *   .727812937550124 ,.727812937550124 , -.761437882318179E-01,
     *     1.74292420972099 ,.000000000000000E+00, -1.70972118222110 ,
     *   .000000000000000E+00, -.727812937550124 ,-.761437882318176E-01,
     *   .267041033156050 ,.267041033156050 , -.237680976615592 ,
     *   .467837316913591E-01,.000000000000000E+00, -.761015965050018 ,
     *   .000000000000000E+00, -.267041033156050 , -.237680976615592 ,
     *    -2.47073714727111 , -2.83022254434173 , -.323074376767549 ,
     *   .359485397070617 ,  2.83022254434173 , -.323074376767549 ,
     *    -.359485397070617 ,.000000000000000E+00,-.410358262631383E-01,
     *    -.400000000000000 , -.400000000000000 ,.313824764847410 ,
     *   .400000000000000 ,.000000000000000E+00,  2.47073714727111 ,
     *   .000000000000000E+00,.400000000000000 ,.313824764847410 ,
     *    -.313824764847409 , -.359485397070617 ,.323074376767549 ,
     *   .456606322232079E-01,.359485397070617 ,.323074376767549 ,
     *  -.456606322232079E-01,.000000000000000E+00,.410358262631383E-01,
     *   .727812937550124 ,.727812937550124 , -.761437882318177E-01,
     *    -.727812937550124 ,.000000000000000E+00,-.761437882318176E-01,
     *   .000000000000000E+00,  1.74292420972099 , -1.70972118222110 ,
     *   .267041033156050 ,.267041033156050 , -.237680976615592 ,
     *    -.267041033156050 ,.000000000000000E+00, -.237680976615592 ,
     *   .000000000000000E+00,.467837316913591E-01, -.761015965050018 ,
     *   .000000000000000E+00, -.359485397070617 ,-.410358262631383E-01,
     *     2.83022254434173 ,.359485397070617 , -.323074376767549 ,
     *    -2.83022254434173 , -2.47073714727111 , -.323074376767549 ,
     *    -.400000000000000 , -.400000000000000 ,.313824764847410 ,
     *   .400000000000000 ,.000000000000000E+00,.313824764847410 ,
     *   .000000000000000E+00,.400000000000000 ,  2.47073714727111 ,
     *  .000000000000000E+00,-.456606322232079E-01,.410358262631383E-01,
     *   .359485397070617 ,.456606322232079E-01,.323074376767549 ,
     *    -.359485397070617 , -.313824764847409 ,.323074376767549/

      data dp2/-.581326747441765 , -.581326747441765 ,-.700266010629198,
     *   .581326747441765 ,.000000000000000E+00, -.700266010629197 ,
     *   .000000000000000E+00, -.875355160262788 ,-.399275296758689E-01,
     *   .100758491021304 ,.100758491021304 , -.756415897075355 ,
     *    -.100758491021304 ,.000000000000000E+00, -.756415897075355 ,
     *   .000000000000000E+00, -.285781352578133 , -.145095331880960 ,
     *   .000000000000000E+00, -1.66862508206251 , -.884134241764073 ,
     *   .211943174357954 ,  1.66862508206251 , -.112299772892315 ,
     *    -.211943174357954 ,  1.45668190770455 , -.112299772892315 ,
     *    -.400000000000000 , -.400000000000000 ,  1.45668190770455 ,
     *   .400000000000000 ,.000000000000000E+00,  1.45668190770455 ,
     *   .000000000000000E+00,.400000000000000 ,.185022861556829 ,
     *   .000000000000000E+00, -.211943174357954 ,.884134241764073 ,
     *   .269203128011253E-01,.211943174357954 ,.112299772892315 ,
     *    -.269203128011253E-01,.185022861556829 ,.112299772892315 ,
     *   .875355160262787 ,.875355160262787 , -.399275296758689E-01,
     *   .581326747441765 ,.000000000000000E+00, -.700266010629197 ,
     *   .000000000000000E+00,.581326747441765 , -.700266010629197 ,
     *   .285781352578133 ,.285781352578133 , -.145095331880960 ,
     *    -.100758491021304 ,.000000000000000E+00, -.756415897075355 ,
     *   .000000000000000E+00, -.100758491021304 , -.756415897075355 ,
     *    -1.45668190770455 , -1.66862508206251 , -.112299772892315 ,
     *     1.66862508206251 ,  1.66862508206251 , -.884134241764072 ,
     *    -1.66862508206251 , -1.45668190770455 , -.112299772892315 ,
     *    -.400000000000000 , -.400000000000000 ,.185022861556829 ,
     *   .400000000000000 ,.000000000000000E+00,  1.45668190770455 ,
     *   .000000000000000E+00,.400000000000000 ,  1.45668190770455 ,
     *    -.185022861556829 , -.211943174357954 ,.112299772892315 ,
     *   .211943174357954 ,.211943174357954 ,.884134241764072 ,
     *    -.211943174357954 , -.185022861556829 ,.112299772892315 ,
     *    -.581326747441765 , -.581326747441765 , -.700266010629198 ,
     *    -.875355160262788 ,.000000000000000E+00,-.399275296758689E-01,
     *   .000000000000000E+00,.581326747441765 , -.700266010629197 ,
     *   .100758491021304 ,.100758491021304 , -.756415897075355 ,
     *    -.285781352578133 ,.000000000000000E+00, -.145095331880960 ,
     *   .000000000000000E+00, -.100758491021304 , -.756415897075355 ,
     *     1.45668190770455 , -.211943174357954 , -.112299772892315 ,
     *     1.66862508206251 ,.211943174357954 , -.112299772892315 ,
     *    -1.66862508206251 ,.000000000000000E+00, -.884134241764073 ,
     *    -.400000000000000 , -.400000000000000 ,  1.45668190770455 ,
     *   .400000000000000 ,.000000000000000E+00,.185022861556829 ,
     *   .000000000000000E+00,.400000000000000 ,  1.45668190770455 ,
     *   .185022861556829 , -.269203128011253E-01,.112299772892315 ,
     *   .211943174357954 ,.269203128011253E-01,.112299772892315 ,
     *    -.211943174357954 ,.000000000000000E+00,.884134241764073/

      data dp3/-.957660410241110E-01, -.957660410241110E-01, 
     *   -.405286630980767 ,
     *   .957661467983153E-01,.000000000000000E+00, -.405286687084434 ,
     *   .000000000000000E+00,.957661467983153E-01, -.405286687084434 ,
     *   .162432787163638 ,.162432787163638 , -.627508866448465 ,
     *    -.162432773728552 ,.000000000000000E+00, -.627508902683917 ,
     *   .000000000000000E+00, -.162432773728552 , -.627508902683917 ,
     *    -.105774204062214E-06, -1.18306448141906 , -.444444431198967 ,
     *     1.18306448141906 ,  1.18306448141906 , -.444444470935398 ,
     *    -1.18306448141906 , -.105774204062214E-06, -.444444431198967 ,
     *    -.400000000000000 , -.400000000000000 ,  1.03279549742923 ,
     *   .400000000000000 ,.000000000000000E+00,  1.03279558976835 ,
     *   .000000000000000E+00,.400000000000000 ,  1.03279558976835 ,
     *    -.134350854885668E-07, -.150268891650706 ,.444444431198967 ,
     *   .150268891650706 ,.150268891650706 ,.444444470935398 ,
     *    -.150268891650706 , -.134350854885668E-07,.444444431198967 ,
     *    -.594853970706175 , -.594853970706175 , -.474352608585539 ,
     *    -.797426985353087 ,.000000000000000E+00,.807685941918872E-01,
     *   .000000000000000E+00, -.797426985353087 ,.807685941918872E-01,
     *    -.594853970706175 , -.594853970706175 ,.474352608585539 ,
     *    -.797426985353087 ,.000000000000000E+00,-.807685941918872E-01,
     *   .000000000000000E+00, -.797426985353087 ,-.807685941918872E-01,
     *     1.39228095605926 , -.202573014646913 , -.323074376767549 ,
     *   .202573014646913 ,.202573014646913 , -.410358262631383E-01,
     *    -.202573014646913 ,  1.39228095605926 , -.323074376767549 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *     1.39228095605926 , -.202573014646913 ,.323074376767549 ,
     *   .202573014646913 ,.202573014646913 ,.410358262631383E-01,
     *    -.202573014646913 ,  1.39228095605926 ,.323074376767549 ,
     *   .797426985353087 ,.797426985353087 ,.807685941918874E-01,
     *   .594853970706174 ,.000000000000000E+00, -.474352608585538 ,
     *   .000000000000000E+00, -.797426985353087 ,.807685941918872E-01,
     *   .797426985353087 ,.797426985353087 , -.807685941918870E-01,
     *   .594853970706174 ,.000000000000000E+00,.474352608585539 ,
     *   .000000000000000E+00, -.797426985353087 ,-.807685941918872E-01,
     *    -1.39228095605926 , -1.59485397070617 , -.323074376767549 ,
     *   .202573014646913 ,  1.59485397070617 , -.323074376767549 ,
     *    -.202573014646913 ,.000000000000000E+00,-.410358262631383E-01,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *    -1.39228095605926 , -1.59485397070617 ,.323074376767549 ,
     *   .202573014646913 ,  1.59485397070617 ,.323074376767549 ,
     *    -.202573014646913 ,.000000000000000E+00,.410358262631383E-01/

      data dp4/.797426985353087 ,.797426985353087 ,.807685941918872E-01,
     *    -.797426985353087 ,.000000000000000E+00,.807685941918872E-01,
     *   .000000000000000E+00,.594853970706174 , -.474352608585538 ,
     *   .797426985353087 ,.797426985353087 , -.807685941918871E-01,
     *    -.797426985353087 ,.000000000000000E+00,-.807685941918872E-01,
     *   .000000000000000E+00,.594853970706174 ,.474352608585539 ,
     *   .000000000000000E+00, -.202573014646913 ,-.410358262631383E-01,
     *     1.59485397070617 ,.202573014646913 , -.323074376767549 ,
     *    -1.59485397070617 , -1.39228095605926 , -.323074376767549 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *   .000000000000000E+00, -.202573014646913 ,.410358262631383E-01,
     *     1.59485397070617 ,.202573014646913 ,.323074376767549 ,
     *    -1.59485397070617 , -1.39228095605926 ,.323074376767549 ,
     *   .597158717897698E-01,.597158717897698E-01,.280749432230789E-01,
     *  -.597158717897699E-01,.000000000000000E+00,.280749432230789E-01,
     *   .000000000000000E+00, -.880568256420460 ,.525839011025453E-01,
     *  .597158717897697E-01,.597158717897697E-01,-.280749432230787E-01,
     * -.597158717897699E-01,.000000000000000E+00,-.280749432230789E-01,
     *   .000000000000000E+00, -.880568256420460 ,-.525839011025453E-01,
     *   .000000000000000E+00, -.940284128210230 , -.884134241764073 ,
     *   .119431743579540 ,.940284128210230 , -.112299772892315 ,
     *    -.119431743579540 ,.820852384630691 , -.112299772892315 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *   .000000000000000E+00, -.940284128210230 ,.884134241764073 ,
     *   .119431743579540 ,.940284128210230 ,.112299772892315 ,
     *    -.119431743579540 ,.820852384630691 ,.112299772892315 ,
     *   .880568256420460 ,.880568256420460 ,.525839011025456E-01,
     *  -.597158717897699E-01,.000000000000000E+00,.280749432230789E-01,
     *  .000000000000000E+00,-.597158717897699E-01,.280749432230789E-01,
     *   .880568256420460 ,.880568256420460 , -.525839011025456E-01,
     * -.597158717897699E-01,.000000000000000E+00,-.280749432230789E-01,
     * .000000000000000E+00,-.597158717897699E-01,-.280749432230789E-01,
     *    -.820852384630690 , -.940284128210230 , -.112299772892315 ,
     *   .940284128210230 ,.940284128210230 , -.884134241764072 ,
     *    -.940284128210230 , -.820852384630690 , -.112299772892315 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *    -.820852384630690 , -.940284128210230 ,.112299772892315 ,
     *   .940284128210230 ,.940284128210230 ,.884134241764072 ,
     *    -.940284128210230 , -.820852384630690 ,.112299772892315/

      data dp5/.597158717897697E-01,.597158717897697E-01,
     *     .280749432230788E-01,
     *    -.880568256420460 ,.000000000000000E+00,.525839011025453E-01,
     *  .000000000000000E+00,-.597158717897699E-01,.280749432230789E-01,
     * .597158717897697E-01,.597158717897697E-01, -.280749432230788E-01,
     *   -.880568256420460 ,.000000000000000E+00, -.525839011025453E-01,
     * .000000000000000E+00,-.597158717897699E-01,-.280749432230789E-01,
     *   .820852384630691 , -.119431743579540 , -.112299772892315 ,
     *   .940284128210230 ,.119431743579540 , -.112299772892315 ,
     *    -.940284128210230 ,.000000000000000E+00, -.884134241764073 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *   .820852384630691 , -.119431743579540 ,.112299772892315 ,
     *   .940284128210230 ,.119431743579540 ,.112299772892315 ,
     *    -.940284128210230 ,.000000000000000E+00,.884134241764073 ,
     *   .333333373069763 ,.333333373069763 ,.111111117733849 ,
     *    -.333333313465118 ,.000000000000000E+00,.111111107799742 ,
     *   .000000000000000E+00, -.333333313465118 ,.111111107799742 ,
     *   .333333373069763 ,.333333373069763 , -.111111117733849 ,
     *    -.333333313465118 ,.000000000000000E+00, -.111111107799742 ,
     *   .000000000000000E+00, -.333333313465118 , -.111111107799742 ,
     *    -.596046447753906E-07, -.666666686534882 , -.444444431198967 ,
     *   .666666686534882 ,.666666686534882 , -.444444470935398 ,
     *    -.666666686534882 , -.596046447753906E-07, -.444444431198967 ,
     *    -1.00000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *     1.00000000000000 ,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,  1.00000000000000 ,.000000000000000E+00,
     *    -.596046447753906E-07, -.666666686534882 ,.444444431198967 ,
     *   .666666686534882 ,.666666686534882 ,.444444470935398 ,
     *    -.666666686534882 , -.596046447753906E-07,.444444431198967 ,
     *    -.467837316913596E-01, -.467837316913596E-01,.761015965050018,
     *    -.267041033156050 ,.000000000000000E+00,.237680976615592 ,
     *   .000000000000000E+00, -.267041033156050 ,.237680976615592 ,
     *    -1.74292420972099 , -1.74292420972099 ,  1.70972118222110 ,
     *    -.727812937550124 ,.000000000000000E+00,.761437882318176E-01,
     *   .000000000000000E+00, -.727812937550124 ,.761437882318176E-01,
     *   .313824764847410 , -.456606322232079E-01, -.323074376767549 ,
     *  .456606322232079E-01,.456606322232079E-01,-.410358262631383E-01,
     *    -.456606322232079E-01,.313824764847410 , -.323074376767549 ,
     *    -.400000000000000 , -.400000000000000 , -2.47073714727111 ,
     *   .400000000000000 ,.000000000000000E+00, -.313824764847410 ,
     *   .000000000000000E+00,.400000000000000 , -.313824764847410 ,
     *     2.47073714727111 , -.359485397070617 ,.323074376767549 ,
     *   .359485397070617 ,.359485397070617 ,.410358262631383E-01,
     *    -.359485397070617 ,  2.47073714727111 ,.323074376767549/

      data dp6/.267041033156050 ,.267041033156050 ,.237680976615592 ,
     *   .467837316913591E-01,.000000000000000E+00,.761015965050018 ,
     *   .000000000000000E+00, -.267041033156050 ,.237680976615592 ,
     *   .727812937550123 ,.727812937550123 ,.761437882318183E-01,
     *     1.74292420972099 ,.000000000000000E+00,  1.70972118222110 ,
     *   .000000000000000E+00, -.727812937550124 ,.761437882318176E-01,
     *    -.313824764847410 , -.359485397070618 , -.323074376767549 ,
     *   .456606322232079E-01,.359485397070618 , -.323074376767549 ,
     * -.456606322232079E-01,.000000000000000E+00,-.410358262631383E-01,
     *    -.400000000000000 , -.400000000000000 , -.313824764847410 ,
     *   .400000000000000 ,.000000000000000E+00, -2.47073714727111 ,
     *   .000000000000000E+00,.400000000000000 , -.313824764847410 ,
     *    -2.47073714727111 , -2.83022254434173 ,.323074376767549 ,
     *   .359485397070617 ,  2.83022254434173 ,.323074376767549 ,
     *    -.359485397070617 ,.000000000000000E+00,.410358262631383E-01,
     *   .267041033156050 ,.267041033156050 ,.237680976615592 ,
     *    -.267041033156050 ,.000000000000000E+00,.237680976615592 ,
     *   .000000000000000E+00,.467837316913591E-01,.761015965050018 ,
     *   .727812937550123 ,.727812937550123 ,.761437882318179E-01,
     *    -.727812937550124 ,.000000000000000E+00,.761437882318176E-01,
     *   .000000000000000E+00,  1.74292420972099 ,  1.70972118222110 ,
     * .000000000000000E+00,-.456606322232079E-01,-.410358262631383E-01,
     *   .359485397070618 ,.456606322232079E-01, -.323074376767549 ,
     *    -.359485397070618 , -.313824764847410 , -.323074376767549 ,
     *    -.400000000000000 , -.400000000000000 , -.313824764847411 ,
     *   .400000000000000 ,.000000000000000E+00, -.313824764847410 ,
     *   .000000000000000E+00,.400000000000000 , -2.47073714727111 ,
     *   .000000000000000E+00, -.359485397070617 ,.410358262631383E-01,
     *     2.83022254434173 ,.359485397070617 ,.323074376767549 ,
     *    -2.83022254434173 , -2.47073714727111 ,.323074376767549 ,
     *   .100758491021304 ,.100758491021304 ,.756415897075355 ,
     *    -.100758491021304 ,.000000000000000E+00,.756415897075355 ,
     *   .000000000000000E+00, -.285781352578133 ,.145095331880960 ,
     *    -.581326747441765 , -.581326747441765 ,.700266010629197 ,
     *   .581326747441765 ,.000000000000000E+00,.700266010629197 ,
     *   .000000000000000E+00, -.875355160262788 ,.399275296758690E-01,
     *   .000000000000000E+00, -.211943174357954 , -.884134241764073 ,
     *   .269203128011253E-01,.211943174357954 , -.112299772892315 ,
     *    -.269203128011253E-01,.185022861556829 , -.112299772892315 ,
     *    -.400000000000000 , -.400000000000000 , -1.45668190770455 ,
     *   .400000000000000 ,.000000000000000E+00, -1.45668190770455 ,
     *   .000000000000000E+00,.400000000000000 , -.185022861556829 ,
     *   .000000000000000E+00, -1.66862508206251 ,.884134241764073 ,
     *   .211943174357954 ,  1.66862508206251 ,.112299772892315 ,
     *    -.211943174357954 ,  1.45668190770455 ,.112299772892315/

      data dp7/.285781352578132 ,.285781352578132 ,.145095331880960 ,
     *    -.100758491021304 ,.000000000000000E+00,.756415897075355 ,
     *   .000000000000000E+00, -.100758491021304 ,.756415897075355 ,
     *   .875355160262787 ,.875355160262787 ,.399275296758687E-01,
     *   .581326747441765 ,.000000000000000E+00,.700266010629197 ,
     *   .000000000000000E+00,.581326747441765 ,.700266010629197 ,
     *    -.185022861556828 , -.211943174357954 , -.112299772892315 ,
     *   .211943174357954 ,.211943174357954 , -.884134241764072 ,
     *    -.211943174357954 , -.185022861556828 , -.112299772892315 ,
     *    -.400000000000000 , -.400000000000000 , -.185022861556829 ,
     *   .400000000000000 ,.000000000000000E+00, -1.45668190770455 ,
     *   .000000000000000E+00,.400000000000000 , -1.45668190770455 ,
     *    -1.45668190770455 , -1.66862508206251 ,.112299772892315 ,
     *     1.66862508206251 ,  1.66862508206251 ,.884134241764072 ,
     *    -1.66862508206251 , -1.45668190770455 ,.112299772892315 ,
     *   .100758491021304 ,.100758491021304 ,.756415897075355 ,
     *    -.285781352578133 ,.000000000000000E+00,.145095331880960 ,
     *   .000000000000000E+00, -.100758491021304 ,.756415897075355 ,
     *    -.581326747441765 , -.581326747441765 ,.700266010629197 ,
     *    -.875355160262788 ,.000000000000000E+00,.399275296758690E-01,
     *   .000000000000000E+00,.581326747441765 ,.700266010629197 ,
     *   .185022861556829 , -.269203128011253E-01, -.112299772892315 ,
     *   .211943174357954 ,.269203128011253E-01, -.112299772892315 ,
     *    -.211943174357954 ,.000000000000000E+00, -.884134241764073 ,
     *    -.400000000000000 , -.400000000000000 , -1.45668190770455 ,
     *   .400000000000000 ,.000000000000000E+00, -.185022861556829 ,
     *   .000000000000000E+00,.400000000000000 , -1.45668190770455 ,
     *     1.45668190770455 , -.211943174357954 ,.112299772892315 ,
     *     1.66862508206251 ,.211943174357954 ,.112299772892315 ,
     *    -1.66862508206251 ,.000000000000000E+00,.884134241764073 ,
     *   .162432787163637 ,.162432787163637 ,.627508866448465 ,
     *    -.162432773728552 ,.000000000000000E+00,.627508902683917 ,
     *   .000000000000000E+00, -.162432773728552 ,.627508902683917 ,
     *    -.957660410241115E-01, -.957660410241115E-01,.405286630980767,
     *   .957661467983153E-01,.000000000000000E+00,.405286687084434 ,
     *   .000000000000000E+00,.957661467983153E-01,.405286687084434 ,
     *    -.134350854885668E-07, -.150268891650706 , -.444444431198967 ,
     *   .150268891650706 ,.150268891650706 , -.444444470935398 ,
     *    -.150268891650706 , -.134350854885668E-07, -.444444431198967 ,
     *    -.400000000000000 , -.400000000000000 , -1.03279549742923 ,
     *   .400000000000000 ,.000000000000000E+00, -1.03279558976835 ,
     *   .000000000000000E+00,.400000000000000 , -1.03279558976835 ,
     *    -.105774204062214E-06, -1.18306448141906 ,.444444431198967 ,
     *     1.18306448141906 ,  1.18306448141906 ,.444444470935398 ,
     *    -1.18306448141906 , -.105774204062214E-06,.444444431198967/



      DATA va1/.261406882550335,-.919231405808113E-01,
     *    -.919231405808113E-01,
     *    -.106025068106032,-.293600565404584E-01,-.293600565404584E-01,
     *   .286663356464480 ,.364110203030687E-01,.286663356464480 ,
     *   .318970794141235 ,.405146029293825E-01,.405146029293825E-01,
     *   .364110203030687E-01,.462480596006959E-02,.364110203030687E-01,
     *    -.919231405808111E-01,.261406882550335, -.919231405808113E-01,
     *    -.293600565404585E-01,-.106025068106032,-.293600565404584E-01,
     *   .286663356464480 ,.286663356464480 ,.364110203030687E-01,
     *   .405146029293826E-01,.318970794141235 ,.405146029293825E-01,
     *   .364110203030688E-01,.364110203030687E-01,.462480596006960E-02,
     *    -.919231405808111E-01, -.919231405808113E-01,.261406882550335,
     *    -.293600565404585E-01,-.293600565404584E-01,-.106025068106032,
     *   .364110203030687E-01,.286663356464480 ,.286663356464480 ,
     *   .405146029293826E-01,.405146029293825E-01,.318970794141235 ,
     *   .462480596006960E-02,.364110203030687E-01,.364110203030688E-01,
     *    -.118939263187433 , -.118939263187433 , -.586007822341042E-01,
     *-.971925056776921E-01,-.971925056776921E-01, .178694675843490E-01,
     *   .784490840298434 ,.996434014656387E-01,.996434014656388E-01,
     *   .188056825642046 ,.188056825642046 ,.238863487159079E-01,
     *   .996434014656388E-01,.126563714266764E-01,.126563714266764E-01,
     *    -.586007822341042E-01, -.118939263187433 , -.118939263187433 ,
     *-.178694675843491E-01,-.971925056776921E-01,-.971925056776921E-01,
     *   .996434014656391E-01,.784490840298434 ,.996434014656391E-01,
     *   .238863487159079E-01,.188056825642046 ,.188056825642046 ,
     *   .126563714266764E-01,.996434014656387E-01,.126563714266764E-01,
     *    -.118939263187433 , -.586007822341042E-01, -.118939263187433 ,
     *-.971925056776921E-01,-.178694675843490E-01,-.971925056776921E-01,
     *   .996434014656388E-01,.996434014656387E-01,.784490840298434 ,
     *   .188056825642046 ,.238863487159079E-01,.188056825642046 ,
     *   .126563714266764E-01,.126563714266764E-01,.996434014656388E-01,
     *    -.165255372416117 , -.165255369562065 , -.165255369562065 ,
     *-.791890707037792E-01,-.791890755446534E-01,-.791890755446534E-01,
     *   .394354803634306 ,.394354838892375 ,.394354803634306 ,
     *   .133333325386047 ,.133333337306976 ,.133333337306976 ,
     *   .500896275646608E-01,.500896320430227E-01,.500896275646608E-01/

      data va2/-.161537188383774,-.910275507576717E-01,
     *    -.910275507576717E-01,
     *    -.161537188383774,-.910275507576717E-01,-.910275507576717E-01,
     *   .161537188383774 ,.205179131315691E-01,.161537188383774 ,
     *   .797426985353087 ,.101286507323456 ,.101286507323456 ,
     *   .161537188383774 ,.205179131315691E-01,.161537188383774 ,
     *    -.910275507576718E-01,-.161537188383774,-.910275507576717E-01,
     *    -.910275507576718E-01,-.161537188383774,-.910275507576717E-01,
     *   .161537188383775 ,.161537188383774 ,.205179131315692E-01,
     *   .101286507323456 ,.797426985353087 ,.101286507323456 ,
     *   .161537188383774 ,.161537188383774 ,.205179131315692E-01,
     *    -.910275507576717E-01,-.910275507576717E-01,-.161537188383774,
     *   -.910275507576718E-01,-.910275507576717E-01, -.161537188383774,
     *   .205179131315692E-01,.161537188383774 ,.161537188383774 ,
     *   .101286507323456 ,.101286507323456 ,.797426985353087 ,
     *   .205179131315692E-01,.161537188383774 ,.161537188383774 ,
     *    -.249108503664097 , -.249108503664097 , -.561498864461576E-01,
     *    -.249108503664097 , -.249108503664097 , -.561498864461576E-01,
     *   .442067120882036 ,.561498864461576E-01,.561498864461576E-01,
     *   .470142064105115 ,.470142064105115 ,.597158717897698E-01,
     *   .442067120882036 ,.561498864461576E-01,.561498864461576E-01,
     *    -.561498864461577E-01, -.249108503664097 , -.249108503664097 ,
     *    -.561498864461577E-01, -.249108503664097 , -.249108503664097 ,
     *   .561498864461577E-01,.442067120882036 ,.561498864461577E-01,
     *   .597158717897699E-01,.470142064105115 ,.470142064105115 ,
     *   .561498864461577E-01,.442067120882036 ,.561498864461577E-01,
     *    -.249108503664097 , -.561498864461576E-01, -.249108503664097 ,
     *    -.249108503664097 , -.561498864461576E-01, -.249108503664097 ,
     *   .561498864461576E-01,.561498864461576E-01,.442067120882036 ,
     *   .470142064105115 ,.597158717897698E-01,.470142064105115 ,
     *   .561498864461576E-01,.561498864461576E-01,.442067120882036 ,
     *    -.222222215599484 , -.222222225533591 , -.222222225533591 ,
     *    -.222222215599484 , -.222222225533591 , -.222222225533591 ,
     *   .222222215599484 ,.222222235467699 ,.222222215599484 ,
     *   .333333313465118 ,.333333343267441 ,.333333343267441 ,
     *   .222222215599484 ,.222222235467699 ,.222222215599484/

      data va3 /-.106025068106032 ,-.293600565404584E-01,
     *   -.293600565404584E-01,
     *   .261406882550335 , -.919231405808112E-01,-.919231405808112E-01,
     *   .364110203030687E-01,.462480596006959E-02,.364110203030687E-01,
     *   .318970794141235 ,.405146029293825E-01,.405146029293825E-01,
     *   .286663356464480 ,.364110203030687E-01,.286663356464480 ,
     *   -.293600565404584E-01,-.106025068106032 ,-.293600565404584E-01,
     *    -.919231405808112E-01,.261406882550336 ,-.919231405808112E-01,
     *   .364110203030688E-01,.364110203030687E-01,.462480596006959E-02,
     *   .405146029293828E-01,.318970794141235 ,.405146029293825E-01,
     *   .286663356464480 ,.286663356464480 ,.364110203030688E-01,
     *    -.293600565404582E-01,-.293600565404584E-01,-.106025068106032,
     *    -.919231405808113E-01, -.919231405808112E-01,.261406882550336,
     *   .462480596006959E-02,.364110203030687E-01,.364110203030688E-01,
     *   .405146029293826E-01,.405146029293825E-01,.318970794141235 ,
     *   .364110203030687E-01,.286663356464480 ,.286663356464480 ,
     *-.971925056776921E-01,-.971925056776922E-01,-.178694675843490E-01,
     *    -.118939263187433 , -.118939263187433 , -.586007822341042E-01,
     *   .996434014656387E-01,.126563714266764E-01,.126563714266764E-01,
     *   .188056825642046 ,.188056825642046 ,.238863487159079E-01,
     *   .784490840298434 ,.996434014656387E-01,.996434014656387E-01,
     *-.178694675843491E-01,-.971925056776922E-01,-.971925056776922E-01,
     *    -.586007822341045E-01, -.118939263187433 , -.118939263187433 ,
     *   .126563714266763E-01,.996434014656388E-01,.126563714266763E-01,
     *   .238863487159078E-01,.188056825642046 ,.188056825642046 ,
     *   .996434014656391E-01,.784490840298434 ,.996434014656391E-01,
     *-.971925056776922E-01,-.178694675843490E-01,-.971925056776922E-01,
     *    -.118939263187433 , -.586007822341042E-01, -.118939263187433 ,
     *   .126563714266764E-01,.126563714266764E-01,.996434014656387E-01,
     *   .188056825642046 ,.238863487159079E-01,.188056825642046 ,
     *   .996434014656388E-01,.996434014656387E-01,.784490840298434 ,
     *-.791890707037790E-01,-.791890755446533E-01,-.791890755446533E-01,
     *    -.165255372416117 , -.165255369562065 , -.165255369562065 ,
     *   .500896275646607E-01,.500896320430227E-01,.500896275646607E-01,
     *   .133333325386047 ,.133333337306976 ,.133333337306976 ,
     *   .394354803634306 ,.394354838892375 ,.394354803634306/


      DATA POIR/.174915528534482E-01,.174915528534482E-01,
     *   .174915528534482E-01,
     *   .183880767761814E-01,.183880767761814E-01,.183880767761814E-01,
     *   .312499991721577E-01,.279864845655171E-01,.279864845655171E-01,
     *   .279864845655171E-01,.294209228418903E-01,.294209228418903E-01,
     *   .294209228418903E-01,.499999986754523E-01,.174915528534482E-01,
     *   .174915528534482E-01,.174915528534482E-01,.183880767761814E-01,
     *   .183880767761814E-01,.183880767761814E-01,.312499991721577E-01/


      DATA DPPS1/-2.18970794141235,-2.18970794141235,-.594853970706175 ,
     *   .000000000000000E+00,.000000000000000E+00, -.594853970706175 ,
     *     2.78456191211852 , -.405146029293825 ,.405146029293825 ,
     *   .405146029293825 , -.405146029293825 ,  2.78456191211852 ,
     *   .594853970706174 ,.594853970706174 ,  2.18970794141235 ,
     *   .000000000000000E+00,.000000000000000E+00, -.594853970706175 ,
     *    -2.78456191211852 , -3.18970794141235 ,.405146029293825 ,
     *     3.18970794141235 , -.405146029293825 ,.000000000000000E+00,
     *   .594853970706174 ,.594853970706174 , -.594853970706175 ,
     *   .000000000000000E+00,.000000000000000E+00,  2.18970794141235 ,
     *   .000000000000000E+00, -.405146029293825 ,  3.18970794141235 ,
     *   .405146029293825 , -3.18970794141235 , -2.78456191211852 ,
     *    -.880568256420461 , -.880568256420461 ,.880568256420460 ,
     *   .000000000000000E+00,.000000000000000E+00, -.761136512840921 ,
     *   .000000000000000E+00, -1.88056825642046 ,.238863487159079 ,
     *     1.88056825642046 , -.238863487159079 ,  1.64170476926138 ,
     *   .761136512840920 ,.761136512840920 ,.880568256420460 ,
     *   .000000000000000E+00,.000000000000000E+00,.880568256420460 ,
     *    -1.64170476926138 , -1.88056825642046 ,  1.88056825642046 ,
     *     1.88056825642046 , -1.88056825642046 , -1.64170476926138 ,
     *    -.880568256420461 , -.880568256420461 , -.761136512840921 ,
     *   .000000000000000E+00,.000000000000000E+00,.880568256420460 ,
     *     1.64170476926138 , -.238863487159079 ,  1.88056825642046 ,
     *   .238863487159079 , -1.88056825642046 ,.000000000000000E+00,
     *    -.333333253860474 , -.333333253860474 ,.333333373069763 ,
     *   .000000000000000E+00,.000000000000000E+00,.333333373069763 ,
     *    -.119209289550781E-06, -1.33333337306976 ,  1.33333337306976 ,
     *     1.33333337306976 , -1.33333337306976 , -.119209289550781E-06/

      DATA PPS1/.474352608585539,-.807685941918872E-01,
     *   -.807685941918872E-01,
     *   .323074376767549 ,.410358262631383E-01,.323074376767549 ,
     *    -.807685941918870E-01,.474352608585538 ,-.807685941918872E-01,
     *   .323074376767549 ,.323074376767549 ,.410358262631383E-01,
     *    -.807685941918870E-01, -.807685941918872E-01,.474352608585538,
     *   .410358262631383E-01,.323074376767549 ,.323074376767549 ,
     *-.280749432230788E-01,-.280749432230789E-01,-.525839011025453E-01,
     *   .884134241764073 ,.112299772892315 ,.112299772892315 ,
     *-.525839011025456E-01,-.280749432230789E-01,-.280749432230789E-01,
     *   .112299772892315 ,.884134241764072 ,.112299772892315 ,
     *-.280749432230788E-01,-.525839011025453E-01,-.280749432230789E-01,
     *   .112299772892315 ,.112299772892315 ,.884134241764073 ,
     *    -.111111117733849 , -.111111107799742 , -.111111107799742 ,
     *   .444444431198967 ,.444444470935398 ,.444444431198967/
      DATA POIPS/.629695902724136E-01,.629695902724136E-01,
     *   .629695902724136E-01,
     *   .661970763942531E-01,.661970763942531E-01,.661970763942531E-01,
     *   .112499997019768/



      DATA DPQS1/-2.06189500386223,-2.06189500386223 ,-.687298334620742,
     *    -.872983346207417E-01, -.261895003862225 , -.261895003862225 ,
     *    -.872983346207417E-01, -.687298334620742 ,  2.74919333848297 ,
     *    -.400000000000000 ,.400000000000000 ,.349193338482967 ,
     *   .349193338482967 ,.400000000000000 , -.400000000000000 ,
     *     2.74919333848297 , -.687298334620742 , -.774596669241483 ,
     *   .687298334620742 , -.774596669241483 , -.872983346207417E-01,
     *    -.774596669241483 ,.872983346207417E-01, -.774596669241483 ,
     *   .000000000000000E+00, -1.00000000000000 ,.400000000000000 ,
     *     1.54919333848297 ,.000000000000000E+00,  1.00000000000000 ,
     *    -.400000000000000 ,  1.54919333848297 ,.687298334620742 ,
     *    -.872983346207421E-01,  2.06189500386223 , -2.06189500386223 ,
     *   .872983346207417E-01, -.687298334620742 ,.261895003862225 ,
     *    -.261895003862225 , -2.74919333848297 , -.400000000000000 ,
     *   .400000000000000 ,  2.74919333848297 , -.349193338482967 ,
     *   .400000000000000 , -.400000000000000 ,.349193338482967 ,
     *    -.774596669241483 , -.687298334620742 , -.774596669241483 ,
     *   .872983346207417E-01, -.774596669241483 ,-.872983346207417E-01,
     *    -.774596669241483 ,.687298334620742 ,  1.54919333848297 ,
     *    -.400000000000000 ,  1.00000000000000 ,.000000000000000E+00,
     *     1.54919333848297 ,.400000000000000 , -1.00000000000000 ,
     *   .000000000000000E+00,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00,.000000000000000E+00,.000000000000000E+00,
     *   .000000000000000E+00, -1.00000000000000 ,  1.00000000000000 ,
     *   .000000000000000E+00,.000000000000000E+00,  1.00000000000000 ,
     *    -1.00000000000000 ,.000000000000000E+00,.774596669241483 ,
     *   .872983346207412E-01,.774596669241483 , -.687298334620742 ,
     *   .774596669241483 ,.687298334620742 ,.774596669241483 ,
     *    -.872983346207417E-01, -1.54919333848297 , -.400000000000000 ,
     *     1.00000000000000 ,.000000000000000E+00, -1.54919333848297 ,
     *   .400000000000000 , -1.00000000000000 ,.000000000000000E+00,
     *    -.872983346207422E-01,.687298334620742 , -.261895003862225 ,
     *   .261895003862225 , -.687298334620742 ,.872983346207417E-01,
     *    -2.06189500386223 ,  2.06189500386223 ,.349193338482967 ,
     *    -.400000000000000 ,.400000000000000 , -.349193338482967 ,
     *     2.74919333848297 ,.400000000000000 , -.400000000000000 ,
     *    -2.74919333848297 ,.872983346207412E-01,.774596669241483 ,
     *    -.872983346207417E-01,.774596669241483 ,.687298334620742 ,
     *   .774596669241483 , -.687298334620742 ,.774596669241483 ,
     *   .000000000000000E+00, -1.00000000000000 ,.400000000000000 ,
     *    -1.54919333848297 ,.000000000000000E+00,  1.00000000000000 ,
     *    -.400000000000000 , -1.54919333848297 ,.261895003862225 ,
     *   .261895003862225 ,.872983346207419E-01,.687298334620742 ,
     *     2.06189500386223 ,  2.06189500386223 ,.687298334620742 ,
     *   .872983346207417E-01, -.349193338482967 , -.400000000000000 ,
     *   .400000000000000 , -2.74919333848297 , -2.74919333848297 ,
     *   .400000000000000 , -.400000000000000 , -.349193338482967/
      DATA PQS1/.432379000772445,-.1000000000000,-.323790007724450E-01,
     *    -.100000000000000E+00,.354919333848297 ,.450806661517033E-01,
     *   .450806661517033E-01,.354919333848297 , -.100000000000000E+00,
     *    -.100000000000000E+00,-.100000000000000E+00,-.100000000000000,
     *   .887298334620742 ,.200000000000000 ,.112701665379258 ,
     *   .200000000000000 , -.100000000000000 ,.432379000772445 ,
     *    -.100000000000000E+00,-.323790007724450E-01,.354919333848297 ,
     *   .354919333848297 ,.450806661517033E-01,.450806661517033E-01,
     *    -.1000000000000E+00,-.1000000000000E+00,-.100000000000000E+00,
     *    -.100000000000000E+00,.200000000000000 ,.112701665379258 ,
     *   .200000000000000 ,.887298334620742 , -.250000000000000 ,
     *    -.250000000000000 , -.250000000000000 , -.250000000000000 ,
     *   .500000000000000 ,.500000000000000 ,.500000000000000 ,
     *   .500000000000000 , -.100000000000000 , -.100000000000000E+00,
     *    -.100000000000000E+00, -.100000000000000E+00,.200000000000000,
     *   .887298334620742 ,.200000000000000 ,.112701665379258 ,
     *    -.100000000000000E+00,-.323790007724450E-01,-.100000000000000,
     *   .432379000772445 ,.450806661517033E-01,.450806661517033E-01,
     *   .354919333848297 ,.354919333848297 , -.100000000000000 ,
     *-.100000000000000E+00,-.100000000000000E+00,-.100000000000000E+00,
     *   .112701665379258 ,.200000000000000 ,.887298334620742 ,
     *   .200000000000000 , -.323790007724456E-01,-.999999999999999E-01,
     *   .432379000772445 , -.100000000000000 ,.450806661517031E-01,
     *   .354919333848297 ,.354919333848297 ,.450806661517031E-01/
      DATA POIQS/.771604938271605E-01,.123456790123457 ,
     *   .771604938271605E-01,
     *   .123456790123457 ,.197530864197531 ,.123456790123457 ,
     *   .771604938271605E-01,.123456790123457 ,.771604938271605E-01/


      call ES3D2C(NNO,NPO,NBFACE,NPOQ,NNOQ,NPOP,NNOP,NOREF,
     +            NPI,POIR,NPISQ,NPISP,POIQS,POIPS, NLOC,
     +            COOR(1,1),COOR(1,2),COOR(1,3),VOL,SURF,PRES,PR1,
     +            PR1,DPR1,DPR1,DPQS1,DPPS1,PQS1,PQS1,PPS1,PPS1,
     +            DELTS,DELTA,BE)
      END


